#include <SyFi.h>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    Dof dof(true, true); 
    // create two triangles
    Triangle t1(lst(0,0), lst(1,0), lst(0,1)); 
    Triangle t2(lst(1,1), lst(1,0), lst(0,1)); 

    int order = 2; 

    DiscontinuousLagrange fe; 
    fe.set_order(order); 
    fe.set_polygon(t1); 
    fe.set_element_number(1); 
    fe.compute_basis_functions(); 
    usage(fe); 
    for (unsigned int i=0; i< fe.nbf(); i++) {
        dof.insert_dof(1,i,fe.dof(i)); 
    }

    fe.set_polygon(t2); 
    fe.set_element_number(2); 
    fe.compute_basis_functions(); 
    usage(fe); 
    for (unsigned int i=0; i< fe.nbf(); i++) {
        dof.insert_dof(2,i,fe.dof(i)); 
    }

    // Print out the global degrees of freedom an their 
    // corresponding local degrees of freedom 
    vector<pair<unsigned int,unsigned int> > vec; 
    pair<unsigned int,unsigned int> index; 
    ex exdof; 
    for (unsigned int i=0; i< dof.size(); i++) {
        exdof = dof.glob_dof(i); 
        vec = dof.glob2loc(i);
        cout <<"global dof " <<i<<" dof "<<exdof<<endl; 
        for (unsigned int j=0; j<vec.size(); j++) { 
            index = vec[j]; 
            cout <<"  element "<<index.first<<" local dof "<<index.second<<endl; 
        }
    }
}
