[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil::multi::op n 0.5.3]
[moddesc   {file utilities}]
[titledesc {Multi-file operation, scatter/gather}]
[category  {Programming tools}]
[require Tcl 8.4]
[require fileutil::multi::op [opt 0.5.3]]
[require wip [opt 1.0]]
[description]
[keywords {file utilities} copy move remove multi-file]
[para]

This package provides objects which are able to perform actions on
multiple files selected by glob patterns.

[para]

At the core is a domain specific language allowing the easy
specification of multi-file copy and/or move and/or deletion
operations. Alternate names would be scatter/gather processor, or
maybe even assembler.

[section {CLASS API}]

The main command of the package is:

[list_begin definitions]

[call [cmd ::fileutil::multi::op] [opt [arg opName]] [opt [arg word]...]]

The command creates a new multi-file operation object with an
associated global Tcl command whose name is [arg opName].  This
command can be used to invoke the various possible file operations.
It has the following general form:

[list_begin definitions]
[call [cmd opName] [arg option] [opt [arg "arg arg ..."]]]

[arg Option] and the [arg arg]s determine the exact behavior of the
command.

[list_end]
[para]

If the string [const %AUTO%] is used as the [arg opName] then the
package will generate a unique name on its own.

[para]

If one or more [arg word]s are specified they are interpreted as an
initial set of file commands to execute. I.e. the method [method do]
of the newly constructed object is implicitly invoked using the words
as its arguments.

[list_end]

[para]


[section {OBJECT API}]

The following methods are possible for multi-file operation objects:

[list_begin definitions]

[call [cmd \$opName] [method do] [opt [arg word]...]]

This method interprets the specified words as file commands to
execute. See the section [sectref {FILE API}] for the set of
acceptable commands, their syntax, and semantics.

[para]

The result of the method is the result generated by the last file
command it executed.

[list_end]


[section {FILE API}]

Both object constructor and method [method do] take a list of words
and interpret them as file commands to execute. The names were chosen
to allow the construction of operations as sentences in near-natural
language. Most of the commands influence just the state of the object,
i.e. are simply providing the configuration used by the command
triggering the actual action.

[list_begin definitions]
[call [cmd into] [arg directory]]

Specifies the destination directory for operations.

[call [cmd in] [arg directory]]

Alias for [cmd into].

[call [cmd to] [arg directory]]

Alias for [cmd into].

[call [cmd from] [arg directory]]

Specifies the source directory for operations.

[call [cmd not] [arg pattern]]

Specifies a glob pattern for paths to be excluded from the operation.

[call [cmd for] [arg pattern]]

Alias for [cmd not].

[call [cmd exclude] [arg pattern]]

Alias for [cmd not].

[call [cmd but]]

Has no arguments of its own, but looks ahead in the list of words and
executes all [cmd not] commands immediately following it. This allows the
construction of "but not" and "but exclude" clauses for a more natural
sounding specification of excluded paths.

[call [cmd except]]

A semi-alias for [cmd but]. Has no arguments of its own, but looks
ahead in the list of words and executes all [cmd for] commands
immediately following it. This allows the construction of "except for"
clauses for a more natural sounding specification of excluded paths.

[call [cmd as] [arg name]]

Specifies a new name for the first file handled by the current
operation. I.e. for the renaming of a single file during the
operation.

[call [cmd recursive]]

Signals that file expansion should happen in the whole directory
hierarchy and not just the directory itself.

[call [cmd recursively]]

An alias for [cmd recursive].

[call [cmd copy]]

Signals that the operation is the copying of files from source to
destination directory per the specified inclusion and exclusion
patterns.

[call [cmd move]]

Signals that the operation is the moving of files from source to
destination directory per the specified inclusion and exclusion
patterns.

[call [cmd remove]]

Signals that the operation is the removal of files in the destination
directory per the specified inclusion and exclusion patterns.

[call [cmd expand]]

Signals that there is no operation but the calculation of the set of
files from the include and exclude patterns. This operation is not
available if [cmd the-set] is used.

[call [cmd invoke] [arg cmdprefix]]

Signals that the user-specified command prefix [arg cmdprefix] is the
operation to perform. The command prefix is executed at the global
level and given the source directory, destination directory, and set
of files (as dictionary mapping from source to destination files), in
this order.

[call [cmd reset]]

Forces the object into the ground state where all parts of the
configuration have default values.

[call [cmd "("]]

Saves a copy of the current object state on a stack.

[call [cmd ")"]]

Takes the state at the top of the state stack and restores it,
i.e. makes it the new current object state.

[call [cmd cd] [arg directory]]

Changes the destination directory to the sub-directory [arg directory]
of the current destination.

[call [cmd up]]

Changes the destination directory to the parent directory of the
current destination.

[call [cmd for-windows]]

Checks that Windows is the current platform. Aborts processing if not.

[call [cmd for-win]]

An alias for [cmd for-windows].

[call [cmd for-unix]]

Checks that Unix is the current platform. Aborts processing if not.

[call [cmd the] [arg pattern]]

This command specifies the files to operate on per a glob pattern, and
is also the active element, i.e. the command which actually performs
the specified operation. All the other commands only modified the
object state to set the operation up, but di nothing else.

[para]

To allow for a more natural sounding syntax this command also looks
ahead in the list of words looks and executes several commands
immediately following it before performing its own actions.

These commands are [cmd as], [cmd but], [cmd exclude], [cmd except],
[cmd from], and [cmd into] (and aliases). That way these commands act
like qualifiers, and still take effect as if they had been written
before this command.

[para]

After the operation has been performed the object state the exclude
patterns and the alias name, if specified, are reset to their default
values (i.e. empty), but nothing else.

[call [cmd the-set] [arg varname]]

Like [cmd the], however the set of files to use is not specified
implicitly per a glob pattern, but contained and loaded from the 
specified variable. The operation [cmd expand] is not available
if this command is used.

[call [cmd ->] [arg varname]]

Saves the set of files from the last expansion into the specified
variable.

[call [cmd strict]]

Make file expansion and definition of destination directory ([cmd in]
and aliases) strict, i.e. report errors for missing directories, and
empty expansion.

[call [cmd !strict]]

Complement of [cmd strict]. A missing destination directory or empty
expansion are not reported as errors.

[call [cmd files]]

Limit the search to files. Default is to accept every type of path.

[call [cmd links]]

Limit the search to symbolic links. Default is to accept every type of path.

[call [cmd directories]]

Limit the search to directories. Default is to accept every type of path.

[call [cmd dirs]]

An alias for [cmd directories].

[call [cmd all]]

Accept all types of paths (default).

[call [cmd state?]]

Returns the current state of the object as dictionary. The dictionary keys and their meanings are:

[list_begin definitions]
[def [const as]]
Last setting made by [cmd as].
[def [const excluded]]
List of currently known exclusion patterns.
[def [const from]]
Current source directory, set by [cmd from].
[def [const into]]
Current destination directory, set by [cmd into] (and aliases).
[def [const operation]]
Current operation to perform, set by [cmd copy], [cmd move], [cmd remove], [cmd expand], or [cmd invoke].
[def [const recursive]]
Current recursion status. Set/unset by [cmd recursive] and [cmd !recursive].
[def [const strict]]
Current strictness. Set/unset by [cmd strict] and [cmd !strict].
[def [const type]]
Current path type limiter. Set by either [cmd files], [cmd directories], [cmd links], or [cmd all].
[list_end]

[call [cmd as?]]
Returns the current alias name.
[call [cmd excluded?]]
Returns the current set of exclusion patterns.
[call [cmd from?]]
Returns the current source directory.
[call [cmd into?]]
Returns the current destination directory.
[call [cmd operation?]]
Returns the current operation to perform.
[call [cmd recursive?]]
Returns the current recursion status.
[call [cmd strict?]]
Returns the current strictness.
[call [cmd type?]]
Returns the current path type limiter.
[list_end]


[section EXAMPLES]

The following examples assume that the variable [var F] contains a
reference to a multi-file operation object.

[example {
    $F do copy                       \\
	the  *.dll                    \\
	from c:/TDK/PrivateOpenSSL/bin \\
	to   [installdir_of tls]
}]

[example {
    $F do move      \\
	the  *       \\
	from /sources \\
	into /scratch  \\
	but not *.html

    # Alternatively use 'except for *.html'.
}]

[example {
    $F do           \\
	move         \\
	the  index    \\
	from /sources  \\
	into /scratch   \\
	as   pkgIndex.tcl
}]

[example {
    $F do         \\
	remove     \\
	the *.txt  \\
	in /scratch
}]

Note that the fact that most commands just modify the object state
allows us to use more off forms as specifications instead of just
nearly-natural language sentences.

For example the second example in this section can re-arranged into:

[example {
    $F do            \\
	from /sources \\
	into /scratch  \\
	but not *.html \\
	move           \\
	the  *
}]

and the result is not only still a valid specification, but even stays
relatively readable.

[para]

Further note that the information collected by the commands [cmd but],
[cmd except], and [cmd as] is automatically reset after the associated
[cmd the] was executed. However no other state is reset in that
manner, allowing the user to avoid repetitions of unchanging
information. For example the second and third examples of this section
can be merged and rewritten into the equivalent:

[example {
$F do                   \\
    move                 \\
    the  *                \\
    from /sources          \\
    into /scratch           \\
    but not *.html not index \\
    the  index               \\
    as   pkgIndex.tcl
}]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph fileutil] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]
