/* http.c generated by valac 0.56.18, the Vala compiler
 * generated from http.vala, do not modify */

/*
 *    Copyright (C) 1999, 2000,
 *    Dirk-Jan C. Binnema <djcb@dds.nl>,
 *    Arjan Scherpenisse <acscherp@wins.uva.nl>
 *    Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */
/* HTTP fetches. */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TG_TYPE_HTTP_ERROR (tg_http_error_get_type ())

#define TG_TYPE_GUI (tg_gui_get_type ())
#define TG_GUI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_GUI, TgGui))
#define TG_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_GUI, TgGuiClass))
#define TG_IS_GUI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_GUI))
#define TG_IS_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_GUI))
#define TG_GUI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_GUI, TgGuiClass))

typedef struct _TgGui TgGui;
typedef struct _TgGuiClass TgGuiClass;

#define TG_TYPE_CHANNEL (tg_channel_get_type ())
#define TG_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_CHANNEL, TgChannel))
#define TG_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_CHANNEL, TgChannelClass))
#define TG_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_CHANNEL))
#define TG_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_CHANNEL))
#define TG_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_CHANNEL, TgChannelClass))

typedef struct _TgChannel TgChannel;
typedef struct _TgChannelClass TgChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	TG_HTTP_ERROR_PIXBUF,
	TG_HTTP_ERROR_VFS,
	TG_HTTP_ERROR_HTTPQUERY
} TgHttpError;
#define TG_HTTP_ERROR tg_http_error_quark ()

VALA_EXTERN GQuark tg_http_error_quark (void);
VALA_EXTERN GType tg_http_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tg_gui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TgGui, g_object_unref)
VALA_EXTERN GdkPixbuf* tg_http_get_image (TgGui* gui,
                              GError** error);
VALA_EXTERN GType tg_channel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TgChannel, g_object_unref)
VALA_EXTERN TgChannel* tg_gui_get_current_channel (TgGui* self);
VALA_EXTERN gint tg_gui_get_subpage_number (TgGui* self);
VALA_EXTERN const gchar* tg_channel_get_subpage_url (TgChannel* self);
VALA_EXTERN gint tg_gui_get_page_number (TgGui* self);
VALA_EXTERN const gchar* tg_channel_get_page_url (TgChannel* self);

GQuark
tg_http_error_quark (void)
{
	return g_quark_from_static_string ("tg-http-error-quark");
}

static GType
tg_http_error_get_type_once (void)
{
	static const GEnumValue values[] = {{TG_HTTP_ERROR_PIXBUF, "TG_HTTP_ERROR_PIXBUF", "pixbuf"}, {TG_HTTP_ERROR_VFS, "TG_HTTP_ERROR_VFS", "vfs"}, {TG_HTTP_ERROR_HTTPQUERY, "TG_HTTP_ERROR_HTTPQUERY", "httpquery"}, {0, NULL, NULL}};
	GType tg_http_error_type_id;
	tg_http_error_type_id = g_enum_register_static ("TgHttpError", values);
	return tg_http_error_type_id;
}

GType
tg_http_error_get_type (void)
{
	static volatile gsize tg_http_error_type_id__once = 0;
	if (g_once_init_enter (&tg_http_error_type_id__once)) {
		GType tg_http_error_type_id;
		tg_http_error_type_id = tg_http_error_get_type_once ();
		g_once_init_leave (&tg_http_error_type_id__once, tg_http_error_type_id);
	}
	return tg_http_error_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
tg_http_get_image (TgGui* gui,
                   GError** error)
{
	TgChannel* channel = NULL;
	TgChannel* _tmp0_;
	TgChannel* _tmp1_;
	TgChannel* _tmp2_;
	gchar* url = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	GFile* http_file = NULL;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFileInputStream* http_input = NULL;
	GdkPixbufLoader* loader = NULL;
	GdkPixbufLoader* _tmp47_;
	guint8* buf = NULL;
	guint8* _tmp48_;
	gint buf_length1;
	gint _buf_size_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbufLoader* _tmp74_;
	GdkPixbuf* _tmp75_;
	GdkPixbuf* _tmp76_;
	GdkPixbuf* _tmp77_;
	GdkPixbuf* _tmp80_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (gui != NULL, NULL);
	_tmp0_ = tg_gui_get_current_channel (gui);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	channel = _tmp2_;
	url = NULL;
	_tmp3_ = tg_gui_get_subpage_number (gui);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		gchar* subpage_url = NULL;
		TgChannel* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp5_ = channel;
		_tmp6_ = tg_channel_get_subpage_url (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		subpage_url = _tmp8_;
		_tmp10_ = subpage_url;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			_tmp11_ = subpage_url;
			_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			_tmp12_ = subpage_url;
			_tmp13_ = tg_gui_get_page_number (gui);
			_tmp14_ = _tmp13_;
			_tmp15_ = tg_gui_get_subpage_number (gui);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf (_tmp12_, _tmp14_, _tmp16_);
			_g_free0 (url);
			url = _tmp17_;
		}
		_g_free0 (subpage_url);
	}
	_tmp19_ = url;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = url;
		_tmp18_ = g_strcmp0 (_tmp20_, "") == 0;
	}
	if (_tmp18_) {
		gchar* page_url = NULL;
		TgChannel* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		const gchar* _tmp26_;
		_tmp21_ = channel;
		_tmp22_ = tg_channel_get_page_url (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup (_tmp23_);
		page_url = _tmp24_;
		_tmp26_ = page_url;
		if (_tmp26_ != NULL) {
			const gchar* _tmp27_;
			_tmp27_ = page_url;
			_tmp25_ = g_strcmp0 (_tmp27_, "") != 0;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			const gchar* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gchar* _tmp31_;
			_tmp28_ = page_url;
			_tmp29_ = tg_gui_get_page_number (gui);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf (_tmp28_, _tmp30_);
			_g_free0 (url);
			url = _tmp31_;
		}
		_g_free0 (page_url);
	}
	_tmp33_ = url;
	if (_tmp33_ == NULL) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp34_;
		_tmp34_ = url;
		_tmp32_ = g_strcmp0 (_tmp34_, "") == 0;
	}
	if (_tmp32_) {
		GError* _tmp35_;
		_tmp35_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_HTTPQUERY, "");
		_inner_error0_ = _tmp35_;
		if (_inner_error0_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp36_ = url;
	_tmp37_ = g_file_new_for_uri (_tmp36_);
	http_file = _tmp37_;
	{
		GFileInputStream* _tmp38_ = NULL;
		GFileInputStream* _tmp39_;
		GFileInputStream* _tmp40_;
		_tmp39_ = g_file_read (http_file, NULL, &_inner_error0_);
		_tmp38_ = _tmp39_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp40_ = _tmp38_;
		_tmp38_ = NULL;
		_g_object_unref0 (http_input);
		http_input = _tmp40_;
		_g_object_unref0 (_tmp38_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp41_;
		GError* _tmp42_;
		const gchar* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		GError* _tmp46_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = url;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("http.vala:62: Unable to fetch '%s': %s", _tmp41_, _tmp43_);
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		_tmp46_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_VFS, _tmp45_);
		_inner_error0_ = _tmp46_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp47_ = gdk_pixbuf_loader_new ();
	loader = _tmp47_;
	_tmp48_ = g_new0 (guint8, 4096);
	buf = _tmp48_;
	buf_length1 = 4096;
	_buf_size_ = buf_length1;
	{
		gboolean _tmp49_ = FALSE;
		_tmp49_ = TRUE;
		while (TRUE) {
			gssize bytes_read = 0L;
			if (!_tmp49_) {
			}
			_tmp49_ = FALSE;
			{
				gssize _tmp50_ = 0L;
				GFileInputStream* _tmp51_;
				guint8* _tmp52_;
				gint _tmp52__length1;
				_tmp51_ = http_input;
				_tmp52_ = buf;
				_tmp52__length1 = buf_length1;
				_tmp50_ = g_input_stream_read ((GInputStream*) _tmp51_, _tmp52_, (gsize) _tmp52__length1, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_IO_ERROR) {
						goto __catch1_g_io_error;
					}
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				bytes_read = _tmp50_;
				if (bytes_read == ((gssize) 0)) {
					break;
				}
			}
			goto __finally1;
			__catch1_g_io_error:
			{
				GError* e = NULL;
				const gchar* _tmp53_;
				GError* _tmp54_;
				const gchar* _tmp55_;
				GError* _tmp56_;
				const gchar* _tmp57_;
				GError* _tmp58_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp53_ = url;
				_tmp54_ = e;
				_tmp55_ = _tmp54_->message;
				g_warning ("http.vala:75: Unable to read data from '%s': %s", _tmp53_, _tmp55_);
				_tmp56_ = e;
				_tmp57_ = _tmp56_->message;
				_tmp58_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_VFS, _tmp57_);
				_inner_error0_ = _tmp58_;
				_g_error_free0 (e);
				goto __finally1;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == TG_HTTP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					return NULL;
				} else {
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			{
				GdkPixbufLoader* _tmp59_;
				guint8* _tmp60_;
				gint _tmp60__length1;
				_tmp59_ = loader;
				_tmp60_ = buf;
				_tmp60__length1 = buf_length1;
				gdk_pixbuf_loader_write (_tmp59_, _tmp60_ + 0, (gsize) (((gint) bytes_read) - 0), &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp61_;
				GError* _tmp62_;
				const gchar* _tmp63_;
				GError* _tmp64_;
				const gchar* _tmp65_;
				GError* _tmp66_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp61_ = url;
				_tmp62_ = e;
				_tmp63_ = _tmp62_->message;
				g_warning ("http.vala:82: Unable to parse image from '%s': %s", _tmp61_, _tmp63_);
				_tmp64_ = e;
				_tmp65_ = _tmp64_->message;
				_tmp66_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, _tmp65_);
				_inner_error0_ = _tmp66_;
				_g_error_free0 (e);
				goto __finally2;
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == TG_HTTP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					return NULL;
				} else {
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	{
		GdkPixbufLoader* _tmp67_;
		_tmp67_ = loader;
		gdk_pixbuf_loader_close (_tmp67_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp68_;
		GError* _tmp69_;
		const gchar* _tmp70_;
		GError* _tmp71_;
		const gchar* _tmp72_;
		GError* _tmp73_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp68_ = url;
		_tmp69_ = e;
		_tmp70_ = _tmp69_->message;
		g_warning ("http.vala:90: Unable to parse image from '%s': %s", _tmp68_, _tmp70_);
		_tmp71_ = e;
		_tmp72_ = _tmp71_->message;
		_tmp73_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, _tmp72_);
		_inner_error0_ = _tmp73_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp74_ = loader;
	_tmp75_ = gdk_pixbuf_loader_get_pixbuf (_tmp74_);
	_tmp76_ = _g_object_ref0 (_tmp75_);
	pixbuf = _tmp76_;
	_tmp77_ = pixbuf;
	if (_tmp77_ == NULL) {
		const gchar* _tmp78_;
		GError* _tmp79_;
		_tmp78_ = url;
		g_warning ("http.vala:97: Pixbuf loader did not create a pixbuf from '%s'", _tmp78_);
		_tmp79_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, "");
		_inner_error0_ = _tmp79_;
		if (_inner_error0_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pixbuf);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_object_unref0 (pixbuf);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp80_ = pixbuf;
	pixbuf = NULL;
	result = _tmp80_;
	_g_object_unref0 (pixbuf);
	buf = (g_free (buf), NULL);
	_g_object_unref0 (loader);
	_g_object_unref0 (http_input);
	_g_object_unref0 (http_file);
	_g_free0 (url);
	_g_object_unref0 (channel);
	return result;
}

