---
myst:
  html_meta:
    keywords: dessin, schema, TikZ, tikz, Tikz, fleche, ligne, decorate, decoration
---
# Comment tracer une ligne avec une flèche au milieu ?

Pour personnaliser les lignes, on peut utiliser le package <ctanpkg:tikz>.

:::{note}
On considère dans cet article que les bases de l’utilisation de ce package sont
connues. Si ce n’est pas le cas, on pourra se reporter à sa
[documentation](https://texlive.mycozy.space/graphics/pgf/base/doc/pgfmanual.pdf), ou à
l’excellent [TikZ pour l'impatient](http://math.et.info.free.fr/TikZ/index.html).
:::

## La bibliothèque `decorations.markings`

Afin de comprendre comment ajouter une flèche à une ligne, commençons par introduire cette
bibliothèque permettant de placer n’importe quelle « marque » sur un chemin défini par la
commande `\draw`.

Pour pouvoir bénéficier de cette bibliothèque, il faut la charger dans le préambule avec
la commande suivante :

```{noedit}
\usetikzlibrary{decorations.markings}
```


Voici un premier exemple.
```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings}
\usepackage{babel}

\begin{document}

\begin{tikzpicture}
  \draw[decorate, decoration={
    markings, mark= at position .3 with{
      \draw (-2pt,-2pt) -- (2pt,2pt);
      \draw (2pt,-2pt) -- (-2pt,2pt);
    }}
  ] (0,0) -- (4,0);
\end{tikzpicture}

\end{document}
```

L’exemple précédent permet de comprendre le principe, mais n’est pas très intéressant : on
ne voit qu’une seule marque et la ligne n’est pas tracée.

Dans le suivant, on trace plusieurs marques le long du chemin, ce qui est déjà mieux.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings}
\usepackage{tikz}


\begin{document}

\begin{tikzpicture}
  \draw[decorate, decoration={
    markings, mark= between positions 0 and 1 step .1 with{
      \draw (-2pt,-2pt) -- (2pt,2pt);
      \draw (2pt,-2pt) -- (-2pt,2pt);
    }}
  ] (0,0) -- (4,0);
\end{tikzpicture}

\end{document}
```

:::{note}
Ici, les positions et distances des marques sont indiquées en pourcentage de la
longueur du chemin, mais on peut utiliser des distances absolues en mm, cm, pt etc.
:::

## Ajouter la ligne

Maintenant que le principe de la « décoration » a été présenté, on souhaite faire
apparaitre la ligne.

Pour cela, on utilise une `postaction` dont le fonctionnement est décrit à la page 189 de la
 [documentation de Ti*k*Z](https://texlive.mycozy.space/graphics/pgf/base/doc/pgfmanual.pdf).

Voici un exemple :

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings}
\usepackage{babel}

\begin{document}

\begin{tikzpicture}
  \draw[postaction={decorate, decoration={
    markings, mark= between positions 0 and 1.0  step 0.1 with{
      \draw (-2pt,-2pt) -- (2pt,2pt);
      \draw (2pt,-2pt) -- (-2pt,2pt);
    }}}
  ] (0,0) -- (4,0);
\end{tikzpicture}

\end{document}
```

Cet exemple illustre l’idée générale : la décoration de la ligne se faisant en «
postaction », la ligne classique sera d’abord tracée, et ensuite les marques sont ajoutées.

:::{tip}
Pour plus d’informations sur les possibilités offertes par Ti*k*Z, on pourra se reporter à
la page 649 de sa [documentation](https://texlive.mycozy.space/graphics/pgf/base/doc/pgfmanual.pdf).
:::

## Placer une flèche au milieu

Pour placer une flèche, on reprend les principes présentés dans les parties précédentes et
on utilise la commande `\arrow` pour la marque.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings}
\usepackage{babel}

\begin{document}

\begin{tikzpicture}
  \draw[postaction={decorate, decoration={
    markings, mark= at position 0.5  with{
      \arrow[red]{>}
    }}}
  ] (0,0) -- (4,0);
\end{tikzpicture}

\end{document}
```

:::{todo}
Il faudrait trouver le moyen d’augmenter le zoom par défaut.
:::
:::{tip}
- Les options éventuelles que l’on peut passer à `\arrow` sont également présentées à la
page 649 de [sa documentation](https://texlive.mycozy.space/graphics/pgf/base/doc/pgfmanual.pdf).
- Il existe aussi la commande `\arrowreversed` qui peut être pratique dans certains cas.
:::


## Personnaliser les flèches
### Personnalisation par défaut
Ti*k*Z offre par défaut une certaine marge de personnalisation des flèches : on peut
choisir le sens, l’épaisseur de la ligne ou encore quelques types de flèches.

Voici un exemple :

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings}
\usepackage{babel}

\begin{document}

\begin{tikzpicture}
  \draw[postaction={decorate, decoration={
    markings, mark= at position 0.5  with{
      \arrow[red, line width=3pt, >=stealth]{>}
    }}}
  ] (0,0) -- (4,0);

  \draw[postaction={decorate, decoration={
    markings, mark= at position 0.5  with{
      \arrow[blue, line width=1pt, >=latex ]{<<}
    }}}
  ] (0,-1) -- (4,-1);
\end{tikzpicture}

\end{document}

```

### La bibliothèque `arrows.meta`

Cette bibliothèque qu’il faudra charger avec `usetikzlibrary{arrows.meta}` permet de
régler l’aspect des flèches de manière beaucoup plus fine.

Les nombreuses possibilités qu’elle offre sont décrites à partir de la page 190 de [la
documentation](https://texlive.mycozy.space/graphics/pgf/base/doc/pgfmanual.pdf).

On donne un exemple ci-dessous.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings, arrows.meta}
\usepackage{babel}

\begin{document}

\begin{tikzpicture}
  \draw[postaction={decorate, decoration={
    markings, mark= at position 0.5  with{
      \arrow{Triangle[open, width=20pt, length=10pt]}
    }}}
  ] (0,0) -- (4,0);
\end{tikzpicture}

\end{document}
```


:::{caution}
On remarque dans l’exemple précédent que les options de personnalisation ne sont pas au
même endroit que précédemment : les options par défaut sont passées à la commande `\arrow`
tandis que celles offertes par `arrows.meta` sont passées au type de
flèche choisi, ici `Triangle`.
:::

## Définir des styles
Si on utilise de manière fréquente le même type de ligne ou de flèche, Ti*k*Z offre la
possibilité de définir **des styles**.

Par exemple en optique géométrique, les styles des différents rayons lumineux peuvent être
définis comme dans l’exemple ci-dessous.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage[a4paper]{geometry}
\usepackage{tikz}
\usetikzlibrary{decorations.markings, arrows.meta}
\usepackage{babel}

\begin{document}

\begin{tikzpicture}
% Définition des styles
\tikzset{simple/.style={postaction={decorate,decoration={
          markings, mark= at position .8with{\arrow{Straight Barb[] }}}}}}

  \tikzset{simpleInv/.style={postaction={decorate,decoration={
          markings,mark=at position .8 with{\arrowreversed{Straight Barb[]}}}}}}

  \tikzset{double/.style={postaction={decorate,decoration={
          markings,mark=at position .8 with{\arrow{Straight Barb[] Straight Barb[]}}}}}}

	% Utilisation des styles
	\draw[simple, red] (0,0) -- (4,0);
	\draw[simpleInv, red] (0,-1) -- (4,-1);
	\draw[double, blue] (0,-2) -- (4,-2);
\end{tikzpicture}

\end{document}
```

:::{admonition} Obsolète
:class: attention
On trouve encore de nombreuses ressources utilisant la syntaxe `tikzstyle(⟨nom du style⟩)
[⟨options⟩]`, qui fonctionne encore mais n’est plus dans la documentation
officielle. Il est donc conseillé de ne plus l’utiliser.
:::
