/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef VINOUI_H
#define VINOUI_H

#include <QObject>
#include <QWidget>
#include <QRadioButton>
#include <QVBoxLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QByteArray>
#include <QDebug>
#include <QGSettings/QGSettings>
#include <QPushButton>
#include "inputpwddialog.h"
#include "titlelabel.h"
#include "kswitchbutton.h"
#include "switchwidget.h"
#include "settinggroup.h"
#include "ukccframe.h"
#include "passwordlabel.h"

const QByteArray kVinoSchemas = "org.gnome.Vino";
const QString kEnableKey =  "enabled";
const QString kXrdpEnableKey = "xrdp-enabled";
const QString kVinoEnableKey = "vino-enabled";
const QString kVinoViewOnlyKey = "view-only";
const QString kVinoPromptKey = "prompt-enabled";
const QString kAuthenticationKey = "authentication-methods";
const QString kVncPwdKey = "vnc-password";

const QByteArray kUkccVnoSchmas = "org.ukui.control-center.vino";
const QString kUkccPromptKey = "remote";
using namespace kdk;

class VinoUi : public QWidget
{
    Q_OBJECT
public:
    explicit VinoUi(QWidget *parent = nullptr);
    void initUi();
    void setFrameVisible(bool visible);

    SwitchWidget *getEnableWidget() {return mEnableWidget;}
    SwitchWidget *getXrdpEnableWidget() {return mXrdpEnableWidget;}
    SettingGroup *getVinoFrame() {return mVinoFrame;}
    SwitchWidget *getVinoEnableWidget() {return mVinoEnableWidget;}
    SwitchWidget *getViewWidget() {return mViewWidget;}
    SwitchWidget *getSecurityWidget() {return mSecurityWidget;}
    SwitchWidget *getSecurityPwdWidget() {return mSecurityPwdWidget;}

#ifdef Nile
    PasswordLabel *getPwdLabel() {return mPwdinputLabel;}
#else
    QLabel *getPwdLabel() {return mPwdstrLabel;}
#endif
    QPushButton *getPwdEditBtn() {return mPwdEditBtn;}

private:
    SwitchWidget *mEnableWidget;     // 允许其他人查看桌面
    SwitchWidget *mXrdpEnableWidget; // 允许其他人使用rdp远程连接
    SettingGroup *mVinoFrame;
    SwitchWidget *mVinoEnableWidget; // 允许其他人使用vnc远程连接
    SwitchWidget *mViewWidget;       // 允许连接控制屏幕
    SwitchWidget *mSecurityWidget;   // 为本机确认每次访问
    SwitchWidget *mSecurityPwdWidget;// 要求用户输入密码

    TitleLabel *mVinoTitleLabel;

    QLabel *mPwdstrLabel;
    PasswordLabel *mPwdinputLabel;
    QPushButton *mPwdEditBtn;
};

#endif // VINOUI_H
