/*
 * userv - lib.c
 * Useful very-low-level utility routines' declarations,
 * for both client and daemon.
 *
 * Copyright (C)1999,2001 Ian Jackson
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with userv; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BOTH_H
#define BOTH_H

/* provided by both.c */

void *xmalloc(size_t s);
void *xrealloc(void *p, size_t s);
char *xstrsave(const char *s);

int working_getc(FILE *file);
size_t working_fread(void *ptr, size_t sz, FILE *file);

/* used by both.c, so must be present */

void syscallerror(const char *what) NONRETURNING;

#define ISCHAR(iswotsit,ch) (iswotsit((unsigned char)(ch))) /*Feh!*/

#endif
