/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xwatch.h"

void addline (char *buf, int colindex)
{
    char
	outbuf [1000];
    int
        i,
        length_so_far,
        extra_length,
	curwidth,
	curheight,
	curx,
	cury;
    char
        *bufcopy,
	*cp;
        
    /* clear trailing \n chars */
    if ( (cp = strchr (buf, '\n')) && cp > buf )
	*cp = '\0';
    if (! *buf)
        return;

    /* see if the contents of the line is `gagged' */
    for (i = 0; i < ngagstring; i++)
        if (strstr (buf, gagstring [i]))
            return;

    /* determine width to use */
    fl_get_browser_dimension (watch_browser, &curx, &cury, 
        &curwidth, &curheight);
    curwidth -= 5;

    /* reset outbuffer */
    outbuf [0] = '\0';

    /* process whole buf, cut it up if necessary */
    bufcopy = xstrdup (buf);
    cp = strtok (bufcopy, " \t");
    while (cp)
    {
        int empty_outbuf = 0;
	/* add color code if necessary */
	if (! outbuf [0])
	{
	    if (colindex != foregr)
		sprintf (outbuf, "@C%d ", colindex);
            else
		strcpy (outbuf, " ");
	    empty_outbuf = 1;
	}

	/* determine length of string so far, flush if necessary */
        length_so_far = fl_get_string_width (fontstyle, fontsize, outbuf,
            strlen (outbuf));
        extra_length = fl_get_string_width (fontstyle, fontsize, cp, 
            strlen (cp));

	/* If the next word is too long to fit, and we have nothing */
	/* to print, */
	if (empty_outbuf && length_so_far + extra_length > curwidth)
	{
            /* print it anyway */
            /* break it into width-sized chunks */
            while (*cp)
            {
                int
                    len_to_print,
                    len_of_color_code;
                
                /* start each line with color code */
                if (colindex != foregr)
                    sprintf (outbuf, "@C%d ", colindex);
                else
                    strcpy (outbuf, " ");
                strcat (outbuf, " ");
                len_of_color_code = strlen(outbuf);
                strcat(outbuf, cp);
                len_to_print = strlen(outbuf);
                while (fl_get_string_width (fontstyle, fontsize, outbuf,
                                            len_to_print) > curwidth
                       && len_to_print > len_of_color_code)
                {
                    --len_to_print;
                }
                /* Make sure we manage to print at least one new character */
                if (len_to_print <= len_of_color_code)
                    len_to_print = len_of_color_code + 1;
                outbuf[len_to_print] = '\0';
                fl_addto_browser (watch_browser, outbuf);
                cp += len_to_print - len_of_color_code;
            }
            outbuf[0] = '\0';
            /* and get the next word */
            cp = strtok (NULL, " \t");
        }
	else if (length_so_far + extra_length > curwidth)
        {
	    fl_addto_browser (watch_browser, outbuf);
	    outbuf [0] = '\0';
	}
        else
        {
            strcat (outbuf, " ");
	    strcat (outbuf, cp);
            cp = strtok (NULL, " \t");
        }
    }
    
    /* flush whatever's left */
    if (cp)
        strcat (outbuf, cp);
    if (outbuf [0])
	fl_addto_browser (watch_browser, outbuf);
        
    /* release memory */
    free (bufcopy);
}
