# encoding: utf-8
# 2011 © Bruno Chareyre <bruno.chareyre@hmg.inpg.fr>
# Check the result of a triaxial test on a dense 100 spheres packing with position defined,
# comparing stresses at the "peak" state. The initial positions have been generated by
# internal compaction without friction, so that it is initially at equilibrium without shear forces. 
# Positions and reference results are in data folder.
from yade import pack,utils,export,plot
import math,os,sys

tolerance=0.01
interactive=False
errors=0
tt=TriaxialTest(internalCompaction=True,numberOfGrains=100,compactionFrictionDeg=0,sphereFrictionDeg=30,importFilename=checksPath+'/data/checkTestTriax.spheres')
tt.generate("checkTest.yade")
O.load("checkTest.yade")
O.run(2020,True)
if interactive:
	print O.engines[4].stress(0)[1],O.engines[4].stress(1)[1], O.engines[4].stress(2)[0], O.engines[4].stress(3)[0], O.engines[4].stress(4)[2], O.engines[4].stress(5)[2]
	os.system('gnuplot -e "plot \'./WallStresses\' using 1:3; replot'+checksPath+'\'/data/WallStressesCheckTest\' using 1:3; replot '+checksPath+'\'/data/WallStresses\' using 1:4; replot '+checksPath+'\'/data/WallStressesCheckTest\' using 1:4; pause -1"')

if abs((O.engines[4].stress(3)[1]-107157.2)/107157.2)>tolerance :
	print "Triaxial checkTest: difference on peak stress"
	errors+=1
if abs((O.engines[4].stress(1)[0]-50058.7)/50058.7)>tolerance :
	print "Triaxial checkTest: difference on confining stress"
	errors+=1
	
if (errors):
	resultStatus +=1	#Test is failed

if (errors):
	resultStatus +=1	#Test is failed
