﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the MIT license.  See License.txt in the project root for license information.

namespace Reference.Assemblies
{
    internal static class Net60Resources
    {
        private static byte[]? _MicrosoftCSharp;
        internal static byte[] MicrosoftCSharp => ResourceLoader.GetOrCreateResource(ref _MicrosoftCSharp, "net60.Microsoft.CSharp");
        private static byte[]? _MicrosoftVisualBasicCore;
        internal static byte[] MicrosoftVisualBasicCore => ResourceLoader.GetOrCreateResource(ref _MicrosoftVisualBasicCore, "net60.Microsoft.VisualBasic.Core");
        private static byte[]? _MicrosoftVisualBasic;
        internal static byte[] MicrosoftVisualBasic => ResourceLoader.GetOrCreateResource(ref _MicrosoftVisualBasic, "net60.Microsoft.VisualBasic");
        private static byte[]? _MicrosoftWin32Primitives;
        internal static byte[] MicrosoftWin32Primitives => ResourceLoader.GetOrCreateResource(ref _MicrosoftWin32Primitives, "net60.Microsoft.Win32.Primitives");
        private static byte[]? _mscorlib;
        internal static byte[] mscorlib => ResourceLoader.GetOrCreateResource(ref _mscorlib, "net60.mscorlib");
        private static byte[]? _netstandard;
        internal static byte[] netstandard => ResourceLoader.GetOrCreateResource(ref _netstandard, "net60.netstandard");
        private static byte[]? _SystemAppContext;
        internal static byte[] SystemAppContext => ResourceLoader.GetOrCreateResource(ref _SystemAppContext, "net60.System.AppContext");
        private static byte[]? _SystemBuffers;
        internal static byte[] SystemBuffers => ResourceLoader.GetOrCreateResource(ref _SystemBuffers, "net60.System.Buffers");
        private static byte[]? _SystemCollectionsConcurrent;
        internal static byte[] SystemCollectionsConcurrent => ResourceLoader.GetOrCreateResource(ref _SystemCollectionsConcurrent, "net60.System.Collections.Concurrent");
        private static byte[]? _SystemCollections;
        internal static byte[] SystemCollections => ResourceLoader.GetOrCreateResource(ref _SystemCollections, "net60.System.Collections");
        private static byte[]? _SystemCollectionsImmutable;
        internal static byte[] SystemCollectionsImmutable => ResourceLoader.GetOrCreateResource(ref _SystemCollectionsImmutable, "net60.System.Collections.Immutable");
        private static byte[]? _SystemCollectionsNonGeneric;
        internal static byte[] SystemCollectionsNonGeneric => ResourceLoader.GetOrCreateResource(ref _SystemCollectionsNonGeneric, "net60.System.Collections.NonGeneric");
        private static byte[]? _SystemCollectionsSpecialized;
        internal static byte[] SystemCollectionsSpecialized => ResourceLoader.GetOrCreateResource(ref _SystemCollectionsSpecialized, "net60.System.Collections.Specialized");
        private static byte[]? _SystemComponentModelAnnotations;
        internal static byte[] SystemComponentModelAnnotations => ResourceLoader.GetOrCreateResource(ref _SystemComponentModelAnnotations, "net60.System.ComponentModel.Annotations");
        private static byte[]? _SystemComponentModelDataAnnotations;
        internal static byte[] SystemComponentModelDataAnnotations => ResourceLoader.GetOrCreateResource(ref _SystemComponentModelDataAnnotations, "net60.System.ComponentModel.DataAnnotations");
        private static byte[]? _SystemComponentModel;
        internal static byte[] SystemComponentModel => ResourceLoader.GetOrCreateResource(ref _SystemComponentModel, "net60.System.ComponentModel");
        private static byte[]? _SystemComponentModelEventBasedAsync;
        internal static byte[] SystemComponentModelEventBasedAsync => ResourceLoader.GetOrCreateResource(ref _SystemComponentModelEventBasedAsync, "net60.System.ComponentModel.EventBasedAsync");
        private static byte[]? _SystemComponentModelPrimitives;
        internal static byte[] SystemComponentModelPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemComponentModelPrimitives, "net60.System.ComponentModel.Primitives");
        private static byte[]? _SystemComponentModelTypeConverter;
        internal static byte[] SystemComponentModelTypeConverter => ResourceLoader.GetOrCreateResource(ref _SystemComponentModelTypeConverter, "net60.System.ComponentModel.TypeConverter");
        private static byte[]? _SystemConfiguration;
        internal static byte[] SystemConfiguration => ResourceLoader.GetOrCreateResource(ref _SystemConfiguration, "net60.System.Configuration");
        private static byte[]? _SystemConsole;
        internal static byte[] SystemConsole => ResourceLoader.GetOrCreateResource(ref _SystemConsole, "net60.System.Console");
        private static byte[]? _SystemCore;
        internal static byte[] SystemCore => ResourceLoader.GetOrCreateResource(ref _SystemCore, "net60.System.Core");
        private static byte[]? _SystemDataCommon;
        internal static byte[] SystemDataCommon => ResourceLoader.GetOrCreateResource(ref _SystemDataCommon, "net60.System.Data.Common");
        private static byte[]? _SystemDataDataSetExtensions;
        internal static byte[] SystemDataDataSetExtensions => ResourceLoader.GetOrCreateResource(ref _SystemDataDataSetExtensions, "net60.System.Data.DataSetExtensions");
        private static byte[]? _SystemData;
        internal static byte[] SystemData => ResourceLoader.GetOrCreateResource(ref _SystemData, "net60.System.Data");
        private static byte[]? _SystemDiagnosticsContracts;
        internal static byte[] SystemDiagnosticsContracts => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsContracts, "net60.System.Diagnostics.Contracts");
        private static byte[]? _SystemDiagnosticsDebug;
        internal static byte[] SystemDiagnosticsDebug => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsDebug, "net60.System.Diagnostics.Debug");
        private static byte[]? _SystemDiagnosticsDiagnosticSource;
        internal static byte[] SystemDiagnosticsDiagnosticSource => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsDiagnosticSource, "net60.System.Diagnostics.DiagnosticSource");
        private static byte[]? _SystemDiagnosticsFileVersionInfo;
        internal static byte[] SystemDiagnosticsFileVersionInfo => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsFileVersionInfo, "net60.System.Diagnostics.FileVersionInfo");
        private static byte[]? _SystemDiagnosticsProcess;
        internal static byte[] SystemDiagnosticsProcess => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsProcess, "net60.System.Diagnostics.Process");
        private static byte[]? _SystemDiagnosticsStackTrace;
        internal static byte[] SystemDiagnosticsStackTrace => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsStackTrace, "net60.System.Diagnostics.StackTrace");
        private static byte[]? _SystemDiagnosticsTextWriterTraceListener;
        internal static byte[] SystemDiagnosticsTextWriterTraceListener => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsTextWriterTraceListener, "net60.System.Diagnostics.TextWriterTraceListener");
        private static byte[]? _SystemDiagnosticsTools;
        internal static byte[] SystemDiagnosticsTools => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsTools, "net60.System.Diagnostics.Tools");
        private static byte[]? _SystemDiagnosticsTraceSource;
        internal static byte[] SystemDiagnosticsTraceSource => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsTraceSource, "net60.System.Diagnostics.TraceSource");
        private static byte[]? _SystemDiagnosticsTracing;
        internal static byte[] SystemDiagnosticsTracing => ResourceLoader.GetOrCreateResource(ref _SystemDiagnosticsTracing, "net60.System.Diagnostics.Tracing");
        private static byte[]? _System;
        internal static byte[] System => ResourceLoader.GetOrCreateResource(ref _System, "net60.System");
        private static byte[]? _SystemDrawing;
        internal static byte[] SystemDrawing => ResourceLoader.GetOrCreateResource(ref _SystemDrawing, "net60.System.Drawing");
        private static byte[]? _SystemDrawingPrimitives;
        internal static byte[] SystemDrawingPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemDrawingPrimitives, "net60.System.Drawing.Primitives");
        private static byte[]? _SystemDynamicRuntime;
        internal static byte[] SystemDynamicRuntime => ResourceLoader.GetOrCreateResource(ref _SystemDynamicRuntime, "net60.System.Dynamic.Runtime");
        private static byte[]? _SystemFormatsAsn1;
        internal static byte[] SystemFormatsAsn1 => ResourceLoader.GetOrCreateResource(ref _SystemFormatsAsn1, "net60.System.Formats.Asn1");
        private static byte[]? _SystemGlobalizationCalendars;
        internal static byte[] SystemGlobalizationCalendars => ResourceLoader.GetOrCreateResource(ref _SystemGlobalizationCalendars, "net60.System.Globalization.Calendars");
        private static byte[]? _SystemGlobalization;
        internal static byte[] SystemGlobalization => ResourceLoader.GetOrCreateResource(ref _SystemGlobalization, "net60.System.Globalization");
        private static byte[]? _SystemGlobalizationExtensions;
        internal static byte[] SystemGlobalizationExtensions => ResourceLoader.GetOrCreateResource(ref _SystemGlobalizationExtensions, "net60.System.Globalization.Extensions");
        private static byte[]? _SystemIOCompressionBrotli;
        internal static byte[] SystemIOCompressionBrotli => ResourceLoader.GetOrCreateResource(ref _SystemIOCompressionBrotli, "net60.System.IO.Compression.Brotli");
        private static byte[]? _SystemIOCompression;
        internal static byte[] SystemIOCompression => ResourceLoader.GetOrCreateResource(ref _SystemIOCompression, "net60.System.IO.Compression");
        private static byte[]? _SystemIOCompressionFileSystem;
        internal static byte[] SystemIOCompressionFileSystem => ResourceLoader.GetOrCreateResource(ref _SystemIOCompressionFileSystem, "net60.System.IO.Compression.FileSystem");
        private static byte[]? _SystemIOCompressionZipFile;
        internal static byte[] SystemIOCompressionZipFile => ResourceLoader.GetOrCreateResource(ref _SystemIOCompressionZipFile, "net60.System.IO.Compression.ZipFile");
        private static byte[]? _SystemIO;
        internal static byte[] SystemIO => ResourceLoader.GetOrCreateResource(ref _SystemIO, "net60.System.IO");
        private static byte[]? _SystemIOFileSystem;
        internal static byte[] SystemIOFileSystem => ResourceLoader.GetOrCreateResource(ref _SystemIOFileSystem, "net60.System.IO.FileSystem");
        private static byte[]? _SystemIOFileSystemDriveInfo;
        internal static byte[] SystemIOFileSystemDriveInfo => ResourceLoader.GetOrCreateResource(ref _SystemIOFileSystemDriveInfo, "net60.System.IO.FileSystem.DriveInfo");
        private static byte[]? _SystemIOFileSystemPrimitives;
        internal static byte[] SystemIOFileSystemPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemIOFileSystemPrimitives, "net60.System.IO.FileSystem.Primitives");
        private static byte[]? _SystemIOFileSystemWatcher;
        internal static byte[] SystemIOFileSystemWatcher => ResourceLoader.GetOrCreateResource(ref _SystemIOFileSystemWatcher, "net60.System.IO.FileSystem.Watcher");
        private static byte[]? _SystemIOIsolatedStorage;
        internal static byte[] SystemIOIsolatedStorage => ResourceLoader.GetOrCreateResource(ref _SystemIOIsolatedStorage, "net60.System.IO.IsolatedStorage");
        private static byte[]? _SystemIOMemoryMappedFiles;
        internal static byte[] SystemIOMemoryMappedFiles => ResourceLoader.GetOrCreateResource(ref _SystemIOMemoryMappedFiles, "net60.System.IO.MemoryMappedFiles");
        private static byte[]? _SystemIOPipes;
        internal static byte[] SystemIOPipes => ResourceLoader.GetOrCreateResource(ref _SystemIOPipes, "net60.System.IO.Pipes");
        private static byte[]? _SystemIOUnmanagedMemoryStream;
        internal static byte[] SystemIOUnmanagedMemoryStream => ResourceLoader.GetOrCreateResource(ref _SystemIOUnmanagedMemoryStream, "net60.System.IO.UnmanagedMemoryStream");
        private static byte[]? _SystemLinq;
        internal static byte[] SystemLinq => ResourceLoader.GetOrCreateResource(ref _SystemLinq, "net60.System.Linq");
        private static byte[]? _SystemLinqExpressions;
        internal static byte[] SystemLinqExpressions => ResourceLoader.GetOrCreateResource(ref _SystemLinqExpressions, "net60.System.Linq.Expressions");
        private static byte[]? _SystemLinqParallel;
        internal static byte[] SystemLinqParallel => ResourceLoader.GetOrCreateResource(ref _SystemLinqParallel, "net60.System.Linq.Parallel");
        private static byte[]? _SystemLinqQueryable;
        internal static byte[] SystemLinqQueryable => ResourceLoader.GetOrCreateResource(ref _SystemLinqQueryable, "net60.System.Linq.Queryable");
        private static byte[]? _SystemMemory;
        internal static byte[] SystemMemory => ResourceLoader.GetOrCreateResource(ref _SystemMemory, "net60.System.Memory");
        private static byte[]? _SystemNet;
        internal static byte[] SystemNet => ResourceLoader.GetOrCreateResource(ref _SystemNet, "net60.System.Net");
        private static byte[]? _SystemNetHttp;
        internal static byte[] SystemNetHttp => ResourceLoader.GetOrCreateResource(ref _SystemNetHttp, "net60.System.Net.Http");
        private static byte[]? _SystemNetHttpJson;
        internal static byte[] SystemNetHttpJson => ResourceLoader.GetOrCreateResource(ref _SystemNetHttpJson, "net60.System.Net.Http.Json");
        private static byte[]? _SystemNetHttpListener;
        internal static byte[] SystemNetHttpListener => ResourceLoader.GetOrCreateResource(ref _SystemNetHttpListener, "net60.System.Net.HttpListener");
        private static byte[]? _SystemNetMail;
        internal static byte[] SystemNetMail => ResourceLoader.GetOrCreateResource(ref _SystemNetMail, "net60.System.Net.Mail");
        private static byte[]? _SystemNetNameResolution;
        internal static byte[] SystemNetNameResolution => ResourceLoader.GetOrCreateResource(ref _SystemNetNameResolution, "net60.System.Net.NameResolution");
        private static byte[]? _SystemNetNetworkInformation;
        internal static byte[] SystemNetNetworkInformation => ResourceLoader.GetOrCreateResource(ref _SystemNetNetworkInformation, "net60.System.Net.NetworkInformation");
        private static byte[]? _SystemNetPing;
        internal static byte[] SystemNetPing => ResourceLoader.GetOrCreateResource(ref _SystemNetPing, "net60.System.Net.Ping");
        private static byte[]? _SystemNetPrimitives;
        internal static byte[] SystemNetPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemNetPrimitives, "net60.System.Net.Primitives");
        private static byte[]? _SystemNetQuic;
        internal static byte[] SystemNetQuic => ResourceLoader.GetOrCreateResource(ref _SystemNetQuic, "net60.System.Net.Quic");
        private static byte[]? _SystemNetRequests;
        internal static byte[] SystemNetRequests => ResourceLoader.GetOrCreateResource(ref _SystemNetRequests, "net60.System.Net.Requests");
        private static byte[]? _SystemNetSecurity;
        internal static byte[] SystemNetSecurity => ResourceLoader.GetOrCreateResource(ref _SystemNetSecurity, "net60.System.Net.Security");
        private static byte[]? _SystemNetServicePoint;
        internal static byte[] SystemNetServicePoint => ResourceLoader.GetOrCreateResource(ref _SystemNetServicePoint, "net60.System.Net.ServicePoint");
        private static byte[]? _SystemNetSockets;
        internal static byte[] SystemNetSockets => ResourceLoader.GetOrCreateResource(ref _SystemNetSockets, "net60.System.Net.Sockets");
        private static byte[]? _SystemNetWebClient;
        internal static byte[] SystemNetWebClient => ResourceLoader.GetOrCreateResource(ref _SystemNetWebClient, "net60.System.Net.WebClient");
        private static byte[]? _SystemNetWebHeaderCollection;
        internal static byte[] SystemNetWebHeaderCollection => ResourceLoader.GetOrCreateResource(ref _SystemNetWebHeaderCollection, "net60.System.Net.WebHeaderCollection");
        private static byte[]? _SystemNetWebProxy;
        internal static byte[] SystemNetWebProxy => ResourceLoader.GetOrCreateResource(ref _SystemNetWebProxy, "net60.System.Net.WebProxy");
        private static byte[]? _SystemNetWebSocketsClient;
        internal static byte[] SystemNetWebSocketsClient => ResourceLoader.GetOrCreateResource(ref _SystemNetWebSocketsClient, "net60.System.Net.WebSockets.Client");
        private static byte[]? _SystemNetWebSockets;
        internal static byte[] SystemNetWebSockets => ResourceLoader.GetOrCreateResource(ref _SystemNetWebSockets, "net60.System.Net.WebSockets");
        private static byte[]? _SystemNumerics;
        internal static byte[] SystemNumerics => ResourceLoader.GetOrCreateResource(ref _SystemNumerics, "net60.System.Numerics");
        private static byte[]? _SystemNumericsVectors;
        internal static byte[] SystemNumericsVectors => ResourceLoader.GetOrCreateResource(ref _SystemNumericsVectors, "net60.System.Numerics.Vectors");
        private static byte[]? _SystemObjectModel;
        internal static byte[] SystemObjectModel => ResourceLoader.GetOrCreateResource(ref _SystemObjectModel, "net60.System.ObjectModel");
        private static byte[]? _SystemReflectionDispatchProxy;
        internal static byte[] SystemReflectionDispatchProxy => ResourceLoader.GetOrCreateResource(ref _SystemReflectionDispatchProxy, "net60.System.Reflection.DispatchProxy");
        private static byte[]? _SystemReflection;
        internal static byte[] SystemReflection => ResourceLoader.GetOrCreateResource(ref _SystemReflection, "net60.System.Reflection");
        private static byte[]? _SystemReflectionEmit;
        internal static byte[] SystemReflectionEmit => ResourceLoader.GetOrCreateResource(ref _SystemReflectionEmit, "net60.System.Reflection.Emit");
        private static byte[]? _SystemReflectionEmitILGeneration;
        internal static byte[] SystemReflectionEmitILGeneration => ResourceLoader.GetOrCreateResource(ref _SystemReflectionEmitILGeneration, "net60.System.Reflection.Emit.ILGeneration");
        private static byte[]? _SystemReflectionEmitLightweight;
        internal static byte[] SystemReflectionEmitLightweight => ResourceLoader.GetOrCreateResource(ref _SystemReflectionEmitLightweight, "net60.System.Reflection.Emit.Lightweight");
        private static byte[]? _SystemReflectionExtensions;
        internal static byte[] SystemReflectionExtensions => ResourceLoader.GetOrCreateResource(ref _SystemReflectionExtensions, "net60.System.Reflection.Extensions");
        private static byte[]? _SystemReflectionMetadata;
        internal static byte[] SystemReflectionMetadata => ResourceLoader.GetOrCreateResource(ref _SystemReflectionMetadata, "net60.System.Reflection.Metadata");
        private static byte[]? _SystemReflectionPrimitives;
        internal static byte[] SystemReflectionPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemReflectionPrimitives, "net60.System.Reflection.Primitives");
        private static byte[]? _SystemReflectionTypeExtensions;
        internal static byte[] SystemReflectionTypeExtensions => ResourceLoader.GetOrCreateResource(ref _SystemReflectionTypeExtensions, "net60.System.Reflection.TypeExtensions");
        private static byte[]? _SystemResourcesReader;
        internal static byte[] SystemResourcesReader => ResourceLoader.GetOrCreateResource(ref _SystemResourcesReader, "net60.System.Resources.Reader");
        private static byte[]? _SystemResourcesResourceManager;
        internal static byte[] SystemResourcesResourceManager => ResourceLoader.GetOrCreateResource(ref _SystemResourcesResourceManager, "net60.System.Resources.ResourceManager");
        private static byte[]? _SystemResourcesWriter;
        internal static byte[] SystemResourcesWriter => ResourceLoader.GetOrCreateResource(ref _SystemResourcesWriter, "net60.System.Resources.Writer");
        private static byte[]? _SystemRuntimeCompilerServicesUnsafe;
        internal static byte[] SystemRuntimeCompilerServicesUnsafe => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeCompilerServicesUnsafe, "net60.System.Runtime.CompilerServices.Unsafe");
        private static byte[]? _SystemRuntimeCompilerServicesVisualC;
        internal static byte[] SystemRuntimeCompilerServicesVisualC => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeCompilerServicesVisualC, "net60.System.Runtime.CompilerServices.VisualC");
        private static byte[]? _SystemRuntime;
        internal static byte[] SystemRuntime => ResourceLoader.GetOrCreateResource(ref _SystemRuntime, "net60.System.Runtime");
        private static byte[]? _SystemRuntimeExtensions;
        internal static byte[] SystemRuntimeExtensions => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeExtensions, "net60.System.Runtime.Extensions");
        private static byte[]? _SystemRuntimeHandles;
        internal static byte[] SystemRuntimeHandles => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeHandles, "net60.System.Runtime.Handles");
        private static byte[]? _SystemRuntimeInteropServices;
        internal static byte[] SystemRuntimeInteropServices => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeInteropServices, "net60.System.Runtime.InteropServices");
        private static byte[]? _SystemRuntimeInteropServicesRuntimeInformation;
        internal static byte[] SystemRuntimeInteropServicesRuntimeInformation => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeInteropServicesRuntimeInformation, "net60.System.Runtime.InteropServices.RuntimeInformation");
        private static byte[]? _SystemRuntimeIntrinsics;
        internal static byte[] SystemRuntimeIntrinsics => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeIntrinsics, "net60.System.Runtime.Intrinsics");
        private static byte[]? _SystemRuntimeLoader;
        internal static byte[] SystemRuntimeLoader => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeLoader, "net60.System.Runtime.Loader");
        private static byte[]? _SystemRuntimeNumerics;
        internal static byte[] SystemRuntimeNumerics => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeNumerics, "net60.System.Runtime.Numerics");
        private static byte[]? _SystemRuntimeSerialization;
        internal static byte[] SystemRuntimeSerialization => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeSerialization, "net60.System.Runtime.Serialization");
        private static byte[]? _SystemRuntimeSerializationFormatters;
        internal static byte[] SystemRuntimeSerializationFormatters => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeSerializationFormatters, "net60.System.Runtime.Serialization.Formatters");
        private static byte[]? _SystemRuntimeSerializationJson;
        internal static byte[] SystemRuntimeSerializationJson => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeSerializationJson, "net60.System.Runtime.Serialization.Json");
        private static byte[]? _SystemRuntimeSerializationPrimitives;
        internal static byte[] SystemRuntimeSerializationPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeSerializationPrimitives, "net60.System.Runtime.Serialization.Primitives");
        private static byte[]? _SystemRuntimeSerializationXml;
        internal static byte[] SystemRuntimeSerializationXml => ResourceLoader.GetOrCreateResource(ref _SystemRuntimeSerializationXml, "net60.System.Runtime.Serialization.Xml");
        private static byte[]? _SystemSecurityClaims;
        internal static byte[] SystemSecurityClaims => ResourceLoader.GetOrCreateResource(ref _SystemSecurityClaims, "net60.System.Security.Claims");
        private static byte[]? _SystemSecurityCryptographyAlgorithms;
        internal static byte[] SystemSecurityCryptographyAlgorithms => ResourceLoader.GetOrCreateResource(ref _SystemSecurityCryptographyAlgorithms, "net60.System.Security.Cryptography.Algorithms");
        private static byte[]? _SystemSecurityCryptographyCsp;
        internal static byte[] SystemSecurityCryptographyCsp => ResourceLoader.GetOrCreateResource(ref _SystemSecurityCryptographyCsp, "net60.System.Security.Cryptography.Csp");
        private static byte[]? _SystemSecurityCryptographyEncoding;
        internal static byte[] SystemSecurityCryptographyEncoding => ResourceLoader.GetOrCreateResource(ref _SystemSecurityCryptographyEncoding, "net60.System.Security.Cryptography.Encoding");
        private static byte[]? _SystemSecurityCryptographyPrimitives;
        internal static byte[] SystemSecurityCryptographyPrimitives => ResourceLoader.GetOrCreateResource(ref _SystemSecurityCryptographyPrimitives, "net60.System.Security.Cryptography.Primitives");
        private static byte[]? _SystemSecurityCryptographyX509Certificates;
        internal static byte[] SystemSecurityCryptographyX509Certificates => ResourceLoader.GetOrCreateResource(ref _SystemSecurityCryptographyX509Certificates, "net60.System.Security.Cryptography.X509Certificates");
        private static byte[]? _SystemSecurity;
        internal static byte[] SystemSecurity => ResourceLoader.GetOrCreateResource(ref _SystemSecurity, "net60.System.Security");
        private static byte[]? _SystemSecurityPrincipal;
        internal static byte[] SystemSecurityPrincipal => ResourceLoader.GetOrCreateResource(ref _SystemSecurityPrincipal, "net60.System.Security.Principal");
        private static byte[]? _SystemSecuritySecureString;
        internal static byte[] SystemSecuritySecureString => ResourceLoader.GetOrCreateResource(ref _SystemSecuritySecureString, "net60.System.Security.SecureString");
        private static byte[]? _SystemServiceModelWeb;
        internal static byte[] SystemServiceModelWeb => ResourceLoader.GetOrCreateResource(ref _SystemServiceModelWeb, "net60.System.ServiceModel.Web");
        private static byte[]? _SystemServiceProcess;
        internal static byte[] SystemServiceProcess => ResourceLoader.GetOrCreateResource(ref _SystemServiceProcess, "net60.System.ServiceProcess");
        private static byte[]? _SystemTextEncodingCodePages;
        internal static byte[] SystemTextEncodingCodePages => ResourceLoader.GetOrCreateResource(ref _SystemTextEncodingCodePages, "net60.System.Text.Encoding.CodePages");
        private static byte[]? _SystemTextEncoding;
        internal static byte[] SystemTextEncoding => ResourceLoader.GetOrCreateResource(ref _SystemTextEncoding, "net60.System.Text.Encoding");
        private static byte[]? _SystemTextEncodingExtensions;
        internal static byte[] SystemTextEncodingExtensions => ResourceLoader.GetOrCreateResource(ref _SystemTextEncodingExtensions, "net60.System.Text.Encoding.Extensions");
        private static byte[]? _SystemTextEncodingsWeb;
        internal static byte[] SystemTextEncodingsWeb => ResourceLoader.GetOrCreateResource(ref _SystemTextEncodingsWeb, "net60.System.Text.Encodings.Web");
        private static byte[]? _SystemTextJson;
        internal static byte[] SystemTextJson => ResourceLoader.GetOrCreateResource(ref _SystemTextJson, "net60.System.Text.Json");
        private static byte[]? _SystemTextRegularExpressions;
        internal static byte[] SystemTextRegularExpressions => ResourceLoader.GetOrCreateResource(ref _SystemTextRegularExpressions, "net60.System.Text.RegularExpressions");
        private static byte[]? _SystemThreadingChannels;
        internal static byte[] SystemThreadingChannels => ResourceLoader.GetOrCreateResource(ref _SystemThreadingChannels, "net60.System.Threading.Channels");
        private static byte[]? _SystemThreading;
        internal static byte[] SystemThreading => ResourceLoader.GetOrCreateResource(ref _SystemThreading, "net60.System.Threading");
        private static byte[]? _SystemThreadingOverlapped;
        internal static byte[] SystemThreadingOverlapped => ResourceLoader.GetOrCreateResource(ref _SystemThreadingOverlapped, "net60.System.Threading.Overlapped");
        private static byte[]? _SystemThreadingTasksDataflow;
        internal static byte[] SystemThreadingTasksDataflow => ResourceLoader.GetOrCreateResource(ref _SystemThreadingTasksDataflow, "net60.System.Threading.Tasks.Dataflow");
        private static byte[]? _SystemThreadingTasks;
        internal static byte[] SystemThreadingTasks => ResourceLoader.GetOrCreateResource(ref _SystemThreadingTasks, "net60.System.Threading.Tasks");
        private static byte[]? _SystemThreadingTasksExtensions;
        internal static byte[] SystemThreadingTasksExtensions => ResourceLoader.GetOrCreateResource(ref _SystemThreadingTasksExtensions, "net60.System.Threading.Tasks.Extensions");
        private static byte[]? _SystemThreadingTasksParallel;
        internal static byte[] SystemThreadingTasksParallel => ResourceLoader.GetOrCreateResource(ref _SystemThreadingTasksParallel, "net60.System.Threading.Tasks.Parallel");
        private static byte[]? _SystemThreadingThread;
        internal static byte[] SystemThreadingThread => ResourceLoader.GetOrCreateResource(ref _SystemThreadingThread, "net60.System.Threading.Thread");
        private static byte[]? _SystemThreadingThreadPool;
        internal static byte[] SystemThreadingThreadPool => ResourceLoader.GetOrCreateResource(ref _SystemThreadingThreadPool, "net60.System.Threading.ThreadPool");
        private static byte[]? _SystemThreadingTimer;
        internal static byte[] SystemThreadingTimer => ResourceLoader.GetOrCreateResource(ref _SystemThreadingTimer, "net60.System.Threading.Timer");
        private static byte[]? _SystemTransactions;
        internal static byte[] SystemTransactions => ResourceLoader.GetOrCreateResource(ref _SystemTransactions, "net60.System.Transactions");
        private static byte[]? _SystemTransactionsLocal;
        internal static byte[] SystemTransactionsLocal => ResourceLoader.GetOrCreateResource(ref _SystemTransactionsLocal, "net60.System.Transactions.Local");
        private static byte[]? _SystemValueTuple;
        internal static byte[] SystemValueTuple => ResourceLoader.GetOrCreateResource(ref _SystemValueTuple, "net60.System.ValueTuple");
        private static byte[]? _SystemWeb;
        internal static byte[] SystemWeb => ResourceLoader.GetOrCreateResource(ref _SystemWeb, "net60.System.Web");
        private static byte[]? _SystemWebHttpUtility;
        internal static byte[] SystemWebHttpUtility => ResourceLoader.GetOrCreateResource(ref _SystemWebHttpUtility, "net60.System.Web.HttpUtility");
        private static byte[]? _SystemWindows;
        internal static byte[] SystemWindows => ResourceLoader.GetOrCreateResource(ref _SystemWindows, "net60.System.Windows");
        private static byte[]? _SystemXml;
        internal static byte[] SystemXml => ResourceLoader.GetOrCreateResource(ref _SystemXml, "net60.System.Xml");
        private static byte[]? _SystemXmlLinq;
        internal static byte[] SystemXmlLinq => ResourceLoader.GetOrCreateResource(ref _SystemXmlLinq, "net60.System.Xml.Linq");
        private static byte[]? _SystemXmlReaderWriter;
        internal static byte[] SystemXmlReaderWriter => ResourceLoader.GetOrCreateResource(ref _SystemXmlReaderWriter, "net60.System.Xml.ReaderWriter");
        private static byte[]? _SystemXmlSerialization;
        internal static byte[] SystemXmlSerialization => ResourceLoader.GetOrCreateResource(ref _SystemXmlSerialization, "net60.System.Xml.Serialization");
        private static byte[]? _SystemXmlXDocument;
        internal static byte[] SystemXmlXDocument => ResourceLoader.GetOrCreateResource(ref _SystemXmlXDocument, "net60.System.Xml.XDocument");
        private static byte[]? _SystemXmlXmlDocument;
        internal static byte[] SystemXmlXmlDocument => ResourceLoader.GetOrCreateResource(ref _SystemXmlXmlDocument, "net60.System.Xml.XmlDocument");
        private static byte[]? _SystemXmlXmlSerializer;
        internal static byte[] SystemXmlXmlSerializer => ResourceLoader.GetOrCreateResource(ref _SystemXmlXmlSerializer, "net60.System.Xml.XmlSerializer");
        private static byte[]? _SystemXmlXPath;
        internal static byte[] SystemXmlXPath => ResourceLoader.GetOrCreateResource(ref _SystemXmlXPath, "net60.System.Xml.XPath");
        private static byte[]? _SystemXmlXPathXDocument;
        internal static byte[] SystemXmlXPathXDocument => ResourceLoader.GetOrCreateResource(ref _SystemXmlXPathXDocument, "net60.System.Xml.XPath.XDocument");
        private static byte[]? _WindowsBase;
        internal static byte[] WindowsBase => ResourceLoader.GetOrCreateResource(ref _WindowsBase, "net60.WindowsBase");
    }
}
