# Text.Analyzers

## [CA1704](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1704): Identifiers should be spelled correctly

The name of an externally visible identifier contains one or more words that are not recognized by the Microsoft spelling checker library.

|Item|Value|
|-|-|
|Category|Naming|
|Enabled|True|
|Severity|Warning|
|CodeFix|False|
---

## [CA1714](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1714): Flags enums should have plural names

A public enumeration has the System.FlagsAttribute attribute, and its name does not end in ""s"". Types that are marked by using FlagsAttribute have names that are plural because the attribute indicates that more than one value can be specified.

|Item|Value|
|-|-|
|Category|Naming|
|Enabled|False|
|Severity|Warning|
|CodeFix|False|
---

## [CA1717](https://docs.microsoft.com/dotnet/fundamentals/code-analysis/quality-rules/ca1717): Only FlagsAttribute enums should have plural names

Naming conventions dictate that a plural name for an enumeration indicates that more than one value of the enumeration can be specified at the same time.

|Item|Value|
|-|-|
|Category|Naming|
|Enabled|False|
|Severity|Warning|
|CodeFix|False|
---
