/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright (c) 2022 NVIDIA Corporation & Affiliates
 */

#ifndef CUDA_DEVICES_H
#define CUDA_DEVICES_H

/* NVIDIA GPU vendor */
#define NVIDIA_GPU_VENDOR_ID (0x10de)

/* NVIDIA GPU device IDs */

#define NVIDIA_GPU_A40_DEVICE_ID (0x2235)
#define NVIDIA_GPU_A30_24GB_DEVICE_ID (0x20b7)
#define NVIDIA_GPU_A30X_24GB_DPU_DEVICE_ID (0x20b9)
#define NVIDIA_GPU_A10_24GB_DEVICE_ID (0x2236)
#define NVIDIA_GPU_A10G_DEVICE_ID (0x2237)
#define NVIDIA_GPU_A10M_DEVICE_ID (0x2238)

#define NVIDIA_GPU_A100_40GB_SXM4_DEVICE_ID (0x20b0)
#define NVIDIA_GPU_A100_40GB_PCIE_DEVICE_ID (0x20b1)
#define NVIDIA_GPU_A100_80GB_SXM4_DEVICE_ID (0x20b2)
#define NVIDIA_GPU_A100_80GB_PCIE_DEVICE_ID (0x20b5)
#define NVIDIA_GPU_A100X_80GB_DPU_DEVICE_ID (0x20b8)

#define NVIDIA_GPU_GA100_PG506_207 (0x20f0)
#define NVIDIA_GPU_GA100_PCIE (0x20f1)
#define NVIDIA_GPU_GA100_PG506_217 (0x20f2)

#define NVIDIA_GPU_V100_16GB_SXM2_DEVICE_ID (0x1db1)
#define NVIDIA_GPU_V100_16GB_DGXS_DEVICE_ID (0x1db2)
#define NVIDIA_GPU_V100_16GB_FHHL_DEVICE_ID (0x1db3)
#define NVIDIA_GPU_V100_16GB_PCIE_DEVICE_ID (0x1db4)

#define NVIDIA_GPU_V100_32GB_SXM2_DEVICE_ID (0x1db5)
#define NVIDIA_GPU_V100_32GB_PCIE_DEVICE_ID (0x1db6)
#define NVIDIA_GPU_V100_32GB_DGXS_DEVICE_ID (0x1db7)
#define NVIDIA_GPU_V100_32GB_SXM3_DEVICE_ID (0x1db8)
#define NVIDIA_GPU_V100_32GB_SXM3_H_DEVICE_ID (0x131d)

#define NVIDIA_GPU_V100_SXM2 (0x1df5)
#define NVIDIA_GPU_V100S_PCIE (0x1df6)

#define NVIDIA_GPU_TITAN_V_CEO_ED (0x12eb)

#define NVIDIA_GPU_GV100GL_PG500_216 (0x1df0)
#define NVIDIA_GPU_GV100GL_PG503_216 (0x1df2)

#define NVIDIA_GPU_TU102_TITAN_RTX (0x1e02)
#define NVIDIA_GPU_TU102GL_QUADRO_RTX (0x1e78)

#define NVIDIA_GPU_GV100_QUADRO_DEVICE_ID (0x1dba)
#define NVIDIA_GPU_QUADRO_RTX_4000 (0x1eb1)
#define NVIDIA_GPU_QUADRO_RTX_5000 (0x1eb0)
#define NVIDIA_GPU_QUADRO_RTX_6000 (0x13d9)
#define NVIDIA_GPU_QUADRO_RTX_8000 (0x13d8)
#define NVIDIA_GPU_QUADRO_RTX_A4000 (0x24b0)
#define NVIDIA_GPU_QUADRO_RTX_A6000 (0x2230)
#define NVIDIA_GPU_QUADRO_RTX_A5000 (0x2231)
#define NVIDIA_GPU_QUADRO_RTX_A4500 (0x2232)
#define NVIDIA_GPU_QUADRO_RTX_A5500 (0x2233)
#define NVIDIA_GPU_QUADRO_RTX_A2000 (0x2531)
#define NVIDIA_GPU_QUADRO_RTX_A2000_12GB (0x2571)

#define NVIDIA_GPU_T4G (0x1eb4)
#define NVIDIA_GPU_T4 (0x1eb8)

#endif /* CUDA_DEVICES_H */
