/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. SEE devtools/client/webconsole/test/README.md.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers.js");
const { prepareMessage } = require("resource://devtools/client/webconsole/utils/messages.js");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("resource://devtools/client/webconsole/types.js");

const rawPackets = new Map();
rawPackets.set(`GET request`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent4",
  "startedDateTime": "2019-11-04T11:06:34.542Z",
  "method": "GET",
  "url": "https://example.com/inexistent.html",
  "isXHR": false,
  "cause": {
    "loadingDocumentUri": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "type": "img",
    "stacktraceAvailable": false
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 4443,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 2,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 2,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`GET request update`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent4",
  "startedDateTime": "2020-07-07T14:41:14.572Z",
  "method": "GET",
  "url": "https://example.com/inexistent.html",
  "isXHR": false,
  "cause": {
    "loadingDocumentUri": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "type": "img",
    "stacktraceAvailable": false
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 4443,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 2,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 3,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR GET request`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent6",
  "startedDateTime": "2020-07-07T14:41:14.612Z",
  "method": "GET",
  "url": "https://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "loadingDocumentUri": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "type": "xhr",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 4443,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 1,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR GET request update`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent6",
  "method": "GET",
  "url": "https://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "loadingDocumentUri": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "type": "xhr",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 4443,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 1,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR POST request`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent8",
  "startedDateTime": "2019-11-04T11:06:35.007Z",
  "method": "POST",
  "url": "https://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "loadingDocumentUri": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "type": "xhr",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 4443,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 2,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 1,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR POST request update`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent8",
  "method": "POST",
  "url": "https://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "loadingDocumentUri": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "type": "xhr",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "https://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 4443,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 2,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 2,
  "securityState": "insecure",
  "isRacing": false
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = NetworkEventMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
