/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* libwpd
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2002 Marc Maurer (uwog@uwog.net)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef WP6PAGEGROUP_H
#define WP6PAGEGROUP_H

#include "WP6VariableLengthGroup.h"

class WP6PageGroup : public WP6VariableLengthGroup
{
public:
	WP6PageGroup(WPXInputStream *input, WPXEncryption *encryption);
	~WP6PageGroup();
	void _readContents(WPXInputStream *input, WPXEncryption *encryption);
	void parse(WP6Listener *listener);

private:
	// variables needed for subgroup 0 and 1 (Left/Right Margin Set)
	uint16_t m_margin;
	// variables needed for subgroup 2 (suppress page characteristics)
	uint8_t m_suppressedCode;
	// variables needed for subgroup 3 (page number position)
	uint16_t m_pageNumberTypefaceDesc;
	uint8_t m_pageNumberUseFlag;
	uint16_t m_pageNumberingFontPIDCopy;
	uint16_t m_pageNumberPointSize;
	uint8_t m_pageNumberPosition;
	uint16_t m_pageNumberMatchedFontIndex;
	uint16_t m_pageNumberMatchedFontPointSize;
	uint16_t m_pageNumberAttributes1;
	uint16_t m_pageNumberAttributes2;
	RGBSColor m_pageNumberColor;
	uint16_t m_pageNumberHeight;
	uint8_t m_pageNumberNewPagePosition;

	// variables needed for subgroup 0x11 (Form)
	uint16_t m_formLength;
	uint16_t m_formWidth;
	uint8_t m_formType;
	WPXFormOrientation m_formOrientation;

};

#endif /* WP6PAGEGROUP_H */
/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
