/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-local-available-application.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_LOCAL_AVAILABLE_APPLICATION_H
#define __UNITY_WEBAPPS_LOCAL_AVAILABLE_APPLICATION_H


#define UNITY_WEBAPPS_TYPE_LOCAL_AVAILABLE_APPLICATION              (unity_webapps_local_available_application_get_type())
#define UNITY_WEBAPPS_LOCAL_AVAILABLE_APPLICATION(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_LOCAL_AVAILABLE_APPLICATION, UnityWebappsLocalAvailableApplication))
#define UNITY_WEBAPPS_LOCAL_AVAILABLE_APPLICATION_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_LOCAL_AVAILABLE_APPLICATION, UnityWebappsLocalAvailableApplicationClass))
#define UNITY_WEBAPPS_IS_LOCAL_AVAILABLE_APPLICATION(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_LOCAL_AVAILABLE_APPLICATION))
#define UNITY_WEBAPPS_IS_LOCAL_AVAILABLE_APPLICATION_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_LOCAL_AVAILABLE_APPLICATION))
#define UNITY_WEBAPPS_LOCAL_AVAILABLE_APPLICATION_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_LOCALx_AVAILABLE_APPLICATION, UnityWebappsLocalAvailableApplicationClass))

#include "unity-webapps-available-application.h"
#include "unity-webapps-application-manifest.h"

typedef struct _UnityWebappsLocalAvailableApplicationPrivate UnityWebappsLocalAvailableApplicationPrivate;

typedef struct _UnityWebappsLocalAvailableApplication UnityWebappsLocalAvailableApplication;


struct _UnityWebappsLocalAvailableApplication {
	UnityWebappsAvailableApplication app;

	UnityWebappsLocalAvailableApplicationPrivate *priv;
};

typedef struct _UnityWebappsLocalAvailableApplicationClass UnityWebappsLocalAvailableApplicationClass;

struct _UnityWebappsLocalAvailableApplicationClass
{
	UnityWebappsAvailableApplicationClass parent_class;
};

GType unity_webapps_local_available_application_get_type (void) G_GNUC_CONST;

UnityWebappsAvailableApplication *unity_webapps_local_available_application_new (UnityWebappsApplicationManifest *manifest);
UnityWebappsApplicationManifest *unity_webapps_local_available_application_get_manifest (UnityWebappsLocalAvailableApplication *app);
gboolean unity_webapps_local_available_application_provides_url (UnityWebappsLocalAvailableApplication *application, const gchar *url);

#endif
