/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.expr.DefaultExpr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.FunctionCallExpr;

class DefaultFunctionCallExpr
extends DefaultExpr
implements FunctionCallExpr {
    private String prefix;
    private String functionName;
    private List parameters;

    public DefaultFunctionCallExpr(String prefix, String functionName) {
        this.prefix = prefix;
        this.functionName = functionName;
        this.parameters = new ArrayList();
    }

    public void addParameter(Expr parameter) {
        this.parameters.add(parameter);
    }

    public List getParameters() {
        return this.parameters;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        String prefix = this.getPrefix();
        if (prefix != null && !prefix.equals("")) {
            buf.append(prefix);
            buf.append(":");
        }
        buf.append(this.getFunctionName());
        buf.append("(");
        Iterator paramIter = this.getParameters().iterator();
        Expr eachParam = null;
        while (paramIter.hasNext()) {
            eachParam = (Expr)paramIter.next();
            buf.append(eachParam.getText());
            if (!paramIter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    public Expr simplify() {
        List paramExprs = this.getParameters();
        int paramSize = paramExprs.size();
        Expr eachParam = null;
        ArrayList<Expr> newParams = new ArrayList<Expr>(paramSize);
        for (int i = 0; i < paramSize; ++i) {
            eachParam = (Expr)paramExprs.get(i);
            newParams.add(eachParam.simplify());
        }
        this.parameters = newParams;
        return this;
    }

    public String toString() {
        String prefix = this.getPrefix();
        if (prefix == null) {
            return "[(DefaultFunctionCallExpr): " + this.getFunctionName() + "(" + this.getParameters() + ") ]";
        }
        return "[(DefaultFunctionCallExpr): " + this.getPrefix() + ":" + this.getFunctionName() + "(" + this.getParameters() + ") ]";
    }

    public Object evaluate(Context context) throws JaxenException {
        String namespaceURI = context.translateNamespacePrefixToUri(this.getPrefix());
        Function func = context.getFunction(namespaceURI, this.getPrefix(), this.getFunctionName());
        List paramExprs = this.getParameters();
        int paramSize = paramExprs.size();
        ArrayList<Object> paramValues = new ArrayList<Object>(paramSize);
        Expr eachParam = null;
        Object eachValue = null;
        for (int i = 0; i < paramSize; ++i) {
            eachParam = (Expr)paramExprs.get(i);
            eachValue = eachParam.evaluate(context);
            paramValues.add(eachValue);
        }
        return func.call(context, paramValues);
    }
}

