# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-01-30 11:18
from __future__ import unicode_literals

from django.db import (
    migrations,
    models,
)
import django.db.models.deletion


def set_pod_default_resource_pool(apps, schema_editor):
    """Assign all pods to the default resource pool."""
    ResourcePool = apps.get_model('maasserver', 'ResourcePool')
    Pod = apps.get_model('maasserver', 'Pod')
    pool = ResourcePool.objects.get(id=0)
    Pod.objects.all().update(default_pool=pool)


class Migration(migrations.Migration):

    dependencies = [
        ('maasserver', '0141_add_default_usergroup'),
    ]

    operations = [
        migrations.AddField(
            model_name='bmc',
            name='default_pool',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='maasserver.ResourcePool'),
        ),
        migrations.RunPython(set_pod_default_resource_pool),
    ]
