// |jit-test| skip-if: helperThreadCount() === 0 || isLcovEnabled()

// Extra GCs can empty the StencilCache to reclaim memory. This lines
// re-configure the gc-zeal setting to prevent this from happening in this test
// case which waits for the cache to contain some entry.
if ('gczeal' in this)
  gczeal(0);

let u = 0;

// At each function, create `width` inner functions.
let width = 2;
// Depth of inner functions.
let depth = 4;
// Number of additional parser & delazification workload running concurrently
// with the one we are attempting to measure, such that we can see differences
// in the report of `isDelazificationPopulatedFor`.
let load = 14;

// Return the number of function generated by a to `depthFirstExec` given the
// same parameters.
function count(w, d) {
  return (Math.pow(w, d + 1) - 1) / (w - 1);
}

// Generate a source code with a large number of inner functions, such that
// eager delazification can be observe while running JS code concurrently.
function depthFirstExec(indent, name, w, d) {
  let fun = `${indent}function ${name} (arg) {\n`;
  let inner = "";
  let val = `arg + isDelazificationPopulatedFor(${name})`;
  if (d > 0) {
    for (let i = 0; i < w; i++) {
      inner += depthFirstExec(`${indent}  `, `${name}_${i}`, w, d - 1);
      val = `${name}_${i}(${val})`;
    }
  }
  fun += inner;
  fun += `${indent}  return ${u} + ${val} - ${u};\n`;
  fun += `${indent}}\n`;
  u += 1;
  return fun;
};

const options = {
  fileName: "depthFirstExec.js",
  lineNumber: 1,
  eagerDelazificationStrategy: "ConcurrentDepthFirst",
};
let script = depthFirstExec("", "raceMe", width, depth);

let jobs = [];
for (let i = 0; i < load; i++) {
  // Spin up extra compilation workload...
  jobs.push(offThreadCompileToStencil(script, options));
}

const stencil = finishOffThreadStencil(jobs[0]);
evalStencil(stencil, options);

waitForDelazificationOf(raceMe);
let start = raceMe(0);
let mid = raceMe(0);
let end = raceMe(0);

assertEq(1 <= start, true);
assertEq(start <= mid, true);
assertEq(mid <= end, true);
assertEq(end <= count(width, depth), true);
print(start, mid, end);
