// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Gurung_Khema`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x016100, 0x016139]
  ]
});
testPropertyEscapes(
  /^\p{Script=Gurung_Khema}+$/u,
  matchSymbols,
  "\\p{Script=Gurung_Khema}"
);
testPropertyEscapes(
  /^\p{Script=Gukh}+$/u,
  matchSymbols,
  "\\p{Script=Gukh}"
);
testPropertyEscapes(
  /^\p{sc=Gurung_Khema}+$/u,
  matchSymbols,
  "\\p{sc=Gurung_Khema}"
);
testPropertyEscapes(
  /^\p{sc=Gukh}+$/u,
  matchSymbols,
  "\\p{sc=Gukh}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x0160FF],
    [0x01613A, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Gurung_Khema}+$/u,
  nonMatchSymbols,
  "\\P{Script=Gurung_Khema}"
);
testPropertyEscapes(
  /^\P{Script=Gukh}+$/u,
  nonMatchSymbols,
  "\\P{Script=Gukh}"
);
testPropertyEscapes(
  /^\P{sc=Gurung_Khema}+$/u,
  nonMatchSymbols,
  "\\P{sc=Gurung_Khema}"
);
testPropertyEscapes(
  /^\P{sc=Gukh}+$/u,
  nonMatchSymbols,
  "\\P{sc=Gukh}"
);

reportCompare(0, 0);
