Multiple stability attributes were declared on the same item.

Erroneous code example:

```compile_fail,E0544
#![feature(staged_api)]
#![allow(internal_features)]
#![stable(since = "1.0.0", feature = "rust1")]

#[stable(feature = "rust1", since = "1.0.0")]
#[stable(feature = "test", since = "2.0.0")] // invalid
fn foo() {}
```

To fix this issue, ensure that each item has at most one stability attribute.

```
#![feature(staged_api)]
#![allow(internal_features)]
#![stable(since = "1.0.0", feature = "rust1")]

#[stable(feature = "test", since = "2.0.0")] // ok!
fn foo() {}
```

See the [How Rust is Made and “Nightly Rust”][how-rust-made-nightly] appendix
of the Book and the [Stability attributes][stability-attributes] section of the
Rustc Dev Guide for more details.

[how-rust-made-nightly]: https://doc.rust-lang.org/book/appendix-07-nightly-rust.html
[stability-attributes]: https://rustc-dev-guide.rust-lang.org/stability.html
