'\"
'\" Copyright (c) 2004 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH ttk::menubutton n 8.5 Tk "Tk Themed Widget"
.so man.macros
.BS
.SH NAME
ttk::menubutton \- Widget that pops down a menu when pressed
.SH SYNOPSIS
\fBttk::menubutton\fR \fIpathName \fR?\fIoptions\fR?
.BE
.SH DESCRIPTION
.PP
A \fBttk::menubutton\fR widget displays a textual label and/or image,
and displays a menu when pressed.
.SO ttk_widget
\-class	\-compound	\-cursor
\-image	\-state	\-style
\-takefocus	\-text	\-textvariable
\-underline	\-width
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-direction direction Direction
Specifies where the menu is to be popped up relative
to the menubutton.
One of: \fBabove\fR, \fBbelow\fR, \fBleft\fR, \fBright\fR,
or \fBflush\fR.  The default is \fBbelow\fR.
\fBflush\fR pops the menu up directly over the menubutton.
.OP \-menu menu Menu
Specifies the path name of the menu associated with the menubutton.
To be on the safe side, the menu ought to be a direct child of the
menubutton.
.\" not documented: may go away:
.\" .OP \-anchor anchor Anchor
.\" .OP \-padding padding Pad
.SH "WIDGET COMMAND"
.PP
Menubutton widgets support the standard
\fBcget\fR, \fBconfigure\fR, \fBidentify\fR, \fBinstate\fR, and \fBstate\fR
methods.  No other widget methods are used.
.SH "STANDARD STYLES"
.PP
\fBTtk::menubutton\fR widgets support the \fBToolbutton\fR style in all
standard themes, which is useful for creating widgets for toolbars.
.SH "STYLING OPTIONS"
.PP
The class name for a \fBttk::menubutton\fP is \fBTMenubutton\fP.
.PP
Dynamic states: \fBactive\fP, \fBdisabled\fP, \fBreadonly\fP.
.PP
\fBTMenubutton\fP styling options configurable with \fBttk::style\fP
are:
.PP
\fB\-arrowsize\fP \fIamount\fP
.br
\fB\-background\fP \fIcolor\fP
.br
\fB\-compound\fP \fIcompound\fP
.br
\fB\-foreground\fP \fIcolor\fP
.br
\fB\-font\fP \fIfont\fP
.br
\fB\-padding\fP \fIpadding\fP
.br
\fB\-relief\fP \fIrelief\fP
.br
\fB\-width\fP \fIamount\fP
.PP
Some options are only available for specific themes.
.PP
See the \fBttk::style\fP manual page for information on how to configure
ttk styles.
.SH "SEE ALSO"
ttk::widget(n), menu(n), menubutton(n)
.SH "KEYWORDS"
widget, button, menu
'\" Local Variables:
'\" mode: nroff
'\" End:
