package cuda

/*
 THIS FILE IS AUTO-GENERATED BY CUDA2GO.
 EDITING IS FUTILE.
*/

import (
	"github.com/mumax/3/cuda/cu"
	"github.com/mumax/3/timer"
	"sync"
	"unsafe"
)

// CUDA handle for reducedot kernel
var reducedot_code cu.Function

// Stores the arguments for reducedot kernel invocation
type reducedot_args_t struct {
	arg_x1      unsafe.Pointer
	arg_x2      unsafe.Pointer
	arg_dst     unsafe.Pointer
	arg_initVal float32
	arg_n       int
	argptr      [5]unsafe.Pointer
	sync.Mutex
}

// Stores the arguments for reducedot kernel invocation
var reducedot_args reducedot_args_t

func init() {
	// CUDA driver kernel call wants pointers to arguments, set them up once.
	reducedot_args.argptr[0] = unsafe.Pointer(&reducedot_args.arg_x1)
	reducedot_args.argptr[1] = unsafe.Pointer(&reducedot_args.arg_x2)
	reducedot_args.argptr[2] = unsafe.Pointer(&reducedot_args.arg_dst)
	reducedot_args.argptr[3] = unsafe.Pointer(&reducedot_args.arg_initVal)
	reducedot_args.argptr[4] = unsafe.Pointer(&reducedot_args.arg_n)
}

// Wrapper for reducedot CUDA kernel, asynchronous.
func k_reducedot_async(x1 unsafe.Pointer, x2 unsafe.Pointer, dst unsafe.Pointer, initVal float32, n int, cfg *config) {
	if Synchronous { // debug
		Sync()
		timer.Start("reducedot")
	}

	reducedot_args.Lock()
	defer reducedot_args.Unlock()

	if reducedot_code == 0 {
		reducedot_code = fatbinLoad(reducedot_map, "reducedot")
	}

	reducedot_args.arg_x1 = x1
	reducedot_args.arg_x2 = x2
	reducedot_args.arg_dst = dst
	reducedot_args.arg_initVal = initVal
	reducedot_args.arg_n = n

	args := reducedot_args.argptr[:]
	cu.LaunchKernel(reducedot_code, cfg.Grid.X, cfg.Grid.Y, cfg.Grid.Z, cfg.Block.X, cfg.Block.Y, cfg.Block.Z, 0, stream0, args)

	if Synchronous { // debug
		Sync()
		timer.Stop("reducedot")
	}
}

// maps compute capability on PTX code for reducedot kernel.
var reducedot_map = map[int]string{0: "",
	50: reducedot_ptx_50,
	52: reducedot_ptx_52,
	53: reducedot_ptx_53,
	60: reducedot_ptx_60,
	61: reducedot_ptx_61,
	62: reducedot_ptx_62,
	70: reducedot_ptx_70,
	72: reducedot_ptx_72,
	75: reducedot_ptx_75,
	80: reducedot_ptx_80,
	86: reducedot_ptx_86,
	87: reducedot_ptx_87,
	89: reducedot_ptx_89,
	90: reducedot_ptx_90}

// reducedot PTX code for various compute capabilities.
const (
	reducedot_ptx_50 = `
.version 8.5
.target sm_50
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_52 = `
.version 8.5
.target sm_52
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_53 = `
.version 8.5
.target sm_53
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_60 = `
.version 8.5
.target sm_60
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_61 = `
.version 8.5
.target sm_61
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_62 = `
.version 8.5
.target sm_62
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_70 = `
.version 8.5
.target sm_70
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_72 = `
.version 8.5
.target sm_72
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_75 = `
.version 8.5
.target sm_75
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_80 = `
.version 8.5
.target sm_80
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_86 = `
.version 8.5
.target sm_86
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_87 = `
.version 8.5
.target sm_87
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_89 = `
.version 8.5
.target sm_89
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
	reducedot_ptx_90 = `
.version 8.5
.target sm_90
.address_size 64

	// .globl	reducedot

.visible .entry reducedot(
	.param .u64 reducedot_param_0,
	.param .u64 reducedot_param_1,
	.param .u64 reducedot_param_2,
	.param .f32 reducedot_param_3,
	.param .u32 reducedot_param_4
)
{
	.reg .pred 	%p<11>;
	.reg .f32 	%f<51>;
	.reg .b32 	%r<37>;
	.reg .b64 	%rd<27>;
	// demoted variable
	.shared .align 4 .b8 _ZZ9reducedotE5sdata[2048];

	ld.param.u64 	%rd12, [reducedot_param_0];
	ld.param.u64 	%rd13, [reducedot_param_1];
	ld.param.u64 	%rd11, [reducedot_param_2];
	ld.param.f32 	%f50, [reducedot_param_3];
	ld.param.u32 	%r17, [reducedot_param_4];
	cvta.to.global.u64 	%rd1, %rd13;
	cvta.to.global.u64 	%rd2, %rd12;
	mov.u32 	%r36, %ntid.x;
	mov.u32 	%r18, %ctaid.x;
	mov.u32 	%r2, %tid.x;
	mad.lo.s32 	%r34, %r18, %r36, %r2;
	mov.u32 	%r19, %nctaid.x;
	mul.lo.s32 	%r4, %r19, %r36;
	setp.ge.s32 	%p1, %r34, %r17;
	@%p1 bra 	$L__BB0_7;

	add.s32 	%r20, %r4, %r17;
	add.s32 	%r21, %r34, %r4;
	not.b32 	%r22, %r21;
	add.s32 	%r23, %r20, %r22;
	div.u32 	%r5, %r23, %r4;
	add.s32 	%r24, %r5, 1;
	and.b32  	%r33, %r24, 3;
	setp.eq.s32 	%p2, %r33, 0;
	@%p2 bra 	$L__BB0_4;

	mul.wide.s32 	%rd14, %r34, 4;
	add.s64 	%rd26, %rd1, %rd14;
	mul.wide.s32 	%rd4, %r4, 4;
	add.s64 	%rd25, %rd2, %rd14;

$L__BB0_3:
	.pragma "nounroll";
	ld.global.nc.f32 	%f10, [%rd26];
	ld.global.nc.f32 	%f11, [%rd25];
	fma.rn.f32 	%f50, %f11, %f10, %f50;
	add.s32 	%r34, %r34, %r4;
	add.s64 	%rd26, %rd26, %rd4;
	add.s64 	%rd25, %rd25, %rd4;
	add.s32 	%r33, %r33, -1;
	setp.ne.s32 	%p3, %r33, 0;
	@%p3 bra 	$L__BB0_3;

$L__BB0_4:
	setp.lt.u32 	%p4, %r5, 3;
	@%p4 bra 	$L__BB0_7;

	mul.wide.s32 	%rd10, %r4, 4;

$L__BB0_6:
	mul.wide.s32 	%rd15, %r34, 4;
	add.s64 	%rd16, %rd2, %rd15;
	add.s64 	%rd17, %rd1, %rd15;
	ld.global.nc.f32 	%f12, [%rd17];
	ld.global.nc.f32 	%f13, [%rd16];
	fma.rn.f32 	%f14, %f13, %f12, %f50;
	add.s64 	%rd18, %rd16, %rd10;
	add.s64 	%rd19, %rd17, %rd10;
	ld.global.nc.f32 	%f15, [%rd19];
	ld.global.nc.f32 	%f16, [%rd18];
	fma.rn.f32 	%f17, %f16, %f15, %f14;
	add.s32 	%r25, %r34, %r4;
	add.s32 	%r26, %r25, %r4;
	add.s64 	%rd20, %rd18, %rd10;
	add.s64 	%rd21, %rd19, %rd10;
	ld.global.nc.f32 	%f18, [%rd21];
	ld.global.nc.f32 	%f19, [%rd20];
	fma.rn.f32 	%f20, %f19, %f18, %f17;
	add.s32 	%r27, %r26, %r4;
	add.s64 	%rd22, %rd20, %rd10;
	add.s64 	%rd23, %rd21, %rd10;
	ld.global.nc.f32 	%f21, [%rd23];
	ld.global.nc.f32 	%f22, [%rd22];
	fma.rn.f32 	%f50, %f22, %f21, %f20;
	add.s32 	%r34, %r27, %r4;
	setp.lt.s32 	%p5, %r34, %r17;
	@%p5 bra 	$L__BB0_6;

$L__BB0_7:
	shl.b32 	%r28, %r2, 2;
	mov.u32 	%r29, _ZZ9reducedotE5sdata;
	add.s32 	%r14, %r29, %r28;
	st.shared.f32 	[%r14], %f50;
	bar.sync 	0;
	setp.lt.u32 	%p6, %r36, 66;
	@%p6 bra 	$L__BB0_11;

$L__BB0_8:
	shr.u32 	%r16, %r36, 1;
	setp.ge.u32 	%p7, %r2, %r16;
	@%p7 bra 	$L__BB0_10;

	ld.shared.f32 	%f23, [%r14];
	shl.b32 	%r30, %r16, 2;
	add.s32 	%r31, %r14, %r30;
	ld.shared.f32 	%f24, [%r31];
	add.f32 	%f25, %f23, %f24;
	st.shared.f32 	[%r14], %f25;

$L__BB0_10:
	bar.sync 	0;
	setp.gt.u32 	%p8, %r36, 131;
	mov.u32 	%r36, %r16;
	@%p8 bra 	$L__BB0_8;

$L__BB0_11:
	setp.gt.s32 	%p9, %r2, 31;
	@%p9 bra 	$L__BB0_13;

	ld.volatile.shared.f32 	%f26, [%r14];
	ld.volatile.shared.f32 	%f27, [%r14+128];
	add.f32 	%f28, %f26, %f27;
	st.volatile.shared.f32 	[%r14], %f28;
	ld.volatile.shared.f32 	%f29, [%r14+64];
	ld.volatile.shared.f32 	%f30, [%r14];
	add.f32 	%f31, %f30, %f29;
	st.volatile.shared.f32 	[%r14], %f31;
	ld.volatile.shared.f32 	%f32, [%r14+32];
	ld.volatile.shared.f32 	%f33, [%r14];
	add.f32 	%f34, %f33, %f32;
	st.volatile.shared.f32 	[%r14], %f34;
	ld.volatile.shared.f32 	%f35, [%r14+16];
	ld.volatile.shared.f32 	%f36, [%r14];
	add.f32 	%f37, %f36, %f35;
	st.volatile.shared.f32 	[%r14], %f37;
	ld.volatile.shared.f32 	%f38, [%r14+8];
	ld.volatile.shared.f32 	%f39, [%r14];
	add.f32 	%f40, %f39, %f38;
	st.volatile.shared.f32 	[%r14], %f40;
	ld.volatile.shared.f32 	%f41, [%r14+4];
	ld.volatile.shared.f32 	%f42, [%r14];
	add.f32 	%f43, %f42, %f41;
	st.volatile.shared.f32 	[%r14], %f43;

$L__BB0_13:
	setp.ne.s32 	%p10, %r2, 0;
	@%p10 bra 	$L__BB0_15;

	ld.shared.f32 	%f44, [_ZZ9reducedotE5sdata];
	cvta.to.global.u64 	%rd24, %rd11;
	atom.global.add.f32 	%f45, [%rd24], %f44;

$L__BB0_15:
	ret;

}

`
)
