#!/bin/bash

#==========================================================================
#
#   Copyright NumFOCUS
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#          https://www.apache.org/licenses/LICENSE-2.0.txt
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#
#==========================================================================


# Script to automate restyling in an ITK remote module.
# `sed` is used to replace http with https links for
# known valid cases.

find . -type f | \
    fgrep -v sed-commands | fgrep -v .git/ | fgrep -v ThirdParty | \
    tr \\n \\0 | xargs -0 sed -i -r \
    -e 's#http://a11yproject.com#https://a11yproject.com#g' \
    -e 's#http://about.gitlab.com#https://about.gitlab.com#g' \
    -e 's#http://akrzemi1.wordpress.com#https://akrzemi1.wordpress.com#g' \
    -e 's#http://analyzedirect.com#https://analyzedirect.com#g' \
    -e 's#http://api.github.com#https://api.github.com#g' \
    -e 's#http://arxiv.org#https://arxiv.org#g' \
    -e 's#http://askubuntu.com#https://askubuntu.com#g' \
    -e 's#http://azure.microsoft.com#https://azure.microsoft.com#g' \
    -e 's#http://badge.fury.io#https://badge.fury.io#g' \
    -e 's#http://bafybeid2yl6aeunciy5rynjmaoxkhhau3jgjpv7x25pylby7hq6n23c57i.ipfs.dweb.link#https://bafybeid2yl6aeunciy5rynjmaoxkhhau3jgjpv7x25pylby7hq6n23c57i.ipfs.dweb.link#g' \
    -e 's#http://bio3d.colorado.edu#https://bio3d.colorado.edu#g' \
    -e 's#http://bitbashing.io#https://bitbashing.io#g' \
    -e 's#http://bitbucket.org#https://bitbucket.org#g' \
    -e 's#http://blog.alexmaccaw.com#https://blog.alexmaccaw.com#g' \
    -e 's#http://blog.kitware.com#https://blog.kitware.com#g' \
    -e 's#http://blogs.msdn.com#https://blogs.msdn.com#g' \
    -e 's#http://blog.tim-smith.us#https://blog.tim-smith.us#g' \
    -e 's#http://books.google.com#https://books.google.com#g' \
    -e 's#http://bootswatch.com#https://bootswatch.com#g' \
    -e 's#http://brainweb.bic.mni.mcgill.ca#https://brainweb.bic.mni.mcgill.ca#g' \
    -e 's#http://breathe.readthedocs.io#https://breathe.readthedocs.io#g' \
    -e 's#http://breathe.readthedocs.org#https://breathe.readthedocs.org#g' \
    -e 's#http://brew.sh#https://brew.sh#g' \
    -e 's#http://bugs.llvm.org#https://bugs.llvm.org#g' \
    -e 's#http://bugs.webkit.org#https://bugs.webkit.org#g' \
    -e 's#http://bugzilla.gnome.org#https://bugzilla.gnome.org#g' \
    -e 's#http://bugzilla.mozilla.org#https://bugzilla.mozilla.org#g' \
    -e 's#http://callumhay.blogspot.com#https://callumhay.blogspot.com#g' \
    -e 's#http://campar.in.tum.de#https://campar.in.tum.de#g' \
    -e 's#http://cdn-fastly.deb.debian.org#https://cdn-fastly.deb.debian.org#g' \
    -e 's#http://cdnjs.cloudflare.com#https://cdnjs.cloudflare.com#g' \
    -e 's#http://cdn.jsdelivr.net#https://cdn.jsdelivr.net#g' \
    -e 's#http://choorucode.com#https://choorucode.com#g' \
    -e 's#http://chris.beams.io#https://chris.beams.io#g' \
    -e 's#http://ci.appveyor.com#https://ci.appveyor.com#g' \
    -e 's#http://circleci.com#https://circleci.com#g' \
    -e 's#http://citeseer.ist.psu.edu#https://citeseer.ist.psu.edu#g' \
    -e 's#http://citeseerx.ist.psu.edu#https://citeseerx.ist.psu.edu#g' \
    -e 's#http://clang.llvm.org#https://clang.llvm.org#g' \
    -e 's#http://cli.github.com#https://cli.github.com#g' \
    -e 's#http://cloudflare-ipfs.com#https://cloudflare-ipfs.com#g' \
    -e 's#http://cmake.org#https://cmake.org#g' \
    -e 's#http://code.google.com#https://code.google.com#g' \
    -e 's#http://codeload.github.com#https://codeload.github.com#g' \
    -e 's#http://commonfund.nih.gov#https://commonfund.nih.gov#g' \
    -e 's#http://connect.microsoft.com#https://connect.microsoft.com#g' \
    -e 's#http://cookiecutter.readthedocs.io#https://cookiecutter.readthedocs.io#g' \
    -e 's#http://cpbotha.net#https://cpbotha.net#g' \
    -e 's#http://creativecommons.org#https://creativecommons.org#g' \
    -e 's#http://daringfireball.net#https://daringfireball.net#g' \
    -e 's#http://data.kitware.com#https://data.kitware.com#g' \
    -e 's#http://data.org#https://data.org#g' \
    -e 's#http://dblp.uni-trier.de#https://dblp.uni-trier.de#g' \
    -e 's#http://dev.azure.com#https://dev.azure.com#g' \
    -e 's#http://developer.apple.com#https://developer.apple.com#g' \
    -e 's#http://developer.github.com#https://developer.github.com#g' \
    -e 's#http://developer.mozilla.org#https://developer.mozilla.org#g' \
    -e 's#http://dicom.nema.org#https://dicom.nema.org#g' \
    -e 's#http://dicom.offis.de#https://dicom.offis.de#g' \
    -e 's#http://discourse.itk.org#https://discourse.itk.org#g' \
    -e 's#http://discourse.slicer.org#https://discourse.slicer.org#g' \
    -e 's#http://doc.qt.io#https://doc.qt.io#g' \
    -e 's#http://docs.cirun.io#https://docs.cirun.io#g' \
    -e 's#http://docs.docker.com#https://docs.docker.com#g' \
    -e 's#http://docs.mathjax.org#https://docs.mathjax.org#g' \
    -e 's#http://docs.microsoft.com#https://docs.microsoft.com#g' \
    -e 's#http://docs.npmjs.com#https://docs.npmjs.com#g' \
    -e 's#http://docs.nvidia.com#https://docs.nvidia.com#g' \
    -e 's#http://docs.python-guide.org#https://docs.python-guide.org#g' \
    -e 's#http://docs.python.org#https://docs.python.org#g' \
    -e 's#http://docs.readthedocs.io#https://docs.readthedocs.io#g' \
    -e 's#http://docs.readthedocs.org#https://docs.readthedocs.org#g' \
    -e 's#http://docs.scipy.org#https://docs.scipy.org#g' \
    -e 's#http://doi.org#https://doi.org#g' \
    -e 's#http://download.microsoft.com#https://download.microsoft.com#g' \
    -e 's#http://downloads.openmicroscopy.org#https://downloads.openmicroscopy.org#g' \
    -e 's#http://dweb.link#https://dweb.link#g' \
    -e 's#http://dx.doi.org#https://dx.doi.org#g' \
    -e 's#http://EditorConfig.org#https://EditorConfig.org#g' \
    -e 's#http://education.siggraph.org#https://education.siggraph.org#g' \
    -e 's#http://eigen.tuxfamily.org#https://eigen.tuxfamily.org#g' \
    -e 's#http://emscripten.org#https://emscripten.org#g' \
    -e 's#http://en.cppreference.com#https://en.cppreference.com#g' \
    -e 's#http://en.wikibooks.org#https://en.wikibooks.org#g' \
    -e 's#http://en.wikipedia.org#https://en.wikipedia.org#g' \
    -e 's#http://example.com#https://example.com#g' \
    -e 's#http://feross.org#https://feross.org#g' \
    -e 's#http://forums.ni.com#https://forums.ni.com#g' \
    -e 's#http://gateway.pinata.cloud#https://gateway.pinata.cloud#g' \
    -e 's#http://gcc.gnu.org#https://gcc.gnu.org#g' \
    -e 's#http://geekfeminism.wikia.com#https://geekfeminism.wikia.com#g' \
    -e 's#http://getbootstrap.com#https://getbootstrap.com#g' \
    -e 's#http://get.webgl.org#https://get.webgl.org#g' \
    -e 's#http://girder.readthedocs.io#https://girder.readthedocs.io#g' \
    -e 's#http://gist.github.com#https://gist.github.com#g' \
    -e 's#http://github.com#https://github.com#g' \
    -e 's#http://gitlab.kitware.com#https://gitlab.kitware.com#g' \
    -e 's#http://git-scm.com#https://git-scm.com#g' \
    -e 's#http://git.wiki.kernel.org#https://git.wiki.kernel.org#g' \
    -e 's#http://goo.gl#https://goo.gl#g' \
    -e 's#http://goo.gle#https://goo.gle#g' \
    -e 's#http://groups.google.com#https://groups.google.com#g' \
    -e 's#http://guides.github.com#https://guides.github.com#g' \
    -e 's#http://hal.inria.fr#https://hal.inria.fr#g' \
    -e 's#http://hdl.handle.net#https://hdl.handle.net#g' \
    -e 's#http://help.github.com#https://help.github.com#g' \
    -e 's#http://help.ubuntu.com#https://help.ubuntu.com#g' \
    -e 's#http://hub.github.com#https://hub.github.com#g' \
    -e 's#http://i.creativecommons.org#https://i.creativecommons.org#g' \
    -e 's#http://img.shields.io#https://img.shields.io#g' \
    -e 's#http://imgur.com#https://imgur.com#g' \
    -e 's#http://inkscape.org#https://inkscape.org#g' \
    -e 's#http://insight-journal.org#https://insight-journal.org#g' \
    -e 's#http://insightsoftwareconsortium.atlassian.net#https://insightsoftwareconsortium.atlassian.net#g' \
    -e 's#http://ipfs.io#https://ipfs.io#g' \
    -e 's#http://issues.itk.org#https://issues.itk.org#g' \
    -e 's#http://itk.org#https://itk.org#g' \
    -e 's#http://itkpythonpackage.readthedocs.io#https://itkpythonpackage.readthedocs.io#g' \
    -e 's#http://jsdelivr.com#https://jsdelivr.com#g' \
    -e 's#http://keepachangelog.com#https://keepachangelog.com#g' \
    -e 's#http://kitware.com#https://kitware.com#g' \
    -e 's#http://kitware.github.io#https://kitware.github.io#g' \
    -e 's#http://lcw.lehman.edu#https://lcw.lehman.edu#g' \
    -e 's#http://learngitbranching.js.org#https://learngitbranching.js.org#g' \
    -e 's#http://librelist.com#https://librelist.com#g' \
    -e 's#http://linkinghub.elsevier.com#https://linkinghub.elsevier.com#g' \
    -e 's#http://lists.apple.com#https://lists.apple.com#g' \
    -e 's#http://lldb.llvm.org#https://lldb.llvm.org#g' \
    -e 's#http://llvm.org#https://llvm.org#g' \
    -e 's#http://math.stackexchange.com#https://math.stackexchange.com#g' \
    -e 's#http://mathworld.wolfram.com#https://mathworld.wolfram.com#g' \
    -e 's#http://matplotlib.org#https://matplotlib.org#g' \
    -e 's#http://maven.imagej.net#https://maven.imagej.net#g' \
    -e 's#http://medical.nema.org#https://medical.nema.org#g' \
    -e 's#http://miktex.org#https://miktex.org#g' \
    -e 's#http://mozilla.org#https://mozilla.org#g' \
    -e 's#http://msdn.microsoft.com#https://msdn.microsoft.com#g' \
    -e 's#http://mybinder.org#https://mybinder.org#g' \
    -e 's#http://nbsphinx.readthedocs.io#https://nbsphinx.readthedocs.io#g' \
    -e 's#http://networkx.github.io#https://networkx.github.io#g' \
    -e 's#http://nicolasgallagher.com#https://nicolasgallagher.com#g' \
    -e 's#http://nifti.nimh.nih.gov#https://nifti.nimh.nih.gov#g' \
    -e 's#http://ninja-build.org#https://ninja-build.org#g' \
    -e 's#http://nodejs.org#https://nodejs.org#g' \
    -e 's#http://numfocus.org#https://numfocus.org#g' \
    -e 's#http://numpy.org#https://numpy.org#g' \
    -e 's#http://nvie.com#https://nvie.com#g' \
    -e 's#http://on.cypress.io#https://on.cypress.io#g' \
    -e 's#http://open.cdash.org#https://open.cdash.org#g' \
    -e 's#http://opencollective.com#https://opencollective.com#g' \
    -e 's#http://openmicroscopy.org#https://openmicroscopy.org#g' \
    -e 's#http://openslide.cs.cmu.edu#https://openslide.cs.cmu.edu#g' \
    -e 's#http://openslide.org#https://openslide.org#g' \
    -e 's#http://openslide.org.#https://openslide.org.#g' \
    -e 's#http://opensource.org#https://opensource.org#g' \
    -e 's#http://orcid.org#https://orcid.org#g' \
    -e 's#http://pandoc.org#https://pandoc.org#g' \
    -e 's#http://paypal.me#https://paypal.me#g' \
    -e 's#http://pdfs.semanticscholar.org#https://pdfs.semanticscholar.org#g' \
    -e 's#http://people.csail.mit.edu#https://people.csail.mit.edu#g' \
    -e 's#http://projecteuclid.org#https://projecteuclid.org#g' \
    -e 's#http://public.kitware.com#https://public.kitware.com#g' \
    -e 's#http://purl.org#https://purl.org#g' \
    -e 's#http://pygments.org#https://pygments.org#g' \
    -e 's#http://pypi.org#https://pypi.org#g' \
    -e 's#http://pypi.python.org#https://pypi.python.org#g' \
    -e 's#http://pythonclock.org#https://pythonclock.org#g' \
    -e 's#http://pythonhosted.org#https://pythonhosted.org#g' \
    -e 's#http://python.org#https://python.org#g' \
    -e 's#http://randomascii.wordpress.com#https://randomascii.wordpress.com#g' \
    -e 's#http://raw.githubusercontent.com#https://raw.githubusercontent.com#g' \
    -e 's#http://rdcu.be#https://rdcu.be#g' \
    -e 's#http://readthedocs.org#https://readthedocs.org#g' \
    -e 's#http://registry.npmjs.org#https://registry.npmjs.org#g' \
    -e 's#http://releases.llvm.org#https://releases.llvm.org#g' \
    -e 's#http://repo.continuum.io#https://repo.continuum.io#g' \
    -e 's#http://review.source.kitware.com#https://review.source.kitware.com#g' \
    -e 's#http://robobees.seas.harvard.edu#https://robobees.seas.harvard.edu#g' \
    -e 's#http://s3.amazonaws.com#https://s3.amazonaws.com#g' \
    -e 's#http://scaryreasoner.wordpress.com#https://scaryreasoner.wordpress.com#g' \
    -e 's#http://schemas.microsoft.com#https://schemas.microsoft.com#g' \
    -e 's#http://scholar.google.com#https://scholar.google.com#g' \
    -e 's#http://scif.io#https://scif.io#g' \
    -e 's#http://scikit-image.org#https://scikit-image.org#g' \
    -e 's#http://scikit-learn.org#https://scikit-learn.org#g' \
    -e 's#http://scipy-cookbook.readthedocs.io#https://scipy-cookbook.readthedocs.io#g' \
    -e 's#http://scotch.io#https://scotch.io#g' \
    -e 's#http://seaborn.pydata.org#https://seaborn.pydata.org#g' \
    -e 's#http://semver.org#https://semver.org#g' \
    -e 's#http://services.github.com#https://services.github.com#g' \
    -e 's#http://sflogo.sourceforge.net#https://sflogo.sourceforge.net#g' \
    -e 's#http://slicer.kitware.com#https://slicer.kitware.com#g' \
    -e 's#http://slicer.org#https://slicer.org#g' \
    -e 's#http://software.intel.com#https://software.intel.com#g' \
    -e 's#http://sourceforge.net#https://sourceforge.net#g' \
    -e 's#http://sourceware.org#https://sourceware.org#g' \
    -e 's#http://stackoverflow.com#https://stackoverflow.com#g' \
    -e 's#http://support.hdfgroup.org#https://support.hdfgroup.org#g' \
    -e 's#http://surfer.nmr.mgh.harvard.edu#https://surfer.nmr.mgh.harvard.edu#g' \
    -e 's#http://swc-specification.readthedocs.io#https://swc-specification.readthedocs.io#g' \
    -e 's#http://thetweaker.wordpress.com#https://thetweaker.wordpress.com#g' \
    -e 's#http://tidelift.com#https://tidelift.com#g' \
    -e 's#http://timkadlec.com#https://timkadlec.com#g' \
    -e 's#http://todogroup.org#https://todogroup.org#g' \
    -e 's#http://tools.ietf.org#https://tools.ietf.org#g' \
    -e 's#http://transfer.sh#https://transfer.sh#g' \
    -e 's#http://travis-ci.org#https://travis-ci.org#g' \
    -e 's#http://try.github.io#https://try.github.io#g' \
    -e 's#http://tubetk.org#https://tubetk.org#g' \
    -e 's#http://tubetk.readthedocs.io#https://tubetk.readthedocs.io#g' \
    -e 's#http://unpkg.com#https://unpkg.com#g' \
    -e 's#http://vitejs.dev#https://vitejs.dev#g' \
    -e 's#http://vtk.org#https://vtk.org#g' \
    -e 's#http://vuejs.org#https://vuejs.org#g' \
    -e 's#http://vxl.github.io#https://vxl.github.io#g' \
    -e 's#http://wasi.dev#https://wasi.dev#g' \
    -e 's#http://wasm.itk.org#https://wasm.itk.org#g' \
    -e 's#http://wasmtime.dev#https://wasmtime.dev#g' \
    -e 's#http://web.archive.org#https://web.archive.org#g' \
    -e 's#http://webassembly.org#https://webassembly.org#g' \
    -e 's#http://webpack.js.org#https://webpack.js.org#g' \
    -e 's#http://wiki.epfl.ch#https://wiki.epfl.ch#g' \
    -e 's#http://wiki.na-mic.org#https://wiki.na-mic.org#g' \
    -e 's#http://wiki.nci.nih.gov#https://wiki.nci.nih.gov#g' \
    -e 's#http://wiki.openrtk.org#https://wiki.openrtk.org#g' \
    -e 's#http://workboxjs.org#https://workboxjs.org#g' \
    -e 's#http://www2.imm.dtu.dk#https://www2.imm.dtu.dk#g' \
    -e 's#http://www5.informatik.uni-erlangen.de#https://www5.informatik.uni-erlangen.de#g' \
    -e 's#http://www.alleninstitute.org#https://www.alleninstitute.org#g' \
    -e 's#http://www.anaconda.com#https://www.anaconda.com#g' \
    -e 's#http://www.apache.org#https://www.apache.org#g' \
    -e 's#http://www.bic.mni.mcgill.ca#https://www.bic.mni.mcgill.ca#g' \
    -e 's#http://www.bio-rad.com#https://www.bio-rad.com#g' \
    -e 's#http://www.birncommunity.org#https://www.birncommunity.org#g' \
    -e 's#http://www.boost.org#https://www.boost.org#g' \
    -e 's#http://www.brainhack.org#https://www.brainhack.org#g' \
    -e 's#http://www.cancer.gov#https://www.cancer.gov#g' \
    -e 's#http://www.ccpem.ac.uk#https://www.ccpem.ac.uk#g' \
    -e 's#http://www.cdash.org#https://www.cdash.org#g' \
    -e 's#http://www.chokkan.org#https://www.chokkan.org#g' \
    -e 's#http://www.cise.ufl.edu#https://www.cise.ufl.edu#g' \
    -e 's#http://www.cmake.org#https://www.cmake.org#g' \
    -e 's#http://www.cmrr.umn.edu#https://www.cmrr.umn.edu#g' \
    -e 's#http://www.cms.hhs.gov#https://www.cms.hhs.gov#g' \
    -e 's#http://www.contributor-covenant.org#https://www.contributor-covenant.org#g' \
    -e 's#http://www.cplusplus.com#https://www.cplusplus.com#g' \
    -e 's#http://www.creatis.insa-lyon.fr#https://www.creatis.insa-lyon.fr#g' \
    -e 's#http://www.cs.bgu.ac.il#https://www.cs.bgu.ac.il#g' \
    -e 's#http://www.cs.rpi.edu#https://www.cs.rpi.edu#g' \
    -e 's#http://www.cs.tut.fi#https://www.cs.tut.fi#g' \
    -e 's#http://www.cs.unb.ca#https://www.cs.unb.ca#g' \
    -e 's#http://www.cs.unc.edu#https://www.cs.unc.edu#g' \
    -e 's#http://www.cypress.io#https://www.cypress.io#g' \
    -e 's#http://www.darpa.mil#https://www.darpa.mil#g' \
    -e 's#http://www.dbf2002.com#https://www.dbf2002.com#g' \
    -e 's#http://www.djangoproject.com#https://www.djangoproject.com#g' \
    -e 's#http://www.doxygen.nl#https://www.doxygen.nl#g' \
    -e 's#http://www.doxygen.org#https://www.doxygen.org#g' \
    -e 's#http://www.dropbox.com#https://www.dropbox.com#g' \
    -e 's#http://www.electronics-notes.com#https://www.electronics-notes.com#g' \
    -e 's#http://www.euclideanspace.com#https://www.euclideanspace.com#g' \
    -e 's#http://www.fftw.org#https://www.fftw.org#g' \
    -e 's#http://www.fltk.org#https://www.fltk.org#g' \
    -e 's#http://www.github.com#https://www.github.com#g' \
    -e 's#http://www.gnu.org#https://www.gnu.org#g' \
    -e 's#http://www.graphicon.ru#https://www.graphicon.ru#g' \
    -e 's#http://www.graphviz.org#https://www.graphviz.org#g' \
    -e 's#http://www.gutenberg.org#https://www.gutenberg.org#g' \
    -e 's#http://www.hdfgroup.org#https://www.hdfgroup.org#g' \
    -e 's#http://www.iana.org#https://www.iana.org#g' \
    -e 's#http://www.iba-protontherapy.com#https://www.iba-protontherapy.com#g' \
    -e 's#http://www.ibm.com#https://www.ibm.com#g' \
    -e 's#http://www.imagemagick.org#https://www.imagemagick.org#g' \
    -e 's#http://www.incf.org#https://www.incf.org#g' \
    -e 's#http://www.inkscape.org#https://www.inkscape.org#g' \
    -e 's#http://www.inria.fr#https://www.inria.fr#g' \
    -e 's#http://www.insight-journal.org#https://www.insight-journal.org#g' \
    -e 's#http://www.insightsoftwareconsortium.org#https://www.insightsoftwareconsortium.org#g' \
    -e 's#http://www.istb.unibe.ch#https://www.istb.unibe.ch#g' \
    -e 's#http://www.itk.org#https://www.itk.org#g' \
    -e 's#http://www.itk.org.#https://www.itk.org.#g' \
    -e 's#http://www.itl.nist.gov#https://www.itl.nist.gov#g' \
    -e 's#http://www.jhuapl.edu#https://www.jhuapl.edu#g' \
    -e 's#http://www.josuttis.com#https://www.josuttis.com#g' \
    -e 's#http://www.jsdelivr.com#https://www.jsdelivr.com#g' \
    -e 's#http://www.kernel.org#https://www.kernel.org#g' \
    -e 's#http://www.kitware.com#https://www.kitware.com#g' \
    -e 's#http://www.linuxfoundation.org#https://www.linuxfoundation.org#g' \
    -e 's#http://www.lorenzobettini.it#https://www.lorenzobettini.it#g' \
    -e 's#http://www.mathjax.org#https://www.mathjax.org#g' \
    -e 's#http://www.mathworks.com#https://www.mathworks.com#g' \
    -e 's#http://www.mcternan.me.uk#https://www.mcternan.me.uk#g' \
    -e 's#http://www.mgh.harvard.edu#https://www.mgh.harvard.edu#g' \
    -e 's#http://www.mitk.org#https://www.mitk.org#g' \
    -e 's#http://www.modernescpp.com#https://www.modernescpp.com#g' \
    -e 's#http://www.modernizr.com#https://www.modernizr.com#g' \
    -e 's#http://www.mozilla.org#https://www.mozilla.org#g' \
    -e 's#http://www.nabble.com#https://www.nabble.com#g' \
    -e 's#http://www.na-mic.org#https://www.na-mic.org#g' \
    -e 's#http://www.ncbi.nlm.nih.gov#https://www.ncbi.nlm.nih.gov#g' \
    -e 's#http://www.ncwit.org#https://www.ncwit.org#g' \
    -e 's#http://www.netlib.org#https://www.netlib.org#g' \
    -e 's#http://www.niams.nih.gov#https://www.niams.nih.gov#g' \
    -e 's#http://www.nibib.nih.gov#https://www.nibib.nih.gov#g' \
    -e 's#http://www.nigms.nih.gov#https://www.nigms.nih.gov#g' \
    -e 's#http://www.ninds.nih.gov#https://www.ninds.nih.gov#g' \
    -e 's#http://www.nist.gov#https://www.nist.gov#g' \
    -e 's#http://www.nmr.mgh.harvard.edu#https://www.nmr.mgh.harvard.edu#g' \
    -e 's#http://www.npmjs.com#https://www.npmjs.com#g' \
    -e 's#http://www.numpy.org#https://www.numpy.org#g' \
    -e 's#http://www.oasis-open.org#https://www.oasis-open.org#g' \
    -e 's#http://www.opengl.org#https://www.opengl.org#g' \
    -e 's#http://www.openjpeg.org#https://www.openjpeg.org#g' \
    -e 's#http://www.openmicroscopy.org#https://www.openmicroscopy.org#g' \
    -e 's#http://www.openrtk.org#https://www.openrtk.org#g' \
    -e 's#http://www.opensource.org#https://www.opensource.org#g' \
    -e 's#http://www.open-std.org#https://www.open-std.org#g' \
    -e 's#http://www.openwetware.org#https://www.openwetware.org#g' \
    -e 's#http://www.paraview.org#https://www.paraview.org#g' \
    -e 's#http://www.patreon.com#https://www.patreon.com#g' \
    -e 's#http://www-personal.umich.edu#https://www-personal.umich.edu#g' \
    -e 's#http://www.povray.org#https://www.povray.org#g' \
    -e 's#http://www.predictive-toxicology.org#https://www.predictive-toxicology.org#g' \
    -e 's#http://www.pubmedcentral.nih.gov#https://www.pubmedcentral.nih.gov#g' \
    -e 's#http://www.python.org#https://www.python.org#g' \
    -e 's#http://www.qt.io#https://www.qt.io#g' \
    -e 's#http://www.researchgate.net#https://www.researchgate.net#g' \
    -e 's#http://www.riverbankcomputing.com#https://www.riverbankcomputing.com#g' \
    -e 's#http://www.r-project.org#https://www.r-project.org#g' \
    -e 's#http://www.sat.qc.ca#https://www.sat.qc.ca#g' \
    -e 's#http://www.scanco.ch#https://www.scanco.ch#g' \
    -e 's#http://www.sgi.com#https://www.sgi.com#g' \
    -e 's#http://www.slaney.org#https://www.slaney.org#g' \
    -e 's#http://www.slicer.org#https://www.slicer.org#g' \
    -e 's#http://www.sphinx-doc.org#https://www.sphinx-doc.org#g' \
    -e 's#http://www.stack.nl#https://www.stack.nl#g' \
    -e 's#http://www.swig.org#https://www.swig.org#g' \
    -e 's#http://www.tensorflow.org#https://www.tensorflow.org#g' \
    -e 's#http://www.threadingbuildingblocks.org#https://www.threadingbuildingblocks.org#g' \
    -e 's#http://www.tubetk.org#https://www.tubetk.org#g' \
    -e 's#http://www.tug.org#https://www.tug.org#g' \
    -e 's#http://www.ubuntu.com#https://www.ubuntu.com#g' \
    -e 's#http://www.ucalgary.ca#https://www.ucalgary.ca#g' \
    -e 's#http://www.uclouvain.be#https://www.uclouvain.be#g' \
    -e 's#http://www.uspto.gov#https://www.uspto.gov#g' \
    -e 's#http://www.via.cornell.edu#https://www.via.cornell.edu#g' \
    -e 's#http://www.vicomtech.org#https://www.vicomtech.org#g' \
    -e 's#http://www.vtk.org#https://www.vtk.org#g' \
    -e 's#http://www.w3.org#https://www.w3.org#g' \
    -e 's#http://www.youtube.com#https://www.youtube.com#g' \
    -e 's#http://xapian.org#https://xapian.org#g' \
    -e 's#http://xarray.pydata.org#https://xarray.pydata.org#g' \
    -e 's#http://xml.apache.org#https://xml.apache.org#g' \
    -e 's#http://xquartz.macosforge.org#https://xquartz.macosforge.org#g' \
    -e 's#http://zarr.readthedocs.io#https://zarr.readthedocs.io#g' \
    -e 's#http://zenodo.org#https://zenodo.org#g'
