/* SPDX-License-Identifier: MIT */
/*
 * Copyright(c) 2021 Intel Corporation.
 *
 */

#ifndef IAF_NETLINK_H_INCLUDED
#define IAF_NETLINK_H_INCLUDED

#define INTERFACE_VERSION 1

enum cmd_op {
	IAF_CMD_OP_UNSPEC = 0,
	IAF_CMD_OP_DEVICE_ENUM = 1,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_PORT_ENABLE = 2,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_PORT_DISABLE = 3,
	IAF_CMD_OP_PORT_STATE_QUERY = 4,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_PORT_USAGE_ENABLE = 5,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_PORT_USAGE_DISABLE = 6,
	IAF_CMD_OP_PORT_USAGE_STATE_QUERY = 7,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_PORT_BEACON_ENABLE = 8,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_PORT_BEACON_DISABLE = 9,
	IAF_CMD_OP_PORT_BEACON_STATE_QUERY = 10,
	IAF_CMD_OP_PORT_ROUTED_QUERY = 11,
	/* Requires GENL_UNS_ADMIN_PERM */
	IAF_CMD_OP_REM_REQUEST = 12,
	IAF_CMD_OP_ROUTING_GEN_QUERY = 13,
	IAF_CMD_OP_FABRIC_DEVICE_PROPERTIES = 14,
	IAF_CMD_OP_SUB_DEVICE_PROPERTIES_GET = 15,
	IAF_CMD_OP_FPORT_STATUS_QUERY = 16,
	IAF_CMD_OP_SUB_DEVICE_TRAP_COUNT_QUERY = 17,
	IAF_CMD_OP_FPORT_PROPERTIES = 18,
	IAF_CMD_OP_FPORT_XMIT_RECV_COUNTS = 19,

	_IAF_CMD_OP_COUNT,
};

enum cmd_msg_type {
	IAF_CMD_MSG_REQUEST = 0,
	IAF_CMD_MSG_RESPONSE = 1,

	_IAF_CMD_MSG_TYPE_COUNT,
};

enum cmd_rsp {
	IAF_CMD_RSP_SUCCESS = 0,
	IAF_CMD_RSP_FAILURE = 1,
	IAF_CMD_RSP_MAIL_BOX_ERROR = 2,
	IAF_CMD_RSP_NOMEM = 3,
	IAF_CMD_RSP_MSGSIZE = 4,
	IAF_CMD_RSP_AGAIN = 5,
	IAF_CMD_RSP_INVALID_INTERFACE_VERSION = 6,
	IAF_CMD_RSP_MISSING_FABRIC_ID = 7,
	IAF_CMD_RSP_MISSING_SD_INDEX = 8,
	IAF_CMD_RSP_UNKNOWN_FABRIC_ID = 9,
	IAF_CMD_RSP_SD_INDEX_OUT_OF_RANGE = 10,
	IAF_CMD_RSP_PORT_RANGE_ERROR = 11,
	IAF_CMD_RSP_MISSING_PORT_NUMBER = 12,
	IAF_CMD_RSP_MISSING_MSG_TYPE = 13,
	IAF_CMD_RSP_MSG_TYPE_NOT_REQUEST = 14,

	_IAF_CMD_RSP_COUNT,
};

enum attr {
	IAF_ATTR_UNSPEC = 0,

	IAF_ATTR_CMD_OP_MSG_TYPE = 1,
	IAF_ATTR_CMD_OP_CONTEXT = 2,
	IAF_ATTR_CMD_OP_RESULT = 3,

	/* Attributes for SD identification */
	IAF_ATTR_FABRIC_ID = 4,
	IAF_ATTR_SD_INDEX = 5,

	IAF_ATTR_PAD = 6,

	IAF_ATTR_ENTRIES = 7,

	/* Attributes for fabric devices */
	IAF_ATTR_FABRIC_DEVICE = 8,

	IAF_ATTR_DEV_NAME = 9,
	IAF_ATTR_PARENT_DEV_NAME = 10,

	IAF_ATTR_SOCKET_ID = 11,
	IAF_ATTR_PCI_SLOT_NUM = 12,
	IAF_ATTR_SUBDEVICE_COUNT = 13,
	IAF_ATTR_VERSION = 14,
	IAF_ATTR_PRODUCT_TYPE = 15,

	IAF_ATTR_SUB_DEVICE = 16,

	/* Attributes for sub devices */
	IAF_ATTR_GUID = 17,
	IAF_ATTR_EXTENDED_PORT_COUNT = 18,
	IAF_ATTR_FABRIC_PORT_COUNT = 19,
	IAF_ATTR_SWITCH_LIFETIME = 20,
	IAF_ATTR_ROUTING_MODE_SUPPORTED = 21,
	IAF_ATTR_ROUTING_MODE_ENABLED = 22,
	IAF_ATTR_EHHANCED_PORT_0_PRESENT = 23,

	IAF_ATTR_FABRIC_PORT = 24,

	IAF_ATTR_FABRIC_PORT_NUMBER = 25,
	IAF_ATTR_FABRIC_PORT_TYPE = 26,

	IAF_ATTR_BRIDGE_PORT_NUMBER = 27,

	IAF_ATTR_ENABLED_STATE = 28,

	IAF_ATTR_ROUTING_GEN_START = 29,
	IAF_ATTR_ROUTING_GEN_END = 30,

	IAF_ATTR_FPORT_HEALTH = 31,
	IAF_ATTR_FPORT_ISSUE_LQI = 32,
	IAF_ATTR_FPORT_ISSUE_LWD = 33,
	IAF_ATTR_FPORT_ISSUE_RATE = 34,
	IAF_ATTR_FPORT_ERROR_FAILED = 35,
	IAF_ATTR_FPORT_ERROR_ISOLATED = 36,
	IAF_ATTR_FPORT_ERROR_FLAPPING = 37,
	IAF_ATTR_FPORT_ERROR_LINK_DOWN = 38,
	IAF_ATTR_FPORT_ERROR_DID_NOT_TRAIN = 39,

	IAF_ATTR_SUB_DEVICE_TRAP_COUNT = 40,

	IAF_ATTR_FPORT_PM_PORT_STATE = 41,
	IAF_ATTR_FPORT_ROUTED = 42,
	IAF_ATTR_FPORT_LOGICAL_STATE = 43,
	IAF_ATTR_FPORT_PHYSICAL_STATE = 44,

	IAF_ATTR_FPORT_FID = 45,
	IAF_ATTR_FPORT_LINK_DOWN_COUNT = 46,
	IAF_ATTR_FPORT_NEIGHBOR_GUID = 47,
	IAF_ATTR_FPORT_PORT_ERROR_ACTION = 48,
	IAF_ATTR_FPORT_NEIGHBOR_PORT_NUMBER = 49,
	IAF_ATTR_FPORT_PORT_LINK_MODE_ACTIVE = 50,
	IAF_ATTR_FPORT_NEIGHBOR_LINK_DOWN_REASON = 51,
	IAF_ATTR_FPORT_H_O_Q_LIFETIME = 52,
	IAF_ATTR_FPORT_VL_CAP = 53,
	IAF_ATTR_FPORT_OPERATIONAL_VLS = 54,
	IAF_ATTR_FPORT_NEIGHBOR_MTU = 55,
	IAF_ATTR_FPORT_LTP_CRC_MODE_SUPPORTED = 56,
	IAF_ATTR_FPORT_LTP_CRC_MODE_ENABLED = 57,
	IAF_ATTR_FPORT_LTP_CRC_MODE_ACTIVE = 58,
	IAF_ATTR_FPORT_LINK_WIDTH_SUPPORTED = 59,
	IAF_ATTR_FPORT_LINK_WIDTH_ENABLED = 60,
	IAF_ATTR_FPORT_LINK_WIDTH_ACTIVE = 61,
	IAF_ATTR_FPORT_LINK_SPEED_SUPPORTED = 62,
	IAF_ATTR_FPORT_LINK_SPEED_ENABLED = 63,
	IAF_ATTR_FPORT_LINK_SPEED_ACTIVE = 64,
	IAF_ATTR_FPORT_LINK_WIDTH_DOWNGRADE_RX_ACTIVE = 65,
	IAF_ATTR_FPORT_LINK_WIDTH_DOWNGRADE_TX_ACTIVE = 66,
	IAF_ATTR_FPORT_LINK_INIT_REASON = 67,
	IAF_ATTR_FPORT_LINK_DOWN_REASON = 68,
	IAF_ATTR_FPORT_LQI_OFFLINE_DISABLED_REASON = 69,
	IAF_ATTR_FPORT_LQI_NEIGHBOR_NORMAL = 70,
	IAF_ATTR_FPORT_LINK_QUALITY_INDICATOR = 71,
	IAF_ATTR_FPORT_BPS_LINK_SPEED_ACTIVE = 72,

	IAF_ATTR_TIMESTAMP = 73,

	IAF_ATTR_FPORT_TX_BYTES = 74,
	IAF_ATTR_FPORT_RX_BYTES = 75,

	IAF_ATTR_FPORT_BPS_LINK_SPEED_MAX = 76,

	IAF_ATTR_FPORT_LQI_CHANGE_COUNT = 77,

	IAF_ATTR_SUB_DEVICE_PORT_STATE_CHANGE_TRAP_COUNT = 78,
	IAF_ATTR_SUB_DEVICE_PORT_LWD_TRAP_COUNT = 79,
	IAF_ATTR_SUB_DEVICE_PORT_LQI_TRAP_COUNT = 80,
	IAF_ATTR_SUB_DEVICE_QSFP_MGR_FAULT_TRAP_COUNT = 81,
	IAF_ATTR_SUB_DEVICE_QSFP_MGR_PORT_PRESENT_TRAP_COUNT = 82,

	_IAF_ATTR_COUNT,
};

enum iaf_fport_health {
	IAF_FPORT_HEALTH_OFF = 0,
	IAF_FPORT_HEALTH_FAILED = 1,
	IAF_FPORT_HEALTH_DEGRADED = 2,
	IAF_FPORT_HEALTH_HEALTHY = 3,

	_IAF_FPORT_HEALTH_COUNT,
};

enum iaf_fport_type {
	IAF_FPORT_TYPE_UNKNOWN = 0,
	IAF_FPORT_TYPE_DISCONNECTED = 1,
	IAF_FPORT_TYPE_FIXED = 2,
	IAF_FPORT_TYPE_VARIABLE = 3,
	IAF_FPORT_TYPE_STANDARD = 4,
	IAF_FPORT_TYPE_SI_PHOTONICS = 5,

	_IAF_FPORT_TYPE_COUNT,
};

#endif
