/*========================== begin_copyright_notice ============================

Copyright (C) 2019-2023 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/


// This file is autogenerated.  It is not currently part of the build process as
// we don't expect to update that often.

static Type* _struct_RTStackFormat__RTStack(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::RTStack";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__MemHit(M),
      _struct_RTStackFormat__MemHit(M),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__MemRay(M);
        return ArrayType::get(EltTy, 2);
      }(),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__MemTravStack(M);
        return ArrayType::get(EltTy, 2);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__MemHit(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::MemHit";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      Type::getFloatTy(M.getContext()),
      Type::getFloatTy(M.getContext()),
      Type::getFloatTy(M.getContext()),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__MemRay(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::MemRay";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      Type::getFloatTy(M.getContext()),
      Type::getFloatTy(M.getContext()),
      _union_anon(M),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      _union_anon_1(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon";
    Type* Tys[] = {
      _struct_anon_0(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_anon_0(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.anon.0";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon_1(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon.1";
    Type* Tys[] = {
      _struct_anon_3(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_anon_3(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.anon.3";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__MemTravStack(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::MemTravStack";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _union_anon_5(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon_5(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon.5";
    Type* Tys[] = {
      _struct_anon_7(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_anon_7(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.anon.7";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 32);
        return ArrayType::get(EltTy, 4);
      }(),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__NodeInfo(M);
        return ArrayType::get(EltTy, 4);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__NodeInfo(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::NodeInfo";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 8),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__SMStack(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::SMStack";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__MemHit(M),
      _struct_RTStackFormat__MemHit(M),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__MemRay(M);
        return ArrayType::get(EltTy, 2);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__SWHotZone_v1(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::SWHotZone_v1";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__StackPtrDRIEncoding(M),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 8);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__StackPtrDRIEncoding(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::StackPtrDRIEncoding";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__StackPtrAndBudges(M),
      IntegerType::get(M.getContext(), 32),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__StackPtrAndBudges(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::StackPtrAndBudges";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 16),
      _union_anon_8(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon_8(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon.8";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 16),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__SWHotZone_v2(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::SWHotZone_v2";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 32);
        return ArrayType::get(EltTy, 3);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_IGC__RayDispatchGlobalData(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.IGC::RayDispatchGlobalData";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _union_IGC__RayDispatchGlobalData__RT(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_IGC__RayDispatchGlobalData__RT(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.IGC::RayDispatchGlobalData::RT";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_IGC__RayDispatchGlobalData__RT__Xe(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_IGC__RayDispatchGlobalData__RT__Xe(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.IGC::RayDispatchGlobalData::RT::Xe";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      _union_anon_10(M),
      _union_anon_11(M),
      _union_anon_12(M),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 32);
        return ArrayType::get(EltTy, 9);
      }(),
      _struct_IGC__RayDispatchGlobalData__RayDispatchGlobalDataCommon(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon_10(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon.10";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 32),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon_11(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon.11";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 32),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _union_anon_12(Module &M)
{
  return
  [&] {
    StringRef StructName = "union.anon.12";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 32),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_IGC__RayDispatchGlobalData__RayDispatchGlobalDataCommon(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.IGC::RayDispatchGlobalData::RayDispatchGlobalDataCommon";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 32);
        return ArrayType::get(EltTy, 3);
      }(),
      IntegerType::get(M.getContext(), 32),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_IGC__TypeHoleGlobalRootSig(Module &M, Type* TypeHoleGlobalRootSig)
{
  return
  [&] {
    (void)M;
    IGC_ASSERT_MESSAGE(checkAlign(M, cast<StructType>(TypeHoleGlobalRootSig), 8), "type not aligned!");
    return TypeHoleGlobalRootSig;
  }();
}
static Type* _struct_IGC__RTGlobalsAndRootSig(Module &M, Type* TypeHoleGlobalRootSig)
{
  return
  [&] {
    StringRef StructName = "struct.IGC::RTGlobalsAndRootSig";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_IGC__RayDispatchGlobalData(M),
      _struct_IGC__TypeHoleGlobalRootSig(M, TypeHoleGlobalRootSig),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__BVH(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::BVH";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__InternalNode(M);
        return ArrayType::get(EltTy, 1);
      }(),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__QuadLeaf(M);
        return ArrayType::get(EltTy, 1);
      }(),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__ProceduralLeaf(M);
        return ArrayType::get(EltTy, 1);
      }(),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__InstanceLeaf(M);
        return ArrayType::get(EltTy, 1);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 32);
        return ArrayType::get(EltTy, 1);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 124);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__InternalNode(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::InternalNode";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 8),
      IntegerType::get(M.getContext(), 8),
      IntegerType::get(M.getContext(), 8),
      IntegerType::get(M.getContext(), 8),
      IntegerType::get(M.getContext(), 8),
      IntegerType::get(M.getContext(), 8),
      [&] {
        auto *EltTy =
          _struct_RTStackFormat__InternalNode__ChildData(M);
        return ArrayType::get(EltTy, 6);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 6);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 6);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 6);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 6);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 6);
      }(),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 8);
        return ArrayType::get(EltTy, 6);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__InternalNode__ChildData(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::InternalNode::ChildData";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 8),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__QuadLeaf(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::QuadLeaf";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__PrimLeafDesc(M),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__PrimLeafDesc(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::PrimLeafDesc";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__ProceduralLeaf(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::ProceduralLeaf";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__PrimLeafDesc(M),
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          IntegerType::get(M.getContext(), 32);
        return ArrayType::get(EltTy, 13);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__InstanceLeaf(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::InstanceLeaf";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      _struct_RTStackFormat__InstanceLeaf_RTStackFormat__Xe___Part0(M),
      _struct_RTStackFormat__InstanceLeaf_RTStackFormat__Xe___Part1(M),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__InstanceLeaf_RTStackFormat__Xe___Part0(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::InstanceLeaf<RTStackFormat::Xe>::Part0";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 64),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_RTStackFormat__InstanceLeaf_RTStackFormat__Xe___Part1(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.RTStackFormat::InstanceLeaf<RTStackFormat::Xe>::Part1";
    if (auto *Ty = IGCLLVM::getTypeByName(M, StructName))
      return Ty;
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 64),
      IntegerType::get(M.getContext(), 32),
      IntegerType::get(M.getContext(), 32),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
      [&] {
        auto *EltTy =
          Type::getFloatTy(M.getContext());
        return ArrayType::get(EltTy, 3);
      }(),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _struct_anon(Module &M)
{
  return
  [&] {
    StringRef StructName = "struct.anon";
    Type* Tys[] = {
      IntegerType::get(M.getContext(), 16),
      IntegerType::get(M.getContext(), 16),
      IntegerType::get(M.getContext(), 16),
      IntegerType::get(M.getContext(), 16),
    };
    return StructType::create(M.getContext(), Tys, StructName, false);
  }();
}
static Type* _gettype_RTStack2_Xe(Module &M)
{
  return
  _struct_RTStackFormat__RTStack(M);
}

static Type* _gettype_SMStack2_Xe(Module &M)
{
  return
  _struct_RTStackFormat__SMStack(M);
}

static Type* _gettype_SWHotZone_v1(Module &M)
{
  return
  _struct_RTStackFormat__SWHotZone_v1(M);
}

static Type* _gettype_SWHotZone_v2(Module &M)
{
  return
  _struct_RTStackFormat__SWHotZone_v2(M);
}

static Type* _gettype_RayDispatchGlobalData(Module &M)
{
  return
  _struct_IGC__RayDispatchGlobalData(M);
}

static Type* _gettype_RTGlobalsAndRootSig(Module &M, Type* TypeHoleGlobalRootSig)
{
  return
  _struct_IGC__RTGlobalsAndRootSig(M, TypeHoleGlobalRootSig);
}

auto* _get_rtMemBasePtr_Xe(const Twine& _ReturnName = "")
{
  auto* V_0 = getGlobalBufferPtr();
  auto* V_1 = CreateInBoundsGEP(V_0, { getInt64(0), getInt32(0), getInt32(0), getInt32(0) });
  auto* V_2 = CreateLoad(V_1, _ReturnName);
  setInvariantLoad(V_2);
  return V_2;
}

auto* _get_maxBVHLevels_Xe(const Twine& _ReturnName = "")
{
  auto* V_0 = getGlobalBufferPtr();
  auto* V_1 = CreateInBoundsGEP(V_0, { getInt64(0), getInt32(0), getInt32(0), getInt32(4), getInt32(0) });
  auto* V_2 = CreateLoad(V_1, _ReturnName);
  setInvariantLoad(V_2);
  return V_2;
}

auto* _get_statelessScratchPtr(const Twine& _ReturnName = "")
{
  auto* V_0 = getGlobalBufferPtr();
  auto* V_1 = CreateInBoundsGEP(V_0, { getInt64(0), getInt32(0), getInt32(0), getInt32(6), getInt32(2) });
  auto* V_2 = CreateLoad(V_1, _ReturnName);
  setInvariantLoad(V_2);
  return V_2;
}

auto* _gepof_StackOffset_v1(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0), getInt32(0) }, _ReturnName);
  return V_1;
}

auto* _gepof_StackOffset_v2(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0) }, _ReturnName);
  return V_1;
}

auto* _getDispatchRaysIndex_HotZone_v1(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0), getInt32(1), getInt32(0) });
  auto* V_3 = CreateLoad(V_2);
  auto* V_4 = CreateAnd(V_3, getInt16(31));
  auto* V_5 = CreateZExt(V_4, getInt32Ty());
  auto* V_6 = CreateLShr(V_3, getInt16(5));
  auto* V_7 = CreateAnd(V_6, getInt16(31));
  auto* V_8 = CreateZExt(V_7, getInt32Ty());
  auto* V_9 = CreateLShr(V_3, getInt16(10));
  auto* V_10 = CreateAnd(V_9, getInt16(31));
  auto* V_11 = CreateZExt(V_10, getInt32Ty());
  auto* V_12 = CreateICmpEQ(arg_1, getInt32(0));
  auto* V_13 = CreateSelect(V_12, getInt32(0), V_5);
  auto* V_14 = CreateICmpUGT(arg_1, getInt32(1));
  auto* V_15 = CreateSelect(V_14, V_8, getInt32(0));
  auto* V_16 = CreateAdd(V_15, V_13);
  auto* V_17 = CreateSelect(V_12, V_5, getInt32(0));
  auto* V_18 = CreateICmpEQ(arg_1, getInt32(1));
  auto* V_19 = CreateSelect(V_18, V_8, V_17);
  auto* V_20 = CreateICmpEQ(arg_1, getInt32(2));
  auto* V_21 = CreateSelect(V_20, V_11, V_19);
  auto* V_22 = CreateShl(getInt32(4294967295), V_21);
  auto* V_23 = CreateXor(V_22, getInt32(4294967295));
  auto* V_24 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_25 = CreateLoad(V_24);
  auto* V_26 = CreateLShr(V_25, V_16);
  auto* V_27 = CreateAnd(V_26, V_23, _ReturnName);
  return V_27;
}

auto* _getDispatchRaysIndex_HotZone_v2(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateZExt(arg_1, getInt64Ty());
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), V_2 });
  auto* V_4 = CreateLoad(V_3, _ReturnName);
  return V_4;
}

void _setDispatchRaysIndex_HotZone_v1(Value* arg_0, Value* arg_1, Value* arg_2, Value* arg_3)
{
  auto* V_4 = ctlz(arg_1);
  auto* V_5 = CreateSub(getInt32(32), V_4);
  auto* V_6 = ctlz(arg_2);
  auto* V_7 = CreateSub(getInt32(32), V_6);
  auto* V_8 = CreateShl(arg_2, V_5);
  auto* V_9 = CreateOr(V_8, arg_1);
  auto* V_10 = CreateShl(V_7, getInt32(5));
  auto* V_11 = CreateOr(V_5, V_10);
  auto* V_12 = CreateAdd(V_7, V_5);
  auto* V_13 = ctlz(arg_3);
  auto* V_14 = CreateShl(arg_3, V_12);
  auto* V_15 = CreateOr(V_14, V_9);
  auto* V_16 = CreateShl(V_13, getInt32(10));
  auto* V_17 = CreateSub(getInt32(32768), V_16);
  auto* V_18 = CreateOr(V_11, V_17);
  auto* V_19 = CreateTrunc(V_18, getInt16Ty());
  auto* V_20 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0), getInt32(1), getInt32(0) });
  CreateStore(V_19, V_20);
  auto* V_21 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(1) });
  CreateStore(V_15, V_21);
  return;
}

void _setDispatchRaysIndex_HotZone_v2(Value* arg_0, Value* arg_1, Value* arg_2)
{
  auto* V_3 = CreateZExt(arg_1, getInt64Ty());
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), V_3 });
  CreateStore(arg_2, V_4);
  return;
}

auto* _getBVHPtr(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* BB_3 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_3->splitBasicBlock(_CurIP, VALUE_NAME("_getBVHPtr.join"));
  BB_3->getTerminator()->eraseFromParent();
  auto* BB_4 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getBVHPtr."), _JoinBB->getParent(), _JoinBB);
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getBVHPtr."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getBVHPtr."), _JoinBB->getParent(), _JoinBB);
  auto* BB_7 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getBVHPtr."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_3);
  auto* V_8 = CreateICmpEQ(arg_0, getInt64(0));
  CreateCondBr(arg_2, BB_4, BB_5);
  SetInsertPoint(BB_4);
  auto* V_9 = CreateAdd(arg_1, arg_0);
  auto* V_10 = CreateSelect(V_8, getInt64(0), V_9);
  CreateBr(BB_7);
  SetInsertPoint(BB_7);
  auto* V_11 = CreatePHI(getInt64Ty(), 3, _ReturnName);
  CreateBr(_JoinBB);
  SetInsertPoint(BB_5);
  CreateCondBr(V_8, BB_7, BB_6);
  SetInsertPoint(BB_6);
  auto* V_12 = CreateIntToPtr(arg_0, PointerType::get(_struct_RTStackFormat__BVH(*Ctx.getModule()), 2));
  auto* V_13 = CreateInBoundsGEP(V_12, { getInt64(0), getInt32(0) });
  auto* V_14 = CreateLoad(V_13);
  auto* V_15 = CreateAdd(V_14, arg_0);
  CreateBr(BB_7);
  V_11->addIncoming(V_10, BB_4);
  V_11->addIncoming(V_15, BB_6);
  V_11->addIncoming(getInt64(0), BB_5);
  SetInsertPoint(_CurIP);
  return V_11;
}

auto* _getWorldRayOrig_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateZExt(arg_1, getInt64Ty());
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), V_2 });
  auto* V_4 = CreateLoad(V_3, _ReturnName);
  return V_4;
}

auto* _getMemRayOrig_Xe(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* V_3 = CreateZExt(arg_2, getInt64Ty());
  auto* V_4 = CreateZExt(arg_1, getInt64Ty());
  auto* V_5 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), V_3, getInt32(0), V_4 });
  auto* V_6 = CreateLoad(V_5, _ReturnName);
  return V_6;
}

auto* _getMemRayDir_Xe(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* V_3 = CreateZExt(arg_2, getInt64Ty());
  auto* V_4 = CreateZExt(arg_1, getInt64Ty());
  auto* V_5 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), V_3, getInt32(1), V_4 });
  auto* V_6 = CreateLoad(V_5, _ReturnName);
  return V_6;
}

auto* _getWorldRayDir_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateZExt(arg_1, getInt64Ty());
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(1), V_2 });
  auto* V_4 = CreateLoad(V_3, _ReturnName);
  return V_4;
}

auto* _getRayTMin_Xe(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(2) });
  auto* V_2 = CreateLoad(V_1, _ReturnName);
  return V_2;
}

auto* _getRayInfo_Xe(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* V_3 = CreateZExt(arg_2, getInt64Ty());
  auto* V_4 = CreateZExt(arg_1, getInt64Ty());
  auto* V_5 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), V_3, getInt32(0), V_4 });
  auto* V_6 = CreateLoad(V_5, _ReturnName);
  return V_6;
}

auto* _getRayFlagsSync_Xe(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(4) });
  auto* V_2 = CreateBitCast(V_1, PointerType::get(_struct_anon(*Ctx.getModule()), arg_0->getType()->getPointerAddressSpace()));
  auto* V_3 = CreateInBoundsGEP(V_2, { getInt64(0), getInt32(3) });
  auto* V_4 = CreateLoad(V_3, _ReturnName);
  return V_4;
}

void _setRayFlagsSync_Xe(Value* arg_0, Value* arg_1)
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(4) });
  auto* V_3 = CreateBitCast(V_2, PointerType::get(_struct_anon(*Ctx.getModule()), arg_0->getType()->getPointerAddressSpace()));
  auto* V_4 = CreateInBoundsGEP(V_3, { getInt64(0), getInt32(3) });
  CreateStore(arg_1, V_4);
  return;
}

auto* _getPrimLeaf_Xe(Value* arg_0, Value* arg_1)
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(4) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(4) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateLoad(V_4);
  auto* V_6 = CreateShl(V_5, getInt64(6));
  auto* V_7 = CreateAnd(V_6, getInt64(281474976710592));
  auto* V_8 = canonizePointer(V_7);
  return V_8;
}

auto* _getInstanceContributionToHitGroupIndex_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_3 = CreateICmpEQ(arg_1, getInt32(1));
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  auto* V_5 = CreateSelect(V_3, V_4, V_2);
  auto* V_6 = CreateLoad(V_5);
  auto* V_7 = CreateShl(V_6, getInt64(6));
  auto* V_8 = CreateAnd(V_7, getInt64(281474976710592));
  auto* V_9 = canonizePointer(V_8);
  auto* V_10 = CreateIntToPtr(V_9, PointerType::get(_struct_RTStackFormat__InstanceLeaf(*Ctx.getModule()), 1));
  auto* V_11 = CreateInBoundsGEP(V_10, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_12 = CreateLoad(V_11);
  auto* V_13 = CreateAnd(V_12, getInt32(16777215), _ReturnName);
  return V_13;
}

auto* _getRayMask_Xe(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(7), getInt32(0), getInt32(0) });
  auto* V_2 = CreateLoad(V_1);
  auto* V_3 = CreateLShr(V_2, getInt64(48));
  auto* V_4 = CreateTrunc(V_3, getInt32Ty());
  auto* V_5 = CreateAnd(V_4, getInt32(255), _ReturnName);
  return V_5;
}

auto* _isValid_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateInBoundsGEP(V_4, { getInt64(0), getInt32(3) });
  auto* V_6 = CreateLoad(V_5);
  auto* V_7 = CreateAnd(V_6, getInt32(65536));
  auto* V_8 = CreateICmpNE(V_7, getInt32(0), _ReturnName);
  return V_8;
}

auto* _createLeafType_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateInBoundsGEP(V_4, { getInt64(0), getInt32(3) });
  auto* V_6 = CreateLoad(V_5);
  auto* V_7 = CreateLShr(V_6, getInt32(17));
  auto* V_8 = CreateAnd(V_7, getInt32(7), _ReturnName);
  return V_8;
}

auto* _getIsFrontFace_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateLoad(V_4);
  auto* V_6 = CreateAnd(V_5, getInt32(134217728));
  auto* V_7 = CreateICmpNE(V_6, getInt32(0), _ReturnName);
  return V_7;
}

auto* _getBvhLevel_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateLoad(V_4);
  auto* V_6 = CreateLShr(V_5, getInt32(24));
  auto* V_7 = CreateAnd(V_6, getInt32(7), _ReturnName);
  return V_7;
}

auto* _isDoneBitNotSet_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateLoad(V_4);
  auto* V_6 = CreateAnd(V_5, getInt32(268435456));
  auto* V_7 = CreateICmpEQ(V_6, getInt32(0), _ReturnName);
  return V_7;
}

void _setDoneBit_Xe(Value* arg_0, Value* arg_1)
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateSelect(arg_1, V_2, V_3);
  auto* V_6 = CreateLoad(V_4);
  auto* V_7 = CreateOr(V_6, getInt32(268435456));
  CreateStore(V_7, V_5);
  return;
}

void _setHitValid_Xe(Value* arg_0, Value* arg_1)
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateSelect(arg_1, V_2, V_3);
  auto* V_6 = CreateLoad(V_4);
  auto* V_7 = CreateOr(V_6, getInt32(65536));
  CreateStore(V_7, V_5);
  return;
}

auto* _getHitBaryCentric_Xe(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0) });
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1) });
  auto* V_5 = CreateSelect(arg_2, V_3, V_4);
  auto* V_6 = CreateICmpEQ(arg_1, getInt32(0));
  auto* V_7 = CreateInBoundsGEP(V_5, { getInt64(0), getInt32(1) });
  auto* V_8 = CreateInBoundsGEP(V_5, { getInt64(0), getInt32(2) });
  auto* V_9 = CreateSelect(V_6, V_7, V_8);
  auto* V_10 = CreateLoad(V_9, _ReturnName);
  return V_10;
}

void _writeBaryCentricToStorage_Xe(Value* arg_0, Value* arg_1, Value* arg_2)
{
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(1) });
  auto* V_5 = CreateSelect(arg_2, V_3, V_4);
  auto* V_6 = CreateBitCast(V_5, PointerType::get(getInt64Ty(), arg_0->getType()->getPointerAddressSpace()));
  auto* V_7 = CreateBitCast(arg_1, PointerType::get(getInt64Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_8 = CreateLoad(V_6);
  CreateStore(V_8, V_7);
  return;
}

auto* _TransformWorldToObject_Xe(Value* arg_0, Value* arg_1, Value* arg_2, Value* arg_3, const Twine& _ReturnName = "")
{
  auto* BB_4 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_4->splitBasicBlock(_CurIP, VALUE_NAME("_TransformWorldToObject_Xe.join"));
  BB_4->getTerminator()->eraseFromParent();
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_TransformWorldToObject_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_TransformWorldToObject_Xe."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_4);
  auto* V_7 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_8 = CreateICmpEQ(arg_3, getInt32(1));
  auto* V_9 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  auto* V_10 = CreateSelect(V_8, V_9, V_7);
  auto* V_11 = CreateLoad(V_10);
  auto* V_12 = CreateShl(V_11, getInt64(6));
  auto* V_13 = CreateAnd(V_12, getInt64(281474976710592));
  auto* V_14 = canonizePointer(V_13);
  auto* V_15 = CreateIntToPtr(V_14, PointerType::get(_struct_RTStackFormat__InstanceLeaf(*Ctx.getModule()), 1));
  auto* V_16 = CreateZExt(arg_1, getInt64Ty());
  CreateCondBr(arg_2, BB_5, BB_6);
  SetInsertPoint(BB_5);
  auto* V_17 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(1), getInt32(6), V_16 });
  auto* V_18 = CreateLoad(V_17);
  CreateBr(BB_6);
  SetInsertPoint(BB_6);
  auto* V_19 = CreatePHI(getFloatTy(), 2);
  auto* V_20 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(0) });
  auto* V_21 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(1), getInt64(0) });
  auto* V_22 = CreateSelect(arg_2, V_20, V_21);
  auto* V_23 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(0), getInt32(3), V_16 });
  auto* V_24 = CreateLoad(V_23);
  auto* V_25 = CreateLoad(V_22);
  auto* V_26 = CreateFMul(V_24, V_25);
  auto* V_27 = CreateFAdd(V_19, V_26);
  auto* V_28 = CreateAdd(arg_1, getInt32(3));
  auto* V_29 = CreateZExt(V_28, getInt64Ty());
  auto* V_30 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(0), getInt32(3), V_29 });
  auto* V_31 = CreateLoad(V_30);
  auto* V_32 = CreateInBoundsGEP(V_22, { getInt64(1) });
  auto* V_33 = CreateLoad(V_32);
  auto* V_34 = CreateFMul(V_31, V_33);
  auto* V_35 = CreateFAdd(V_27, V_34);
  auto* V_36 = CreateAdd(arg_1, getInt32(6));
  auto* V_37 = CreateZExt(V_36, getInt64Ty());
  auto* V_38 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(0), getInt32(3), V_37 });
  auto* V_39 = CreateLoad(V_38);
  auto* V_40 = CreateInBoundsGEP(V_22, { getInt64(2) });
  auto* V_41 = CreateLoad(V_40);
  auto* V_42 = CreateFMul(V_39, V_41);
  auto* V_43 = CreateFAdd(V_35, V_42, _ReturnName);
  CreateBr(_JoinBB);
  V_19->addIncoming(V_18, BB_5);
  V_19->addIncoming(ConstantFP::get(*Ctx.getLLVMContext(), APFloat(APFloat::IEEEsingle(), APInt(32, 0x0))), BB_4);
  SetInsertPoint(_CurIP);
  return V_43;
}

auto* _getObjWorldAndWorldObj_Xe(Value* arg_0, Value* arg_1, Value* arg_2, Value* arg_3, const Twine& _ReturnName = "")
{
  auto* BB_4 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_4->splitBasicBlock(_CurIP, VALUE_NAME("_getObjWorldAndWorldObj_Xe.join"));
  BB_4->getTerminator()->eraseFromParent();
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getObjWorldAndWorldObj_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getObjWorldAndWorldObj_Xe."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_4);
  auto* V_7 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_8 = CreateICmpEQ(arg_3, getInt32(1));
  auto* V_9 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  auto* V_10 = CreateSelect(V_8, V_9, V_7);
  auto* V_11 = CreateLoad(V_10);
  auto* V_12 = CreateShl(V_11, getInt64(6));
  auto* V_13 = CreateAnd(V_12, getInt64(281474976710592));
  auto* V_14 = canonizePointer(V_13);
  auto* V_15 = CreateIntToPtr(V_14, PointerType::get(_struct_RTStackFormat__InstanceLeaf(*Ctx.getModule()), 1));
  auto* V_16 = CreateZExt(arg_1, getInt64Ty());
  auto* V_17 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(1), getInt32(3), V_16 });
  auto* V_18 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(0), getInt32(3), V_16 });
  auto* V_19 = CreateSelect(arg_2, V_17, V_18);
  auto* V_20 = CreateICmpUGT(arg_1, getInt32(8));
  CreateCondBr(V_20, BB_5, BB_6);
  SetInsertPoint(BB_5);
  auto* V_21 = CreateAdd(arg_1, getInt32(4294967287));
  auto* V_22 = CreateZExt(V_21, getInt64Ty());
  auto* V_23 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(0), getInt32(6), V_22 });
  auto* V_24 = CreateInBoundsGEP(V_15, { getInt64(0), getInt32(1), getInt32(6), V_22 });
  auto* V_25 = CreateSelect(arg_2, V_23, V_24);
  CreateBr(BB_6);
  SetInsertPoint(BB_6);
  auto* V_26 = CreatePHI(PointerType::get(getFloatTy(), 1), 2);
  auto* V_27 = CreateLoad(V_26, _ReturnName);
  CreateBr(_JoinBB);
  V_26->addIncoming(V_19, BB_4);
  V_26->addIncoming(V_25, BB_5);
  SetInsertPoint(_CurIP);
  return V_27;
}

auto* _getRayTCurrent_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(0) });
  auto* V_3 = CreateICmpEQ(arg_1, getInt32(3));
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(3) });
  auto* V_5 = CreateSelect(V_3, V_4, V_2);
  auto* V_6 = CreateICmpEQ(arg_1, getInt32(1));
  auto* V_7 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0) });
  auto* V_8 = CreateSelect(V_6, V_7, V_5);
  auto* V_9 = CreateLoad(V_8, _ReturnName);
  return V_9;
}

auto* _getHitT_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0) });
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(0) });
  auto* V_4 = CreateSelect(arg_1, V_2, V_3);
  auto* V_5 = CreateLoad(V_4, _ReturnName);
  return V_5;
}

void _setHitT_Xe(Value* arg_0, Value* arg_1, Value* arg_2)
{
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0) });
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(0) });
  auto* V_5 = CreateSelect(arg_2, V_3, V_4);
  CreateStore(arg_1, V_5);
  return;
}

auto* _getInstanceIndex_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_3 = CreateICmpEQ(arg_1, getInt32(1));
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  auto* V_5 = CreateSelect(V_3, V_4, V_2);
  auto* V_6 = CreateLoad(V_5);
  auto* V_7 = CreateShl(V_6, getInt64(6));
  auto* V_8 = CreateAnd(V_7, getInt64(281474976710592));
  auto* V_9 = canonizePointer(V_8);
  auto* V_10 = CreateIntToPtr(V_9, PointerType::get(_struct_RTStackFormat__InstanceLeaf(*Ctx.getModule()), 1));
  auto* V_11 = CreateInBoundsGEP(V_10, { getInt64(0), getInt32(1), getInt32(2) });
  auto* V_12 = CreateLoad(V_11, _ReturnName);
  return V_12;
}

auto* _getInstanceID_Xe(Value* arg_0, Value* arg_1, const Twine& _ReturnName = "")
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_3 = CreateICmpEQ(arg_1, getInt32(1));
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  auto* V_5 = CreateSelect(V_3, V_4, V_2);
  auto* V_6 = CreateLoad(V_5);
  auto* V_7 = CreateShl(V_6, getInt64(6));
  auto* V_8 = CreateAnd(V_7, getInt64(281474976710592));
  auto* V_9 = canonizePointer(V_8);
  auto* V_10 = CreateIntToPtr(V_9, PointerType::get(_struct_RTStackFormat__InstanceLeaf(*Ctx.getModule()), 1));
  auto* V_11 = CreateInBoundsGEP(V_10, { getInt64(0), getInt32(1), getInt32(1) });
  auto* V_12 = CreateLoad(V_11, _ReturnName);
  return V_12;
}

auto* _getPrimitiveIndex_Xe(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* BB_3 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_3->splitBasicBlock(_CurIP, VALUE_NAME("_getPrimitiveIndex_Xe.join"));
  BB_3->getTerminator()->eraseFromParent();
  auto* BB_4 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getPrimitiveIndex_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getPrimitiveIndex_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_getPrimitiveIndex_Xe."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_3);
  auto* V_7 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(4) });
  auto* V_8 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(4) });
  auto* V_9 = CreateSelect(arg_2, V_7, V_8);
  auto* V_10 = CreateLoad(V_9);
  auto* V_11 = CreateShl(V_10, getInt64(6));
  auto* V_12 = CreateAnd(V_11, getInt64(281474976710592));
  auto* V_13 = canonizePointer(V_12);
  auto* V_14 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_15 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_16 = CreateSelect(arg_2, V_14, V_15);
  auto* V_17 = CreateLoad(V_16);
  auto* V_18 = CreateAnd(arg_1, getInt32(1));
  auto* V_19 = CreateICmpEQ(V_18, getInt32(0));
  CreateCondBr(V_19, BB_5, BB_4);
  SetInsertPoint(BB_5);
  auto* V_20 = CreateAnd(V_17, getInt32(65535));
  auto* V_21 = CreateIntToPtr(V_13, PointerType::get(_struct_RTStackFormat__QuadLeaf(*Ctx.getModule()), 1));
  auto* V_22 = CreateInBoundsGEP(V_21, { getInt64(0), getInt32(1) });
  auto* V_23 = CreateLoad(V_22);
  auto* V_24 = CreateAdd(V_23, V_20);
  CreateBr(BB_6);
  SetInsertPoint(BB_6);
  auto* V_25 = CreatePHI(getInt32Ty(), 2, _ReturnName);
  CreateBr(_JoinBB);
  SetInsertPoint(BB_4);
  auto* V_26 = CreateLShr(V_17, getInt32(20));
  auto* V_27 = CreateAnd(V_26, getInt32(15));
  auto* V_28 = CreateIntToPtr(V_13, PointerType::get(_struct_RTStackFormat__ProceduralLeaf(*Ctx.getModule()), 1));
  auto* V_29 = CreateZExt(V_27, getInt64Ty());
  auto* V_30 = CreateInBoundsGEP(V_28, { getInt64(0), getInt32(2), V_29 });
  auto* V_31 = CreateLoad(V_30);
  CreateBr(BB_6);
  V_25->addIncoming(V_31, BB_4);
  V_25->addIncoming(V_24, BB_5);
  SetInsertPoint(_CurIP);
  return V_25;
}

auto* _getGeometryIndex_Xe(Value* arg_0, Value* arg_1, Value* arg_2, const Twine& _ReturnName = "")
{
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(4) });
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(4) });
  auto* V_5 = CreateSelect(arg_2, V_3, V_4);
  auto* V_6 = CreateLoad(V_5);
  auto* V_7 = CreateShl(V_6, getInt64(6));
  auto* V_8 = CreateAnd(V_7, getInt64(281474976710592));
  auto* V_9 = canonizePointer(V_8);
  auto* V_10 = CreateAnd(arg_1, getInt32(1));
  auto* V_11 = CreateICmpEQ(V_10, getInt32(0));
  auto* V_12 = CreateIntToPtr(V_9, PointerType::get(_struct_RTStackFormat__ProceduralLeaf(*Ctx.getModule()), 1));
  auto* V_13 = CreateInBoundsGEP(V_12, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_14 = CreateIntToPtr(V_9, PointerType::get(_struct_RTStackFormat__QuadLeaf(*Ctx.getModule()), 1));
  auto* V_15 = CreateInBoundsGEP(V_14, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_16 = CreateSelect(V_11, V_15, V_13);
  auto* V_17 = CreateLoad(V_16);
  auto* V_18 = CreateAnd(V_17, getInt32(536870911), _ReturnName);
  return V_18;
}

void _createPotentialHit2CommittedHit_Xe(Value* arg_0)
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1) });
  auto* V_2 = CreateBitCast(V_1, PointerType::get(getInt32Ty(), arg_0->getType()->getPointerAddressSpace()));
  auto* V_3 = CreateLoad(V_2);
  auto* V_4 = CreateBitCast(arg_0, PointerType::get(getInt32Ty(), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(V_3, V_4);
  auto* V_5 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(1) });
  auto* V_6 = CreateBitCast(V_5, PointerType::get(getInt32Ty(), arg_0->getType()->getPointerAddressSpace()));
  auto* V_7 = CreateLoad(V_6);
  auto* V_8 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_9 = CreateBitCast(V_8, PointerType::get(getInt32Ty(), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(V_7, V_9);
  auto* V_10 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(2) });
  auto* V_11 = CreateBitCast(V_10, PointerType::get(getInt32Ty(), arg_0->getType()->getPointerAddressSpace()));
  auto* V_12 = CreateLoad(V_11);
  auto* V_13 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(2) });
  auto* V_14 = CreateBitCast(V_13, PointerType::get(getInt32Ty(), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(V_12, V_14);
  auto* V_15 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_16 = CreateLoad(V_15);
  auto* V_17 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  CreateStore(V_16, V_17);
  auto* V_18 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(4) });
  auto* V_19 = CreateLoad(V_18);
  auto* V_20 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(4) });
  CreateStore(V_19, V_20);
  auto* V_21 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_22 = CreateLoad(V_21);
  auto* V_23 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  CreateStore(V_22, V_23);
  return;
}

void _createTraceRayInlinePrologue_Xe(Value* arg_0, Value* arg_1, Value* arg_2, Value* arg_3, Value* arg_4, Value* arg_5)
{
  auto* V_6 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0) });
  auto* V_7 = CreateBitCast(V_6, PointerType::get(IGCLLVM::FixedVectorType::get(getFloatTy(), 8), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(arg_1, V_7);
  auto* V_8 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(4) });
  auto* V_9 = CreateBitCast(V_8, PointerType::get(_struct_anon(*Ctx.getModule()), arg_0->getType()->getPointerAddressSpace()));
  auto* V_10 = CreateInBoundsGEP(V_9, { getInt64(0), getInt32(3) });
  auto* V_11 = CreateLoad(V_10);
  auto* V_12 = CreateZExt(V_11, getInt32Ty());
  auto* V_13 = CreateInBoundsGEP(V_8, { getInt64(0), getInt32(0), getInt32(0) });
  auto* V_14 = CreateAnd(arg_2, getInt64(281474976710655));
  auto* V_15 = CreateOr(V_12, arg_3);
  auto* V_16 = CreateZExt(V_15, getInt64Ty());
  auto* V_17 = CreateShl(V_16, getInt64(48));
  auto* V_18 = CreateOr(V_17, V_14);
  CreateStore(V_18, V_13);
  auto* V_19 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(7), getInt32(0), getInt32(0) });
  auto* V_20 = CreateAnd(arg_4, getInt32(255));
  auto* V_21 = CreateZExt(V_20, getInt64Ty());
  auto* V_22 = CreateShl(V_21, getInt64(48));
  CreateStore(V_22, V_19);
  auto* V_23 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0) });
  CreateStore(arg_5, V_23);
  auto* V_24 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  CreateStore(getInt32(0), V_24);
  auto* V_25 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  CreateStore(getInt32(0), V_25);
  return;
}

void _emitSingleRQMemRayWrite_Xe(Value* arg_0, Value* arg_1, Value* arg_2)
{
  auto* BB_3 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_3->splitBasicBlock(_CurIP, VALUE_NAME("_emitSingleRQMemRayWrite_Xe.join"));
  BB_3->getTerminator()->eraseFromParent();
  auto* BB_4 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_emitSingleRQMemRayWrite_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_emitSingleRQMemRayWrite_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_emitSingleRQMemRayWrite_Xe."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_3);
  auto* V_7 = CreateGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0) });
  auto* V_8 = CreateBitCast(V_7, PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()));
  auto* V_9 = CreateGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0) });
  auto* V_10 = CreateBitCast(V_9, PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()));
  CreateIntrinsic(Intrinsic::memcpy, { PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()), PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()), getInt64Ty() }, { V_8, V_10, getInt64(32), getFalse() }, nullptr);
  auto* V_11 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(8) });
  auto* V_12 = CreateBitCast(V_11, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_13 = CreateLoad(V_12);
  auto* V_14 = CreateInsertElement(UndefValue::get(IGCLLVM::FixedVectorType::get(getInt32Ty(), 8)), V_13, getInt64(0));
  auto* V_15 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(9) });
  auto* V_16 = CreateBitCast(V_15, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_17 = CreateLoad(V_16);
  auto* V_18 = CreateInsertElement(V_14, V_17, getInt64(1));
  CreateCondBr(arg_2, BB_4, BB_5);
  SetInsertPoint(BB_4);
  auto* V_19 = CreateShuffleVector(V_18, ConstantVector::get({ UndefValue::get(getInt32Ty()), UndefValue::get(getInt32Ty()), getInt32(0), getInt32(0), getInt32(0), getInt32(0), UndefValue::get(getInt32Ty()), UndefValue::get(getInt32Ty()) }), ConstantVector::get({ getInt32(0), getInt32(1), getInt32(10), getInt32(11), getInt32(12), getInt32(13), getInt32(6), getInt32(7) }));
  CreateBr(BB_6);
  SetInsertPoint(BB_6);
  auto* V_20 = CreatePHI(IGCLLVM::FixedVectorType::get(getInt32Ty(), 8), 2);
  auto* V_21 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(14) });
  auto* V_22 = CreateBitCast(V_21, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_23 = CreateLoad(V_22);
  auto* V_24 = CreateInsertElement(V_20, V_23, getInt64(6));
  auto* V_25 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(15) });
  auto* V_26 = CreateBitCast(V_25, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_27 = CreateLoad(V_26);
  auto* V_28 = CreateInsertElement(V_24, V_27, getInt64(7));
  auto* V_29 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(8) });
  auto* V_30 = CreateBitCast(V_29, PointerType::get(IGCLLVM::FixedVectorType::get(getInt32Ty(), 8), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(V_28, V_30);
  CreateBr(_JoinBB);
  SetInsertPoint(BB_5);
  auto* V_31 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(10) });
  auto* V_32 = CreateBitCast(V_31, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_33 = CreateLoad(V_32);
  auto* V_34 = CreateInsertElement(V_18, V_33, getInt64(2));
  auto* V_35 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(11) });
  auto* V_36 = CreateBitCast(V_35, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_37 = CreateLoad(V_36);
  auto* V_38 = CreateInsertElement(V_34, V_37, getInt64(3));
  auto* V_39 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(12) });
  auto* V_40 = CreateBitCast(V_39, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_41 = CreateLoad(V_40);
  auto* V_42 = CreateInsertElement(V_38, V_41, getInt64(4));
  auto* V_43 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(2), getInt64(0), getInt32(0), getInt64(13) });
  auto* V_44 = CreateBitCast(V_43, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_45 = CreateLoad(V_44);
  auto* V_46 = CreateInsertElement(V_42, V_45, getInt64(5));
  CreateBr(BB_6);
  V_20->addIncoming(V_19, BB_4);
  V_20->addIncoming(V_46, BB_5);
  SetInsertPoint(_CurIP);
}

void _copyMemHitInProceed_Xe(Value* arg_0, Value* arg_1, Value* arg_2)
{
  auto* BB_3 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_3->splitBasicBlock(_CurIP, VALUE_NAME("_copyMemHitInProceed_Xe.join"));
  BB_3->getTerminator()->eraseFromParent();
  auto* BB_4 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_copyMemHitInProceed_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_copyMemHitInProceed_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_copyMemHitInProceed_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_7 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_copyMemHitInProceed_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_8 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_copyMemHitInProceed_Xe."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_3);
  CreateCondBr(arg_2, BB_5, BB_4);
  SetInsertPoint(BB_5);
  auto* V_9 = CreatePHI(IGCLLVM::FixedVectorType::get(getInt32Ty(), 4), 2);
  auto* V_10 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_11 = CreateLoad(V_10);
  auto* V_12 = CreateInsertElement(V_9, V_11, getInt64(3));
  auto* V_13 = CreateBitCast(arg_0, PointerType::get(IGCLLVM::FixedVectorType::get(getInt32Ty(), 4), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(V_12, V_13);
  auto* V_14 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(1) });
  auto* V_15 = CreateBitCast(V_14, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_16 = CreateLoad(V_15);
  auto* V_17 = CreateInsertElement(UndefValue::get(IGCLLVM::FixedVectorType::get(getInt32Ty(), 4)), V_16, getInt64(0));
  CreateCondBr(arg_2, BB_6, BB_7);
  SetInsertPoint(BB_6);
  auto* V_18 = CreateShuffleVector(V_17, ConstantVector::get({ UndefValue::get(getInt32Ty()), getInt32(0), getInt32(0), UndefValue::get(getInt32Ty()) }), ConstantVector::get({ getInt32(0), getInt32(5), getInt32(6), getInt32(3) }));
  CreateBr(BB_8);
  SetInsertPoint(BB_8);
  auto* V_19 = CreatePHI(IGCLLVM::FixedVectorType::get(getInt32Ty(), 4), 2);
  auto* V_20 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_21 = CreateLoad(V_20);
  auto* V_22 = CreateOr(V_21, getInt32(268435456));
  auto* V_23 = CreateInsertElement(V_19, V_22, getInt64(3));
  auto* V_24 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1) });
  auto* V_25 = CreateBitCast(V_24, PointerType::get(IGCLLVM::FixedVectorType::get(getInt32Ty(), 4), arg_0->getType()->getPointerAddressSpace()));
  CreateStore(V_23, V_25);
  CreateBr(_JoinBB);
  SetInsertPoint(BB_7);
  auto* V_26 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(1), getInt32(1) });
  auto* V_27 = CreateBitCast(V_26, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_28 = CreateLoad(V_27);
  auto* V_29 = CreateInsertElement(V_17, V_28, getInt64(1));
  auto* V_30 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(1), getInt32(2) });
  auto* V_31 = CreateBitCast(V_30, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_32 = CreateLoad(V_31);
  auto* V_33 = CreateInsertElement(V_29, V_32, getInt64(2));
  CreateBr(BB_8);
  SetInsertPoint(BB_4);
  auto* V_34 = CreateBitCast(arg_1, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_35 = CreateLoad(V_34);
  auto* V_36 = CreateInsertElement(UndefValue::get(IGCLLVM::FixedVectorType::get(getInt32Ty(), 4)), V_35, getInt64(0));
  auto* V_37 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(0), getInt32(1) });
  auto* V_38 = CreateBitCast(V_37, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_39 = CreateLoad(V_38);
  auto* V_40 = CreateInsertElement(V_36, V_39, getInt64(1));
  auto* V_41 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(0), getInt32(2) });
  auto* V_42 = CreateBitCast(V_41, PointerType::get(getInt32Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_43 = CreateLoad(V_42);
  auto* V_44 = CreateInsertElement(V_40, V_43, getInt64(2));
  CreateBr(BB_5);
  V_9->addIncoming(V_44, BB_4);
  V_9->addIncoming(ConstantVector::get({ getInt32(0), getInt32(0), getInt32(0), UndefValue::get(getInt32Ty()) }), BB_3);
  V_19->addIncoming(V_18, BB_6);
  V_19->addIncoming(V_33, BB_7);
  SetInsertPoint(_CurIP);
}

auto* _syncStackToShadowMemory_Xe(Value* arg_0, Value* arg_1, Value* arg_2, Value* arg_3, const Twine& _ReturnName = "")
{
  auto* BB_4 = GetInsertBlock();
  auto* _CurIP = &*GetInsertPoint();
  auto *_JoinBB = BB_4->splitBasicBlock(_CurIP, VALUE_NAME("_syncStackToShadowMemory_Xe.join"));
  BB_4->getTerminator()->eraseFromParent();
  auto* BB_5 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_syncStackToShadowMemory_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_6 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_syncStackToShadowMemory_Xe."), _JoinBB->getParent(), _JoinBB);
  auto* BB_7 = BasicBlock::Create(*Ctx.getLLVMContext(), VALUE_NAME("_syncStackToShadowMemory_Xe."), _JoinBB->getParent(), _JoinBB);
  SetInsertPoint(BB_4);
  auto* V_8 = CreateBitCast(arg_1, PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_9 = CreateBitCast(arg_0, PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()));
  auto* V_10 = CreateInBoundsGEP(arg_1, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_11 = CreateLoad(V_10);
  auto* V_12 = CreateAnd(V_11, getInt32(268435456));
  auto* V_13 = CreateICmpEQ(V_12, getInt32(0));
  CreateCondBr(V_13, BB_5, BB_7);
  SetInsertPoint(BB_5);
  createReadSyncTraceRay(arg_2);
  CreateStore(getInt32(3), arg_3);
  auto* V_14 = CreateGEP(arg_1, { getInt64(0), getInt32(1), getInt32(0) });
  auto* V_15 = CreateBitCast(V_14, PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_16 = CreateGEP(arg_0, { getInt64(0), getInt32(1), getInt32(0) });
  auto* V_17 = CreateBitCast(V_16, PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()));
  CreateIntrinsic(Intrinsic::memcpy, { PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()), PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()), getInt64Ty() }, { V_15, V_17, getInt64(32), getFalse() }, nullptr);
  auto* V_18 = CreateGEP(arg_1, { getInt64(0), getInt32(2), getInt64(1) });
  auto* V_19 = CreateBitCast(V_18, PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()));
  auto* V_20 = CreateGEP(arg_0, { getInt64(0), getInt32(2), getInt64(1) });
  auto* V_21 = CreateBitCast(V_20, PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()));
  CreateIntrinsic(Intrinsic::memcpy, { PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()), PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()), getInt64Ty() }, { V_19, V_21, getInt64(24), getFalse() }, nullptr);
  auto* V_22 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_23 = CreateLoad(V_22);
  auto* V_24 = CreateAnd(V_23, getInt32(65536));
  auto* V_25 = CreateICmpEQ(V_24, getInt32(0));
  auto* V_26 = CreateLoad(V_10);
  auto* V_27 = CreateAnd(V_26, getInt32(268435456));
  auto* V_28 = CreateICmpEQ(V_27, getInt32(0));
  CreateCondBr(V_25, BB_7, BB_6);
  SetInsertPoint(BB_6);
  CreateIntrinsic(Intrinsic::memcpy, { PointerType::get(getInt8Ty(), arg_1->getType()->getPointerAddressSpace()), PointerType::get(getInt8Ty(), arg_0->getType()->getPointerAddressSpace()), getInt64Ty() }, { V_8, V_9, getInt64(32), getFalse() }, nullptr);
  CreateBr(BB_7);
  SetInsertPoint(BB_7);
  auto* V_29 = CreatePHI(getInt1Ty(), 3, _ReturnName);
  CreateBr(_JoinBB);
  V_29->addIncoming(V_28, BB_5);
  V_29->addIncoming(getFalse(), BB_4);
  V_29->addIncoming(V_28, BB_6);
  SetInsertPoint(_CurIP);
  return V_29;
}

auto* _getCommittedStatus_Xe(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_2 = CreateLoad(V_1);
  auto* V_3 = CreateLShr(V_2, getInt32(17));
  auto* V_4 = CreateAnd(V_3, getInt32(1));
  auto* V_5 = CreateAdd(V_4, getInt32(1));
  auto* V_6 = CreateAnd(V_2, getInt32(65536));
  auto* V_7 = CreateICmpEQ(V_6, getInt32(0));
  auto* V_8 = CreateSelect(V_7, getInt32(0), V_5, _ReturnName);
  return V_8;
}

auto* _getCandidateType_Xe(Value* arg_0, const Twine& _ReturnName = "")
{
  auto* V_1 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_2 = CreateLoad(V_1);
  auto* V_3 = CreateLShr(V_2, getInt32(17));
  auto* V_4 = CreateAnd(V_3, getInt32(1), _ReturnName);
  return V_4;
}

void _commitProceduralPrimitiveHit_Xe(Value* arg_0, Value* arg_1)
{
  auto* V_2 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(0) });
  CreateStore(arg_1, V_2);
  auto* V_3 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(0) });
  CreateStore(arg_1, V_3);
  auto* V_4 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(1) });
  CreateStore(ConstantFP::get(*Ctx.getLLVMContext(), APFloat(APFloat::IEEEsingle(), APInt(32, 0x0))), V_4);
  auto* V_5 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(2) });
  CreateStore(ConstantFP::get(*Ctx.getLLVMContext(), APFloat(APFloat::IEEEsingle(), APInt(32, 0x0))), V_5);
  auto* V_6 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(3) });
  auto* V_7 = CreateLoad(V_6);
  auto* V_8 = CreateOr(V_7, getInt32(65536));
  CreateStore(V_8, V_6);
  auto* V_9 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(3) });
  auto* V_10 = CreateLoad(V_9);
  auto* V_11 = CreateOr(V_10, getInt32(65536));
  CreateStore(V_11, V_9);
  auto* V_12 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(4) });
  auto* V_13 = CreateLoad(V_12);
  auto* V_14 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(4) });
  CreateStore(V_13, V_14);
  auto* V_15 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(1), getInt32(5) });
  auto* V_16 = CreateLoad(V_15);
  auto* V_17 = CreateInBoundsGEP(arg_0, { getInt64(0), getInt32(0), getInt32(5) });
  CreateStore(V_16, V_17);
  return;
}

auto* _getSyncStackID_Xe(const Twine& _ReturnName = "")
{
  auto* V_0 = getSr0_0();
  auto* V_1 = CreateShl(V_0, getInt32(3));
  auto* V_2 = CreateAnd(V_1, getInt32(1408));
  auto* V_3 = CreateShl(V_0, getInt32(1));
  auto* V_4 = CreateAnd(V_3, getInt32(512));
  auto* V_5 = get32BitLaneIDReplicate();
  auto* V_6 = CreateShl(V_0, getInt32(4));
  auto* V_7 = CreateAnd(V_6, getInt32(112));
  auto* V_8 = CreateOr(V_4, V_5);
  auto* V_9 = CreateOr(V_8, V_2);
  auto* V_10 = CreateOr(V_9, V_7, _ReturnName);
  return V_10;
}

auto* _getSyncStackID_Xe_HPC(const Twine& _ReturnName = "")
{
  auto* V_0 = getSr0_0();
  auto* V_1 = CreateShl(V_0, getInt32(4));
  auto* V_2 = CreateAnd(V_1, getInt32(768));
  auto* V_3 = CreateShl(V_0, getInt32(2));
  auto* V_4 = CreateAnd(V_3, getInt32(1024));
  auto* V_5 = get32BitLaneIDReplicate();
  auto* V_6 = CreateAnd(V_1, getInt32(112));
  auto* V_7 = CreateOr(V_4, V_5);
  auto* V_8 = CreateOr(V_7, V_2);
  auto* V_9 = CreateOr(V_8, V_6, _ReturnName);
  return V_9;
}

