/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "swiftdescr.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_SWIFT_DESCR_SWIFTDESCR_H
#define AB_SWIFT_DESCR_SWIFTDESCR_H


#ifdef __cplusplus
extern "C" {
#endif

/** @page P_AB_SWIFT_DESCR Structure AB_SWIFT_DESCR
<p>This page describes the properties of AB_SWIFT_DESCR.</p>



<h1>AB_SWIFT_DESCR</h1>

This class holds a SWIFT document descriptor like "pain.001.002.03". Such a descriptor can be parsed into an object of this class via AB_SwiftDescr_FromString(). The element of the string given above will go into the following fields: pain -> family 001 -> version1 002 -> version2 03 -> version3


@anchor AB_SWIFT_DESCR_family
<h2>family</h2>

Family of descriptors (e.g. "pain" in "pain.001.001.03")
<p>Set this property with @ref AB_SwiftDescr_SetFamily(), get it with @ref AB_SwiftDescr_GetFamily().</p>


@anchor AB_SWIFT_DESCR_version1
<h2>version1</h2>

First part of the version (i.e. the "001" in "pain.001.002.03")
<p>Set this property with @ref AB_SwiftDescr_SetVersion1(), get it with @ref AB_SwiftDescr_GetVersion1().</p>


@anchor AB_SWIFT_DESCR_version2
<h2>version2</h2>

Second part of the version (i.e. the "002" in "pain.001.002.03")
<p>Set this property with @ref AB_SwiftDescr_SetVersion2(), get it with @ref AB_SwiftDescr_GetVersion2().</p>


@anchor AB_SWIFT_DESCR_version3
<h2>version3</h2>

Second part of the version (i.e. the "03" in "pain.001.002.03")
<p>Set this property with @ref AB_SwiftDescr_SetVersion3(), get it with @ref AB_SwiftDescr_GetVersion3().</p>


@anchor AB_SWIFT_DESCR_alias1
<h2>alias1</h2>

Alias string for the given descriptor. This can be used to store additional names with descriptor (e.g. when searching for a special descriptor by a given name you can store the name of the originally searched name here).
<p>Set this property with @ref AB_SwiftDescr_SetAlias1(), get it with @ref AB_SwiftDescr_GetAlias1().</p>


@anchor AB_SWIFT_DESCR_alias2
<h2>alias2</h2>

Another alias string for the given descriptor. This can be used to store additional names with descriptor (e.g. when searching for a special descriptor by a given name you can store the name of the originally searched name here).
<p>Set this property with @ref AB_SwiftDescr_SetAlias2(), get it with @ref AB_SwiftDescr_GetAlias2().</p>

*/

/* needed system headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/list1.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

/* pre-headers */
#include <aqbanking/error.h>
#include <gwenhywfar/types.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/stringlist.h>
#include <ctype.h>

typedef struct AB_SWIFT_DESCR AB_SWIFT_DESCR;
GWEN_LIST_FUNCTION_DEFS(AB_SWIFT_DESCR, AB_SwiftDescr)



/* post-headers */


/** Constructor. */
AB_SWIFT_DESCR *AB_SwiftDescr_new(void);

/** Destructor. */
void AB_SwiftDescr_free(AB_SWIFT_DESCR *p_struct);

void AB_SwiftDescr_Attach(AB_SWIFT_DESCR *p_struct);

AB_SWIFT_DESCR *AB_SwiftDescr_dup(const AB_SWIFT_DESCR *p_src);

AB_SWIFT_DESCR *AB_SwiftDescr_copy(AB_SWIFT_DESCR *p_struct, const AB_SWIFT_DESCR *p_src);

/** Getter.
 * Use this function to get the member "family" (see @ref AB_SWIFT_DESCR_family)
*/
const char *AB_SwiftDescr_GetFamily(const AB_SWIFT_DESCR *p_struct);

/** Getter.
 * Use this function to get the member "version1" (see @ref AB_SWIFT_DESCR_version1)
*/
int AB_SwiftDescr_GetVersion1(const AB_SWIFT_DESCR *p_struct);

/** Getter.
 * Use this function to get the member "version2" (see @ref AB_SWIFT_DESCR_version2)
*/
int AB_SwiftDescr_GetVersion2(const AB_SWIFT_DESCR *p_struct);

/** Getter.
 * Use this function to get the member "version3" (see @ref AB_SWIFT_DESCR_version3)
*/
int AB_SwiftDescr_GetVersion3(const AB_SWIFT_DESCR *p_struct);

/** Getter.
 * Use this function to get the member "alias1" (see @ref AB_SWIFT_DESCR_alias1)
*/
const char *AB_SwiftDescr_GetAlias1(const AB_SWIFT_DESCR *p_struct);

/** Getter.
 * Use this function to get the member "alias2" (see @ref AB_SWIFT_DESCR_alias2)
*/
const char *AB_SwiftDescr_GetAlias2(const AB_SWIFT_DESCR *p_struct);

/** Setter.
 * Use this function to set the member "family" (see @ref AB_SWIFT_DESCR_family)
*/
void AB_SwiftDescr_SetFamily(AB_SWIFT_DESCR *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "version1" (see @ref AB_SWIFT_DESCR_version1)
*/
void AB_SwiftDescr_SetVersion1(AB_SWIFT_DESCR *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "version2" (see @ref AB_SWIFT_DESCR_version2)
*/
void AB_SwiftDescr_SetVersion2(AB_SWIFT_DESCR *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "version3" (see @ref AB_SWIFT_DESCR_version3)
*/
void AB_SwiftDescr_SetVersion3(AB_SWIFT_DESCR *p_struct, int p_src);

/** Setter.
 * Use this function to set the member "alias1" (see @ref AB_SWIFT_DESCR_alias1)
*/
void AB_SwiftDescr_SetAlias1(AB_SWIFT_DESCR *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "alias2" (see @ref AB_SWIFT_DESCR_alias2)
*/
void AB_SwiftDescr_SetAlias2(AB_SWIFT_DESCR *p_struct, const char *p_src);

AB_SWIFT_DESCR_LIST *AB_SwiftDescr_List_dup(const AB_SWIFT_DESCR_LIST *p_src);

void AB_SwiftDescr_ReadDb(AB_SWIFT_DESCR *p_struct, GWEN_DB_NODE *p_db);

int AB_SwiftDescr_WriteDb(const AB_SWIFT_DESCR *p_struct, GWEN_DB_NODE *p_db);

AB_SWIFT_DESCR *AB_SwiftDescr_fromDb(GWEN_DB_NODE *p_db);

int AB_SwiftDescr_toDb(const AB_SWIFT_DESCR *p_struct, GWEN_DB_NODE *p_db);

void AB_SwiftDescr_ReadXml(AB_SWIFT_DESCR *p_struct, GWEN_XMLNODE *p_db);

void AB_SwiftDescr_WriteXml(const AB_SWIFT_DESCR *p_struct, GWEN_XMLNODE *p_db);

void AB_SwiftDescr_toXml(const AB_SWIFT_DESCR *p_struct, GWEN_XMLNODE *p_db);

AB_SWIFT_DESCR *AB_SwiftDescr_fromXml(GWEN_XMLNODE *p_db);

/** 
 * Check whether a given SWIFT descriptor matches the given criteria. 
 * @param a descriptor to match against 
 * @param wantedFamily descriptor family, e.g. "pain" or "camt" (wildcards and jokers allowed) 
 * @param wantedVersion1 first part of the version to match (0 matches all) 
 * @param wantedVersion2 second part of the version to match (0 matches all) 
 * @param wantedVersion3 third part of the version to match (0 matches all) 
 */ 
  int AB_SwiftDescr_Matches(const AB_SWIFT_DESCR *a, const char *wantedFamily, int wantedVersion1, int wantedVersion2, int wantedVersion3);
/** 
 * Find first SWIFT descriptor in a list by given criteria. 
 * @param dl list of descriptors to search in 
 * @param wantedFamily descriptor family, e.g. "pain" or "camt" (wildcards and jokers allowed) 
 * @param wantedVersion1 first part of the version to match (0 matches all) 
 * @param wantedVersion2 second part of the version to match (0 matches all) 
 * @param wantedVersion3 third part of the version to match (0 matches all) 
 */ 
  AB_SWIFT_DESCR *AB_SwiftDescr_List_FindFirst(const AB_SWIFT_DESCR_LIST *dl, const char *wantedFamily, int wantedVersion1, int wantedVersion2, int wantedVersion3);
/** 
 * Find next SWIFT descriptor in a list by given criteria. 
 * @param d last descriptor checked (i.e. search in the following descriptors) 
 * @param wantedFamily descriptor family, e.g. "pain" or "camt" (wildcards and jokers allowed) 
 * @param wantedVersion1 first part of the version to match (0 matches all) 
 * @param wantedVersion2 second part of the version to match (0 matches all) 
 * @param wantedVersion3 third part of the version to match (0 matches all) 
 */ 
  AB_SWIFT_DESCR *AB_SwiftDescr_List_FindNext(AB_SWIFT_DESCR *d, const char *wantedFamily, int wantedVersion1, int wantedVersion2, int wantedVersion3);
/** 
 * Create a SWIFT descriptor from a given string. 
 * * Example strings are "pain.001.002.03" or "camt_054_001_02". 
 * @return created descriptor (NULL for invalid string) 
 */ 
  AB_SWIFT_DESCR *AB_SwiftDescr_FromString(const char *s);
/* end-headers */


#ifdef __cplusplus
}
#endif

#endif

