/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#ifndef _STRINGCOLLECTOR_H_
#define _STRINGCOLLECTOR_H_

#include <getopt++/Option.h>
#include <vector>

// Each registered option must implement this class.
class StringCollector : public Option
{

public:
    StringCollector (int _maxStrings = 0, bool const &_stopAfterMax = false) : maxStrings(_maxStrings), stopAfterMax(_stopAfterMax)
    {}
     virtual const std::string shortOption() const
       {
	 return "";
       }
     virtual const std::string longOption() const
       {
	 return "";
       }
     virtual const std::string shortHelp() const
       {
	 return "";
       }
     virtual Option::Argument argument() const
       {
	 return Required;
       }

     virtual Option::Result Process(const char * value)
    {
        if (maxStrings != 0 && strings.size() >= maxStrings)
	  return Failed;
        strings.push_back(value);
	return (maxStrings != 0 && strings.size() >= maxStrings && stopAfterMax) ? Stop : Ok;
    }

     std::string operator () (int offset)
    {
        return strings[offset - 1];
    }

    size_t size() const
    {
        return strings.size();
    }
    std::vector<std::string> const &theVector() const 
      {
	return strings;
      }

private:
    std::vector<std::string> strings;
    int maxStrings;
    bool const stopAfterMax;
}
;

#endif // _STRINGCOLLECTOR_H_
