--  We use the following setup:
--     aggr.gpr is the root aggregate project
--       It aggregates a.gpr, a2.gpr,  b.gpr  and c2/c.gpr
--       a.gpr withs c1/c.gpr
--       a2.gpr withs c2/c.gpr
--       c1/c.gpr and c2/c.gpr both have a file c.ads
--     a.gpr has one Ada package a.adb, which withs c.ads
--       This source is also part of a2.gpr, but it sees another c.ads
--       in that context, which affects the xref resolution
--
--  This setup therefore has the following use cases:
--  * homonym projects:     c1/c.gpr  and c2/c.gpr
--  * project in multiple aggregated projects: c1/c.gpr from a.gpr and b.gpr
--  * sources in multiple aggregated projects: a.ads in a.gpr and a2.gpr
--  * xref result depends on project:
--     "C" in a.ads points to either c1/c.gpr or c2/c.gpr

--TEST -Paggr.gpr
--GNATINSPECT --traceon=PROJECTS.AGGREGATE


--  Test with a.ads, shared source

params Proc_A:a.ads
#Error: ambiguous file name 'a.ads'
params Proc_A:a.ads:a.gpr
#  1> Param:a.ads:3:22 (IN_PARAMETER)
params Proc_A:a.ads:a2.gpr
#  1> Param:a.ads:3:22 (IN_PARAMETER)

type Param:a.ads:3:22
#Error: ambiguous file name 'a.ads'
type Param:a.ads:a.gpr:3:22
#  1> Type_C:c.ads:2:9
type Param:a.ads:a2.gpr:3:22
#  1> Type_C:c.ads:5:9

--  Test with c.ads, multiple possible full paths

decl type_c:c.ads
#Error: ambiguous file name 'c.ads'
decl type_c:c.ads:c1/c.gpr
#  1> Type_C:c.ads:2:9
decl type_c:c.ads:c2/c.gpr
#  1> Type_C:c.ads:5:9
