/*
 * @(#)DefaultChannelLogRecord.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.logger;

import net.sourceforge.groboutils.codecoverage.v2.IChannelLogRecord;


/**
 * A standard implementation of a channel log record.  Includes an
 * <tt>equals( Object )</tt> and <tt>hashCode()</tt> implementation.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/17 08:24:39 $
 * @since     December 17, 2002
 */
public final class DefaultChannelLogRecord implements IChannelLogRecord
{
    private String sig;
    private short methIndex;
    private short markIndex;
    
    public DefaultChannelLogRecord( String s, short me, short ma )
    {
        if (s == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        this.sig = s;
        this.methIndex = me;
        this.markIndex = ma;
    }
    
    
    public boolean equals( Object o )
    {
        if (o == null)
        {
            return false;
        }
        if (this == o)
        {
            return true;
        }
        if (o instanceof IChannelLogRecord)
        {
            IChannelLogRecord dclr = (IChannelLogRecord)o;
            if (dclr.getClassSignature().equals( this.sig ) &&
                dclr.getMethodIndex() == this.methIndex &&
                dclr.getMarkIndex() == this.markIndex)
            {
                return true;
            }
        }
        return false;
    }
    
    
    public int hashCode()
    {
        return this.sig.hashCode() + (int)this.methIndex +
            (int)this.markIndex;
    }
    
    
    public String getClassSignature()
    {
        return this.sig;
    }
    
    public short getMethodIndex()
    {
        return this.methIndex;
    }
    
    public short getMarkIndex()
    {
        return this.markIndex;
    }
}

