/*
 * @(#)CaptureEvent.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1.event;

import java.awt.Robot;
import java.awt.event.InputEvent;


/**
 * An event object which stores a capture event.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   Jan 4, 2002
 */
public abstract class CaptureEvent implements java.io.Serializable
{
    public static final int CE_MOUSE_MOVED = 1;
    public static final int CE_MOUSE_PRESSED = 2;
    public static final int CE_MOUSE_RELEASED = 3;
    public static final int CE_KEY_PRESSED = 4;
    public static final int CE_KEY_RELEASED = 5;
    public static final int CE_MOUSE_WHEEL = 6;
    
    /**
     * @serial
     */
    private int eventType = -1;
    
    /**
     * @serial
     */
    private InputEvent event = null;
    
    /**
     * @serial
     */
    private long timeOfEvent = -1;
    
    
    /**
     * Create a CaptureEvent with an AWT InputEvent.
     */
    public CaptureEvent( int eventType, InputEvent event )
    {
        this.eventType = eventType;
        this.event = event;
        if (event != null)
        {
            this.timeOfEvent = event.getWhen();
        }
    }
    
    
    /**
     * Create a CaptureEvent without an AWT InputEvent.
     */
    public CaptureEvent( int eventType )
    {
        this.eventType = eventType;
        this.event = null;
        this.timeOfEvent = -1;
    }
    
    
    public int getEventType()
    {
        return this.eventType;
    }
    
    
    public InputEvent getInputEvent()
    {
        return this.event;
    }
    
    
    public long getTimeOfEvent()
    {
        return this.timeOfEvent;
    }
    
    
    /**
     * Reenacts the event that this CaptureEvent represents underneath it
     * all.
     */
    public abstract void performEvent( Robot r );
}

