package org.jboss.cache.api.nodevalidity;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.testng.annotations.Test;

/**
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.1.0
 */
@Test(groups = {"functional"})
public class ReplicatedPessNodeValidityTest extends NodeValidityTestBase
{
   protected Cache<String, String> createObserver()
   {
      return newCache();
   }

   protected Cache<String, String> createModifier()
   {
      return newCache();
   }

   protected Cache<String, String> newCache()
   {
      CacheFactory<String, String> f = new DefaultCacheFactory();
      Cache<String, String> cache = f.createCache(false);
      cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
      optimisticConfiguration(cache.getConfiguration());
      cache.start();
      return cache;
   }
}
