/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

final class AppDTVImpl
extends DTVImpl {
    private int jdbcType = 999;
    private Object value;
    private Object setterArgs;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$net$URL;

    AppDTVImpl() {
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void setValue(DTV dTV, TypeInfo typeInfo, int n, Object object, Object object2, SQLServerConnection sQLServerConnection) throws SQLServerException {
        SetValueOp setValueOp = new SetValueOp(typeInfo, object2, sQLServerConnection);
        DTV.executeOp(dTV, setValueOp, object, n);
        this.value = setValueOp.getValue();
        this.jdbcType = setValueOp.getJdbcType();
        this.setterArgs = setValueOp.getSetterArgs();
    }

    Object getSetterArgs() {
        return this.setterArgs;
    }

    boolean isNull() {
        return null == this.value;
    }

    int getJdbcType(TypeInfo typeInfo) throws SQLServerException {
        return this.jdbcType;
    }

    Object getValue(DTV dTV, int n, boolean bl, int n2, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (this.jdbcType != n) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(this.jdbcType), Util.javaSqlTypeToString(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return this.value;
    }

    int getInt() {
        return (Integer)this.value;
    }

    short getShort() {
        return (Short)this.value;
    }

    byte getByte(DTV dTV, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (!(this.value instanceof Byte)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{Util.javaSqlTypeToString(this.jdbcType), "Byte"};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, false);
        }
        return (Byte)this.value;
    }

    static {
        $assertionsDisabled = !AppDTVImpl.class.desiredAssertionStatus();
    }

    final class SetValueOp
    extends DTVExecuteOp {
        private int jdbcType;
        private final TypeInfo typeInfo;
        private Object value;
        private Object setterArgs;
        private final SQLServerConnection con;

        int getJdbcType() {
            return this.jdbcType;
        }

        Object getValue() {
            return this.value;
        }

        Object getSetterArgs() {
            return this.setterArgs;
        }

        SetValueOp(TypeInfo typeInfo, Object object, SQLServerConnection sQLServerConnection) {
            this.typeInfo = typeInfo;
            this.setterArgs = object;
            this.con = sQLServerConnection;
        }

        void execute(String string, int n) throws SQLServerException {
            if (3 == n || 2 == n) {
                try {
                    this.execute(new BigDecimal(string), n);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
                    Object[] objectArray = new Object[]{"String", Util.javaSqlTypeToString(n)};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, true);
                }
            } else if (DataTypes.isBinaryJDBCType(n) || null != this.typeInfo && DataTypes.isBinary(this.typeInfo.getNativeType()) && 36 != this.typeInfo.getNativeType()) {
                this.execute(null == string ? null : ParameterUtils.HexToBin(string), -2);
            } else if (!this.con.sendStringParametersAsUnicode() && null != string) {
                byte[] byArray = null;
                try {
                    byArray = string.getBytes(this.con.getDatabaseCollation().getCharset());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                    Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                    SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
                }
                this.execute(byArray, n);
            } else {
                this.value = string;
                this.jdbcType = n;
            }
        }

        void execute(Clob clob, int n) throws SQLServerException {
            this.value = clob;
            this.jdbcType = n;
        }

        void execute(Byte by, int n) throws SQLServerException {
            this.value = by;
            this.jdbcType = n;
        }

        void execute(Integer n, int n2) throws SQLServerException {
            this.value = n;
            this.jdbcType = n2;
        }

        void execute(Time time, DTV dTV, int n) throws SQLServerException {
            this.value = time;
            this.jdbcType = n;
        }

        void execute(Date date, DTV dTV, int n) throws SQLServerException {
            this.value = date;
            this.jdbcType = n;
        }

        void execute(Timestamp timestamp, DTV dTV, int n) throws SQLServerException {
            this.value = timestamp;
            this.jdbcType = n;
        }

        void execute(Float f, int n) throws SQLServerException {
            this.value = f;
            this.jdbcType = n;
        }

        void execute(Double d, int n) throws SQLServerException {
            this.value = d;
            this.jdbcType = n;
        }

        void execute(BigDecimal bigDecimal, int n) throws SQLServerException {
            Integer n2;
            if (null != bigDecimal && null != (n2 = (Integer)this.setterArgs) && n2.intValue() != bigDecimal.scale()) {
                bigDecimal = bigDecimal.setScale((int)n2, 1);
            }
            this.value = bigDecimal;
            this.jdbcType = n;
        }

        void execute(Long l, int n) throws SQLServerException {
            this.value = l;
            this.jdbcType = n;
        }

        void execute(Short s, int n) throws SQLServerException {
            this.value = s;
            this.jdbcType = n;
        }

        void execute(Boolean bl, int n) throws SQLServerException {
            this.value = bl;
            this.jdbcType = n;
        }

        void execute(byte[] byArray, int n) throws SQLServerException {
            this.value = byArray;
            this.jdbcType = n;
        }

        void execute(Blob blob, int n) throws SQLServerException {
            this.value = blob;
            this.jdbcType = n;
        }

        void execute(InputStream inputStream, DTV dTV, int n) throws SQLServerException {
            InputStreamSetterArgs inputStreamSetterArgs = (InputStreamSetterArgs)this.setterArgs;
            if (null != inputStream && -1L == inputStreamSetterArgs.length && !this.con.isYukonOrLater()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                byte[] byArray = new byte[8000];
                int n2 = 0;
                while (true) {
                    try {
                        int n3;
                        while ((n3 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                            byteArrayOutputStream.write(byArray);
                            n2 += n3;
                        }
                    }
                    catch (IOException iOException) {
                        SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
                        continue;
                    }
                    break;
                }
                byArray = new byte[n2];
                System.arraycopy(byteArrayOutputStream.toByteArray(), 0, byArray, 0, n2);
                this.execute(byArray, n);
                return;
            }
            this.value = inputStream;
            this.jdbcType = n;
        }

        void execute(Reader reader, DTV dTV, int n) throws SQLServerException {
            CharacterStreamSetterArgs characterStreamSetterArgs = (CharacterStreamSetterArgs)this.setterArgs;
            if (null != reader && -1 == characterStreamSetterArgs.length && !this.con.isYukonOrLater() || DataTypes.isBinaryJDBCType(n) || null != this.typeInfo && DataTypes.isBinary(this.typeInfo.getNativeType()) && 36 != this.typeInfo.getNativeType() || !this.con.sendStringParametersAsUnicode() && null != reader) {
                String string = DDC.convertReaderToString(reader, characterStreamSetterArgs.length);
                if (-1 != characterStreamSetterArgs.length && string.length() != characterStreamSetterArgs.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
                    Object[] objectArray = new Object[]{new Integer(characterStreamSetterArgs.length), new Integer(string.length())};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                }
                this.execute(string, n);
            } else {
                this.value = reader;
                this.jdbcType = n;
            }
        }

        void executeDefault(Object object, int n) throws SQLServerException {
            if ((class$java$sql$Array == null ? (class$java$sql$Array = AppDTVImpl.class$("java.sql.Array")) : class$java$sql$Array).isInstance(object) || (class$java$sql$Ref == null ? (class$java$sql$Ref = AppDTVImpl.class$("java.sql.Ref")) : class$java$sql$Ref).isInstance(object) || (class$java$net$URL == null ? (class$java$net$URL = AppDTVImpl.class$("java.net.URL")) : class$java$net$URL).isInstance(object)) {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_notSupported"), null, false);
            } else {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownType"));
                Object[] objectArray = new Object[]{new String(object.getClass().getName())};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
            }
        }
    }
}

