/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockResponse;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.OutboundRule;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedResponse;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class UrlRewriteWrappedResponseTest
extends TestCase {
    MockResponse response;

    public void setUp() {
        Log.setLevel("DEBUG");
        this.response = new MockResponse();
    }

    public void testUrlEncode() {
        Conf conf = new Conf();
        OutboundRule rule1 = new OutboundRule();
        rule1.setFrom("/aaa");
        rule1.setTo("/bbb");
        conf.addOutboundRule(rule1);
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("doesn't matter");
        UrlRewriteWrappedResponse urlRewriteWrappedResponse = new UrlRewriteWrappedResponse(this.response, request, urlRewriter);
        UrlRewriteWrappedResponseTest.assertEquals((String)"/bbb;mockencoded=test", (String)urlRewriteWrappedResponse.encodeURL("/aaa"));
    }

    public void testLoadsOfOutboundRules() {
        Log.setLevel("ERROR");
        float testAmount = 10000.0f;
        float timePerRule = 3.0f;
        Conf conf = new Conf();
        for (int i = 0; i < 1000; ++i) {
            OutboundRule rule = new OutboundRule();
            rule.setFrom("^/([a-z]+)/([0-9]+)/" + i + "/$");
            rule.setTo("/blah/a/$2/");
            conf.addOutboundRule(rule);
        }
        conf.initialise();
        UrlRewriter urlRewriter = new UrlRewriter(conf);
        MockRequest request = new MockRequest("/dir/999/45/");
        UrlRewriteWrappedResponse urlRewriteWrappedResponse = new UrlRewriteWrappedResponse(this.response, request, urlRewriter);
        urlRewriteWrappedResponse.encodeURL("/aaa");
        long timeStart = System.currentTimeMillis();
        for (float i = 0.0f; i < testAmount; i += 1.0f) {
            urlRewriteWrappedResponse.encodeURL("/sdasd/asdasd/asdasd");
            if (i % 500.0f != 0.0f || !(i > 0.0f)) continue;
            System.out.println("avg so far " + (float)(System.currentTimeMillis() - timeStart) / i + "ms per rule");
        }
        long took = System.currentTimeMillis() - timeStart;
        System.out.println("took " + took + "ms " + (float)took / testAmount + "ms per rule");
        UrlRewriteWrappedResponseTest.assertTrue(((float)took / testAmount < timePerRule ? 1 : 0) != 0);
    }
}

