#include "osl/misc/math.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <vector>

using namespace osl;

class MathTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( MathTest );
  CPPUNIT_TEST( testNthPower );
  CPPUNIT_TEST( testComputeStdDev );
  CPPUNIT_TEST_SUITE_END();
public:
  void testNthPower();
  void testComputeStdDev();
};

void MathTest::testNthPower() {
  CPPUNIT_ASSERT_EQUAL(1, (osl::misc::nthPower<0>(3)));
  CPPUNIT_ASSERT_EQUAL(3, (osl::misc::nthPower<1>(3)));
  CPPUNIT_ASSERT_EQUAL(3*3, (osl::misc::nthPower<2>(3)));
  CPPUNIT_ASSERT_EQUAL(3*3*3*3*3, (osl::misc::nthPower<5>(3)));
}

void MathTest::testComputeStdDev() {
  typedef std::vector<double> data_t;
  data_t data;
  data.push_back(154.0);
  data.push_back(150.0);
  data.push_back(140.0);
  data_t::const_iterator first = data.begin();
  data_t::const_iterator last  = data.end();
  const size_t cnt  = distance(first, last);
  const double sum  = accumulate(first, last, double());
  const double mean = sum / cnt;
  const double result = misc::computeStdDev(data.begin(), data.end(), mean);
  CPPUNIT_ASSERT_DOUBLES_EQUAL(5.89, result, 0.01);
}

CPPUNIT_TEST_SUITE_REGISTRATION(MathTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
