/* @cond INNERDOC */
/*! 
 @file
 @brief Matrix type dispatching code, for each matrix operation.
 */

/*

Copyright (C) 2008-2022 Michele Martone

This file is part of librsb.

librsb is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

librsb is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with librsb; see the file COPYING.
If not, see <http://www.gnu.org/licenses/>.

*/
/*
 The code in this file was generated automatically by an M4 script. 
 It is not meant to be used as an API (Application Programming Interface).
 p.s.: right now, only row major matrix access is considered.

 */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*!
 @file
 @brief
 Performance kernels dispatching code, for each type, submatrix size, operation.
 For block coordinates format.
 Kernels unrolled, with no loops, for only user-specified blockings.
 */

/*

Copyright (C) 2008-2022 Michele Martone

This file is part of librsb.

librsb is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

librsb is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with librsb; see the file COPYING.
If not, see <http://www.gnu.org/licenses/>.

*/
/*
 The code in this file was generated automatically by an M4 script. 
 It is not meant to be used as an API (Application Programming Interface).
 p.s.: right now, only row major matrix access is considered.

 */
#include "rsb_common.h"
#include "rsb_krnl_bcss_spmv_u.h"	/* uhm */
#include "rsb_krnl_bcss_spsv_u.h"	/* uhm */
#include "rsb_krnl_bcss_misc_u.h"	/* uhm */

#pragma GCC visibility push(hidden)

#if RSB_WANT_EXPERIMENTAL_NO_EXTRA_CSR_ALLOCATIONS
#define RSB_MTX_NOT_OK(MTXAP) ( ((MTXAP)->rpntr || (MTXAP)->cpntr) || RSB_MATRIX_UNSUPPORTED_TYPE((MTXAP)->typecode) )
#else /* RSB_WANT_EXPERIMENTAL_NO_EXTRA_CSR_ALLOCATIONS */
#define RSB_MTX_NOT_OK(MTXAP) RSB_MATRIX_UNSUPPORTED_TYPE((MTXAP)->typecode)
#endif /* RSB_WANT_EXPERIMENTAL_NO_EXTRA_CSR_ALLOCATIONS */




rsb_err_t rsb__do_spmv_uaua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spmv_uaua" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uaua_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uaua_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uaua_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uaua_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uaua_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_spmv_uauz(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spmv_uauz" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uauz_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uauz_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uauz_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uauz_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uauz_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_spmv_uxua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const void * alphap,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spmv_uxua" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_uxua_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_uxua_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_uxua_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_uxua_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_uxua_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_spmv_unua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spmv_unua" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_unua_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_unua_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_unua_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_unua_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_unua_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_unua_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_unua_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_unua_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_spmv_sasa(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,rsb_coo_idx_t incx, rsb_coo_idx_t incy,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spmv_sasa" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sasa_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sasa_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sasa_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sasa_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sasa_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_spsv_uxua(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spsv_uxua" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;
	if(RSB_DO_FLAG_HAS_INTERSECTION(symmetry,RSB_FLAG_ANY_SYMMETRY))
		goto ssoerr;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	else
		errval = rsb__BCOR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_float_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	else
		errval = rsb__BCSR_spsv_uxua_double_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
	goto ret;
ssoerr:	errval = RSB__ERR_NO_SYM_SPSV;
	RSB_ERROR("Sorry, triangular solve of a non-unsymmetric matrix is nonsense.\n");
ret:	return errval;
}

rsb_err_t rsb__do_spmv_sxsa(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const void * alphap,rsb_coo_idx_t incx, rsb_coo_idx_t incy,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spmv_sxsa" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sU_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sS_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sH_dE_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_C__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tN_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tT_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sU_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sS_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_spmv_sxsa_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_spmv_sxsa_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_spmv_sxsa_double_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_spmv_sxsa_float_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_float_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_spmv_sxsa_double_complex_H__tC_r1_c1_uu_sH_dI_uG( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_spsv_sxsx(const struct rsb_mtx_t * mtxAp,const void * restrict rhs, void * restrict out,const void * alphap,rsb_coo_idx_t incx, rsb_coo_idx_t incy,const rsb_trans_t transA)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "spsv_sxsx" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;
	if(RSB_DO_FLAG_HAS_INTERSECTION(symmetry,RSB_FLAG_ANY_SYMMETRY))
		goto ssoerr;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dE_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dE_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_C__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tN_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tT_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	else
		errval = rsb__BCOR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_float_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):	if(rsb__is_lower_triangle(mtxAp->flags))
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dI_uL( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	else
		errval = rsb__BCSR_spsv_sxsx_double_complex_H__tC_r1_c1_uu_sU_dI_uU( 	mtxAp->VA,rhs,out,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,alphap,incx,incy );
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
	goto ret;
ssoerr:	errval = RSB__ERR_NO_SYM_SPSV;
	RSB_ERROR("Sorry, triangular solve of a non-unsymmetric matrix is nonsense.\n");
ret:	return errval;
}

rsb_err_t rsb__do_infty_norm(const struct rsb_mtx_t * mtxAp,const rsb_trans_t transA,void * row_sums)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "infty_norm" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_infty_norm_double_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_infty_norm_float_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_infty_norm_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_infty_norm_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_infty_norm_double_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_infty_norm_float_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_infty_norm_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_infty_norm_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_rowssums(const struct rsb_mtx_t * mtxAp,const rsb_trans_t transA,void * row_sums)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "rowssums" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tN_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tN_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tN_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tT_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tT_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tT_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tC_sU_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tC_sS_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tC_sH_dE_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	case(RSB_DIAGONAL_I):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_C_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	case(RSB_COORDINATE_TYPE_H):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tN_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tN_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tN_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tT_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tT_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tT_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_C):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tC_sU_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tC_sS_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_rowssums_double_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_rowssums_float_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_rowssums_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_rowssums_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_rowssums_double_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_rowssums_float_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_rowssums_float_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_rowssums_double_complex_H_u_tC_sH_dI_uG(	mtxAp->VA,row_sums,mtxAp->Mdim,mtxAp->mdim,(rsb_half_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	default:	goto traerr;
	}
	break;
	default:	goto idxerr;
	}
	break;
	default:	goto diaerr;
	}
	goto ret;
typerr: errval = RSB_ERR_UNSUPPORTED_TYPE;
	RSB_ERROR("Sorry, data type \"%c\" currently not supported.\n",mtxAp->typecode);
	goto ret;
fmterr:	errval = RSB_ERR_UNSUPPORTED_FORMAT;
	RSB_ERROR("Sorry, matrix storage \"%c\" currently not supported.\n",mtxAp->matrix_storage);
	goto ret;
symerr:	errval = RSB__ERR_UNSUPPORTED_SYMM;
	RSB_ERROR("Sorry, this symmetry case (0x%x) is not supported.\n",(rsb_int)symmetry);
	goto ret;
traerr: errval = RSB__ERR_UNSUPPORTED_TRANSA;
	RSB_ERROR("Sorry, this transposition case (0x%x) is not supported.\n",(rsb_int)transA);
	goto ret;
idxerr:	errval = RSB__ERR_UNSUPPORTED_IDX_TYPE;
	RSB_ERROR("Sorry, this coordinate index (0x%x) is not supported.\n",(rsb_int)half_storage);
	goto ret;
diaerr:	errval = RSB__ERR_UNSUPPORTED_DIAG;
	RSB_ERROR("Sorry, this diagonal type (0x%x) is not supported.\n",(rsb_int)diagonal);
ret:	return errval;
}

rsb_err_t rsb__do_scale(struct rsb_mtx_t * mtxAp,const rsb_trans_t transA,const void * scale_factors)
{
	/*!
	 * \ingroup rsb_doc_kernels
	 * Run-time "scale" kernels dispatching function for a single sparse matrix block.
	 *
	 * \return \rsb_errval_inp_param_msg
	 */
	rsb_err_t errval = RSB_ERR_INTERNAL_ERROR;
#ifdef RSB_COORDINATE_TYPE_H
	const rsb_int_t half_storage = rsb__do_is_candidate_size_for_halfword(mtxAp->Mdim,mtxAp->mdim,/*nnz*/0,mtxAp->flags)?RSB_COORDINATE_TYPE_H:RSB_COORDINATE_TYPE_C;
#else /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_int_t half_storage=RSB_COORDINATE_TYPE_C;
#endif /* RSB_M4_MATRIX_INDEX_COORDINATE_TYPE_PREPROCESSOR_SYMBOL(`rsb_half_idx_t') */
	const rsb_flags_t symmetry = rsb__get_symmetry_type_flag(mtxAp);
	const rsb_flags_t diagonal = rsb__get_diagonal_type_flag(mtxAp);
	const rsb_type_t typecode = mtxAp->typecode;

	if(RSB_MTX_NOT_OK(mtxAp))
		return RSB_ERR_BADARGS;

	switch(diagonal)
	{
	case(RSB_DIAGONAL_E):
	switch(half_storage)
	{
	case(RSB_COORDINATE_TYPE_C):
	switch(transA)
	{
	case(RSB_TRANSPOSITION_N):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_scale_double_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_scale_float_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_scale_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_scale_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_scale_double_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_scale_float_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_scale_float_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_scale_double_complex_C_u_tN_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_scale_double_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_scale_float_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_scale_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_scale_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_scale_double_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_scale_float_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_scale_float_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_scale_double_complex_C_u_tN_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_scale_double_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_scale_float_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_scale_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_scale_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_scale_double_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_scale_float_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_scale_float_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_scale_double_complex_C_u_tN_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	default:	goto symerr;
	}
	break;
	case(RSB_TRANSPOSITION_T):
	switch(symmetry)
	{
	case(RSB_SYMMETRY_U):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_scale_double_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_scale_float_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_scale_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_scale_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_scale_double_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_scale_float_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_scale_float_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_scale_double_complex_C_u_tT_sU_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_S):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_scale_double_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_scale_float_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_scale_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_scale_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_scale_double_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCSR_scale_float_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCSR_scale_float_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCSR_scale_double_complex_C_u_tT_sS_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	default:	goto fmterr;
	}
	break;
	case(RSB_SYMMETRY_H):
	switch(mtxAp->matrix_storage)
	{
	case(RSB_MATRIX_STORAGE_BCOR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCOR_scale_double_C_u_tT_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT ):		errval = rsb__BCOR_scale_float_C_u_tT_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_FLOAT_COMPLEX ):		errval = rsb__BCOR_scale_float_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	case(RSB_NUMERICAL_TYPE_DOUBLE_COMPLEX ):		errval = rsb__BCOR_scale_double_complex_C_u_tT_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,mtxAp->bm,mtxAp->roff,mtxAp->coff,mtxAp->flags,mtxAp->nnz,scale_factors);
	break;
	default:	goto typerr;
	}
	break;
	case(RSB_MATRIX_STORAGE_BCSR):
	switch(typecode)
	{
	case(RSB_NUMERICAL_TYPE_DOUBLE ):		errval = rsb__BCSR_scale_double_C_u_tT_sH_dE_uG(	mtxAp->VA,mtxAp->Mdim,mtxAp->mdim,(rsb_coo_idx_t*)mtxAp->bindx,mtxAp->bpntr,mtxAp->indptr,mtxAp->rpntr,mtxAp->cpntr,mtxAp->broff-mtxAp->roff,m