# 0.18.0 uTox: 👑🎉

## Features:
More stability, less code!

## Fixes:
* **Fix crash when changing toxcore-related settings** (92102bf65c80121cde73f3c192c3315cf3e4cfba)
* fix dragging friend list (#1470) (@w23rd) (70127baa853e6ee197f2ef44cccc44898629c8a3)
* utox_settings struct: give proxy_ip[] a size (fix UB) (072d29e0e6b6c1c1ea174ebcdcf6afd8b5bcf593)
* Update and refactor settings loading and saving:
	- **Drop obsolete save and load settings format** (@redmanmale) (6ead53756eda188b652c423488de84a888d139cc)
	- Rename (and fix usages) SETTINGS fields to match UTOXSAVE struct to be able to load it from config directly (@redmanmale) (751ea57ca8e4af429d57b84b5da1c3d5656a65dd)
	- Remove unused function config_osdefaults() (@redmanmale) (fe8cfe02f661765533698fcee2f734f943635e84)
	- Use settings instead of separate variables (@redmanmale) (94d474ae4a55efc7e0f15a1ea6872121f1c0a0e1)
	- Refactoring save and load uTox settings (@redmanmale) (acb2787f2996d9dd568f7b53ef9e23922f87a02e)
	- Save settings before killing Tox threads (@redmanmale) (a615853499f75d636a137c89763e1c779e062666)
	- Style fixes (@redmanmale) (0a0b1715e81d9a50b7a3dd5e31e3dde2a6ac37cc)
	- Update mock settings (@redmanmale) (0c8c74e9caca7717a2060c593b716cb104b3041b)
	- Try create Tox folder before saving settings (@redmanmale) (93aaef8e01cde29ea0f513a411caee8607b124ad)
	- settings.c: Write macros for write_config_value_\*() (6347681afa3a9f710ded5479e62510d3678ac771)
* getopt: Exit on wrong usage (c7353a36aee818df83e42a4024a792295e99fa4e)
* Fix offset of the typing notification (@redmanmale) (c92dfe6b3fcc05822df58b55cfac8db0d48ed355)
* Fix file size formatting in chatlog (@redmanmale) (60a0085c7cb48eaaf824941ca2281abaee996e0b)
* Fix handling large files (@redmanmale) (590efb82a816f6ae181e4192e8f7a673ee90b924)

## Documentation:
* Various README updates:
	- README.md: replace link to changelog with release notes (f15d7af96fcb6e2e9d5663cd08421633043ecb23)
	- README.md: Team: replace GitLab with GitHub links (e0949cfe0b1d23cdbecd50d9a67a31427249f171)
	- README.md: offer direct email contact (09d5f14edeb40e850931046c033e1986d3e6efc1)
	- README.md: rearrange Features (6fa1daf7438dd9f0bb51bf3342f10bf757c040cc)
	- README.md: move Features before Downloads (787d0a15a1720aa9e18e25302b6ac3c3a09fe148)
	- README.md: move screenshots to separate page (9b6735eff4ff1bc08d71a87e80160bbce7e58c73)
	- README.md: reorder links in the header (b9de94a85862642563376459ae02b60350d636e3)
	- README.md: add introduction text (edc42233af09030919ac8959512973910edc0d9a)
	- README: Update my email address (a9dcd5434636a06a8f3e18606b95942c82547a18)
* INSTALL: Fix table of contents; clean up a bit; update link for Windows (@redmanmale) (c004daf0652d897327749aa7d777753e0e966411)
* README: Update link to win64; drop obsolete or dead links to win32 and winXP (@redmanmale) (09807d91e0d74e48cf9c7d5940077bf86e0c4d68)
* README: Drop frighteningly red coverage badge leading nowhere (@redmanmale) (800c730005058367e326a064d10776ce59a20963)
* README: aTox is love, aTox is life! (@grayhatter) (c651f0dd465e0de220b56a61019b381c265211d9)
* Document and simplify filter_audio_check() (6894b7319034e8fba05a36e2b6332a821193fbcd)
* Reflect in --help text, that --debug requires an argument (dc3afc5f288e8efa8a65574e0a65f0f6fd9dfbb5)
* Add missing themes to --help text (8d7c875a48d65559053a54ab074be88c5ddc2937)
* Various man page updates:
	- utox.1.in: Don't list every theme in synopsis (3a17352f8104ccf7ac9cbc3e8ac000327419ca4f)
	- utox.1.in: Add --debug option (b955771ce9b34188eff17b50ffbc5268dde985a8)
	- utox.1.in: Correct max verbosity increment from 3 to 6 (0693ec07b5d8167f49e71d6c93b450fb0022c6a7)
	- utox.1.in: Remove reference to website utox.io (5af1aae0a871ad6faaf6671ae124d96e8667443d)
	- Move utox.1.in from src/ to man/ (8ffc8d156bc537103f91387732309bfaca0df8cd)
* README: Update fingerprint (@endoffile78) (20e441e77b58d516c100fe97156816e573e4f533)
* CHANGELOG.md: redirect to release_notes/ (fa06d80ec5104092c43169d2abf9cce94622eadf)
* BUILD: Update build docs for x86 (@redmanmale) (e769a7571fdabc139faaf98afe8dacf2d47aa7ba)
* README: Update Appveyor badge to point to official uTox project (@redmanmale) (2549594df7949811254c9792c520cff6c9d6b890)
* BUILD: Update build docs for Windows (@redmanmale) (c32820f840208e6ff700829a4069507e7506c805)

## Languages:
* Update Japanese (@xfm00mm) (6ef32a4358117342f42368585d1a74df1203cb66)
* Update German (Markus V) (b4c8682dfda4e45fa19e0edfd0ca6a59557fd5ac)

## Development:
* Minor settings changes (3873db771f71e1d078cb26cc08c2bd70c64672c4 7ae69a6e87bc9756a69585cd653be2c17a048820 e85192772b68f91b7a3dedfddee0881a2a4aeccf c8441c85a2d80552f0030142aa80ada8610e45e1)
* \*\*/CMakeLists.txt: remove header files from add_library() and add_executable() (2b4aa1cb1be47ca649dacb89d8f3eb613e17b4cb)
* src/xlib/CMakeLists.txt: compile mmenu.{c,h} conditionally (f09ef2654639c454b466eacb251358eaea0975ef)
* src/xlib/CMakeLists.txt: compile dbus.{c,h} conditionally (968275fe297dbd825b07fdafa9f3985d77afc471)
* Return the new groupchat pointer from group_create instead of a bool (@endoffile78) (f394e678dd63e002e8debc353a0766ddd43e0a9f)
* CMake: Simplify regexes that match MacOS, Linux, NetBSD and FreeBSD (@mazocomp) (3c94f978bb11e283aca4ce6e6861ec86b681e3d4)
* CI: Use Openal fork with fix for CMake > 3.12 (@redmanmale) (1754f832aa15d62eb00bfb4794b983d8e33ec0ef)
* Update Travis CI config: remove obsolete parameters, update linux dist (@redmanmale) (294ce89d96d530ea0ef30715797bd648e71e9d39)
* Rename friend list functions (e42ce470e9def27b9571c7a43efc98fe93fdabfb 99836d739983f5d4eef1fd6788ba055cdab87160 e5a2173dee5f428e83165a8412bcc86bb430373c 5aae930e6f32c7dfe4313e4cd15f3e85355e9d48)
* Various Windows cleanups (@redmanmale) (66b82df51b00dbc67e68bcba2d1d2a1e43b95f9d d256ba90bb37997109e38b68edbac4a6406adea6 f293dd42243dbb3af3d2a3e5fd77aeae085e1016)
* Use the old stb commit (@robinlinden) (18c7a3f140178f9d2afdf5392d2332f7dfe95ed0)
* CMake: Mark targets as being C only (@robinlinden) (1d31a8fb9fd8b968f9579664e99affac931b3b30)
* CI: Don't depend on cmdline.org artifacts on Travis (@robinlinden) (264cabac264fb00fa6dc92d7dc5424c55f5b6825)
* CMake: Fix cross-compilation from Linux to Windows (@robinlinden) (4720a2ccfb668eee1d34af14efca51f05c215d14)
* CI: Update Appveyor build (@redmanmale) (b9814dcba6a4b9ed5f92390c61ce9133fd21779a)
* CMake: Give third-party libraries their own targets (@robinlinden) (f2c9417b9a8c00b7037f634127c3e8736e42497e)
* Allow building Windows w/ -fno-common (@robinlinden) (f9423b4b3328d30443c2255176edaaf9d578f729)
* Fix implicit fallthrough warnings in Windows (@robinlinden) (34ceb7b1307b797f690d1d2fb3a543f65e104c2e)


## This release of uTox was brought to you by

### Regular contributors
@avoidr, @endoffile78, @grayhatter, @mazocomp, @redmanmale, @robinlinden

### New contributors
Markus V, @w23rd, @xfm00mm

## Do you know another language?
Help us translate uTox!
