#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Faerie Solitaire:
# - Faerie Solitaire Harvest
# - Faerie Solitaire Remastered
# send your bug reports to contact@dotslashplay.it
###

script_version=20241203.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID_REMASTERED='faerie-solitaire-remastered'
GAME_NAME_REMASTERED='Faerie Solitaire Remastered'

GAME_ID_HARVEST='faerie-solitaire-harvest'
GAME_NAME_HARVEST='Faerie Solitaire Harvest'

ARCHIVE_BASE_REMASTERED_0_NAME='FaerieSolitaireRemastered_x86_64-linux.zip'
ARCHIVE_BASE_REMASTERED_0_MD5='a225276e98b580bf76afa1d1b0f2780b'
ARCHIVE_BASE_REMASTERED_0_SIZE='143721'
ARCHIVE_BASE_REMASTERED_0_VERSION='2.0.19.12.15-itch.2019.12.19'
ARCHIVE_BASE_REMASTERED_0_URL='https://subsoap.itch.io/faerie-solitaire-remastered-linux'

ARCHIVE_BASE_HARVEST_0_NAME='FaerieSolitaireHarvest_x86_64-linux.tar.gz'
ARCHIVE_BASE_HARVEST_0_MD5='8871ffc902d5ce3896cca715eebb3fd9'
ARCHIVE_BASE_HARVEST_0_SIZE='173848'
ARCHIVE_BASE_HARVEST_0_VERSION='1.1.19.9.21-itch.2019.09.21'
ARCHIVE_BASE_HARVEST_0_URL='https://puppygames001.itch.io/faerie-solitaire-harvest'

CONTENT_PATH_DEFAULT_REMASTERED='Faerie Solitaire Remastered'
CONTENT_PATH_DEFAULT_HARVEST='FaerieSolitaireHarvest'
CONTENT_LIBS_BIN_FILES_HARVEST='
libfmod.so
libfmodstudio.so'
CONTENT_GAME_BIN_FILES_REMASTERED='
FaerieSolitaireRemastered.x86_64'
CONTENT_GAME_BIN_FILES_HARVEST='
FaerieSolitaireHarvest.x86_64'
CONTENT_GAME_DATA_FILES='
game.arcd
game.arci
game.dmanifest
game.projectc
game.public.der'
CONTENT_GAME0_DATA_FILES_HARVEST='
assets/banks/master.bank
assets/banks/master.strings.bank'

APP_MAIN_EXE_REMASTERED='FaerieSolitaireRemastered.x86_64'
APP_MAIN_EXE_HARVEST='FaerieSolitaireHarvest.x86_64'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_REMASTERED='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libstdc++.so.6
libX11.so.6
libXext.so.6'
PKG_BIN_DEPENDENCIES_LIBRARIES_HARVEST='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6'

PKG_DATA_ID_REMASTERED="${GAME_ID_REMASTERED}-data"
PKG_DATA_ID_HARVEST="${GAME_ID_HARVEST}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

## Fearie Solitaire Harvest - The game engine looks for FMOD libraries in a hardcoded path
case "$(current_archive)" in
	('ARCHIVE_BASE_HARVEST_'*)
		ln --symbolic "$(path_libraries)/libfmod.so" "$(package_path 'PKG_BIN')$(path_game_data)"
		ln --symbolic "$(path_libraries)/libfmodstudio.so" "$(package_path 'PKG_BIN')$(path_game_data)"
	;;
esac

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
