/*****************************************************************************
 * descs_list.h: All supported ISO/IEC 13818-1 descriptors
 *****************************************************************************
 * Copyright (C) 2009-2010 VideoLAN
 *
 * Authors: Christophe Massiot <massiot@via.ecp.fr>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *****************************************************************************/

#ifndef __BITSTREAM_MPEG_DESCS_LIST_H__
#define __BITSTREAM_MPEG_DESCS_LIST_H__

/*
 * 1. Keep the list ordered.
 * 2. When you are adding new descriptor here, make sure you also add
 *    the needed code in bitstream/mpeg/psi/descs_print.h
 */

#include <bitstream/mpeg/psi/desc_02.h>
#include <bitstream/mpeg/psi/desc_03.h>
#include <bitstream/mpeg/psi/desc_04.h>
#include <bitstream/mpeg/psi/desc_05.h>
#include <bitstream/mpeg/psi/desc_06.h>
#include <bitstream/mpeg/psi/desc_07.h>
#include <bitstream/mpeg/psi/desc_08.h>
#include <bitstream/mpeg/psi/desc_09.h>
#include <bitstream/mpeg/psi/desc_0a.h>
#include <bitstream/mpeg/psi/desc_0b.h>
#include <bitstream/mpeg/psi/desc_0c.h>
#include <bitstream/mpeg/psi/desc_0d.h>
#include <bitstream/mpeg/psi/desc_0e.h>
#include <bitstream/mpeg/psi/desc_0f.h>
#include <bitstream/mpeg/psi/desc_10.h>
#include <bitstream/mpeg/psi/desc_11.h>
#include <bitstream/mpeg/psi/desc_12.h>
#include <bitstream/mpeg/psi/desc_13.h>
#include <bitstream/mpeg/psi/desc_1b.h>
#include <bitstream/mpeg/psi/desc_1c.h>
#include <bitstream/mpeg/psi/desc_1d.h>
#include <bitstream/mpeg/psi/desc_1e.h>
#include <bitstream/mpeg/psi/desc_1f.h>
#include <bitstream/mpeg/psi/desc_20.h>
#include <bitstream/mpeg/psi/desc_21.h>
#include <bitstream/mpeg/psi/desc_22.h>
#include <bitstream/mpeg/psi/desc_23.h>
#include <bitstream/mpeg/psi/desc_24.h>
#include <bitstream/mpeg/psi/desc_25.h>
#include <bitstream/mpeg/psi/desc_26.h>
#include <bitstream/mpeg/psi/desc_27.h>
#include <bitstream/mpeg/psi/desc_28.h>
#include <bitstream/mpeg/psi/desc_2a.h>
#include <bitstream/mpeg/psi/desc_2b.h>
#include <bitstream/mpeg/psi/desc_2c.h>
#include <bitstream/mpeg/psi/desc_32.h>
#include <bitstream/mpeg/psi/desc_38.h>
#include <bitstream/mpeg/psi/desc_3f.h>
#include <bitstream/mpeg/psi/desc_3f03.h>

#endif
