/*
 *  Fenix - Videogame compiler/interpreter
 *  Current release       : FENIX - PROJECT 1.0 - R 0.84
 *  Last stable release   :
 *  Project documentation : http://fenix.divsite.net
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  Copyright  1999 Jos Luis Cebrin Page
 *  Copyright  2002 Fenix Team
 *
 */

#ifdef TARGET_BEOS
#include <posix/assert.h>
#else
#include <assert.h>
#endif

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

#include "fxi.h"
#include "dcb.h"

#define CHARWIDTH 6

static char sysfont[][8][16] = {
{
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "OOOOO." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "......" }
},{
        { "OOOOO." },
        { "O....." },
        { "O....." },
        { "OOOO.." },
        { "O....." },
        { "O....." },
        { "OOOOO." },
        { "......" }
},{
        { "OOOOO." },
        { "O....." },
        { "O....." },
        { "OOOO.." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O....." },
		{ "O..OO." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "OOOOO." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { "OOOOO." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "OOOOO." },
        { "......" }
},{
        { "....O." },
        { "....O." },
        { "....O." },
        { "....O." },
        { "....O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "O...O." },
        { "O..O.." },
        { "O.O..." },
        { "OO...." },
        { "O.O..." },
        { "O..O.." },
        { "O...O." },
        { "......" }
},{
        { "O....." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "OOOOO." },
        { "......" }
},{
        { "O...O." },
        { "OO.OO." },
        { "O.O.O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { ".OOO.." },
        { "......" },
        { "OO..O." },
        { "OO..O." },
        { "O.O.O." },
        { "O..OO." },
        { "O..OO." },
        { "......" }
},{
        { "OO..O." },
        { "OO..O." },
        { "O.O.O." },
        { "O.O.O." },
        { "O.O.O." },
        { "O..OO." },
        { "O..OO." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O.O.O." },
        { "OO..O." },
        { ".OOO.." },
        { "......" }
},{
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "O.O..." },
        { "O..O.." },
        { "O...O." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O....." },
        { ".OOO.." },
        { "....O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "OOOOO." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "......" }
},{
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".O.O.." },
        { ".O.O.." },
        { "..O..." },
        { "......" }
},{
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O.O.O." },
        { "O.O.O." },
        { ".O.O.." },
        { "......" }
},{
        { "O...O." },
        { "O...O." },
        { ".O.O.." },
        { "..O..." },
        { ".O.O.." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { "O...O." },
        { "O...O." },
        { ".O.O.." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "......" }
},{
        { "OOOOO." },
        { "....O." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "O....." },
        { "OOOOO." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "..O..." },
        { ".OO..." },
        { "O.O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "OOOOO." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "....O." },
        { "..OO.." },
        { ".O...." },
        { "O....." },
        { "OOOOO." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "....O." },
        { ".OOO.." },
        { "....O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "....O." },
        { "O...O." },
        { "O...O." },
        { "OOOOO." },
        { "....O." },
        { "....O." },
        { "....O." },
        { "......" }
},{
        { "OOOOO." },
        { "O....." },
        { "OOOO.." },
        { "....O." },
        { "....O." },
        { "....O." },
        { "OOOO.." },
        { "......" }
},{
        { ".OOO.." },
        { "O....." },
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "OOOOO." },
        { "....O." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "O....." },
        { "O....." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOOO." },
        { "....O." },
        { ".OOO.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "..OO.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "..OO.." },
        { "......" },
        { "......" },
        { "..OO.." },
        { "......" },
        { "......" }
},{
        { "......" },
        { "......" },
        { "......" },
        { ".OOOO." },
        { "......" },
        { ".OOOO." },
        { "......" },
        { "......" }
},{
        { "OO...." },
        { "O...O." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "O...O." },
        { "...OO." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOO.." },
        { "....O." },
        { ".OOOO." },
        { "O...O." },
        { ".OOOO." },
        { "......" }
},{
        { "O....." },
        { "O....." },
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOO.." },
        { "O...O." },
        { "O....." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "....O." },
        { "....O." },
        { ".OOOO." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOOO." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOO.." },
        { "O...O." },
        { "OOOO.." },
        { "O....." },
        { ".OOOO." },
        { "......" }
},{
        { ".OOO.." },
        { "O...O." },
        { "O....." },
        { "OOO..." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOOO." },
        { "O...O." },
        { "O...O." },
        { ".OOOO." },
        { "....O." },
        { ".OOO.." }
},{
        { "O....." },
        { "O....." },
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { "......" },
        { "..O..." },
        { "......" },
        { ".OO..." },
        { "..O..." },
        { "..O..." },
        { ".OOO.." },
        { "......" }
},{
        { "......" },
        { "....O." },
        { "......" },
        { "..OOO." },
        { "....O." },
        { "....O." },
        { "O...O." },
        { ".OOO.." }
},{
        { "O....." },
        { "O....." },
        { "O....." },
        { "O..O.." },
        { "OOO..." },
        { "O..O.." },
        { "O...O." },
        { "......" }
},{
        { ".OO..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "OOOOO." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".O.O.." },
        { "O.O.O." },
        { "O.O.O." },
        { "O.O.O." },
        { "O.O.O." },
        { "......" }
},{
        { "OOOOO." },
        { "......" },
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOO.." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "OOOO.." },
        { "O...O." },
        { "O...O." },
        { "OOOO.." },
        { "O....." },
        { "O....." }
},{
        { "......" },
        { "......" },
        { ".OOOO." },
        { "O...O." },
        { "O...O." },
        { ".OOOO." },
        { "....O." },
        { "....O." }
},{
        { "......" },
        { "......" },
        { "O.OO.." },
        { "OO..O." },
        { "O....." },
        { "O....." },
        { "O....." },
        { "......" }
},{
        { "......" },
        { "......" },
        { ".OOO.." },
        { "O....." },
        { ".OOO.." },
        { "....O." },
        { "OOOO.." },
        { "......" }
},{
        { ".O...." },
        { ".O...." },
        { "OOOO.." },
        { ".O...." },
        { ".O...." },
        { ".O..O." },
        { "..OO.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".O.O.." },
        { "..O..." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "O...O." },
        { "O...O." },
        { "O.O.O." },
        { "O.O.O." },
        { ".O.O.." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "O...O." },
        { ".O.O.." },
        { "..O..." },
        { ".O.O.." },
        { "O...O." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "O...O." },
        { "O...O." },
        { "O...O." },
        { ".OOOO." },
        { "....O." },
        { "OOOO.." }
},{
        { "......" },
        { "......" },
        { "OOOOO." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "OOOOO." },
        { "......" }
},{
        { ".OOO.." },
        { ".O...." },
        { ".O...." },
        { ".O...." },
        { ".O...." },
        { ".O...." },
        { ".OOO.." },
        { "......" }
},{
        { ".OOO.." },
        { "...O.." },
        { "...O.." },
        { "...O.." },
        { "...O.." },
        { "...O.." },
        { ".OOO.." },
        { "......" }
},{
        { "..OO.." },
        { ".O...." },
        { ".O...." },
        { ".O...." },
        { ".O...." },
        { ".O...." },
        { "..OO.." },
        { "......" }
},{
        { ".OO..." },
        { "...O.." },
        { "...O.." },
        { "...O.." },
        { "...O.." },
        { "...O.." },
        { ".OO..." },
        { "......" }
},{
        { "..OO.." },
        { ".O...." },
        { ".O...." },
        { "O....." },
        { ".O...." },
        { ".O...." },
        { "..OO.." },
        { "......" }
},{
        { ".OO..." },
        { "...O.." },
        { "...O.." },
        { "....O." },
        { "...O.." },
        { "...O.." },
        { ".OO..." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "OOOOO." },
        { "......" },
        { "......" },
        { "......" }
},{
        { ".O...." },
        { "..O..." },
        { "...O.." },
        { "....O." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "......" }
},{
        { "....O." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "..O..." },
        { "...O.." },
        { "....O." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "OOOOO." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "...O.." },
        { ".OO..." }
},{
        { "......" },
        { "O....." },
        { ".O...." },
        { "..O..." },
        { "...O.." },
        { "....O." },
        { ".....O" },
        { "......" }
},{
        { "......" },
        { ".....O" },
        { "....O." },
        { "...O.." },
        { "..O..." },
        { ".O...." },
        { "O....." },
        { "......" }
},{
        { "......" },
        { "......" },
        { "..O..." },
        { "..O..." },
        { "OOOOO." },
        { "..O..." },
        { "..O..." },
        { "......" }
},{
        { "......" },
        { ".O.O.." },
        { "..O..." },
        { "OOOOO." },
        { "..O..." },
        { ".O.O.." },
        { "......" },
        { "......" }
},{
        { "......" },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "......" },
        { "..O..." },
        { "......" }
},{
        { "......" },
        { "..O..." },
        { "......" },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "......" }
},{
        { "......" },
        { ".OOO.." },
        { "O...O." },
        { "...O.." },
        { "..O..." },
        { "......" },
        { "..O..." },
        { "......" }
},{
        { "......" },
        { "..O..." },
        { "......" },
        { "..O..." },
        { ".O...." },
        { "O...O." },
        { ".OOO.." },
        { "......" }
},{
        { ".O.O.." },
        { ".O.O.." },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" }
},{
        { "...O.." },
        { "..O..." },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "......" }
},{
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..OOOO" },
        { "..O..." },
        { "..O..." },
        { "..O..." }
},{
        { "......" },
        { "......" },
        { "......" },
        { "......" },
        { "OOOOOO" },
        { "......" },
        { "......" },
        { "......" }
},{
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." },
        { "..O..." }
}
};

static Uint8 * letters = " ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.:=%abcdefghijklmnopqrstuvwxyz[](){}-><_,\\/+*!?\"'\x01\x02\x03" ;

static int fg, bg ;

void gr_sys_putchar (GRAPH * map, int ox, int oy, Uint8 c)
{
        Sint32 x, y ;
        static int corr[256] ;
        static int corr_init = 0 ;

        if (!corr_init)
        {
                Uint8 * ptr ;

                for (ptr = letters; *ptr; ptr++)
                        corr[*ptr] = corr_init++ ;
        }

#define PUTSYS(TYPE)												\
        for (y = oy ; y < oy+8 ; y++)								\
        {															\
                TYPE * ptr; Uint8 * cptr ;							\
                if (y < 0 || y >= (int)map->height)					\
                        continue ;									\
                ptr = (TYPE *)((Uint8*)map->data + map->pitch*y) ;	\
                ptr += ox;											\
                cptr = (Uint8*)sysfont[c][y-oy];		  			\
                for (x = ox ; x < ox+6 ; x++, cptr++)				\
                {                                        			\
                        if (x < 0 || x >= (int)map->width)  		\
                        {                                			\
                                ptr++ ;                  			\
                                continue ;               			\
                        }                                			\
                        if (*cptr == 'O')                			\
                                *ptr++ = fg ;            			\
                        else if (bg)                     			\
                                *ptr++ = bg ;            			\
                        else ptr++ ;                     			\
                }                                        			\
        }

        if (map->depth == 8)
		{
			c = corr[c] ;
			PUTSYS(Uint8)
		}
        else
		{
			c = corr[c] ;
			PUTSYS(Uint16)
		}

#undef PUTSYS
}

static int text_colors[] =
{
        0x404040, 0xC00000, 0x00C000, 0x0000C0, 0x00C0C0, 0xC000C0, 0xC0C000, 0xC0C0C0,
        0x808080, 0xFF0000, 0x00FF00, 0x0000FF, 0x00FFFF, 0xFF00FF, 0xFFFF00, 0xFFFFFF
} ;

void gr_sys_puts (GRAPH * map, int x, int y, Uint8 * str, int len)
{
	if (bg == 0 && fg != 0)
	{
		int ofg = fg;
		fg = 0;
		gr_sys_puts (map, x-1, y, str, len);
		gr_sys_puts (map, x+1, y, str, len);
		gr_sys_puts (map, x-1, y-1, str, len);
		gr_sys_puts (map, x+1, y+1, str, len);
		gr_sys_puts (map, x, y-1, str, len);
		gr_sys_puts (map, x, y+1, str, len);
		fg = ofg;
	}

	while (*str && len--)
	{
		if (*str == (Uint8)'')
		{
			Uint8 color = 0 ;
			str++ ;
			if (isdigit(*str)) color = *str++ - '0' ;
			if (isdigit(*str)) color = color*10 + *str++ - '0' ;
			if (color > 15) color = 15 ;
			if (fg != 0) gr_sys_color (text_colors[color], -1) ;
			if (!*str) { len++ ; break ; }
		}
		gr_sys_putchar (map, x, y, *str++) ;
		x += CHARWIDTH ;
	}
	while (len-- > 0)
	{
		gr_sys_putchar (map, x, y, ' ') ;
		x += CHARWIDTH ;
	}
}

void gr_sys_color (int cfg, int cbg)
{
	if (cbg == 0) bg = 0;
	if (enable_16bits)
	{
		if (cfg > 0)
			fg = gr_rgb (((cfg & 0xFF0000) >> 16),
						 ((cfg & 0x00FF00) >>  8),
						  (cfg & 0x0000FF) ) ;
		if (cbg > 0)
			bg = gr_rgb (((cbg & 0xFF0000) >> 16),
						 ((cbg & 0x00FF00) >>  8),
						  (cbg & 0x0000FF) ) ;
	}
	else
	{
		if (!trans_table_updated)
			gr_make_trans_table() ;

		if (cfg > 0)
			fg = gr_find_nearest_color (
				((cfg & 0xFF0000) >> 16),
				((cfg & 0x00FF00) >>  8),
				 (cfg & 0x0000FF) ) ;
		if (cbg > 0)
			bg = gr_find_nearest_color (
				((cbg & 0xFF0000) >> 16),
				((cbg & 0x00FF00) >>  8),
				 (cbg & 0x0000FF) ) ;
	}
}

