/* Generated by Frama-C */
#include "pthread.h"
#include "sched.h"
#include "signal.h"
#include "stddef.h"
#include "stdint.h"
#include "stdio.h"
#include "stdlib.h"
#include "time.h"
extern  __attribute__((__FC_BUILTIN__)) int __e_acsl_sound_verdict;

/*@ requires valid_memptr: \valid(memptr);
    requires
      alignment_is_a_suitable_power_of_two:
        alignment >= sizeof(void *) &&
        ((size_t)alignment & ((size_t)alignment - 1)) == 0;
    assigns __fc_heap_status, \result;
    assigns __fc_heap_status
      \from (indirect: alignment), size, __fc_heap_status;
    assigns \result
      \from (indirect: alignment), (indirect: size),
            (indirect: __fc_heap_status);
    allocates *\old(memptr);
    
    behavior allocation:
      assumes can_allocate: is_allocable(size);
      ensures allocation: \fresh{Old, Here}(*\old(memptr),\old(size));
      ensures result_zero: \result == 0;
      assigns __fc_heap_status, \result;
      assigns __fc_heap_status
        \from (indirect: alignment), size, __fc_heap_status;
      assigns \result
        \from (indirect: alignment), (indirect: size),
              (indirect: __fc_heap_status);
    
    behavior no_allocation:
      assumes cannot_allocate: !is_allocable(size);
      ensures result_non_zero: \result < 0 || \result > 0;
      assigns \result;
      assigns \result \from (indirect: alignment);
      allocates \nothing;
    
    complete behaviors no_allocation, allocation;
    disjoint behaviors no_allocation, allocation;
 */
int __gen_e_acsl_posix_memalign(void **memptr, size_t alignment, size_t size);

/*@ assigns __e_acsl_heap_allocation_size, __e_acsl_heap_allocated_blocks;
    assigns __e_acsl_heap_allocation_size
      \from (indirect: alignment), size, __e_acsl_heap_allocation_size;
    assigns __e_acsl_heap_allocated_blocks
      \from (indirect: alignment), size, __e_acsl_heap_allocated_blocks;
 */
void *aligned_alloc(size_t alignment, size_t size);

int main(int argc, char const **argv)
{
  int __retres;
  char *a;
  __e_acsl_memory_init(& argc,(char ***)(& argv),8UL);
  __e_acsl_store_block((void *)(& a),8UL);
  char **memptr = malloc(sizeof(void *));
  __e_acsl_store_block((void *)(& memptr),8UL);
  __e_acsl_full_init((void *)(& memptr));
  int res2 =
    __gen_e_acsl_posix_memalign((void **)memptr,(size_t)256,(size_t)15);
  char *p = *memptr;
  __e_acsl_store_block((void *)(& p),8UL);
  __e_acsl_full_init((void *)(& p));
  {
    int __gen_e_acsl_initialized;
    int __gen_e_acsl_and;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data = {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data,"&p",
                                 (void *)(& p));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data,
                                   "sizeof(char *)",0,sizeof(char *));
    __gen_e_acsl_initialized = __e_acsl_initialized((void *)(& p),
                                                    sizeof(char *));
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,
                                 "\\initialized(&p)",0,
                                 __gen_e_acsl_initialized);
    if (__gen_e_acsl_initialized) {
      int __gen_e_acsl_valid;
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data,"p",(void *)p);
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data,
                                     "sizeof(char)",0,sizeof(char));
      __gen_e_acsl_valid = __e_acsl_valid((void *)p,sizeof(char),(void *)p,
                                          (void *)(& p));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,"\\valid(p)",0,
                                   __gen_e_acsl_valid);
      __gen_e_acsl_and = __gen_e_acsl_valid;
    }
    else __gen_e_acsl_and = 0;
    __gen_e_acsl_assert_data.blocking = 1;
    __gen_e_acsl_assert_data.kind = "Assertion";
    __gen_e_acsl_assert_data.pred_txt = "\\valid(p)";
    __gen_e_acsl_assert_data.file = "memalign.c";
    __gen_e_acsl_assert_data.fct = "main";
    __gen_e_acsl_assert_data.line = 15;
    __e_acsl_assert(__gen_e_acsl_and,& __gen_e_acsl_assert_data);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data);
  }
  /*@ assert \valid(p); */ ;
  {
    unsigned long __gen_e_acsl_block_length;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_2 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_2,"p",(void *)p);
    __gen_e_acsl_block_length = __e_acsl_block_length((void *)p);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,
                                   "\\block_length(p)",0,
                                   __gen_e_acsl_block_length);
    __gen_e_acsl_assert_data_2.blocking = 1;
    __gen_e_acsl_assert_data_2.kind = "Assertion";
    __gen_e_acsl_assert_data_2.pred_txt = "\\block_length(p) == 15";
    __gen_e_acsl_assert_data_2.file = "memalign.c";
    __gen_e_acsl_assert_data_2.fct = "main";
    __gen_e_acsl_assert_data_2.line = 16;
    __e_acsl_assert(__gen_e_acsl_block_length == 15UL,
                    & __gen_e_acsl_assert_data_2);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_2);
  }
  /*@ assert \block_length(p) == 15; */ ;
  {
    int __gen_e_acsl_freeable;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_3 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_3,"p",(void *)p);
    __gen_e_acsl_freeable = __e_acsl_freeable((void *)p);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_3,
                                 "\\freeable(p)",0,__gen_e_acsl_freeable);
    __gen_e_acsl_assert_data_3.blocking = 1;
    __gen_e_acsl_assert_data_3.kind = "Assertion";
    __gen_e_acsl_assert_data_3.pred_txt = "\\freeable(p)";
    __gen_e_acsl_assert_data_3.file = "memalign.c";
    __gen_e_acsl_assert_data_3.fct = "main";
    __gen_e_acsl_assert_data_3.line = 17;
    __e_acsl_assert(__gen_e_acsl_freeable,& __gen_e_acsl_assert_data_3);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_3);
  }
  /*@ assert \freeable(p); */ ;
  free((void *)p);
  {
    int __gen_e_acsl_initialized_2;
    int __gen_e_acsl_and_2;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_4 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_4,"&p",
                                 (void *)(& p));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,
                                   "sizeof(char *)",0,sizeof(char *));
    __gen_e_acsl_initialized_2 = __e_acsl_initialized((void *)(& p),
                                                      sizeof(char *));
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,
                                 "\\initialized(&p)",0,
                                 __gen_e_acsl_initialized_2);
    if (__gen_e_acsl_initialized_2) {
      int __gen_e_acsl_valid_2;
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_4,"p",
                                   (void *)p);
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_4,
                                     "sizeof(char)",0,sizeof(char));
      __gen_e_acsl_valid_2 = __e_acsl_valid((void *)p,sizeof(char),(void *)p,
                                            (void *)(& p));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,"\\valid(p)",
                                   0,__gen_e_acsl_valid_2);
      __gen_e_acsl_and_2 = __gen_e_acsl_valid_2;
    }
    else __gen_e_acsl_and_2 = 0;
    __gen_e_acsl_assert_data_4.blocking = 1;
    __gen_e_acsl_assert_data_4.kind = "Assertion";
    __gen_e_acsl_assert_data_4.pred_txt = "!\\valid(p)";
    __gen_e_acsl_assert_data_4.file = "memalign.c";
    __gen_e_acsl_assert_data_4.fct = "main";
    __gen_e_acsl_assert_data_4.line = 19;
    __e_acsl_assert(! __gen_e_acsl_and_2,& __gen_e_acsl_assert_data_4);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_4);
  }
  /*@ assert !\valid(p); */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((size_t)256,(size_t)12);
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_5 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_5,"a",(void *)a);
    __gen_e_acsl_assert_data_5.blocking = 1;
    __gen_e_acsl_assert_data_5.kind = "Assertion";
    __gen_e_acsl_assert_data_5.pred_txt = "a == \\null";
    __gen_e_acsl_assert_data_5.file = "memalign.c";
    __gen_e_acsl_assert_data_5.fct = "main";
    __gen_e_acsl_assert_data_5.line = 23;
    __e_acsl_assert(a == (char *)0,& __gen_e_acsl_assert_data_5);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_5);
  }
  /*@ assert a == \null; */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((size_t)255,(size_t)512);
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_6 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_6,"a",(void *)a);
    __gen_e_acsl_assert_data_6.blocking = 1;
    __gen_e_acsl_assert_data_6.kind = "Assertion";
    __gen_e_acsl_assert_data_6.pred_txt = "a == \\null";
    __gen_e_acsl_assert_data_6.file = "memalign.c";
    __gen_e_acsl_assert_data_6.fct = "main";
    __gen_e_acsl_assert_data_6.line = 26;
    __e_acsl_assert(a == (char *)0,& __gen_e_acsl_assert_data_6);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_6);
  }
  /*@ assert a == \null; */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((size_t)0,(size_t)512);
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_7 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_7,"a",(void *)a);
    __gen_e_acsl_assert_data_7.blocking = 1;
    __gen_e_acsl_assert_data_7.kind = "Assertion";
    __gen_e_acsl_assert_data_7.pred_txt = "a == \\null";
    __gen_e_acsl_assert_data_7.file = "memalign.c";
    __gen_e_acsl_assert_data_7.fct = "main";
    __gen_e_acsl_assert_data_7.line = 29;
    __e_acsl_assert(a == (char *)0,& __gen_e_acsl_assert_data_7);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_7);
  }
  /*@ assert a == \null; */ ;
  __e_acsl_full_init((void *)(& a));
  a = (char *)aligned_alloc((size_t)256,(size_t)512);
  {
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_8 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_8,"a",(void *)a);
    __gen_e_acsl_assert_data_8.blocking = 1;
    __gen_e_acsl_assert_data_8.kind = "Assertion";
    __gen_e_acsl_assert_data_8.pred_txt = "a != \\null";
    __gen_e_acsl_assert_data_8.file = "memalign.c";
    __gen_e_acsl_assert_data_8.fct = "main";
    __gen_e_acsl_assert_data_8.line = 32;
    __e_acsl_assert(a != (char *)0,& __gen_e_acsl_assert_data_8);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_8);
  }
  /*@ assert a != \null; */ ;
  {
    int __gen_e_acsl_initialized_3;
    int __gen_e_acsl_and_3;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_9 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_9,"&a",
                                 (void *)(& a));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_9,
                                   "sizeof(char *)",0,sizeof(char *));
    __gen_e_acsl_initialized_3 = __e_acsl_initialized((void *)(& a),
                                                      sizeof(char *));
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,
                                 "\\initialized(&a)",0,
                                 __gen_e_acsl_initialized_3);
    if (__gen_e_acsl_initialized_3) {
      int __gen_e_acsl_valid_3;
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_9,"a",
                                   (void *)a);
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_9,
                                     "sizeof(char)",0,sizeof(char));
      __gen_e_acsl_valid_3 = __e_acsl_valid((void *)a,sizeof(char),(void *)a,
                                            (void *)(& a));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_9,"\\valid(a)",
                                   0,__gen_e_acsl_valid_3);
      __gen_e_acsl_and_3 = __gen_e_acsl_valid_3;
    }
    else __gen_e_acsl_and_3 = 0;
    __gen_e_acsl_assert_data_9.blocking = 1;
    __gen_e_acsl_assert_data_9.kind = "Assertion";
    __gen_e_acsl_assert_data_9.pred_txt = "\\valid(a)";
    __gen_e_acsl_assert_data_9.file = "memalign.c";
    __gen_e_acsl_assert_data_9.fct = "main";
    __gen_e_acsl_assert_data_9.line = 33;
    __e_acsl_assert(__gen_e_acsl_and_3,& __gen_e_acsl_assert_data_9);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_9);
  }
  /*@ assert \valid(a); */ ;
  {
    unsigned long __gen_e_acsl_block_length_2;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_10 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_10,"a",(void *)a);
    __gen_e_acsl_block_length_2 = __e_acsl_block_length((void *)a);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_10,
                                   "\\block_length(a)",0,
                                   __gen_e_acsl_block_length_2);
    __gen_e_acsl_assert_data_10.blocking = 1;
    __gen_e_acsl_assert_data_10.kind = "Assertion";
    __gen_e_acsl_assert_data_10.pred_txt = "\\block_length(a) == 512";
    __gen_e_acsl_assert_data_10.file = "memalign.c";
    __gen_e_acsl_assert_data_10.fct = "main";
    __gen_e_acsl_assert_data_10.line = 34;
    __e_acsl_assert(__gen_e_acsl_block_length_2 == 512UL,
                    & __gen_e_acsl_assert_data_10);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_10);
  }
  /*@ assert \block_length(a) == 512; */ ;
  {
    int __gen_e_acsl_freeable_2;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_11 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_11,"a",(void *)a);
    __gen_e_acsl_freeable_2 = __e_acsl_freeable((void *)a);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_11,
                                 "\\freeable(a)",0,__gen_e_acsl_freeable_2);
    __gen_e_acsl_assert_data_11.blocking = 1;
    __gen_e_acsl_assert_data_11.kind = "Assertion";
    __gen_e_acsl_assert_data_11.pred_txt = "\\freeable(a)";
    __gen_e_acsl_assert_data_11.file = "memalign.c";
    __gen_e_acsl_assert_data_11.fct = "main";
    __gen_e_acsl_assert_data_11.line = 35;
    __e_acsl_assert(__gen_e_acsl_freeable_2,& __gen_e_acsl_assert_data_11);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_11);
  }
  /*@ assert \freeable(a); */ ;
  free((void *)a);
  {
    int __gen_e_acsl_initialized_4;
    int __gen_e_acsl_and_4;
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_12 =
      {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_12,"&a",
                                 (void *)(& a));
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_12,
                                   "sizeof(char *)",0,sizeof(char *));
    __gen_e_acsl_initialized_4 = __e_acsl_initialized((void *)(& a),
                                                      sizeof(char *));
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_12,
                                 "\\initialized(&a)",0,
                                 __gen_e_acsl_initialized_4);
    if (__gen_e_acsl_initialized_4) {
      int __gen_e_acsl_valid_4;
      __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data_12,"a",
                                   (void *)a);
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_12,
                                     "sizeof(char)",0,sizeof(char));
      __gen_e_acsl_valid_4 = __e_acsl_valid((void *)a,sizeof(char),(void *)a,
                                            (void *)(& a));
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_12,
                                   "\\valid(a)",0,__gen_e_acsl_valid_4);
      __gen_e_acsl_and_4 = __gen_e_acsl_valid_4;
    }
    else __gen_e_acsl_and_4 = 0;
    __gen_e_acsl_assert_data_12.blocking = 1;
    __gen_e_acsl_assert_data_12.kind = "Assertion";
    __gen_e_acsl_assert_data_12.pred_txt = "!\\valid(a)";
    __gen_e_acsl_assert_data_12.file = "memalign.c";
    __gen_e_acsl_assert_data_12.fct = "main";
    __gen_e_acsl_assert_data_12.line = 38;
    __e_acsl_assert(! __gen_e_acsl_and_4,& __gen_e_acsl_assert_data_12);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_12);
  }
  /*@ assert !\valid(a); */ ;
  __retres = 0;
  __e_acsl_delete_block((void *)(& a));
  __e_acsl_delete_block((void *)(& p));
  __e_acsl_delete_block((void *)(& memptr));
  __e_acsl_memory_clean();
  return __retres;
}

/*@ requires valid_memptr: \valid(memptr);
    requires
      alignment_is_a_suitable_power_of_two:
        alignment >= sizeof(void *) &&
        ((size_t)alignment & ((size_t)alignment - 1)) == 0;
    assigns __fc_heap_status, \result;
    assigns __fc_heap_status
      \from (indirect: alignment), size, __fc_heap_status;
    assigns \result
      \from (indirect: alignment), (indirect: size),
            (indirect: __fc_heap_status);
    allocates *\old(memptr);
    
    behavior allocation:
      assumes can_allocate: is_allocable(size);
      ensures allocation: \fresh{Old, Here}(*\old(memptr),\old(size));
      ensures result_zero: \result == 0;
      assigns __fc_heap_status, \result;
      assigns __fc_heap_status
        \from (indirect: alignment), size, __fc_heap_status;
      assigns \result
        \from (indirect: alignment), (indirect: size),
              (indirect: __fc_heap_status);
    
    behavior no_allocation:
      assumes cannot_allocate: !is_allocable(size);
      ensures result_non_zero: \result < 0 || \result > 0;
      assigns \result;
      assigns \result \from (indirect: alignment);
      allocates \nothing;
    
    complete behaviors no_allocation, allocation;
    disjoint behaviors no_allocation, allocation;
 */
int __gen_e_acsl_posix_memalign(void **memptr, size_t alignment, size_t size)
{
  __e_acsl_contract_t *__gen_e_acsl_contract;
  int __retres;
  {
    int __gen_e_acsl_valid;
    int __gen_e_acsl_and;
    __e_acsl_store_block((void *)(& memptr),8UL);
    __gen_e_acsl_contract = __e_acsl_contract_init(2UL);
    __e_acsl_assert_data_t __gen_e_acsl_assert_data = {.values = (void *)0};
    __e_acsl_assert_register_ptr(& __gen_e_acsl_assert_data,"memptr",
                                 (void *)memptr);
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data,
                                   "sizeof(void *)",0,sizeof(void *));
    __gen_e_acsl_valid = __e_acsl_valid((void *)memptr,sizeof(void *),
                                        (void *)memptr,(void *)(& memptr));
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data,
                                 "\\valid(memptr)",0,__gen_e_acsl_valid);
    __gen_e_acsl_assert_data.blocking = 1;
    __gen_e_acsl_assert_data.kind = "Precondition";
    __gen_e_acsl_assert_data.pred_txt = "\\valid(memptr)";
    __gen_e_acsl_assert_data.file = "FRAMAC_SHARE/libc/stdlib.h";
    __gen_e_acsl_assert_data.fct = "posix_memalign";
    __gen_e_acsl_assert_data.line = 701;
    __gen_e_acsl_assert_data.name = "valid_memptr";
    __e_acsl_assert(__gen_e_acsl_valid,& __gen_e_acsl_assert_data);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data);
    __e_acsl_assert_data_t __gen_e_acsl_assert_data_2 =
      {.values = (void *)0};
    __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,"alignment",
                                   0,alignment);
    __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_2,
                                 "sizeof(void *)",0,8);
    if (alignment >= 8UL) {
      __e_acsl_mpz_t __gen_e_acsl_;
      __e_acsl_mpz_t __gen_e_acsl__2;
      __e_acsl_mpz_t __gen_e_acsl_sub;
      __e_acsl_mpz_t __gen_e_acsl_band;
      unsigned long __gen_e_acsl__3;
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,
                                     "alignment",0,alignment);
      __gmpz_init_set_ui(__gen_e_acsl_,alignment);
      __e_acsl_assert_register_ulong(& __gen_e_acsl_assert_data_2,
                                     "alignment",0,alignment);
      __gmpz_init_set_si(__gen_e_acsl__2,1L);
      __gmpz_init(__gen_e_acsl_sub);
      __gmpz_sub(__gen_e_acsl_sub,
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_),
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl__2));
      __gmpz_init(__gen_e_acsl_band);
      __gmpz_and(__gen_e_acsl_band,
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_),
                 (__e_acsl_mpz_struct const *)(__gen_e_acsl_sub));
      __gen_e_acsl__3 = __gmpz_get_ui((__e_acsl_mpz_struct const *)(__gen_e_acsl_band));
      __gen_e_acsl_and = __gen_e_acsl__3 == 0UL;
      __gmpz_clear(__gen_e_acsl_);
      __gmpz_clear(__gen_e_acsl__2);
      __gmpz_clear(__gen_e_acsl_sub);
      __gmpz_clear(__gen_e_acsl_band);
    }
    else __gen_e_acsl_and = 0;
    __gen_e_acsl_assert_data_2.blocking = 1;
    __gen_e_acsl_assert_data_2.kind = "Precondition";
    __gen_e_acsl_assert_data_2.pred_txt = "alignment >= sizeof(void *) &&\n((size_t)alignment & ((size_t)alignment - 1)) == 0";
    __gen_e_acsl_assert_data_2.file = "FRAMAC_SHARE/libc/stdlib.h";
    __gen_e_acsl_assert_data_2.fct = "posix_memalign";
    __gen_e_acsl_assert_data_2.line = 703;
    __gen_e_acsl_assert_data_2.name = "alignment_is_a_suitable_power_of_two";
    __e_acsl_assert(__gen_e_acsl_and,& __gen_e_acsl_assert_data_2);
    __e_acsl_assert_clean(& __gen_e_acsl_assert_data_2);
  }
  __retres = posix_memalign(memptr,alignment,size);
  {
    int __gen_e_acsl_assumes_value;
    __gen_e_acsl_assumes_value = __e_acsl_contract_get_behavior_assumes
    ((__e_acsl_contract_t const *)__gen_e_acsl_contract,0UL);
    if (__gen_e_acsl_assumes_value) {
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_4 =
        {.values = (void *)0};
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_4,"\\result",0,
                                   __retres);
      __gen_e_acsl_assert_data_4.blocking = 1;
      __gen_e_acsl_assert_data_4.kind = "Postcondition";
      __gen_e_acsl_assert_data_4.pred_txt = "\\result == 0";
      __gen_e_acsl_assert_data_4.file = "FRAMAC_SHARE/libc/stdlib.h";
      __gen_e_acsl_assert_data_4.fct = "posix_memalign";
      __gen_e_acsl_assert_data_4.line = 715;
      __gen_e_acsl_assert_data_4.name = "allocation/result_zero";
      __e_acsl_assert(__retres == 0,& __gen_e_acsl_assert_data_4);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_4);
    }
    __gen_e_acsl_assumes_value = __e_acsl_contract_get_behavior_assumes
    ((__e_acsl_contract_t const *)__gen_e_acsl_contract,1UL);
    if (__gen_e_acsl_assumes_value) {
      int __gen_e_acsl_or;
      __e_acsl_assert_data_t __gen_e_acsl_assert_data_5 =
        {.values = (void *)0};
      __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,"\\result",0,
                                   __retres);
      if (__retres < 0) __gen_e_acsl_or = 1;
      else {
        __e_acsl_assert_register_int(& __gen_e_acsl_assert_data_5,"\\result",
                                     0,__retres);
        __gen_e_acsl_or = __retres > 0;
      }
      __gen_e_acsl_assert_data_5.blocking = 1;
      __gen_e_acsl_assert_data_5.kind = "Postcondition";
      __gen_e_acsl_assert_data_5.pred_txt = "\\result < 0 || \\result > 0";
      __gen_e_acsl_assert_data_5.file = "FRAMAC_SHARE/libc/stdlib.h";
      __gen_e_acsl_assert_data_5.fct = "posix_memalign";
      __gen_e_acsl_assert_data_5.line = 720;
      __gen_e_acsl_assert_data_5.name = "no_allocation/result_non_zero";
      __e_acsl_assert(__gen_e_acsl_or,& __gen_e_acsl_assert_data_5);
      __e_acsl_assert_clean(& __gen_e_acsl_assert_data_5);
    }
    __e_acsl_contract_clean(__gen_e_acsl_contract);
    __e_acsl_delete_block((void *)(& memptr));
    return __retres;
  }
}


