# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
sys.path.insert(0, os.path.abspath('_ext'))

# -- Project information -----------------------------------------------------
# The full version, including alpha/beta/rc tags
PACKAGE_VERSION = os.environ.get('PACKAGE_VERSION', '0.0.0')
PACKAGE_NAME = os.environ.get('PACKAGE_NAME', 'FriCAS')
PACKAGE_TARNAME = os.environ.get('PACKAGE_TARNAME', PACKAGE_NAME.lower())
PACKAGE_BUGREPORT = os.environ.get('PACKAGE_BUGREPORT',
                                   'fricas-devel@googlegroups.com')

# The official place of the documentation.
PACKAGE_URL = os.environ.get('PACKAGE_URL', 'https://fricas.github.io')
FRICAS_URL = PACKAGE_URL

# Place of the official code repository.
# It should be possible to clone the repository from this URL.
PACKAGE_SOURCE = os.environ.get('PACKAGE_SOURCE',
                                'https://github.com/fricas/fricas')

# Adding the path to a file to PACKAGE_SOURCE_VIEW should give a URL to
# show the respective source file.
PACKAGE_SOURCE_VIEW = os.environ.get(
    'PACKAGE_SOURCE_VIEW',  PACKAGE_SOURCE + '/blob/master')

# Adding the path to a file to PACKAGE_SOURCE_VIEW should give a URL to
# edit the respective source file.
PACKAGE_SOURCE_EDIT = os.environ.get(
    'PACKAGE_SOURCE_EDIT', PACKAGE_SOURCE + '/edit/master')

PACKAGE_BOOK = os.environ.get('PACKAGE_BOOK', FRICAS_URL + '/book.pdf')

###################################################################
copyright = '2007-2020, FriCAS Team'
author = 'FriCAS Team'
project = PACKAGE_TARNAME
release = PACKAGE_VERSION

# Add "Edit on github link".
# See https://gist.github.com/mgedmin/6052926
# Put here a template such that
# show_on_github_url.format(path=path_to_rst_file)
# gives the actual url to show the file in the browser and
# edit_on_github_url.format(path=path_to_rst_file)
# gives the actual url to edit the file.
show_on_github_url = os.environ.get(
    'SHOW_ON_GITHUB_URL', PACKAGE_SOURCE_VIEW + 'src/doc/sphinx/source/{path}')
edit_on_github_url = os.environ.get(
    'EDIT_ON_GITHUB_URL', PACKAGE_SOURCE_EDIT + 'src/doc/sphinx/source/{path}')
###################################################################

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.mathjax',
    'sphinx.ext.extlinks',
      # allow extlinks variable (short links) below
    'edit_on_github',
      # _ext/edit_on_github.py is for direct editing of .rst sources
]

# This is used to refer to .spad source files.
# %s will be substituted by filename and line number looking like this:
# "aggcat#L1675", i.e. the String that appears in the .rst file as
# :viewcode:`aggcat#L1675`.
# Such references are generated by api.spad.
extlinks = {'viewsource':(PACKAGE_SOURCE_VIEW + '/%s', ''),
            'viewcode':(PACKAGE_SOURCE_VIEW + '/src/algebra/%s', ''),
            'editcode':(PACKAGE_SOURCE_EDIT + '/src/algebra/%s', ''),
            'fricasapi':(FRICAS_URL + '/api/%s', '')
           }

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The master toctree document.
master_doc = 'index'

# -- Options for HTML output -------------------------------------------------

highlight_language = 'none'

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'fricas-theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
#  "stickysidebar": "True",
#  "externalrefs": "True",
#  "relbarbgcolor": "green",
}

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ['_theme']

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = PACKAGE_NAME

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}
html_sidebars = {
   '**': ['globaltoc.html', 'sourcelink.html', 'searchbox.html'],
}

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

# -- Private FriCAS additions --------------------------------------------
rst_prolog = """
.. role:: spadop
.. role:: spadfun
.. role:: spadtype
"""

rst_epilog = """
.. |PACKAGE_VERSION| replace:: %s
.. |PACKAGE_TARNAME| replace:: %s
.. |PACKAGE_NAME| replace:: %s
.. |FriCAS| replace:: `%s`_
.. _%s: %s/index.html
.. |PACKAGE_BUGREPORT| replace:: %s
.. |PACKAGE_URL| replace:: %s/index.html
.. |PACKAGE_SOURCE| replace:: %s
.. |PACKAGE_BOOK| replace:: `%s Book`_
.. _%s Book: %s

.. |mailing list| replace:: `%s mailing list`_
.. _%s mailing list: https://groups.google.com/forum/#!forum/fricas-devel
.. |git repository| replace:: `%s git repository`_
.. _%s git repository: %s
.. |home page| replace:: `%s home page`_
.. _%s home page: %s/index.html
""" % (PACKAGE_VERSION,
       PACKAGE_TARNAME,
       PACKAGE_NAME,
       PACKAGE_NAME, PACKAGE_NAME, PACKAGE_URL,
       PACKAGE_BUGREPORT,
       PACKAGE_URL,
       PACKAGE_SOURCE,
       PACKAGE_NAME, PACKAGE_NAME, PACKAGE_BOOK,

       PACKAGE_NAME, PACKAGE_NAME,
       PACKAGE_NAME, PACKAGE_NAME, PACKAGE_SOURCE,
       PACKAGE_NAME, PACKAGE_NAME, PACKAGE_URL)

rst_epilog = rst_epilog + """
.. _SPAD: http://fricas-wiki.math.uni.wroc.pl/ProgrammingSPAD
"""

print('=== PACKAGE_NAME:        ' + PACKAGE_NAME)
print('=== PACKAGE_TARNAME:     ' + PACKAGE_TARNAME)
print('=== PACKAGE_VERSION:     ' + PACKAGE_VERSION)
print('=== PACKAGE_BUGREPORT:   ' + PACKAGE_BUGREPORT)
print('=== PACKAGE_URL:         ' + PACKAGE_URL)
print('=== PACKAGE_SOURCE:      ' + PACKAGE_SOURCE)
print('=== PACKAGE_SOURCE_VIEW: ' + PACKAGE_SOURCE_VIEW)
print('=== PACKAGE_SOURCE_EDIT: ' + PACKAGE_SOURCE_EDIT)
print('=== FRICAS_URL:          ' + FRICAS_URL)
print('=== PACKAGE_BOOK:        ' + PACKAGE_BOOK)
print('=== edit_on_github_url:  ' + edit_on_github_url)
print('=== show_on_github_url:  ' + show_on_github_url)
print('=== rst_epi ===' + rst_epilog)
