/* SPDX-License-Identifier: GPL-2.0-or-later */
/**
  ******************************************************************************
  * @file  ezGPIO_fullMux_ctrl_macro.h
  * @author  StarFive Technology
  * @version  V1.0
  * @date  07/22/2020
  * @brief
  ******************************************************************************
  * @copy
  *
  * THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STARFIVE SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  *  COPYRIGHT 2020 Shanghai StarFive Technology Co., Ltd.
  */


#ifndef _EZGPIO_FULLMUX_MACRO_H_
#define _EZGPIO_FULLMUX_MACRO_H_

//#define EZGPIO_FULLMUX_BASE_ADDR 0x0
#define gpioen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x0
#define gpio_0_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x50
#define gpio_0_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x54
#define gpio_1_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x58
#define gpio_1_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x5C
#define gpio_2_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x60
#define gpio_2_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x64
#define gpio_3_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x68
#define gpio_3_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x6C
#define gpio_4_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x70
#define gpio_4_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x74
#define gpio_5_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x78
#define gpio_5_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x7C
#define gpio_6_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x80
#define gpio_6_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x84
#define gpio_7_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x88
#define gpio_7_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x8C
#define gpio_8_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x90
#define gpio_8_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x94
#define gpio_9_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x98
#define gpio_9_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x9C
#define gpio_10_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xA0
#define gpio_10_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xA4
#define gpio_11_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xA8
#define gpio_11_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xAC
#define gpio_12_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xB0
#define gpio_12_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xB4
#define gpio_13_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xB8
#define gpio_13_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xBC
#define gpio_14_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xC0
#define gpio_14_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xC4
#define gpio_15_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xC8
#define gpio_15_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xCC
#define gpio_16_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xD0
#define gpio_16_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xD4
#define gpio_17_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xD8
#define gpio_17_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xDC
#define gpio_18_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xE0
#define gpio_18_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xE4
#define gpio_19_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xE8
#define gpio_19_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xEC
#define gpio_20_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xF0
#define gpio_20_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xF4
#define gpio_21_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xF8
#define gpio_21_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0xFC
#define gpio_22_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x100
#define gpio_22_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x104
#define gpio_23_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x108
#define gpio_23_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x10C
#define gpio_24_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x110
#define gpio_24_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x114
#define gpio_25_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x118
#define gpio_25_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x11C
#define gpio_26_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x120
#define gpio_26_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x124
#define gpio_27_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x128
#define gpio_27_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x12C
#define gpio_28_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x130
#define gpio_28_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x134
#define gpio_29_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x138
#define gpio_29_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x13C
#define gpio_30_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x140
#define gpio_30_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x144
#define gpio_31_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x148
#define gpio_31_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x14C
#define gpio_32_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x150
#define gpio_32_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x154
#define gpio_33_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x158
#define gpio_33_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x15C
#define gpio_34_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x160
#define gpio_34_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x164
#define gpio_35_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x168
#define gpio_35_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x16C
#define gpio_36_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x170
#define gpio_36_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x174
#define gpio_37_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x178
#define gpio_37_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x17C
#define gpio_38_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x180
#define gpio_38_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x184
#define gpio_39_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x188
#define gpio_39_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x18C
#define gpio_40_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x190
#define gpio_40_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x194
#define gpio_41_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x198
#define gpio_41_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x19C
#define gpio_42_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1A0
#define gpio_42_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1A4
#define gpio_43_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1A8
#define gpio_43_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1AC
#define gpio_44_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1B0
#define gpio_44_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1B4
#define gpio_45_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1B8
#define gpio_45_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1BC
#define gpio_46_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1C0
#define gpio_46_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1C4
#define gpio_47_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1C8
#define gpio_47_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1CC
#define gpio_48_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1D0
#define gpio_48_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1D4
#define gpio_49_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1D8
#define gpio_49_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1DC
#define gpio_50_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1E0
#define gpio_50_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1E4
#define gpio_51_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1E8
#define gpio_51_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1EC
#define gpio_52_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1F0
#define gpio_52_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1F4
#define gpio_53_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1F8
#define gpio_53_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x1FC
#define gpio_54_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x200
#define gpio_54_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x204
#define gpio_55_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x208
#define gpio_55_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x20C
#define gpio_56_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x210
#define gpio_56_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x214
#define gpio_57_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x218
#define gpio_57_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x21C
#define gpio_58_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x220
#define gpio_58_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x224
#define gpio_59_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x228
#define gpio_59_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x22C
#define gpio_60_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x230
#define gpio_60_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x234
#define gpio_61_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x238
#define gpio_61_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x23C
#define gpio_62_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x240
#define gpio_62_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x244
#define gpio_63_dout_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x248
#define gpio_63_doen_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x24C
#define gpio_cpu_jtag_tck_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x250
#define gpio_cpu_jtag_tdi_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x254
#define gpio_cpu_jtag_tms_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x258
#define gpio_cpu_jtag_trst_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x25C
#define gpio_dmic_sdin_bit0_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x260
#define gpio_dmic_sdin_bit1_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x264
#define gpio_dsp_JTCK_pad_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x268
#define gpio_dsp_JTDI_pad_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x26C
#define gpio_dsp_JTMS_pad_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x270
#define gpio_dsp_TRST_pad_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x274
#define gpio_i2c0_pad_sck_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x278
#define gpio_i2c0_pad_sda_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x27C
#define gpio_i2c1_pad_sck_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x280
#define gpio_i2c1_pad_sda_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x284
#define gpio_i2c2_pad_sck_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x288
#define gpio_i2c2_pad_sda_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x28C
#define gpio_i2c3_pad_sck_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x290
#define gpio_i2c3_pad_sda_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x294
#define gpio_i2srx_bclk_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x298
#define gpio_i2srx_lrck_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x29C
#define gpio_i2srx_sdin_bit0_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2A0
#define gpio_i2srx_sdin_bit1_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2A4
#define gpio_i2srx_sdin_bit2_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2A8
#define gpio_i2stx_bclk_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2AC
#define gpio_i2stx_lrck_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2B0
#define gpio_sdio0_pad_card_detect_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2B4
#define gpio_sdio0_pad_card_write_prt_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2B8
#define gpio_sdio0_pad_ccmd_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2BC
#define gpio_sdio0_pad_cdata_in_bit0_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2C0
#define gpio_sdio0_pad_cdata_in_bit1_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2C4
#define gpio_sdio0_pad_cdata_in_bit2_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2C8
#define gpio_sdio0_pad_cdata_in_bit3_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2CC
#define gpio_sdio0_pad_cdata_in_bit4_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2D0
#define gpio_sdio0_pad_cdata_in_bit5_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2D4
#define gpio_sdio0_pad_cdata_in_bit6_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2D8
#define gpio_sdio0_pad_cdata_in_bit7_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2DC
#define gpio_sdio1_pad_card_detect_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2E0
#define gpio_sdio1_pad_card_write_prt_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2E4
#define gpio_sdio1_pad_ccmd_in_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2E8
#define gpio_sdio1_pad_cdata_in_bit0_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2EC
#define gpio_sdio1_pad_cdata_in_bit1_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2F0
#define gpio_sdio1_pad_cdata_in_bit2_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2F4
#define gpio_sdio1_pad_cdata_in_bit3_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2F8
#define gpio_sdio1_pad_cdata_in_bit4_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x2FC
#define gpio_sdio1_pad_cdata_in_bit5_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x300
#define gpio_sdio1_pad_cdata_in_bit6_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x304
#define gpio_sdio1_pad_cdata_in_bit7_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x308
#define gpio_spdif_rx_sdin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x30C
#define gpio_spi0_pad_rxd_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x310
#define gpio_spi0_pad_ss_in_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x314
#define gpio_spi1_pad_rxd_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x318
#define gpio_spi1_pad_ss_in_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x31C
#define gpio_spi2_pad_rxd_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x320
#define gpio_spi2_pad_ss_in_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x324
#define gpio_spi2ahb_pad_rxd_bit0_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x328
#define gpio_spi2ahb_pad_rxd_bit1_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x32C
#define gpio_spi2ahb_pad_rxd_bit2_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x330
#define gpio_spi2ahb_pad_rxd_bit3_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x334
#define gpio_spi2ahb_pad_ss_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x338
#define gpio_spi2ahb_slv_sclkin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x33C
#define gpio_spi3_pad_rxd_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x340
#define gpio_spi3_pad_ss_in_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x344
#define gpio_uart0_pad_ctsn_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x348
#define gpio_uart0_pad_dcdn_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x34C
#define gpio_uart0_pad_dsrn_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x350
#define gpio_uart0_pad_rin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x354
#define gpio_uart0_pad_sin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x358
#define gpio_uart1_pad_sin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x35C
#define gpio_uart2_pad_cts_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x360
#define gpio_uart2_pad_dcd_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x364
#define gpio_uart2_pad_dsr_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x368
#define gpio_uart2_pad_ri_n_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x36C
#define gpio_uart2_pad_sin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x370
#define gpio_uart3_pad_sin_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x374
#define gpio_usb_over_current_REG_ADDR  EZGPIO_FULLMUX_BASE_ADDR + 0x378
#define SET_GPIO_EN { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpioen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1); \
	_ezchip_macro_read_value_ |= (0x1&0x1); \
	MA_OUTW(gpioen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_0_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_0_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_0_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_0_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_1_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_1_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_1_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_1_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_2_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_2_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_2_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_2_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_3_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_3_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_3_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_3_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_4_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_4_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_4_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_4_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_5_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_5_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_5_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_5_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_6_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_6_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_6_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_6_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_7_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_7_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_7_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_7_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_8_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_8_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_8_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_8_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_9_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_9_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_9_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_9_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_10_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_10_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_10_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_10_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_11_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_11_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_11_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_11_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_12_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_12_doen_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_12_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_12_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x51&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x52&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x53&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x54&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x55&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x56&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x57&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x58&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x59&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_sdio1_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spdif_tx_sdout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spdif_tx_sdout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x60&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi0_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x61&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi0_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x62&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi0_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x63&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi0_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x64&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi0_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x65&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi1_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x66&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi1_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x67&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi1_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x68&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi1_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x69&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi1_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x70&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x71&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x72&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x73&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_txd_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x74&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_txd_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x75&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_txd_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x76&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi2ahb_pad_txd_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x77&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi3_pad_oe_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x78&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi3_pad_sck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x79&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi3_pad_ss_0_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7A&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi3_pad_ss_1_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7B&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_spi3_pad_txd { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7C&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart0_pad_dtrn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7D&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart0_pad_rtsn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7E&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart0_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7F&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart1_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x80&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart2_pad_dtr_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x81&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart2_pad_rts_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x82&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart2_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x83&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_uart3_pad_sout { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x84&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_dout_usb_drv_bus { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_dout_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x85&0xFF); \
	MA_OUTW(gpio_13_dout_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_reverse_(en) { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0x1<<31); \
	_ezchip_macro_read_value_ |= (en&0x1)<<31; \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_LOW { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x0&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_HIGH { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_clk_gmac_tophyref { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_cpu_jtag_tdo { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_cpu_jtag_tdo_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_dmic_clk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x5&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_dsp_JTDOEn_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x6&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_dsp_JTDO_pad { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x7&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c0_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x8&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c0_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x9&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c1_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xA&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c1_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xB&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c2_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xC&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c2_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xD&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c3_pad_sck_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xE&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2c3_pad_sda_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0xF&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2srx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x10&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2srx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x11&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2srx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x12&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2srx_lrck_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x13&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2srx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x14&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_bclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x15&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_bclk_out_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x16&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_lrck_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x17&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_lrckout_oen { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x18&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_mclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x19&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_sdout0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1A&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_i2stx_sdout1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1B&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_lcd_pad_csm_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1C&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1D&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1E&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x1F&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x20&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x21&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x22&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x23&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_oe_n_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x24&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x25&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x26&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x27&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x28&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x29&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2A&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2B&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwm_pad_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2C&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwmdac_left_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2D&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_pwmdac_right_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2E&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_qspi_csn1_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x2F&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_qspi_csn2_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x30&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_qspi_csn3_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x31&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_register23_SCFG_cmsensor_rst0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x32&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_register23_SCFG_cmsensor_rst1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x33&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_register32_SCFG_gmac_phy_rstn { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x34&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x35&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x36&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x37&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x38&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x39&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3A&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3B&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3C&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3D&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3E&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x3F&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_oe_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x40&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x41&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x42&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x43&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit3 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x44&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit4 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x45&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit5 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x46&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit6 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x47&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_cdata_out_bit7 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x48&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio0_pad_rst_n { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x49&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_card_power_en { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4A&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_cclk_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4B&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_ccmd_oe { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4C&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_ccmd_out { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4D&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_cdata_oe_bit0 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4E&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_cdata_oe_bit1 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x4F&0xFF); \
	MA_OUTW(gpio_13_doen_REG_ADDR,_ezchip_macro_read_value_); \
}

#define SET_GPIO_13_doen_sdio1_pad_cdata_oe_bit2 { \
	uint32_t _ezchip_macro_read_value_=MA_INW(gpio_13_doen_REG_ADDR); \
	_ezchip_macro_read_value_ &= ~(0xFF); \
	_ezchip_macro_read_value_ |= (0x50&0xFF); \
