/*
 *		Copyright (C) 2013-2015, 2019 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify
 *		it under the terms of version 3 of the GNU Lesser General Public
 *		License (LGPLv3) as published by the Free Software Foundation.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *		GNU (Lesser) General Public License for more details.
 *
 *		You should have received a copy of the GNU (Lesser) General Public
 *		License along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef KONCLUDE_PARSER_CBUILDEXPRESSION_H
#define KONCLUDE_PARSER_CBUILDEXPRESSION_H


// Libraries includes


// Namespace includes
#include "ExpressionSettings.h"
#include "CExpressionHashMixer.h"
#include "CSubExpressionVisitor.h"

// Other includes


// Logger includes
#include "Logger/CLogger.h"

using namespace Konclude::Logger;


namespace Konclude {

	namespace Parser {

		namespace Expression {

			/*! 
			 *	\class		CBuildExpression
			 *	\author		Andreas Steigmiller
			 *	\version	0.1
			 *	\brief		TODO
			 */
			class CBuildExpression {
				// public methods
				public:
					//! Constructor
					CBuildExpression();

					enum ExpressionType {	BETCLASS, BETOBJECTPROPERTY, BETCLASSVARIABLE, BETOBJECTPROPERTYVARIABLE, BETDATAPROPERTYVARIABLE,
						
											BETEQUIVALENTCLASSES, BETESUBCLASSOF, BETDISJOINTUNION, BETDISJOINTCLASSES,

											BETOBJECTSOMEVALUEFROM, BETOBJECTINTERSECTION, BETOBJECTALLVALUEFROM, BETOBJECTEXACTLYCARDINALITY, BETOBJECTHASSELF,
											BETOBJECTMINCARDINALITY, BETOBJECTMAXCARDINALITY, BETOBJECTCOMPLEMENTOF, BETOBJECTUNION, BETOBJECTONEOF, BETOBJECTHASVALUE,

											BETSUBOBJECTPROPERTYOF, BETTRANSETIVEPROPERTYOF, BETINVERSEOBJECTPROPERTYOF, BETFUNCTIONALPROPERTYOF,
											BETOBJECTPROPERTYDOMAIN, BETOBJECTPROPERTYRANGE, BETFUNCTIONALOBJECTPROPERTY, BETTRANSITIVEOBJECTPROPERTY, 
											BETINVERSEOBJECTPROPERTIES, BETEQUIVALENTOBJECTPROPERTIES, BETSYMMETRICPROPERTY, BETASYMMETRICPROPERTY, 
											BETREFLEXIVEPROPERTY, BETIRREFLEXIVEPROPERTY, BETOBJECTPROPERTYCHAIN, BETDISJOINTOBJECTPROPERTIES, BETINVERSEFUNCTIONALPROPERTY,

											BETCLASSASSERTION, BETOBJECTPROPERTYASSERTION, BETSAMEINDIVIDUAL, BETDIFFERENTINDIVIDUAL, BETNEGATIVEOBJECTPROPERTYASSERTION,
											
											BETNAMEDINDIVIDUAL, BETANONYMOUSINDIVIDUAL, BETNOMINALINDIVIDUALVARIABLE, BETANONYMOUSINDIVIDUALVARIABLE, BETNAMEDINDIVIDUALVARIABLE,

											BETISCLASSSATISFIABLE, BETARECLASSESEQUIVALENCE, BETISCLASSSUBSUMTIONBY, BETARECLASSESDISJOINT, BETISINSTANCEOF, 
											BETPRECEDENTCLASSBUILD, BETPRECEDENTPROPERTYBUILD, BETPRECEDENTINDIVIDUALBUILD, BETGETFLATTENEDTYPES, BETGETFLATTENEDINDIVIDUALS,
											BETGETINDIVIDUALS, BETGETTYPES, BETGETSUBCLASSES, BETGETSUPERCLASSES, BETGETEQUIVALENTCLASSES, BETISENTAILED,
											BETGETOBJECTPROPERTYTARGETS, BETGETFLATTENEDOBJECTPROPERTYTARGETS, BETGETSAMEINDIVIDUALS,
											BETGETDETERMINISTICCLASSASSERTIONS, BETGETNONDETERMINISTICCLASSASSERTIONS, BETGETNONDETERMINISTICINDIVIDUALS, BETGETDETERMINISTICINDIVIDUALS,
											BETGETEQUIVALENTOBJECTPROPERTIES, BETGETSUBOBJECTPROPERTIES, BETGETSUPEROBJECTPROPERTIES,
											BETGETEQUIVALENTDATAPROPERTIES, BETGETSUBDATAPROPERTIES, BETGETSUPERDATAPROPERTIES, BETISOBJECTPROPERTYSATISFIABLE,
											BETGETSUBCLASSHIERARCHY, BETGETSUBOBJECTPROPERTYHIERARCHY, BETGETSUBDATAPROPERTYHIERARCHY, BETISDATAPROPERTYSATISFIABLE,
											BETGETOBJECTPROPERTYSOURCES, BETGETFLATTENEDOBJECTPROPERTYSOURCES, BETGETOBJECTPROPERTIESOFSOURCE, BETGETOBJECTPROPERTIESOFTARGET, BETGETOBJECTPROPERTIESBETWEEN,
											BETSPARQLSELECTBASICGRAPHPATTERN, BETSPARQLASKBASICGRAPHPATTERN,


											BETDATATYPE, BETDATALEXICALVALUE, BETDATALITERAL, BETDATAPROPERTY, BETDATAINTERSECTIONOF, 
											BETDATAUNIONOF, BETDATACOMPLEMENTOF, BETDATAONEOF, BETDATAFACETIRI, BETDATAFACETRESTRICION, BETDATATYPERESTRICTION, 
											BETDATAVALUEVARIABLE, BETDATALITERALVARIABLE,
											
											BETDATASOMEVALUEFROM, BETDATAHASVALUE, BETDATAALLVALUEFROM, BETDATAMINCARDINALITY, BETDATAMAXCARDINALITY, BETDATAEXACTCARDINALITY,

											BETDATAPROPERTYDOMAIN, BETDATAPROPERTYRANGE, BETSUBDATAPROPERTYOF, BETDISJOINTDATAPROPERTIES, BETEQUIVALENTDATAPROPERTIES,
											BETFUNCTIONALDATAPROPERTY, BETDATAPROPERTYASSERTION, BETNEGATIVEDATAPROPERTYASSERTION,
											
											BETDECLARATION, 

											BETRULECLASSATOM, BETRULEPROPERTYATOM, BETRULEDIFFERENTINDIVIDUALSATOM, BETRULEATOMBODYLIST, BETRULEATOMHEADLIST,


											BETORDERINGVARIABLE,
											BETFILTERINGCOMPARISONDATALITERAL,


											BET_QUERYING_TEMPORARY_INVERSE_OBJECT_PROPERTY_OF,
											BET_QUERYING_TEMPORARY_NAMED_INDIVIDUAL


										};

					virtual ExpressionType getType() = 0;

					virtual cint64 getStructuralHashValue() = 0;
					virtual bool compareStructuralEquivalence(CBuildExpression* compareExpression) = 0;


					virtual bool visitSubExpressions(CSubExpressionVisitor* subExpressionVisitor);


				// protected methods
				protected:

				// private methods
				private:
			};

		}; // end namespace Expression

	}; // end namespace Parser

}; // end namespace Konclude

#endif // KONCLUDE_PARSER_CBUILDEXPRESSION_H
