/***************************************************************************
    begin       : Tue Dec 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef CHIPCARD_CHIPCARD_H
#define CHIPCARD_CHIPCARD_H

#define CHIPCARD_SYS_IS_WINDOWS 0


#ifdef LCC_IS_SUBPROJECT
# define CHIPCARD_API
# define CHIPCARD_EXPORT
# define CHIPCARD_NOEXPORT
#else
# ifdef BUILDING_CHIPCARD
   /* building Gwenhywfar */
#  if CHIPCARD_SYS_IS_WINDOWS
     /* for windows */
#    ifdef __declspec
#      define CHIPCARD_API __declspec (dllexport)
#    else /* if __declspec */
#      define CHIPCARD_API
#    endif /* if NOT __declspec */
#  else
     /* for non-win32 */
#    ifdef GCC_WITH_VISIBILITY_ATTRIBUTE
#      define CHIPCARD_API __attribute__((visibility("default")))
#    else
#      define CHIPCARD_API
#    endif
#  endif
# else
   /* not building Gwenhywfar */
#  if CHIPCARD_SYS_IS_WINDOWS
     /* for windows */
#    ifdef __declspec
#      define CHIPCARD_API __declspec (dllimport)
#    else /* if __declspec */
#      define CHIPCARD_API
#    endif /* if NOT __declspec */
#  else
     /* for non-win32 */
#    define CHIPCARD_API
#  endif
# endif

# ifdef GCC_WITH_VISIBILITY_ATTRIBUTE
#  define CHIPCARD_EXPORT __attribute__((visibility("default")))
#  define CHIPCARD_NOEXPORT __attribute__((visibility("hidden")))
# else
#  define CHIPCARD_EXPORT
#  define CHIPCARD_NOEXPORT
# endif
#endif


#if CHIPCARD_SYS_IS_WINDOWS
# define CHIPCARD_CB __stdcall
#else
# define CHIPCARD_CB
#endif


#ifndef CHIPCARD_NOWARN_DEPRECATED
# ifdef __GNUC__
#  define CHIPCARD_DEPRECATED __attribute((__deprecated__))
# else
#  define CHIPCARD_DEPRECATED
# endif
# else
#  define CHIPCARD_DEPRECATED
#endif

#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

#include <inttypes.h>


#define LC_LOGDOMAIN "libchipcard"


/** Reader flags */
/*@{*/
#define LC_READER_FLAGS_KEYPAD             0x00010000
#define LC_READER_FLAGS_LOW_WRITE_BOUNDARY 0x00020000
/*@}*/

CHIPCARD_API uint32_t LC_ReaderFlags_fromXml(GWEN_XMLNODE *node, const char *name);
CHIPCARD_API uint32_t LC_ReaderFlags_fromDb(GWEN_DB_NODE *db, const char *name);
CHIPCARD_API void LC_ReaderFlags_toDb(GWEN_DB_NODE *db, const char *name, uint32_t fl);



#endif /* CHIPCARD_CHIPCARD_H */
