/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.GenericURLContext;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class rmiURLContext
extends GenericURLContext {
    public rmiURLContext() {
        super(null);
    }

    public rmiURLContext(Hashtable<?, ?> environment) {
        super(environment);
    }

    @Override
    protected ResolveResult getRootURLContext(String url, Hashtable<?, ?> environment) throws NamingException {
        if (!url.startsWith("rmi:")) {
            throw new IllegalArgumentException(Messages.getString("jndi.74", url));
        }
        int length = url.length();
        int start = "rmi:".length();
        String hostName = null;
        int port = 0;
        if (start < length && url.charAt(start) == '/' && ++start < length && url.charAt(start) == '/') {
            int portStart;
            int hostEnd;
            int end;
            if ((end = url.indexOf(47, ++start)) < 0) {
                end = length;
            }
            if ((hostEnd = url.indexOf(58, start)) < 0 || hostEnd > end) {
                hostEnd = end;
            }
            if (start < hostEnd) {
                hostName = url.substring(start, hostEnd);
            }
            if ((portStart = hostEnd + 1) < end) {
                try {
                    port = Integer.parseInt(url.substring(portStart, end));
                }
                catch (NumberFormatException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException(Messages.getString("jndi.75", url)).initCause(e);
                }
            }
            start = end < length ? end + 1 : length;
        }
        CompositeName name = new CompositeName();
        if (start < length) {
            name.add(url.substring(start));
        }
        return new ResolveResult((Object)new RegistryContext(hostName, port, environment), name);
    }
}

