// kalynatab.cpp - written and placed in the public domain by Jeffrey Walton

#include "pch.h"
#include "config.h"
#include "kalyna.h"

NAMESPACE_BEGIN(CryptoPP)
NAMESPACE_BEGIN(KalynaTab)

extern const word64 T[8][256];  // Columns
extern const word64 IT[8][256]; // Inverse
extern const byte S[4][256];    // Substitution
extern const byte IS[4][256];   // Inverse

const word64 T[8][256] =
{
    {
        W64LIT(0xa832a829d77f9aa8), W64LIT(0x4352432297d41143), W64LIT(0x5f3e5fc2df80615f), W64LIT(0x061e063014121806),
        W64LIT(0x6bda6b7f670cb16b), W64LIT(0x75bc758f2356c975), W64LIT(0x6cc16c477519ad6c), W64LIT(0x592059f2cb927959),
        W64LIT(0x71a871af3b4ad971), W64LIT(0xdf84dfb6f8275bdf), W64LIT(0x87a1874c35b22687), W64LIT(0x95fb95dc59cc6e95),
        W64LIT(0x174b17b872655c17), W64LIT(0xf017f0d31aeae7f0), W64LIT(0xd89fd88eea3247d8), W64LIT(0x092d0948363f2409),
        W64LIT(0x6dc46d4f731ea96d), W64LIT(0xf318f3cb10e3ebf3), W64LIT(0x1d691de84e53741d), W64LIT(0xcbc0cb16804b0bcb),
        W64LIT(0xc9cac9068c4503c9), W64LIT(0x4d644d52b3fe294d), W64LIT(0x2c9c2c7de8c4b02c), W64LIT(0xaf29af11c56a86af),
        W64LIT(0x798079ef0b72f979), W64LIT(0xe047e0537a9aa7e0), W64LIT(0x97f197cc55c26697), W64LIT(0xfd2efdbb34c9d3fd),
        W64LIT(0x6fce6f5f7f10a16f), W64LIT(0x4b7a4b62a7ec314b), W64LIT(0x454c451283c60945), W64LIT(0x39dd39d596afe439),
        W64LIT(0x3ec63eed84baf83e), W64LIT(0xdd8edda6f42953dd), W64LIT(0xa315a371ed4eb6a3), W64LIT(0x4f6e4f42bff0214f),
        W64LIT(0xb45eb4c99f2beab4), W64LIT(0xb654b6d99325e2b6), W64LIT(0x9ac89aa47be1529a), W64LIT(0x0e360e70242a380e),
        W64LIT(0x1f631ff8425d7c1f), W64LIT(0xbf79bf91a51ac6bf), W64LIT(0x154115a87e6b5415), W64LIT(0xe142e15b7c9da3e1),
        W64LIT(0x49704972abe23949), W64LIT(0xd2bdd2ded6046fd2), W64LIT(0x93e593ec4dde7693), W64LIT(0xc6f9c67eae683fc6),
        W64LIT(0x92e092e44bd97292), W64LIT(0x72a772b73143d572), W64LIT(0x9edc9e8463fd429e), W64LIT(0x61f8612f5b3a9961),
        W64LIT(0xd1b2d1c6dc0d63d1), W64LIT(0x63f2633f57349163), W64LIT(0xfa35fa8326dccffa), W64LIT(0xee71ee235eb09fee),
        W64LIT(0xf403f4f302f6f7f4), W64LIT(0x197d19c8564f6419), W64LIT(0xd5a6d5e6c41173d5), W64LIT(0xad23ad01c9648ead),
        W64LIT(0x582558facd957d58), W64LIT(0xa40ea449ff5baaa4), W64LIT(0xbb6dbbb1bd06d6bb), W64LIT(0xa11fa161e140bea1),
        W64LIT(0xdc8bdcaef22e57dc), W64LIT(0xf21df2c316e4eff2), W64LIT(0x83b5836c2dae3683), W64LIT(0x37eb37a5b285dc37),
        W64LIT(0x4257422a91d31542), W64LIT(0xe453e4736286b7e4), W64LIT(0x7a8f7af7017bf57a), W64LIT(0x32fa328dac9ec832),
        W64LIT(0x9cd69c946ff34a9c), W64LIT(0xccdbcc2e925e17cc), W64LIT(0xab3dab31dd7696ab), W64LIT(0x4a7f4a6aa1eb354a),
        W64LIT(0x8f898f0c058a068f), W64LIT(0x6ecb6e577917a56e), W64LIT(0x04140420181c1004), W64LIT(0x27bb2725d2f59c27),
        W64LIT(0x2e962e6de4cab82e), W64LIT(0xe75ce76b688fbbe7), W64LIT(0xe24de2437694afe2), W64LIT(0x5a2f5aeac19b755a),
        W64LIT(0x96f496c453c56296), W64LIT(0x164e16b074625816), W64LIT(0x23af2305cae98c23), W64LIT(0x2b872b45fad1ac2b),
        W64LIT(0xc2edc25eb6742fc2), W64LIT(0x65ec650f43268965), W64LIT(0x66e36617492f8566), W64LIT(0x0f330f78222d3c0f),
        W64LIT(0xbc76bc89af13cabc), W64LIT(0xa937a921d1789ea9), W64LIT(0x474647028fc80147), W64LIT(0x415841329bda1941),
        W64LIT(0x34e434bdb88cd034), W64LIT(0x4875487aade53d48), W64LIT(0xfc2bfcb332ced7fc), W64LIT(0xb751b7d19522e6b7),
        W64LIT(0x6adf6a77610bb56a), W64LIT(0x88928834179f1a88), W64LIT(0xa50ba541f95caea5), W64LIT(0x530253a2f7a45153),
        W64LIT(0x86a4864433b52286), W64LIT(0xf93af99b2cd5c3f9), W64LIT(0x5b2a5be2c79c715b), W64LIT(0xdb90db96e03b4bdb),
        W64LIT(0x38d838dd90a8e038), W64LIT(0x7b8a7bff077cf17b), W64LIT(0xc3e8c356b0732bc3), W64LIT(0x1e661ef0445a781e),
        W64LIT(0x22aa220dccee8822), W64LIT(0x33ff3385aa99cc33), W64LIT(0x24b4243dd8fc9024), W64LIT(0x2888285df0d8a028),
        W64LIT(0x36ee36adb482d836), W64LIT(0xc7fcc776a86f3bc7), W64LIT(0xb240b2f98b39f2b2), W64LIT(0x3bd73bc59aa1ec3b),
        W64LIT(0x8e8c8e04038d028e), W64LIT(0x77b6779f2f58c177), W64LIT(0xba68bab9bb01d2ba), W64LIT(0xf506f5fb04f1f3f5),
        W64LIT(0x144414a0786c5014), W64LIT(0x9fd99f8c65fa469f), W64LIT(0x0828084030382008), W64LIT(0x551c5592e3b64955),
        W64LIT(0x9bcd9bac7de6569b), W64LIT(0x4c614c5ab5f92d4c), W64LIT(0xfe21fea33ec0dffe), W64LIT(0x60fd60275d3d9d60),
        W64LIT(0x5c315cdad5896d5c), W64LIT(0xda95da9ee63c4fda), W64LIT(0x187818c050486018), W64LIT(0x4643460a89cf0546),
        W64LIT(0xcddecd26945913cd), W64LIT(0x7d947dcf136ee97d), W64LIT(0x21a52115c6e78421), W64LIT(0xb04ab0e98737fab0),
        W64LIT(0x3fc33fe582bdfc3f), W64LIT(0x1b771bd85a416c1b), W64LIT(0x8997893c11981e89), W64LIT(0xff24ffab38c7dbff),
        W64LIT(0xeb60eb0b40ab8beb), W64LIT(0x84ae84543fbb2a84), W64LIT(0x69d0696f6b02b969), W64LIT(0x3ad23acd9ca6e83a),
        W64LIT(0x9dd39d9c69f44e9d), W64LIT(0xd7acd7f6c81f7bd7), W64LIT(0xd3b8d3d6d0036bd3), W64LIT(0x70ad70a73d4ddd70),
        W64LIT(0x67e6671f4f288167), W64LIT(0x405d403a9ddd1d40), W64LIT(0xb55bb5c1992ceeb5), W64LIT(0xde81debefe205fde),
        W64LIT(0x5d345dd2d38e695d), W64LIT(0x30f0309da090c030), W64LIT(0x91ef91fc41d07e91), W64LIT(0xb14fb1e18130feb1),
        W64LIT(0x788578e70d75fd78), W64LIT(0x1155118866774411), W64LIT(0x0105010806070401), W64LIT(0xe556e57b6481b3e5),
        W64LIT(0x0000000000000000), W64LIT(0x68d568676d05bd68), W64LIT(0x98c298b477ef5a98), W64LIT(0xa01aa069e747baa0),
        W64LIT(0xc5f6c566a46133c5), W64LIT(0x020a02100c0e0802), W64LIT(0xa604a659f355a2a6), W64LIT(0x74b974872551cd74),
        W64LIT(0x2d992d75eec3b42d), W64LIT(0x0b270b583a312c0b), W64LIT(0xa210a279eb49b2a2), W64LIT(0x76b37697295fc576),
        W64LIT(0xb345b3f18d3ef6b3), W64LIT(0xbe7cbe99a31dc2be), W64LIT(0xced1ce3e9e501fce), W64LIT(0xbd73bd81a914cebd),
        W64LIT(0xae2cae19c36d82ae), W64LIT(0xe96ae91b4ca583e9), W64LIT(0x8a988a241b91128a), W64LIT(0x31f53195a697c431),
        W64LIT(0x1c6c1ce04854701c), W64LIT(0xec7bec3352be97ec), W64LIT(0xf112f1db1cede3f1), W64LIT(0x99c799bc71e85e99),
        W64LIT(0x94fe94d45fcb6a94), W64LIT(0xaa38aa39db7192aa), W64LIT(0xf609f6e30ef8fff6), W64LIT(0x26be262dd4f29826),
        W64LIT(0x2f932f65e2cdbc2f), W64LIT(0xef74ef2b58b79bef), W64LIT(0xe86fe8134aa287e8), W64LIT(0x8c868c140f830a8c),
        W64LIT(0x35e135b5be8bd435), W64LIT(0x030f03180a090c03), W64LIT(0xd4a3d4eec21677d4), W64LIT(0x7f9e7fdf1f60e17f),
        W64LIT(0xfb30fb8b20dbcbfb), W64LIT(0x051105281e1b1405), W64LIT(0xc1e2c146bc7d23c1), W64LIT(0x5e3b5ecad987655e),
        W64LIT(0x90ea90f447d77a90), W64LIT(0x20a0201dc0e08020), W64LIT(0x3dc93df58eb3f43d), W64LIT(0x82b082642ba93282),
        W64LIT(0xf70cf7eb08fffbf7), W64LIT(0xea65ea0346ac8fea), W64LIT(0x0a220a503c36280a), W64LIT(0x0d390d682e23340d),
        W64LIT(0x7e9b7ed71967e57e), W64LIT(0xf83ff8932ad2c7f8), W64LIT(0x500d50bafdad5d50), W64LIT(0x1a721ad05c46681a),
        W64LIT(0xc4f3c46ea26637c4), W64LIT(0x071b073812151c07), W64LIT(0x57165782efb84157), W64LIT(0xb862b8a9b70fdab8),
        W64LIT(0x3ccc3cfd88b4f03c), W64LIT(0x62f7623751339562), W64LIT(0xe348e34b7093abe3), W64LIT(0xc8cfc80e8a4207c8),
        W64LIT(0xac26ac09cf638aac), W64LIT(0x520752aaf1a35552), W64LIT(0x64e9640745218d64), W64LIT(0x1050108060704010),
        W64LIT(0xd0b7d0ceda0a67d0), W64LIT(0xd99ad986ec3543d9), W64LIT(0x135f13986a794c13), W64LIT(0x0c3c0c602824300c),
        W64LIT(0x125a12906c7e4812), W64LIT(0x298d2955f6dfa429), W64LIT(0x510851b2fbaa5951), W64LIT(0xb967b9a1b108deb9),
        W64LIT(0xcfd4cf3698571bcf), W64LIT(0xd6a9d6fece187fd6), W64LIT(0x73a273bf3744d173), W64LIT(0x8d838d1c09840e8d),
        W64LIT(0x81bf817c21a03e81), W64LIT(0x5419549ae5b14d54), W64LIT(0xc0e7c04eba7a27c0), W64LIT(0xed7eed3b54b993ed),
        W64LIT(0x4e6b4e4ab9f7254e), W64LIT(0x4449441a85c10d44), W64LIT(0xa701a751f552a6a7), W64LIT(0x2a822a4dfcd6a82a),
        W64LIT(0x85ab855c39bc2e85), W64LIT(0x25b12535defb9425), W64LIT(0xe659e6636e88bfe6), W64LIT(0xcac5ca1e864c0fca),
        W64LIT(0x7c917cc71569ed7c), W64LIT(0x8b9d8b2c1d96168b), W64LIT(0x5613568ae9bf4556), W64LIT(0x80ba807427a73a80)
    },
    {
        W64LIT(0xd1ce3e9e501fcece), W64LIT(0x6dbbb1bd06d6bbbb), W64LIT(0x60eb0b40ab8bebeb), W64LIT(0xe092e44bd9729292),
        W64LIT(0x65ea0346ac8feaea), W64LIT(0xc0cb16804b0bcbcb), W64LIT(0x5f13986a794c1313), W64LIT(0xe2c146bc7d23c1c1),
        W64LIT(0x6ae91b4ca583e9e9), W64LIT(0xd23acd9ca6e83a3a), W64LIT(0xa9d6fece187fd6d6), W64LIT(0x40b2f98b39f2b2b2),
        W64LIT(0xbdd2ded6046fd2d2), W64LIT(0xea90f447d77a9090), W64LIT(0x4b17b872655c1717), W64LIT(0x3ff8932ad2c7f8f8),
        W64LIT(0x57422a91d3154242), W64LIT(0x4115a87e6b541515), W64LIT(0x13568ae9bf455656), W64LIT(0x5eb4c99f2beab4b4),
        W64LIT(0xec650f4326896565), W64LIT(0x6c1ce04854701c1c), W64LIT(0x928834179f1a8888), W64LIT(0x52432297d4114343),
        W64LIT(0xf6c566a46133c5c5), W64LIT(0x315cdad5896d5c5c), W64LIT(0xee36adb482d83636), W64LIT(0x68bab9bb01d2baba),
        W64LIT(0x06f5fb04f1f3f5f5), W64LIT(0x165782efb8415757), W64LIT(0xe6671f4f28816767), W64LIT(0x838d1c09840e8d8d),
        W64LIT(0xf53195a697c43131), W64LIT(0x09f6e30ef8fff6f6), W64LIT(0xe9640745218d6464), W64LIT(0x2558facd957d5858),
        W64LIT(0xdc9e8463fd429e9e), W64LIT(0x03f4f302f6f7f4f4), W64LIT(0xaa220dccee882222), W64LIT(0x38aa39db7192aaaa),
        W64LIT(0xbc758f2356c97575), W64LIT(0x330f78222d3c0f0f), W64LIT(0x0a02100c0e080202), W64LIT(0x4fb1e18130feb1b1),
        W64LIT(0x84dfb6f8275bdfdf), W64LIT(0xc46d4f731ea96d6d), W64LIT(0xa273bf3744d17373), W64LIT(0x644d52b3fe294d4d),
        W64LIT(0x917cc71569ed7c7c), W64LIT(0xbe262dd4f2982626), W64LIT(0x962e6de4cab82e2e), W64LIT(0x0cf7eb08fffbf7f7),
        W64LIT(0x2808403038200808), W64LIT(0x345dd2d38e695d5d), W64LIT(0x49441a85c10d4444), W64LIT(0xc63eed84baf83e3e),
        W64LIT(0xd99f8c65fa469f9f), W64LIT(0x4414a0786c501414), W64LIT(0xcfc80e8a4207c8c8), W64LIT(0x2cae19c36d82aeae),
        W64LIT(0x19549ae5b14d5454), W64LIT(0x5010806070401010), W64LIT(0x9fd88eea3247d8d8), W64LIT(0x76bc89af13cabcbc),
        W64LIT(0x721ad05c46681a1a), W64LIT(0xda6b7f670cb16b6b), W64LIT(0xd0696f6b02b96969), W64LIT(0x18f3cb10e3ebf3f3),
        W64LIT(0x73bd81a914cebdbd), W64LIT(0xff3385aa99cc3333), W64LIT(0x3dab31dd7696abab), W64LIT(0x35fa8326dccffafa),
        W64LIT(0xb2d1c6dc0d63d1d1), W64LIT(0xcd9bac7de6569b9b), W64LIT(0xd568676d05bd6868), W64LIT(0x6b4e4ab9f7254e4e),
        W64LIT(0x4e16b07462581616), W64LIT(0xfb95dc59cc6e9595), W64LIT(0xef91fc41d07e9191), W64LIT(0x71ee235eb09feeee),
        W64LIT(0x614c5ab5f92d4c4c), W64LIT(0xf2633f5734916363), W64LIT(0x8c8e04038d028e8e), W64LIT(0x2a5be2c79c715b5b),
        W64LIT(0xdbcc2e925e17cccc), W64LIT(0xcc3cfd88b4f03c3c), W64LIT(0x7d19c8564f641919), W64LIT(0x1fa161e140bea1a1),
        W64LIT(0xbf817c21a03e8181), W64LIT(0x704972abe2394949), W64LIT(0x8a7bff077cf17b7b), W64LIT(0x9ad986ec3543d9d9),
        W64LIT(0xce6f5f7f10a16f6f), W64LIT(0xeb37a5b285dc3737), W64LIT(0xfd60275d3d9d6060), W64LIT(0xc5ca1e864c0fcaca),
        W64LIT(0x5ce76b688fbbe7e7), W64LIT(0x872b45fad1ac2b2b), W64LIT(0x75487aade53d4848), W64LIT(0x2efdbb34c9d3fdfd),
        W64LIT(0xf496c453c5629696), W64LIT(0x4c451283c6094545), W64LIT(0x2bfcb332ced7fcfc), W64LIT(0x5841329bda194141),
        W64LIT(0x5a12906c7e481212), W64LIT(0x390d682e23340d0d), W64LIT(0x8079ef0b72f97979), W64LIT(0x56e57b6481b3e5e5),
        W64LIT(0x97893c11981e8989), W64LIT(0x868c140f830a8c8c), W64LIT(0x48e34b7093abe3e3), W64LIT(0xa0201dc0e0802020),
        W64LIT(0xf0309da090c03030), W64LIT(0x8bdcaef22e57dcdc), W64LIT(0x51b7d19522e6b7b7), W64LIT(0xc16c477519ad6c6c),
        W64LIT(0x7f4a6aa1eb354a4a), W64LIT(0x5bb5c1992ceeb5b5), W64LIT(0xc33fe582bdfc3f3f), W64LIT(0xf197cc55c2669797),
        W64LIT(0xa3d4eec21677d4d4), W64LIT(0xf762375133956262), W64LIT(0x992d75eec3b42d2d), W64LIT(0x1e06301412180606),
        W64LIT(0x0ea449ff5baaa4a4), W64LIT(0x0ba541f95caea5a5), W64LIT(0xb5836c2dae368383), W64LIT(0x3e5fc2df80615f5f),
        W64LIT(0x822a4dfcd6a82a2a), W64LIT(0x95da9ee63c4fdada), W64LIT(0xcac9068c4503c9c9), W64LIT(0x0000000000000000),
        W64LIT(0x9b7ed71967e57e7e), W64LIT(0x10a279eb49b2a2a2), W64LIT(0x1c5592e3b6495555), W64LIT(0x79bf91a51ac6bfbf),
        W64LIT(0x5511886677441111), W64LIT(0xa6d5e6c41173d5d5), W64LIT(0xd69c946ff34a9c9c), W64LIT(0xd4cf3698571bcfcf),
        W64LIT(0x360e70242a380e0e), W64LIT(0x220a503c36280a0a), W64LIT(0xc93df58eb3f43d3d), W64LIT(0x0851b2fbaa595151),
        W64LIT(0x947dcf136ee97d7d), W64LIT(0xe593ec4dde769393), W64LIT(0x771bd85a416c1b1b), W64LIT(0x21fea33ec0dffefe),
        W64LIT(0xf3c46ea26637c4c4), W64LIT(0x4647028fc8014747), W64LIT(0x2d0948363f240909), W64LIT(0xa4864433b5228686),
        W64LIT(0x270b583a312c0b0b), W64LIT(0x898f0c058a068f8f), W64LIT(0xd39d9c69f44e9d9d), W64LIT(0xdf6a77610bb56a6a),
        W64LIT(0x1b073812151c0707), W64LIT(0x67b9a1b108deb9b9), W64LIT(0x4ab0e98737fab0b0), W64LIT(0xc298b477ef5a9898),
        W64LIT(0x7818c05048601818), W64LIT(0xfa328dac9ec83232), W64LIT(0xa871af3b4ad97171), W64LIT(0x7a4b62a7ec314b4b),
        W64LIT(0x74ef2b58b79befef), W64LIT(0xd73bc59aa1ec3b3b), W64LIT(0xad70a73d4ddd7070), W64LIT(0x1aa069e747baa0a0),
        W64LIT(0x53e4736286b7e4e4), W64LIT(0x5d403a9ddd1d4040), W64LIT(0x24ffab38c7dbffff), W64LIT(0xe8c356b0732bc3c3),
        W64LIT(0x37a921d1789ea9a9), W64LIT(0x59e6636e88bfe6e6), W64LIT(0x8578e70d75fd7878), W64LIT(0x3af99b2cd5c3f9f9),
        W64LIT(0x9d8b2c1d96168b8b), W64LIT(0x43460a89cf054646), W64LIT(0xba807427a73a8080), W64LIT(0x661ef0445a781e1e),
        W64LIT(0xd838dd90a8e03838), W64LIT(0x42e15b7c9da3e1e1), W64LIT(0x62b8a9b70fdab8b8), W64LIT(0x32a829d77f9aa8a8),
        W64LIT(0x47e0537a9aa7e0e0), W64LIT(0x3c0c602824300c0c), W64LIT(0xaf2305cae98c2323), W64LIT(0xb37697295fc57676),
        W64LIT(0x691de84e53741d1d), W64LIT(0xb12535defb942525), W64LIT(0xb4243dd8fc902424), W64LIT(0x1105281e1b140505),
        W64LIT(0x12f1db1cede3f1f1), W64LIT(0xcb6e577917a56e6e), W64LIT(0xfe94d45fcb6a9494), W64LIT(0x88285df0d8a02828),
        W64LIT(0xc89aa47be1529a9a), W64LIT(0xae84543fbb2a8484), W64LIT(0x6fe8134aa287e8e8), W64LIT(0x15a371ed4eb6a3a3),
        W64LIT(0x6e4f42bff0214f4f), W64LIT(0xb6779f2f58c17777), W64LIT(0xb8d3d6d0036bd3d3), W64LIT(0xab855c39bc2e8585),
        W64LIT(0x4de2437694afe2e2), W64LIT(0x0752aaf1a3555252), W64LIT(0x1df2c316e4eff2f2), W64LIT(0xb082642ba9328282),
        W64LIT(0x0d50bafdad5d5050), W64LIT(0x8f7af7017bf57a7a), W64LIT(0x932f65e2cdbc2f2f), W64LIT(0xb974872551cd7474),
        W64LIT(0x0253a2f7a4515353), W64LIT(0x45b3f18d3ef6b3b3), W64LIT(0xf8612f5b3a996161), W64LIT(0x29af11c56a86afaf),
        W64LIT(0xdd39d596afe43939), W64LIT(0xe135b5be8bd43535), W64LIT(0x81debefe205fdede), W64LIT(0xdecd26945913cdcd),
        W64LIT(0x631ff8425d7c1f1f), W64LIT(0xc799bc71e85e9999), W64LIT(0x26ac09cf638aacac), W64LIT(0x23ad01c9648eadad),
        W64LIT(0xa772b73143d57272), W64LIT(0x9c2c7de8c4b02c2c), W64LIT(0x8edda6f42953dddd), W64LIT(0xb7d0ceda0a67d0d0),
        W64LIT(0xa1874c35b2268787), W64LIT(0x7cbe99a31dc2bebe), W64LIT(0x3b5ecad987655e5e), W64LIT(0x04a659f355a2a6a6),
        W64LIT(0x7bec3352be97ecec), W64LIT(0x140420181c100404), W64LIT(0xf9c67eae683fc6c6), W64LIT(0x0f03180a090c0303),
        W64LIT(0xe434bdb88cd03434), W64LIT(0x30fb8b20dbcbfbfb), W64LIT(0x90db96e03b4bdbdb), W64LIT(0x2059f2cb92795959),
        W64LIT(0x54b6d99325e2b6b6), W64LIT(0xedc25eb6742fc2c2), W64LIT(0x0501080607040101), W64LIT(0x17f0d31aeae7f0f0),
        W64LIT(0x2f5aeac19b755a5a), W64LIT(0x7eed3b54b993eded), W64LIT(0x01a751f552a6a7a7), W64LIT(0xe36617492f856666),
        W64LIT(0xa52115c6e7842121), W64LIT(0x9e7fdf1f60e17f7f), W64LIT(0x988a241b91128a8a), W64LIT(0xbb2725d2f59c2727),
        W64LIT(0xfcc776a86f3bc7c7), W64LIT(0xe7c04eba7a27c0c0), W64LIT(0x8d2955f6dfa42929), W64LIT(0xacd7f6c81f7bd7d7)
    },
    {
        W64LIT(0x93ec4dde769393e5), W64LIT(0xd986ec3543d9d99a), W64LIT(0x9aa47be1529a9ac8), W64LIT(0xb5c1992ceeb5b55b),
        W64LIT(0x98b477ef5a9898c2), W64LIT(0x220dccee882222aa), W64LIT(0x451283c60945454c), W64LIT(0xfcb332ced7fcfc2b),
        W64LIT(0xbab9bb01d2baba68), W64LIT(0x6a77610bb56a6adf), W64LIT(0xdfb6f8275bdfdf84), W64LIT(0x02100c0e0802020a),
        W64LIT(0x9f8c65fa469f9fd9), W64LIT(0xdcaef22e57dcdc8b), W64LIT(0x51b2fbaa59515108), W64LIT(0x59f2cb9279595920),
        W64LIT(0x4a6aa1eb354a4a7f), W64LIT(0x17b872655c17174b), W64LIT(0x2b45fad1ac2b2b87), W64LIT(0xc25eb6742fc2c2ed),
        W64LIT(0x94d45fcb6a9494fe), W64LIT(0xf4f302f6f7f4f403), W64LIT(0xbbb1bd06d6bbbb6d), W64LIT(0xa371ed4eb6a3a315),
        W64LIT(0x62375133956262f7), W64LIT(0xe4736286b7e4e453), W64LIT(0x71af3b4ad97171a8), W64LIT(0xd4eec21677d4d4a3),
        W64LIT(0xcd26945913cdcdde), W64LIT(0x70a73d4ddd7070ad), W64LIT(0x16b074625816164e), W64LIT(0xe15b7c9da3e1e142),
        W64LIT(0x4972abe239494970), W64LIT(0x3cfd88b4f03c3ccc), W64LIT(0xc04eba7a27c0c0e7), W64LIT(0xd88eea3247d8d89f),
        W64LIT(0x5cdad5896d5c5c31), W64LIT(0x9bac7de6569b9bcd), W64LIT(0xad01c9648eadad23), W64LIT(0x855c39bc2e8585ab),
        W64LIT(0x53a2f7a451535302), W64LIT(0xa161e140bea1a11f), W64LIT(0x7af7017bf57a7a8f), W64LIT(0xc80e8a4207c8c8cf),
        W64LIT(0x2d75eec3b42d2d99), W64LIT(0xe0537a9aa7e0e047), W64LIT(0xd1c6dc0d63d1d1b2), W64LIT(0x72b73143d57272a7),
        W64LIT(0xa659f355a2a6a604), W64LIT(0x2c7de8c4b02c2c9c), W64LIT(0xc46ea26637c4c4f3), W64LIT(0xe34b7093abe3e348),
        W64LIT(0x7697295fc57676b3), W64LIT(0x78e70d75fd787885), W64LIT(0xb7d19522e6b7b751), W64LIT(0xb4c99f2beab4b45e),
        W64LIT(0x0948363f2409092d), W64LIT(0x3bc59aa1ec3b3bd7), W64LIT(0x0e70242a380e0e36), W64LIT(0x41329bda19414158),
        W64LIT(0x4c5ab5f92d4c4c61), W64LIT(0xdebefe205fdede81), W64LIT(0xb2f98b39f2b2b240), W64LIT(0x90f447d77a9090ea),
        W64LIT(0x2535defb942525b1), W64LIT(0xa541f95caea5a50b), W64LIT(0xd7f6c81f7bd7d7ac), W64LIT(0x03180a090c03030f),
        W64LIT(0x1188667744111155), W64LIT(0x0000000000000000), W64LIT(0xc356b0732bc3c3e8), W64LIT(0x2e6de4cab82e2e96),
        W64LIT(0x92e44bd9729292e0), W64LIT(0xef2b58b79befef74), W64LIT(0x4e4ab9f7254e4e6b), W64LIT(0x12906c7e4812125a),
        W64LIT(0x9d9c69f44e9d9dd3), W64LIT(0x7dcf136ee97d7d94), W64LIT(0xcb16804b0bcbcbc0), W64LIT(0x35b5be8bd43535e1),
        W64LIT(0x1080607040101050), W64LIT(0xd5e6c41173d5d5a6), W64LIT(0x4f42bff0214f4f6e), W64LIT(0x9e8463fd429e9edc),
        W64LIT(0x4d52b3fe294d4d64), W64LIT(0xa921d1789ea9a937), W64LIT(0x5592e3b64955551c), W64LIT(0xc67eae683fc6c6f9),
        W64LIT(0xd0ceda0a67d0d0b7), W64LIT(0x7bff077cf17b7b8a), W64LIT(0x18c0504860181878), W64LIT(0x97cc55c2669797f1),
        W64LIT(0xd3d6d0036bd3d3b8), W64LIT(0x36adb482d83636ee), W64LIT(0xe6636e88bfe6e659), W64LIT(0x487aade53d484875),
        W64LIT(0x568ae9bf45565613), W64LIT(0x817c21a03e8181bf), W64LIT(0x8f0c058a068f8f89), W64LIT(0x779f2f58c17777b6),
        W64LIT(0xcc2e925e17ccccdb), W64LIT(0x9c946ff34a9c9cd6), W64LIT(0xb9a1b108deb9b967), W64LIT(0xe2437694afe2e24d),
        W64LIT(0xac09cf638aacac26), W64LIT(0xb8a9b70fdab8b862), W64LIT(0x2f65e2cdbc2f2f93), W64LIT(0x15a87e6b54151541),
        W64LIT(0xa449ff5baaa4a40e), W64LIT(0x7cc71569ed7c7c91), W64LIT(0xda9ee63c4fdada95), W64LIT(0x38dd90a8e03838d8),
        W64LIT(0x1ef0445a781e1e66), W64LIT(0x0b583a312c0b0b27), W64LIT(0x05281e1b14050511), W64LIT(0xd6fece187fd6d6a9),
        W64LIT(0x14a0786c50141444), W64LIT(0x6e577917a56e6ecb), W64LIT(0x6c477519ad6c6cc1), W64LIT(0x7ed71967e57e7e9b),
        W64LIT(0x6617492f856666e3), W64LIT(0xfdbb34c9d3fdfd2e), W64LIT(0xb1e18130feb1b14f), W64LIT(0xe57b6481b3e5e556),
        W64LIT(0x60275d3d9d6060fd), W64LIT(0xaf11c56a86afaf29), W64LIT(0x5ecad987655e5e3b), W64LIT(0x3385aa99cc3333ff),
        W64LIT(0x874c35b2268787a1), W64LIT(0xc9068c4503c9c9ca), W64LIT(0xf0d31aeae7f0f017), W64LIT(0x5dd2d38e695d5d34),
        W64LIT(0x6d4f731ea96d6dc4), W64LIT(0x3fe582bdfc3f3fc3), W64LIT(0x8834179f1a888892), W64LIT(0x8d1c09840e8d8d83),
        W64LIT(0xc776a86f3bc7c7fc), W64LIT(0xf7eb08fffbf7f70c), W64LIT(0x1de84e53741d1d69), W64LIT(0xe91b4ca583e9e96a),
        W64LIT(0xec3352be97ecec7b), W64LIT(0xed3b54b993eded7e), W64LIT(0x807427a73a8080ba), W64LIT(0x2955f6dfa429298d),
        W64LIT(0x2725d2f59c2727bb), W64LIT(0xcf3698571bcfcfd4), W64LIT(0x99bc71e85e9999c7), W64LIT(0xa829d77f9aa8a832),
        W64LIT(0x50bafdad5d50500d), W64LIT(0x0f78222d3c0f0f33), W64LIT(0x37a5b285dc3737eb), W64LIT(0x243dd8fc902424b4),
        W64LIT(0x285df0d8a0282888), W64LIT(0x309da090c03030f0), W64LIT(0x95dc59cc6e9595fb), W64LIT(0xd2ded6046fd2d2bd),
        W64LIT(0x3eed84baf83e3ec6), W64LIT(0x5be2c79c715b5b2a), W64LIT(0x403a9ddd1d40405d), W64LIT(0x836c2dae368383b5),
        W64LIT(0xb3f18d3ef6b3b345), W64LIT(0x696f6b02b96969d0), W64LIT(0x5782efb841575716), W64LIT(0x1ff8425d7c1f1f63),
        W64LIT(0x073812151c07071b), W64LIT(0x1ce04854701c1c6c), W64LIT(0x8a241b91128a8a98), W64LIT(0xbc89af13cabcbc76),
        W64LIT(0x201dc0e0802020a0), W64LIT(0xeb0b40ab8bebeb60), W64LIT(0xce3e9e501fceced1), W64LIT(0x8e04038d028e8e8c),
        W64LIT(0xab31dd7696abab3d), W64LIT(0xee235eb09feeee71), W64LIT(0x3195a697c43131f5), W64LIT(0xa279eb49b2a2a210),
        W64LIT(0x73bf3744d17373a2), W64LIT(0xf99b2cd5c3f9f93a), W64LIT(0xca1e864c0fcacac5), W64LIT(0x3acd9ca6e83a3ad2),
        W64LIT(0x1ad05c46681a1a72), W64LIT(0xfb8b20dbcbfbfb30), W64LIT(0x0d682e23340d0d39), W64LIT(0xc146bc7d23c1c1e2),
        W64LIT(0xfea33ec0dffefe21), W64LIT(0xfa8326dccffafa35), W64LIT(0xf2c316e4eff2f21d), W64LIT(0x6f5f7f10a16f6fce),
        W64LIT(0xbd81a914cebdbd73), W64LIT(0x96c453c5629696f4), W64LIT(0xdda6f42953dddd8e), W64LIT(0x432297d411434352),
        W64LIT(0x52aaf1a355525207), W64LIT(0xb6d99325e2b6b654), W64LIT(0x0840303820080828), W64LIT(0xf3cb10e3ebf3f318),
        W64LIT(0xae19c36d82aeae2c), W64LIT(0xbe99a31dc2bebe7c), W64LIT(0x19c8564f6419197d), W64LIT(0x893c11981e898997),
        W64LIT(0x328dac9ec83232fa), W64LIT(0x262dd4f2982626be), W64LIT(0xb0e98737fab0b04a), W64LIT(0xea0346ac8feaea65),
        W64LIT(0x4b62a7ec314b4b7a), W64LIT(0x640745218d6464e9), W64LIT(0x84543fbb2a8484ae), W64LIT(0x82642ba9328282b0),
        W64LIT(0x6b7f670cb16b6bda), W64LIT(0xf5fb04f1f3f5f506), W64LIT(0x79ef0b72f9797980), W64LIT(0xbf91a51ac6bfbf79),
        W64LIT(0x0108060704010105), W64LIT(0x5fc2df80615f5f3e), W64LIT(0x758f2356c97575bc), W64LIT(0x633f5734916363f2),
        W64LIT(0x1bd85a416c1b1b77), W64LIT(0x2305cae98c2323af), W64LIT(0x3df58eb3f43d3dc9), W64LIT(0x68676d05bd6868d5),
        W64LIT(0x2a4dfcd6a82a2a82), W64LIT(0x650f4326896565ec), W64LIT(0xe8134aa287e8e86f), W64LIT(0x91fc41d07e9191ef),
        W64LIT(0xf6e30ef8fff6f609), W64LIT(0xffab38c7dbffff24), W64LIT(0x13986a794c13135f), W64LIT(0x58facd957d585825),
        W64LIT(0xf1db1cede3f1f112), W64LIT(0x47028fc801474746), W64LIT(0x0a503c36280a0a22), W64LIT(0x7fdf1f60e17f7f9e),
        W64LIT(0xc566a46133c5c5f6), W64LIT(0xa751f552a6a7a701), W64LIT(0xe76b688fbbe7e75c), W64LIT(0x612f5b3a996161f8),
        W64LIT(0x5aeac19b755a5a2f), W64LIT(0x063014121806061e), W64LIT(0x460a89cf05464643), W64LIT(0x441a85c10d444449),
        W64LIT(0x422a91d315424257), W64LIT(0x0420181c10040414), W64LIT(0xa069e747baa0a01a), W64LIT(0xdb96e03b4bdbdb90),
        W64LIT(0x39d596afe43939dd), W64LIT(0x864433b5228686a4), W64LIT(0x549ae5b14d545419), W64LIT(0xaa39db7192aaaa38),
        W64LIT(0x8c140f830a8c8c86), W64LIT(0x34bdb88cd03434e4), W64LIT(0x2115c6e7842121a5), W64LIT(0x8b2c1d96168b8b9d),
        W64LIT(0xf8932ad2c7f8f83f), W64LIT(0x0c602824300c0c3c), W64LIT(0x74872551cd7474b9), W64LIT(0x671f4f28816767e6)
    },
    {
        W64LIT(0x676d05bd6868d568), W64LIT(0x1c09840e8d8d838d), W64LIT(0x1e864c0fcacac5ca), W64LIT(0x52b3fe294d4d644d),
        W64LIT(0xbf3744d17373a273), W64LIT(0x62a7ec314b4b7a4b), W64LIT(0x4ab9f7254e4e6b4e), W64LIT(0x4dfcd6a82a2a822a),
        W64LIT(0xeec21677d4d4a3d4), W64LIT(0xaaf1a35552520752), W64LIT(0x2dd4f2982626be26), W64LIT(0xf18d3ef6b3b345b3),
        W64LIT(0x9ae5b14d54541954), W64LIT(0xf0445a781e1e661e), W64LIT(0xc8564f6419197d19), W64LIT(0xf8425d7c1f1f631f),
        W64LIT(0x0dccee882222aa22), W64LIT(0x180a090c03030f03), W64LIT(0x0a89cf0546464346), W64LIT(0xf58eb3f43d3dc93d),
        W64LIT(0x75eec3b42d2d992d), W64LIT(0x6aa1eb354a4a7f4a), W64LIT(0xa2f7a45153530253), W64LIT(0x6c2dae368383b583),
        W64LIT(0x986a794c13135f13), W64LIT(0x241b91128a8a988a), W64LIT(0xd19522e6b7b751b7), W64LIT(0xe6c41173d5d5a6d5),
        W64LIT(0x35defb942525b125), W64LIT(0xef0b72f979798079), W64LIT(0xfb04f1f3f5f506f5), W64LIT(0x81a914cebdbd73bd),
        W64LIT(0xfacd957d58582558), W64LIT(0x65e2cdbc2f2f932f), W64LIT(0x682e23340d0d390d), W64LIT(0x100c0e0802020a02),
        W64LIT(0x3b54b993eded7eed), W64LIT(0xb2fbaa5951510851), W64LIT(0x8463fd429e9edc9e), W64LIT(0x8866774411115511),
        W64LIT(0xc316e4eff2f21df2), W64LIT(0xed84baf83e3ec63e), W64LIT(0x92e3b64955551c55), W64LIT(0xcad987655e5e3b5e),
        W64LIT(0xc6dc0d63d1d1b2d1), W64LIT(0xb074625816164e16), W64LIT(0xfd88b4f03c3ccc3c), W64LIT(0x17492f856666e366),
        W64LIT(0xa73d4ddd7070ad70), W64LIT(0xd2d38e695d5d345d), W64LIT(0xcb10e3ebf3f318f3), W64LIT(0x1283c60945454c45),
        W64LIT(0x3a9ddd1d40405d40), W64LIT(0x2e925e17ccccdbcc), W64LIT(0x134aa287e8e86fe8), W64LIT(0xd45fcb6a9494fe94),
        W64LIT(0x8ae9bf4556561356), W64LIT(0x4030382008082808), W64LIT(0x3e9e501fceced1ce), W64LIT(0xd05c46681a1a721a),
        W64LIT(0xcd9ca6e83a3ad23a), W64LIT(0xded6046fd2d2bdd2), W64LIT(0x5b7c9da3e1e142e1), W64LIT(0xb6f8275bdfdf84df),
        W64LIT(0xc1992ceeb5b55bb5), W64LIT(0xdd90a8e03838d838), W64LIT(0x577917a56e6ecb6e), W64LIT(0x70242a380e0e360e),
        W64LIT(0x7b6481b3e5e556e5), W64LIT(0xf302f6f7f4f403f4), W64LIT(0x9b2cd5c3f9f93af9), W64LIT(0x4433b5228686a486),
        W64LIT(0x1b4ca583e9e96ae9), W64LIT(0x42bff0214f4f6e4f), W64LIT(0xfece187fd6d6a9d6), W64LIT(0x5c39bc2e8585ab85),
        W64LIT(0x05cae98c2323af23), W64LIT(0x3698571bcfcfd4cf), W64LIT(0x8dac9ec83232fa32), W64LIT(0xbc71e85e9999c799),
        W64LIT(0x95a697c43131f531), W64LIT(0xa0786c5014144414), W64LIT(0x19c36d82aeae2cae), W64LIT(0x235eb09feeee71ee),
        W64LIT(0x0e8a4207c8c8cfc8), W64LIT(0x7aade53d48487548), W64LIT(0xd6d0036bd3d3b8d3), W64LIT(0x9da090c03030f030),
        W64LIT(0x61e140bea1a11fa1), W64LIT(0xe44bd9729292e092), W64LIT(0x329bda1941415841), W64LIT(0xe18130feb1b14fb1),
        W64LIT(0xc050486018187818), W64LIT(0x6ea26637c4c4f3c4), W64LIT(0x7de8c4b02c2c9c2c), W64LIT(0xaf3b4ad97171a871),
        W64LIT(0xb73143d57272a772), W64LIT(0x1a85c10d44444944), W64LIT(0xa87e6b5415154115), W64LIT(0xbb34c9d3fdfd2efd),
        W64LIT(0xa5b285dc3737eb37), W64LIT(0x99a31dc2bebe7cbe), W64LIT(0xc2df80615f5f3e5f), W64LIT(0x39db7192aaaa38aa),
        W64LIT(0xac7de6569b9bcd9b), W64LIT(0x34179f1a88889288), W64LIT(0x8eea3247d8d89fd8), W64LIT(0x31dd7696abab3dab),
        W64LIT(0x3c11981e89899789), W64LIT(0x946ff34a9c9cd69c), W64LIT(0x8326dccffafa35fa), W64LIT(0x275d3d9d6060fd60),
        W64LIT(0x0346ac8feaea65ea), W64LIT(0x89af13cabcbc76bc), W64LIT(0x375133956262f762), W64LIT(0x602824300c0c3c0c),
        W64LIT(0x3dd8fc902424b424), W64LIT(0x59f355a2a6a604a6), W64LIT(0x29d77f9aa8a832a8), W64LIT(0x3352be97ecec7bec),
        W64LIT(0x1f4f28816767e667), W64LIT(0x1dc0e0802020a020), W64LIT(0x96e03b4bdbdb90db), W64LIT(0xc71569ed7c7c917c),
        W64LIT(0x5df0d8a028288828), W64LIT(0xa6f42953dddd8edd), W64LIT(0x09cf638aacac26ac), W64LIT(0xe2c79c715b5b2a5b),
        W64LIT(0xbdb88cd03434e434), W64LIT(0xd71967e57e7e9b7e), W64LIT(0x8060704010105010), W64LIT(0xdb1cede3f1f112f1),
        W64LIT(0xff077cf17b7b8a7b), W64LIT(0x0c058a068f8f898f), W64LIT(0x3f5734916363f263), W64LIT(0x69e747baa0a01aa0),
        W64LIT(0x281e1b1405051105), W64LIT(0xa47be1529a9ac89a), W64LIT(0x2297d41143435243), W64LIT(0x9f2f58c17777b677),
        W64LIT(0x15c6e7842121a521), W64LIT(0x91a51ac6bfbf79bf), W64LIT(0x25d2f59c2727bb27), W64LIT(0x48363f2409092d09),
        W64LIT(0x56b0732bc3c3e8c3), W64LIT(0x8c65fa469f9fd99f), W64LIT(0xd99325e2b6b654b6), W64LIT(0xf6c81f7bd7d7acd7),
        W64LIT(0x55f6dfa429298d29), W64LIT(0x5eb6742fc2c2edc2), W64LIT(0x0b40ab8bebeb60eb), W64LIT(0x4eba7a27c0c0e7c0),
        W64LIT(0x49ff5baaa4a40ea4), W64LIT(0x2c1d96168b8b9d8b), W64LIT(0x140f830a8c8c868c), W64LIT(0xe84e53741d1d691d),
        W64LIT(0x8b20dbcbfbfb30fb), W64LIT(0xab38c7dbffff24ff), W64LIT(0x46bc7d23c1c1e2c1), W64LIT(0xf98b39f2b2b240b2),
        W64LIT(0xcc55c2669797f197), W64LIT(0x6de4cab82e2e962e), W64LIT(0x932ad2c7f8f83ff8), W64LIT(0x0f4326896565ec65),
        W64LIT(0xe30ef8fff6f609f6), W64LIT(0x8f2356c97575bc75), W64LIT(0x3812151c07071b07), W64LIT(0x20181c1004041404),
        W64LIT(0x72abe23949497049), W64LIT(0x85aa99cc3333ff33), W64LIT(0x736286b7e4e453e4), W64LIT(0x86ec3543d9d99ad9),
        W64LIT(0xa1b108deb9b967b9), W64LIT(0xceda0a67d0d0b7d0), W64LIT(0x2a91d31542425742), W64LIT(0x76a86f3bc7c7fcc7),
        W64LIT(0x477519ad6c6cc16c), W64LIT(0xf447d77a9090ea90), W64LIT(0x0000000000000000), W64LIT(0x04038d028e8e8c8e),
        W64LIT(0x5f7f10a16f6fce6f), W64LIT(0xbafdad5d50500d50), W64LIT(0x0806070401010501), W64LIT(0x66a46133c5c5f6c5),
        W64LIT(0x9ee63c4fdada95da), W64LIT(0x028fc80147474647), W64LIT(0xe582bdfc3f3fc33f), W64LIT(0x26945913cdcddecd),
        W64LIT(0x6f6b02b96969d069), W64LIT(0x79eb49b2a2a210a2), W64LIT(0x437694afe2e24de2), W64LIT(0xf7017bf57a7a8f7a),
        W64LIT(0x51f552a6a7a701a7), W64LIT(0x7eae683fc6c6f9c6), W64LIT(0xec4dde769393e593), W64LIT(0x78222d3c0f0f330f),
        W64LIT(0x503c36280a0a220a), W64LIT(0x3014121806061e06), W64LIT(0x636e88bfe6e659e6), W64LIT(0x45fad1ac2b2b872b),
        W64LIT(0xc453c5629696f496), W64LIT(0x71ed4eb6a3a315a3), W64LIT(0xe04854701c1c6c1c), W64LIT(0x11c56a86afaf29af),
        W64LIT(0x77610bb56a6adf6a), W64LIT(0x906c7e4812125a12), W64LIT(0x543fbb2a8484ae84), W64LIT(0xd596afe43939dd39),
        W64LIT(0x6b688fbbe7e75ce7), W64LIT(0xe98737fab0b04ab0), W64LIT(0x642ba9328282b082), W64LIT(0xeb08fffbf7f70cf7),
        W64LIT(0xa33ec0dffefe21fe), W64LIT(0x9c69f44e9d9dd39d), W64LIT(0x4c35b2268787a187), W64LIT(0xdad5896d5c5c315c),
        W64LIT(0x7c21a03e8181bf81), W64LIT(0xb5be8bd43535e135), W64LIT(0xbefe205fdede81de), W64LIT(0xc99f2beab4b45eb4),
        W64LIT(0x41f95caea5a50ba5), W64LIT(0xb332ced7fcfc2bfc), W64LIT(0x7427a73a8080ba80), W64LIT(0x2b58b79befef74ef),
        W64LIT(0x16804b0bcbcbc0cb), W64LIT(0xb1bd06d6bbbb6dbb), W64LIT(0x7f670cb16b6bda6b), W64LIT(0x97295fc57676b376),
        W64LIT(0xb9bb01d2baba68ba), W64LIT(0xeac19b755a5a2f5a), W64LIT(0xcf136ee97d7d947d), W64LIT(0xe70d75fd78788578),
        W64LIT(0x583a312c0b0b270b), W64LIT(0xdc59cc6e9595fb95), W64LIT(0x4b7093abe3e348e3), W64LIT(0x01c9648eadad23ad),
        W64LIT(0x872551cd7474b974), W64LIT(0xb477ef5a9898c298), W64LIT(0xc59aa1ec3b3bd73b), W64LIT(0xadb482d83636ee36),
        W64LIT(0x0745218d6464e964), W64LIT(0x4f731ea96d6dc46d), W64LIT(0xaef22e57dcdc8bdc), W64LIT(0xd31aeae7f0f017f0),
        W64LIT(0xf2cb927959592059), W64LIT(0x21d1789ea9a937a9), W64LIT(0x5ab5f92d4c4c614c), W64LIT(0xb872655c17174b17),
        W64LIT(0xdf1f60e17f7f9e7f), W64LIT(0xfc41d07e9191ef91), W64LIT(0xa9b70fdab8b862b8), W64LIT(0x068c4503c9c9cac9),
        W64LIT(0x82efb84157571657), W64LIT(0xd85a416c1b1b771b), W64LIT(0x537a9aa7e0e047e0), W64LIT(0x2f5b3a996161f861)
    },
    {
        W64LIT(0xd77f9aa8a832a829), W64LIT(0x97d4114343524322), W64LIT(0xdf80615f5f3e5fc2), W64LIT(0x14121806061e0630),
        W64LIT(0x670cb16b6bda6b7f), W64LIT(0x2356c97575bc758f), W64LIT(0x7519ad6c6cc16c47), W64LIT(0xcb927959592059f2),
        W64LIT(0x3b4ad97171a871af), W64LIT(0xf8275bdfdf84dfb6), W64LIT(0x35b2268787a1874c), W64LIT(0x59cc6e9595fb95dc),
        W64LIT(0x72655c17174b17b8), W64LIT(0x1aeae7f0f017f0d3), W64LIT(0xea3247d8d89fd88e), W64LIT(0x363f2409092d0948),
        W64LIT(0x731ea96d6dc46d4f), W64LIT(0x10e3ebf3f318f3cb), W64LIT(0x4e53741d1d691de8), W64LIT(0x804b0bcbcbc0cb16),
        W64LIT(0x8c4503c9c9cac906), W64LIT(0xb3fe294d4d644d52), W64LIT(0xe8c4b02c2c9c2c7d), W64LIT(0xc56a86afaf29af11),
        W64LIT(0x0b72f979798079ef), W64LIT(0x7a9aa7e0e047e053), W64LIT(0x55c2669797f197cc), W64LIT(0x34c9d3fdfd2efdbb),
        W64LIT(0x7f10a16f6fce6f5f), W64LIT(0xa7ec314b4b7a4b62), W64LIT(0x83c60945454c4512), W64LIT(0x96afe43939dd39d5),
        W64LIT(0x84baf83e3ec63eed), W64LIT(0xf42953dddd8edda6), W64LIT(0xed4eb6a3a315a371), W64LIT(0xbff0214f4f6e4f42),
        W64LIT(0x9f2beab4b45eb4c9), W64LIT(0x9325e2b6b654b6d9), W64LIT(0x7be1529a9ac89aa4), W64LIT(0x242a380e0e360e70),
        W64LIT(0x425d7c1f1f631ff8), W64LIT(0xa51ac6bfbf79bf91), W64LIT(0x7e6b5415154115a8), W64LIT(0x7c9da3e1e142e15b),
        W64LIT(0xabe2394949704972), W64LIT(0xd6046fd2d2bdd2de), W64LIT(0x4dde769393e593ec), W64LIT(0xae683fc6c6f9c67e),
        W64LIT(0x4bd9729292e092e4), W64LIT(0x3143d57272a772b7), W64LIT(0x63fd429e9edc9e84), W64LIT(0x5b3a996161f8612f),
        W64LIT(0xdc0d63d1d1b2d1c6), W64LIT(0x5734916363f2633f), W64LIT(0x26dccffafa35fa83), W64LIT(0x5eb09feeee71ee23),
        W64LIT(0x02f6f7f4f403f4f3), W64LIT(0x564f6419197d19c8), W64LIT(0xc41173d5d5a6d5e6), W64LIT(0xc9648eadad23ad01),
        W64LIT(0xcd957d58582558fa), W64LIT(0xff5baaa4a40ea449), W64LIT(0xbd06d6bbbb6dbbb1), W64LIT(0xe140bea1a11fa161),
        W64LIT(0xf22e57dcdc8bdcae), W64LIT(0x16e4eff2f21df2c3), W64LIT(0x2dae368383b5836c), W64LIT(0xb285dc3737eb37a5),
        W64LIT(0x91d315424257422a), W64LIT(0x6286b7e4e453e473), W64LIT(0x017bf57a7a8f7af7), W64LIT(0xac9ec83232fa328d),
        W64LIT(0x6ff34a9c9cd69c94), W64LIT(0x925e17ccccdbcc2e), W64LIT(0xdd7696abab3dab31), W64LIT(0xa1eb354a4a7f4a6a),
        W64LIT(0x058a068f8f898f0c), W64LIT(0x7917a56e6ecb6e57), W64LIT(0x181c100404140420), W64LIT(0xd2f59c2727bb2725),
        W64LIT(0xe4cab82e2e962e6d), W64LIT(0x688fbbe7e75ce76b), W64LIT(0x7694afe2e24de243), W64LIT(0xc19b755a5a2f5aea),
        W64LIT(0x53c5629696f496c4), W64LIT(0x74625816164e16b0), W64LIT(0xcae98c2323af2305), W64LIT(0xfad1ac2b2b872b45),
        W64LIT(0xb6742fc2c2edc25e), W64LIT(0x4326896565ec650f), W64LIT(0x492f856666e36617), W64LIT(0x222d3c0f0f330f78),
        W64LIT(0xaf13cabcbc76bc89), W64LIT(0xd1789ea9a937a921), W64LIT(0x8fc8014747464702), W64LIT(0x9bda194141584132),
        W64LIT(0xb88cd03434e434bd), W64LIT(0xade53d484875487a), W64LIT(0x32ced7fcfc2bfcb3), W64LIT(0x9522e6b7b751b7d1),
        W64LIT(0x610bb56a6adf6a77), W64LIT(0x179f1a8888928834), W64LIT(0xf95caea5a50ba541), W64LIT(0xf7a45153530253a2),
        W64LIT(0x33b5228686a48644), W64LIT(0x2cd5c3f9f93af99b), W64LIT(0xc79c715b5b2a5be2), W64LIT(0xe03b4bdbdb90db96),
        W64LIT(0x90a8e03838d838dd), W64LIT(0x077cf17b7b8a7bff), W64LIT(0xb0732bc3c3e8c356), W64LIT(0x445a781e1e661ef0),
        W64LIT(0xccee882222aa220d), W64LIT(0xaa99cc3333ff3385), W64LIT(0xd8fc902424b4243d), W64LIT(0xf0d8a0282888285d),
        W64LIT(0xb482d83636ee36ad), W64LIT(0xa86f3bc7c7fcc776), W64LIT(0x8b39f2b2b240b2f9), W64LIT(0x9aa1ec3b3bd73bc5),
        W64LIT(0x038d028e8e8c8e04), W64LIT(0x2f58c17777b6779f), W64LIT(0xbb01d2baba68bab9), W64LIT(0x04f1f3f5f506f5fb),
        W64LIT(0x786c5014144414a0), W64LIT(0x65fa469f9fd99f8c), W64LIT(0x3038200808280840), W64LIT(0xe3b64955551c5592),
        W64LIT(0x7de6569b9bcd9bac), W64LIT(0xb5f92d4c4c614c5a), W64LIT(0x3ec0dffefe21fea3), W64LIT(0x5d3d9d6060fd6027),
        W64LIT(0xd5896d5c5c315cda), W64LIT(0xe63c4fdada95da9e), W64LIT(0x50486018187818c0), W64LIT(0x89cf05464643460a),
        W64LIT(0x945913cdcddecd26), W64LIT(0x136ee97d7d947dcf), W64LIT(0xc6e7842121a52115), W64LIT(0x8737fab0b04ab0e9),
        W64LIT(0x82bdfc3f3fc33fe5), W64LIT(0x5a416c1b1b771bd8), W64LIT(0x11981e898997893c), W64LIT(0x38c7dbffff24ffab),
        W64LIT(0x40ab8bebeb60eb0b), W64LIT(0x3fbb2a8484ae8454), W64LIT(0x6b02b96969d0696f), W64LIT(0x9ca6e83a3ad23acd),
        W64LIT(0x69f44e9d9dd39d9c), W64LIT(0xc81f7bd7d7acd7f6), W64LIT(0xd0036bd3d3b8d3d6), W64LIT(0x3d4ddd7070ad70a7),
        W64LIT(0x4f28816767e6671f), W64LIT(0x9ddd1d40405d403a), W64LIT(0x992ceeb5b55bb5c1), W64LIT(0xfe205fdede81debe),
        W64LIT(0xd38e695d5d345dd2), W64LIT(0xa090c03030f0309d), W64LIT(0x41d07e9191ef91fc), W64LIT(0x8130feb1b14fb1e1),
        W64LIT(0x0d75fd78788578e7), W64LIT(0x6677441111551188), W64LIT(0x0607040101050108), W64LIT(0x6481b3e5e556e57b),
        W64LIT(0x0000000000000000), W64LIT(0x6d05bd6868d56867), W64LIT(0x77ef5a9898c298b4), W64LIT(0xe747baa0a01aa069),
        W64LIT(0xa46133c5c5f6c566), W64LIT(0x0c0e0802020a0210), W64LIT(0xf355a2a6a604a659), W64LIT(0x2551cd7474b97487),
        W64LIT(0xeec3b42d2d992d75), W64LIT(0x3a312c0b0b270b58), W64LIT(0xeb49b2a2a210a279), W64LIT(0x295fc57676b37697),
        W64LIT(0x8d3ef6b3b345b3f1), W64LIT(0xa31dc2bebe7cbe99), W64LIT(0x9e501fceced1ce3e), W64LIT(0xa914cebdbd73bd81),
        W64LIT(0xc36d82aeae2cae19), W64LIT(0x4ca583e9e96ae91b), W64LIT(0x1b91128a8a988a24), W64LIT(0xa697c43131f53195),
        W64LIT(0x4854701c1c6c1ce0), W64LIT(0x52be97ecec7bec33), W64LIT(0x1cede3f1f112f1db), W64LIT(0x71e85e9999c799bc),
        W64LIT(0x5fcb6a9494fe94d4), W64LIT(0xdb7192aaaa38aa39), W64LIT(0x0ef8fff6f609f6e3), W64LIT(0xd4f2982626be262d),
        W64LIT(0xe2cdbc2f2f932f65), W64LIT(0x58b79befef74ef2b), W64LIT(0x4aa287e8e86fe813), W64LIT(0x0f830a8c8c868c14),
        W64LIT(0xbe8bd43535e135b5), W64LIT(0x0a090c03030f0318), W64LIT(0xc21677d4d4a3d4ee), W64LIT(0x1f60e17f7f9e7fdf),
        W64LIT(0x20dbcbfbfb30fb8b), W64LIT(0x1e1b140505110528), W64LIT(0xbc7d23c1c1e2c146), W64LIT(0xd987655e5e3b5eca),
        W64LIT(0x47d77a9090ea90f4), W64LIT(0xc0e0802020a0201d), W64LIT(0x8eb3f43d3dc93df5), W64LIT(0x2ba9328282b08264),
        W64LIT(0x08fffbf7f70cf7eb), W64LIT(0x46ac8feaea65ea03), W64LIT(0x3c36280a0a220a50), W64LIT(0x2e23340d0d390d68),
        W64LIT(0x1967e57e7e9b7ed7), W64LIT(0x2ad2c7f8f83ff893), W64LIT(0xfdad5d50500d50ba), W64LIT(0x5c46681a1a721ad0),
        W64LIT(0xa26637c4c4f3c46e), W64LIT(0x12151c07071b0738), W64LIT(0xefb8415757165782), W64LIT(0xb70fdab8b862b8a9),
        W64LIT(0x88b4f03c3ccc3cfd), W64LIT(0x5133956262f76237), W64LIT(0x7093abe3e348e34b), W64LIT(0x8a4207c8c8cfc80e),
        W64LIT(0xcf638aacac26ac09), W64LIT(0xf1a35552520752aa), W64LIT(0x45218d6464e96407), W64LIT(0x6070401010501080),
        W64LIT(0xda0a67d0d0b7d0ce), W64LIT(0xec3543d9d99ad986), W64LIT(0x6a794c13135f1398), W64LIT(0x2824300c0c3c0c60),
        W64LIT(0x6c7e4812125a1290), W64LIT(0xf6dfa429298d2955), W64LIT(0xfbaa5951510851b2), W64LIT(0xb108deb9b967b9a1),
        W64LIT(0x98571bcfcfd4cf36), W64LIT(0xce187fd6d6a9d6fe), W64LIT(0x3744d17373a273bf), W64LIT(0x09840e8d8d838d1c),
        W64LIT(0x21a03e8181bf817c), W64LIT(0xe5b14d545419549a), W64LIT(0xba7a27c0c0e7c04e), W64LIT(0x54b993eded7eed3b),
        W64LIT(0xb9f7254e4e6b4e4a), W64LIT(0x85c10d444449441a), W64LIT(0xf552a6a7a701a751), W64LIT(0xfcd6a82a2a822a4d),
        W64LIT(0x39bc2e8585ab855c), W64LIT(0xdefb942525b12535), W64LIT(0x6e88bfe6e659e663), W64LIT(0x864c0fcacac5ca1e),
        W64LIT(0x1569ed7c7c917cc7), W64LIT(0x1d96168b8b9d8b2c), W64LIT(0xe9bf45565613568a), W64LIT(0x27a73a8080ba8074)
    },
    {
        W64LIT(0x501fceced1ce3e9e), W64LIT(0x06d6bbbb6dbbb1bd), W64LIT(0xab8bebeb60eb0b40), W64LIT(0xd9729292e092e44b),
        W64LIT(0xac8feaea65ea0346), W64LIT(0x4b0bcbcbc0cb1680), W64LIT(0x794c13135f13986a), W64LIT(0x7d23c1c1e2c146bc),
        W64LIT(0xa583e9e96ae91b4c), W64LIT(0xa6e83a3ad23acd9c), W64LIT(0x187fd6d6a9d6fece), W64LIT(0x39f2b2b240b2f98b),
        W64LIT(0x046fd2d2bdd2ded6), W64LIT(0xd77a9090ea90f447), W64LIT(0x655c17174b17b872), W64LIT(0xd2c7f8f83ff8932a),
        W64LIT(0xd315424257422a91), W64LIT(0x6b5415154115a87e), W64LIT(0xbf45565613568ae9), W64LIT(0x2beab4b45eb4c99f),
        W64LIT(0x26896565ec650f43), W64LIT(0x54701c1c6c1ce048), W64LIT(0x9f1a888892883417), W64LIT(0xd411434352432297),
        W64LIT(0x6133c5c5f6c566a4), W64LIT(0x896d5c5c315cdad5), W64LIT(0x82d83636ee36adb4), W64LIT(0x01d2baba68bab9bb),
        W64LIT(0xf1f3f5f506f5fb04), W64LIT(0xb8415757165782ef), W64LIT(0x28816767e6671f4f), W64LIT(0x840e8d8d838d1c09),
        W64LIT(0x97c43131f53195a6), W64LIT(0xf8fff6f609f6e30e), W64LIT(0x218d6464e9640745), W64LIT(0x957d58582558facd),
        W64LIT(0xfd429e9edc9e8463), W64LIT(0xf6f7f4f403f4f302), W64LIT(0xee882222aa220dcc), W64LIT(0x7192aaaa38aa39db),
        W64LIT(0x56c97575bc758f23), W64LIT(0x2d3c0f0f330f7822), W64LIT(0x0e0802020a02100c), W64LIT(0x30feb1b14fb1e181),
        W64LIT(0x275bdfdf84dfb6f8), W64LIT(0x1ea96d6dc46d4f73), W64LIT(0x44d17373a273bf37), W64LIT(0xfe294d4d644d52b3),
        W64LIT(0x69ed7c7c917cc715), W64LIT(0xf2982626be262dd4), W64LIT(0xcab82e2e962e6de4), W64LIT(0xfffbf7f70cf7eb08),
        W64LIT(0x3820080828084030), W64LIT(0x8e695d5d345dd2d3), W64LIT(0xc10d444449441a85), W64LIT(0xbaf83e3ec63eed84),
        W64LIT(0xfa469f9fd99f8c65), W64LIT(0x6c5014144414a078), W64LIT(0x4207c8c8cfc80e8a), W64LIT(0x6d82aeae2cae19c3),
        W64LIT(0xb14d545419549ae5), W64LIT(0x7040101050108060), W64LIT(0x3247d8d89fd88eea), W64LIT(0x13cabcbc76bc89af),
        W64LIT(0x46681a1a721ad05c), W64LIT(0x0cb16b6bda6b7f67), W64LIT(0x02b96969d0696f6b), W64LIT(0xe3ebf3f318f3cb10),
        W64LIT(0x14cebdbd73bd81a9), W64LIT(0x99cc3333ff3385aa), W64LIT(0x7696abab3dab31dd), W64LIT(0xdccffafa35fa8326),
        W64LIT(0x0d63d1d1b2d1c6dc), W64LIT(0xe6569b9bcd9bac7d), W64LIT(0x05bd6868d568676d), W64LIT(0xf7254e4e6b4e4ab9),
        W64LIT(0x625816164e16b074), W64LIT(0xcc6e9595fb95dc59), W64LIT(0xd07e9191ef91fc41), W64LIT(0xb09feeee71ee235e),
        W64LIT(0xf92d4c4c614c5ab5), W64LIT(0x34916363f2633f57), W64LIT(0x8d028e8e8c8e0403), W64LIT(0x9c715b5b2a5be2c7),
        W64LIT(0x5e17ccccdbcc2e92), W64LIT(0xb4f03c3ccc3cfd88), W64LIT(0x4f6419197d19c856), W64LIT(0x40bea1a11fa161e1),
        W64LIT(0xa03e8181bf817c21), W64LIT(0xe2394949704972ab), W64LIT(0x7cf17b7b8a7bff07), W64LIT(0x3543d9d99ad986ec),
        W64LIT(0x10a16f6fce6f5f7f), W64LIT(0x85dc3737eb37a5b2), W64LIT(0x3d9d6060fd60275d), W64LIT(0x4c0fcacac5ca1e86),
        W64LIT(0x8fbbe7e75ce76b68), W64LIT(0xd1ac2b2b872b45fa), W64LIT(0xe53d484875487aad), W64LIT(0xc9d3fdfd2efdbb34),
        W64LIT(0xc5629696f496c453), W64LIT(0xc60945454c451283), W64LIT(0xced7fcfc2bfcb332), W64LIT(0xda1941415841329b),
        W64LIT(0x7e4812125a12906c), W64LIT(0x23340d0d390d682e), W64LIT(0x72f979798079ef0b), W64LIT(0x81b3e5e556e57b64),
        W64LIT(0x981e898997893c11), W64LIT(0x830a8c8c868c140f), W64LIT(0x93abe3e348e34b70), W64LIT(0xe0802020a0201dc0),
        W64LIT(0x90c03030f0309da0), W64LIT(0x2e57dcdc8bdcaef2), W64LIT(0x22e6b7b751b7d195), W64LIT(0x19ad6c6cc16c4775),
        W64LIT(0xeb354a4a7f4a6aa1), W64LIT(0x2ceeb5b55bb5c199), W64LIT(0xbdfc3f3fc33fe582), W64LIT(0xc2669797f197cc55),
        W64LIT(0x1677d4d4a3d4eec2), W64LIT(0x33956262f7623751), W64LIT(0xc3b42d2d992d75ee), W64LIT(0x121806061e063014),
        W64LIT(0x5baaa4a40ea449ff), W64LIT(0x5caea5a50ba541f9), W64LIT(0xae368383b5836c2d), W64LIT(0x80615f5f3e5fc2df),
        W64LIT(0xd6a82a2a822a4dfc), W64LIT(0x3c4fdada95da9ee6), W64LIT(0x4503c9c9cac9068c), W64LIT(0x0000000000000000),
        W64LIT(0x67e57e7e9b7ed719), W64LIT(0x49b2a2a210a279eb), W64LIT(0xb64955551c5592e3), W64LIT(0x1ac6bfbf79bf91a5),
        W64LIT(0x7744111155118866), W64LIT(0x1173d5d5a6d5e6c4), W64LIT(0xf34a9c9cd69c946f), W64LIT(0x571bcfcfd4cf3698),
        W64LIT(0x2a380e0e360e7024), W64LIT(0x36280a0a220a503c), W64LIT(0xb3f43d3dc93df58e), W64LIT(0xaa5951510851b2fb),
        W64LIT(0x6ee97d7d947dcf13), W64LIT(0xde769393e593ec4d), W64LIT(0x416c1b1b771bd85a), W64LIT(0xc0dffefe21fea33e),
        W64LIT(0x6637c4c4f3c46ea2), W64LIT(0xc80147474647028f), W64LIT(0x3f2409092d094836), W64LIT(0xb5228686a4864433),
        W64LIT(0x312c0b0b270b583a), W64LIT(0x8a068f8f898f0c05), W64LIT(0xf44e9d9dd39d9c69), W64LIT(0x0bb56a6adf6a7761),
        W64LIT(0x151c07071b073812), W64LIT(0x08deb9b967b9a1b1), W64LIT(0x37fab0b04ab0e987), W64LIT(0xef5a9898c298b477),
        W64LIT(0x486018187818c050), W64LIT(0x9ec83232fa328dac), W64LIT(0x4ad97171a871af3b), W64LIT(0xec314b4b7a4b62a7),
        W64LIT(0xb79befef74ef2b58), W64LIT(0xa1ec3b3bd73bc59a), W64LIT(0x4ddd7070ad70a73d), W64LIT(0x47baa0a01aa069e7),
        W64LIT(0x86b7e4e453e47362), W64LIT(0xdd1d40405d403a9d), W64LIT(0xc7dbffff24ffab38), W64LIT(0x732bc3c3e8c356b0),
        W64LIT(0x789ea9a937a921d1), W64LIT(0x88bfe6e659e6636e), W64LIT(0x75fd78788578e70d), W64LIT(0xd5c3f9f93af99b2c),
        W64LIT(0x96168b8b9d8b2c1d), W64LIT(0xcf05464643460a89), W64LIT(0xa73a8080ba807427), W64LIT(0x5a781e1e661ef044),
        W64LIT(0xa8e03838d838dd90), W64LIT(0x9da3e1e142e15b7c), W64LIT(0x0fdab8b862b8a9b7), W64LIT(0x7f9aa8a832a829d7),
        W64LIT(0x9aa7e0e047e0537a), W64LIT(0x24300c0c3c0c6028), W64LIT(0xe98c2323af2305ca), W64LIT(0x5fc57676b3769729),
        W64LIT(0x53741d1d691de84e), W64LIT(0xfb942525b12535de), W64LIT(0xfc902424b4243dd8), W64LIT(0x1b1405051105281e),
        W64LIT(0xede3f1f112f1db1c), W64LIT(0x17a56e6ecb6e5779), W64LIT(0xcb6a9494fe94d45f), W64LIT(0xd8a0282888285df0),
        W64LIT(0xe1529a9ac89aa47b), W64LIT(0xbb2a8484ae84543f), W64LIT(0xa287e8e86fe8134a), W64LIT(0x4eb6a3a315a371ed),
        W64LIT(0xf0214f4f6e4f42bf), W64LIT(0x58c17777b6779f2f), W64LIT(0x036bd3d3b8d3d6d0), W64LIT(0xbc2e8585ab855c39),
        W64LIT(0x94afe2e24de24376), W64LIT(0xa35552520752aaf1), W64LIT(0xe4eff2f21df2c316), W64LIT(0xa9328282b082642b),
        W64LIT(0xad5d50500d50bafd), W64LIT(0x7bf57a7a8f7af701), W64LIT(0xcdbc2f2f932f65e2), W64LIT(0x51cd7474b9748725),
        W64LIT(0xa45153530253a2f7), W64LIT(0x3ef6b3b345b3f18d), W64LIT(0x3a996161f8612f5b), W64LIT(0x6a86afaf29af11c5),
        W64LIT(0xafe43939dd39d596), W64LIT(0x8bd43535e135b5be), W64LIT(0x205fdede81debefe), W64LIT(0x5913cdcddecd2694),
        W64LIT(0x5d7c1f1f631ff842), W64LIT(0xe85e9999c799bc71), W64LIT(0x638aacac26ac09cf), W64LIT(0x648eadad23ad01c9),
        W64LIT(0x43d57272a772b731), W64LIT(0xc4b02c2c9c2c7de8), W64LIT(0x2953dddd8edda6f4), W64LIT(0x0a67d0d0b7d0ceda),
        W64LIT(0xb2268787a1874c35), W64LIT(0x1dc2bebe7cbe99a3), W64LIT(0x87655e5e3b5ecad9), W64LIT(0x55a2a6a604a659f3),
        W64LIT(0xbe97ecec7bec3352), W64LIT(0x1c10040414042018), W64LIT(0x683fc6c6f9c67eae), W64LIT(0x090c03030f03180a),
        W64LIT(0x8cd03434e434bdb8), W64LIT(0xdbcbfbfb30fb8b20), W64LIT(0x3b4bdbdb90db96e0), W64LIT(0x927959592059f2cb),
        W64LIT(0x25e2b6b654b6d993), W64LIT(0x742fc2c2edc25eb6), W64LIT(0x0704010105010806), W64LIT(0xeae7f0f017f0d31a),
        W64LIT(0x9b755a5a2f5aeac1), W64LIT(0xb993eded7eed3b54), W64LIT(0x52a6a7a701a751f5), W64LIT(0x2f856666e3661749),
        W64LIT(0xe7842121a52115c6), W64LIT(0x60e17f7f9e7fdf1f), W64LIT(0x91128a8a988a241b), W64LIT(0xf59c2727bb2725d2),
        W64LIT(0x6f3bc7c7fcc776a8), W64LIT(0x7a27c0c0e7c04eba), W64LIT(0xdfa429298d2955f6), W64LIT(0x1f7bd7d7acd7f6c8)
    },
    {
        W64LIT(0x769393e593ec4dde), W64LIT(0x43d9d99ad986ec35), W64LIT(0x529a9ac89aa47be1), W64LIT(0xeeb5b55bb5c1992c),
        W64LIT(0x5a9898c298b477ef), W64LIT(0x882222aa220dccee), W64LIT(0x0945454c451283c6), W64LIT(0xd7fcfc2bfcb332ce),
        W64LIT(0xd2baba68bab9bb01), W64LIT(0xb56a6adf6a77610b), W64LIT(0x5bdfdf84dfb6f827), W64LIT(0x0802020a02100c0e),
        W64LIT(0x469f9fd99f8c65fa), W64LIT(0x57dcdc8bdcaef22e), W64LIT(0x5951510851b2fbaa), W64LIT(0x7959592059f2cb92),
        W64LIT(0x354a4a7f4a6aa1eb), W64LIT(0x5c17174b17b87265), W64LIT(0xac2b2b872b45fad1), W64LIT(0x2fc2c2edc25eb674),
        W64LIT(0x6a9494fe94d45fcb), W64LIT(0xf7f4f403f4f302f6), W64LIT(0xd6bbbb6dbbb1bd06), W64LIT(0xb6a3a315a371ed4e),
        W64LIT(0x956262f762375133), W64LIT(0xb7e4e453e4736286), W64LIT(0xd97171a871af3b4a), W64LIT(0x77d4d4a3d4eec216),
        W64LIT(0x13cdcddecd269459), W64LIT(0xdd7070ad70a73d4d), W64LIT(0x5816164e16b07462), W64LIT(0xa3e1e142e15b7c9d),
        W64LIT(0x394949704972abe2), W64LIT(0xf03c3ccc3cfd88b4), W64LIT(0x27c0c0e7c04eba7a), W64LIT(0x47d8d89fd88eea32),
        W64LIT(0x6d5c5c315cdad589), W64LIT(0x569b9bcd9bac7de6), W64LIT(0x8eadad23ad01c964), W64LIT(0x2e8585ab855c39bc),
        W64LIT(0x5153530253a2f7a4), W64LIT(0xbea1a11fa161e140), W64LIT(0xf57a7a8f7af7017b), W64LIT(0x07c8c8cfc80e8a42),
        W64LIT(0xb42d2d992d75eec3), W64LIT(0xa7e0e047e0537a9a), W64LIT(0x63d1d1b2d1c6dc0d), W64LIT(0xd57272a772b73143),
        W64LIT(0xa2a6a604a659f355), W64LIT(0xb02c2c9c2c7de8c4), W64LIT(0x37c4c4f3c46ea266), W64LIT(0xabe3e348e34b7093),
        W64LIT(0xc57676b37697295f), W64LIT(0xfd78788578e70d75), W64LIT(0xe6b7b751b7d19522), W64LIT(0xeab4b45eb4c99f2b),
        W64LIT(0x2409092d0948363f), W64LIT(0xec3b3bd73bc59aa1), W64LIT(0x380e0e360e70242a), W64LIT(0x1941415841329bda),
        W64LIT(0x2d4c4c614c5ab5f9), W64LIT(0x5fdede81debefe20), W64LIT(0xf2b2b240b2f98b39), W64LIT(0x7a9090ea90f447d7),
        W64LIT(0x942525b12535defb), W64LIT(0xaea5a50ba541f95c), W64LIT(0x7bd7d7acd7f6c81f), W64LIT(0x0c03030f03180a09),
        W64LIT(0x4411115511886677), W64LIT(0x0000000000000000), W64LIT(0x2bc3c3e8c356b073), W64LIT(0xb82e2e962e6de4ca),
        W64LIT(0x729292e092e44bd9), W64LIT(0x9befef74ef2b58b7), W64LIT(0x254e4e6b4e4ab9f7), W64LIT(0x4812125a12906c7e),
        W64LIT(0x4e9d9dd39d9c69f4), W64LIT(0xe97d7d947dcf136e), W64LIT(0x0bcbcbc0cb16804b), W64LIT(0xd43535e135b5be8b),
        W64LIT(0x4010105010806070), W64LIT(0x73d5d5a6d5e6c411), W64LIT(0x214f4f6e4f42bff0), W64LIT(0x429e9edc9e8463fd),
        W64LIT(0x294d4d644d52b3fe), W64LIT(0x9ea9a937a921d178), W64LIT(0x4955551c5592e3b6), W64LIT(0x3fc6c6f9c67eae68),
        W64LIT(0x67d0d0b7d0ceda0a), W64LIT(0xf17b7b8a7bff077c), W64LIT(0x6018187818c05048), W64LIT(0x669797f197cc55c2),
        W64LIT(0x6bd3d3b8d3d6d003), W64LIT(0xd83636ee36adb482), W64LIT(0xbfe6e659e6636e88), W64LIT(0x3d484875487aade5),
        W64LIT(0x45565613568ae9bf), W64LIT(0x3e8181bf817c21a0), W64LIT(0x068f8f898f0c058a), W64LIT(0xc17777b6779f2f58),
        W64LIT(0x17ccccdbcc2e925e), W64LIT(0x4a9c9cd69c946ff3), W64LIT(0xdeb9b967b9a1b108), W64LIT(0xafe2e24de2437694),
        W64LIT(0x8aacac26ac09cf63), W64LIT(0xdab8b862b8a9b70f), W64LIT(0xbc2f2f932f65e2cd), W64LIT(0x5415154115a87e6b),
        W64LIT(0xaaa4a40ea449ff5b), W64LIT(0xed7c7c917cc71569), W64LIT(0x4fdada95da9ee63c), W64LIT(0xe03838d838dd90a8),
        W64LIT(0x781e1e661ef0445a), W64LIT(0x2c0b0b270b583a31), W64LIT(0x1405051105281e1b), W64LIT(0x7fd6d6a9d6fece18),
        W64LIT(0x5014144414a0786c), W64LIT(0xa56e6ecb6e577917), W64LIT(0xad6c6cc16c477519), W64LIT(0xe57e7e9b7ed71967),
        W64LIT(0x856666e36617492f), W64LIT(0xd3fdfd2efdbb34c9), W64LIT(0xfeb1b14fb1e18130), W64LIT(0xb3e5e556e57b6481),
        W64LIT(0x9d6060fd60275d3d), W64LIT(0x86afaf29af11c56a), W64LIT(0x655e5e3b5ecad987), W64LIT(0xcc3333ff3385aa99),
        W64LIT(0x268787a1874c35b2), W64LIT(0x03c9c9cac9068c45), W64LIT(0xe7f0f017f0d31aea), W64LIT(0x695d5d345dd2d38e),
        W64LIT(0xa96d6dc46d4f731e), W64LIT(0xfc3f3fc33fe582bd), W64LIT(0x1a8888928834179f), W64LIT(0x0e8d8d838d1c0984),
        W64LIT(0x3bc7c7fcc776a86f), W64LIT(0xfbf7f70cf7eb08ff), W64LIT(0x741d1d691de84e53), W64LIT(0x83e9e96ae91b4ca5),
        W64LIT(0x97ecec7bec3352be), W64LIT(0x93eded7eed3b54b9), W64LIT(0x3a8080ba807427a7), W64LIT(0xa429298d2955f6df),
        W64LIT(0x9c2727bb2725d2f5), W64LIT(0x1bcfcfd4cf369857), W64LIT(0x5e9999c799bc71e8), W64LIT(0x9aa8a832a829d77f),
        W64LIT(0x5d50500d50bafdad), W64LIT(0x3c0f0f330f78222d), W64LIT(0xdc3737eb37a5b285), W64LIT(0x902424b4243dd8fc),
        W64LIT(0xa0282888285df0d8), W64LIT(0xc03030f0309da090), W64LIT(0x6e9595fb95dc59cc), W64LIT(0x6fd2d2bdd2ded604),
        W64LIT(0xf83e3ec63eed84ba), W64LIT(0x715b5b2a5be2c79c), W64LIT(0x1d40405d403a9ddd), W64LIT(0x368383b5836c2dae),
        W64LIT(0xf6b3b345b3f18d3e), W64LIT(0xb96969d0696f6b02), W64LIT(0x415757165782efb8), W64LIT(0x7c1f1f631ff8425d),
        W64LIT(0x1c07071b07381215), W64LIT(0x701c1c6c1ce04854), W64LIT(0x128a8a988a241b91), W64LIT(0xcabcbc76bc89af13),
        W64LIT(0x802020a0201dc0e0), W64LIT(0x8bebeb60eb0b40ab), W64LIT(0x1fceced1ce3e9e50), W64LIT(0x028e8e8c8e04038d),
        W64LIT(0x96abab3dab31dd76), W64LIT(0x9feeee71ee235eb0), W64LIT(0xc43131f53195a697), W64LIT(0xb2a2a210a279eb49),
        W64LIT(0xd17373a273bf3744), W64LIT(0xc3f9f93af99b2cd5), W64LIT(0x0fcacac5ca1e864c), W64LIT(0xe83a3ad23acd9ca6),
        W64LIT(0x681a1a721ad05c46), W64LIT(0xcbfbfb30fb8b20db), W64LIT(0x340d0d390d682e23), W64LIT(0x23c1c1e2c146bc7d),
        W64LIT(0xdffefe21fea33ec0), W64LIT(0xcffafa35fa8326dc), W64LIT(0xeff2f21df2c316e4), W64LIT(0xa16f6fce6f5f7f10),
        W64LIT(0xcebdbd73bd81a914), W64LIT(0x629696f496c453c5), W64LIT(0x53dddd8edda6f429), W64LIT(0x11434352432297d4),
        W64LIT(0x5552520752aaf1a3), W64LIT(0xe2b6b654b6d99325), W64LIT(0x2008082808403038), W64LIT(0xebf3f318f3cb10e3),
        W64LIT(0x82aeae2cae19c36d), W64LIT(0xc2bebe7cbe99a31d), W64LIT(0x6419197d19c8564f), W64LIT(0x1e898997893c1198),
        W64LIT(0xc83232fa328dac9e), W64LIT(0x982626be262dd4f2), W64LIT(0xfab0b04ab0e98737), W64LIT(0x8feaea65ea0346ac),
        W64LIT(0x314b4b7a4b62a7ec), W64LIT(0x8d6464e964074521), W64LIT(0x2a8484ae84543fbb), W64LIT(0x328282b082642ba9),
        W64LIT(0xb16b6bda6b7f670c), W64LIT(0xf3f5f506f5fb04f1), W64LIT(0xf979798079ef0b72), W64LIT(0xc6bfbf79bf91a51a),
        W64LIT(0x0401010501080607), W64LIT(0x615f5f3e5fc2df80), W64LIT(0xc97575bc758f2356), W64LIT(0x916363f2633f5734),
        W64LIT(0x6c1b1b771bd85a41), W64LIT(0x8c2323af2305cae9), W64LIT(0xf43d3dc93df58eb3), W64LIT(0xbd6868d568676d05),
        W64LIT(0xa82a2a822a4dfcd6), W64LIT(0x896565ec650f4326), W64LIT(0x87e8e86fe8134aa2), W64LIT(0x7e9191ef91fc41d0),
        W64LIT(0xfff6f609f6e30ef8), W64LIT(0xdbffff24ffab38c7), W64LIT(0x4c13135f13986a79), W64LIT(0x7d58582558facd95),
        W64LIT(0xe3f1f112f1db1ced), W64LIT(0x0147474647028fc8), W64LIT(0x280a0a220a503c36), W64LIT(0xe17f7f9e7fdf1f60),
        W64LIT(0x33c5c5f6c566a461), W64LIT(0xa6a7a701a751f552), W64LIT(0xbbe7e75ce76b688f), W64LIT(0x996161f8612f5b3a),
        W64LIT(0x755a5a2f5aeac19b), W64LIT(0x1806061e06301412), W64LIT(0x05464643460a89cf), W64LIT(0x0d444449441a85c1),
        W64LIT(0x15424257422a91d3), W64LIT(0x100404140420181c), W64LIT(0xbaa0a01aa069e747), W64LIT(0x4bdbdb90db96e03b),
        W64LIT(0xe43939dd39d596af), W64LIT(0x228686a4864433b5), W64LIT(0x4d545419549ae5b1), W64LIT(0x92aaaa38aa39db71),
        W64LIT(0x0a8c8c868c140f83), W64LIT(0xd03434e434bdb88c), W64LIT(0x842121a52115c6e7), W64LIT(0x168b8b9d8b2c1d96),
        W64LIT(0xc7f8f83ff8932ad2), W64LIT(0x300c0c3c0c602824), W64LIT(0xcd7474b974872551), W64LIT(0x816767e6671f4f28)
    },
    {
        W64LIT(0x6868d568676d05bd), W64LIT(0x8d8d838d1c09840e), W64LIT(0xcacac5ca1e864c0f), W64LIT(0x4d4d644d52b3fe29),
        W64LIT(0x7373a273bf3744d1), W64LIT(0x4b4b7a4b62a7ec31), W64LIT(0x4e4e6b4e4ab9f725), W64LIT(0x2a2a822a4dfcd6a8),
        W64LIT(0xd4d4a3d4eec21677), W64LIT(0x52520752aaf1a355), W64LIT(0x2626be262dd4f298), W64LIT(0xb3b345b3f18d3ef6),
        W64LIT(0x545419549ae5b14d), W64LIT(0x1e1e661ef0445a78), W64LIT(0x19197d19c8564f64), W64LIT(0x1f1f631ff8425d7c),
        W64LIT(0x2222aa220dccee88), W64LIT(0x03030f03180a090c), W64LIT(0x464643460a89cf05), W64LIT(0x3d3dc93df58eb3f4),
        W64LIT(0x2d2d992d75eec3b4), W64LIT(0x4a4a7f4a6aa1eb35), W64LIT(0x53530253a2f7a451), W64LIT(0x8383b5836c2dae36),
        W64LIT(0x13135f13986a794c), W64LIT(0x8a8a988a241b9112), W64LIT(0xb7b751b7d19522e6), W64LIT(0xd5d5a6d5e6c41173),
        W64LIT(0x2525b12535defb94), W64LIT(0x79798079ef0b72f9), W64LIT(0xf5f506f5fb04f1f3), W64LIT(0xbdbd73bd81a914ce),
        W64LIT(0x58582558facd957d), W64LIT(0x2f2f932f65e2cdbc), W64LIT(0x0d0d390d682e2334), W64LIT(0x02020a02100c0e08),
        W64LIT(0xeded7eed3b54b993), W64LIT(0x51510851b2fbaa59), W64LIT(0x9e9edc9e8463fd42), W64LIT(0x1111551188667744),
        W64LIT(0xf2f21df2c316e4ef), W64LIT(0x3e3ec63eed84baf8), W64LIT(0x55551c5592e3b649), W64LIT(0x5e5e3b5ecad98765),
        W64LIT(0xd1d1b2d1c6dc0d63), W64LIT(0x16164e16b0746258), W64LIT(0x3c3ccc3cfd88b4f0), W64LIT(0x6666e36617492f85),
        W64LIT(0x7070ad70a73d4ddd), W64LIT(0x5d5d345dd2d38e69), W64LIT(0xf3f318f3cb10e3eb), W64LIT(0x45454c451283c609),
        W64LIT(0x40405d403a9ddd1d), W64LIT(0xccccdbcc2e925e17), W64LIT(0xe8e86fe8134aa287), W64LIT(0x9494fe94d45fcb6a),
        W64LIT(0x565613568ae9bf45), W64LIT(0x0808280840303820), W64LIT(0xceced1ce3e9e501f), W64LIT(0x1a1a721ad05c4668),
        W64LIT(0x3a3ad23acd9ca6e8), W64LIT(0xd2d2bdd2ded6046f), W64LIT(0xe1e142e15b7c9da3), W64LIT(0xdfdf84dfb6f8275b),
        W64LIT(0xb5b55bb5c1992cee), W64LIT(0x3838d838dd90a8e0), W64LIT(0x6e6ecb6e577917a5), W64LIT(0x0e0e360e70242a38),
        W64LIT(0xe5e556e57b6481b3), W64LIT(0xf4f403f4f302f6f7), W64LIT(0xf9f93af99b2cd5c3), W64LIT(0x8686a4864433b522),
        W64LIT(0xe9e96ae91b4ca583), W64LIT(0x4f4f6e4f42bff021), W64LIT(0xd6d6a9d6fece187f), W64LIT(0x8585ab855c39bc2e),
        W64LIT(0x2323af2305cae98c), W64LIT(0xcfcfd4cf3698571b), W64LIT(0x3232fa328dac9ec8), W64LIT(0x9999c799bc71e85e),
        W64LIT(0x3131f53195a697c4), W64LIT(0x14144414a0786c50), W64LIT(0xaeae2cae19c36d82), W64LIT(0xeeee71ee235eb09f),
        W64LIT(0xc8c8cfc80e8a4207), W64LIT(0x484875487aade53d), W64LIT(0xd3d3b8d3d6d0036b), W64LIT(0x3030f0309da090c0),
        W64LIT(0xa1a11fa161e140be), W64LIT(0x9292e092e44bd972), W64LIT(0x41415841329bda19), W64LIT(0xb1b14fb1e18130fe),
        W64LIT(0x18187818c0504860), W64LIT(0xc4c4f3c46ea26637), W64LIT(0x2c2c9c2c7de8c4b0), W64LIT(0x7171a871af3b4ad9),
        W64LIT(0x7272a772b73143d5), W64LIT(0x444449441a85c10d), W64LIT(0x15154115a87e6b54), W64LIT(0xfdfd2efdbb34c9d3),
        W64LIT(0x3737eb37a5b285dc), W64LIT(0xbebe7cbe99a31dc2), W64LIT(0x5f5f3e5fc2df8061), W64LIT(0xaaaa38aa39db7192),
        W64LIT(0x9b9bcd9bac7de656), W64LIT(0x8888928834179f1a), W64LIT(0xd8d89fd88eea3247), W64LIT(0xabab3dab31dd7696),
        W64LIT(0x898997893c11981e), W64LIT(0x9c9cd69c946ff34a), W64LIT(0xfafa35fa8326dccf), W64LIT(0x6060fd60275d3d9d),
        W64LIT(0xeaea65ea0346ac8f), W64LIT(0xbcbc76bc89af13ca), W64LIT(0x6262f76237513395), W64LIT(0x0c0c3c0c60282430),
        W64LIT(0x2424b4243dd8fc90), W64LIT(0xa6a604a659f355a2), W64LIT(0xa8a832a829d77f9a), W64LIT(0xecec7bec3352be97),
        W64LIT(0x6767e6671f4f2881), W64LIT(0x2020a0201dc0e080), W64LIT(0xdbdb90db96e03b4b), W64LIT(0x7c7c917cc71569ed),
        W64LIT(0x282888285df0d8a0), W64LIT(0xdddd8edda6f42953), W64LIT(0xacac26ac09cf638a), W64LIT(0x5b5b2a5be2c79c71),
        W64LIT(0x3434e434bdb88cd0), W64LIT(0x7e7e9b7ed71967e5), W64LIT(0x1010501080607040), W64LIT(0xf1f112f1db1cede3),
        W64LIT(0x7b7b8a7bff077cf1), W64LIT(0x8f8f898f0c058a06), W64LIT(0x6363f2633f573491), W64LIT(0xa0a01aa069e747ba),
        W64LIT(0x05051105281e1b14), W64LIT(0x9a9ac89aa47be152), W64LIT(0x434352432297d411), W64LIT(0x7777b6779f2f58c1),
        W64LIT(0x2121a52115c6e784), W64LIT(0xbfbf79bf91a51ac6), W64LIT(0x2727bb2725d2f59c), W64LIT(0x09092d0948363f24),
        W64LIT(0xc3c3e8c356b0732b), W64LIT(0x9f9fd99f8c65fa46), W64LIT(0xb6b654b6d99325e2), W64LIT(0xd7d7acd7f6c81f7b),
        W64LIT(0x29298d2955f6dfa4), W64LIT(0xc2c2edc25eb6742f), W64LIT(0xebeb60eb0b40ab8b), W64LIT(0xc0c0e7c04eba7a27),
        W64LIT(0xa4a40ea449ff5baa), W64LIT(0x8b8b9d8b2c1d9616), W64LIT(0x8c8c868c140f830a), W64LIT(0x1d1d691de84e5374),
        W64LIT(0xfbfb30fb8b20dbcb), W64LIT(0xffff24ffab38c7db), W64LIT(0xc1c1e2c146bc7d23), W64LIT(0xb2b240b2f98b39f2),
        W64LIT(0x9797f197cc55c266), W64LIT(0x2e2e962e6de4cab8), W64LIT(0xf8f83ff8932ad2c7), W64LIT(0x6565ec650f432689),
        W64LIT(0xf6f609f6e30ef8ff), W64LIT(0x7575bc758f2356c9), W64LIT(0x07071b073812151c), W64LIT(0x0404140420181c10),
        W64LIT(0x4949704972abe239), W64LIT(0x3333ff3385aa99cc), W64LIT(0xe4e453e4736286b7), W64LIT(0xd9d99ad986ec3543),
        W64LIT(0xb9b967b9a1b108de), W64LIT(0xd0d0b7d0ceda0a67), W64LIT(0x424257422a91d315), W64LIT(0xc7c7fcc776a86f3b),
        W64LIT(0x6c6cc16c477519ad), W64LIT(0x9090ea90f447d77a), W64LIT(0x0000000000000000), W64LIT(0x8e8e8c8e04038d02),
        W64LIT(0x6f6fce6f5f7f10a1), W64LIT(0x50500d50bafdad5d), W64LIT(0x0101050108060704), W64LIT(0xc5c5f6c566a46133),
        W64LIT(0xdada95da9ee63c4f), W64LIT(0x47474647028fc801), W64LIT(0x3f3fc33fe582bdfc), W64LIT(0xcdcddecd26945913),
        W64LIT(0x6969d0696f6b02b9), W64LIT(0xa2a210a279eb49b2), W64LIT(0xe2e24de2437694af), W64LIT(0x7a7a8f7af7017bf5),
        W64LIT(0xa7a701a751f552a6), W64LIT(0xc6c6f9c67eae683f), W64LIT(0x9393e593ec4dde76), W64LIT(0x0f0f330f78222d3c),
        W64LIT(0x0a0a220a503c3628), W64LIT(0x06061e0630141218), W64LIT(0xe6e659e6636e88bf), W64LIT(0x2b2b872b45fad1ac),
        W64LIT(0x9696f496c453c562), W64LIT(0xa3a315a371ed4eb6), W64LIT(0x1c1c6c1ce0485470), W64LIT(0xafaf29af11c56a86),
        W64LIT(0x6a6adf6a77610bb5), W64LIT(0x12125a12906c7e48), W64LIT(0x8484ae84543fbb2a), W64LIT(0x3939dd39d596afe4),
        W64LIT(0xe7e75ce76b688fbb), W64LIT(0xb0b04ab0e98737fa), W64LIT(0x8282b082642ba932), W64LIT(0xf7f70cf7eb08fffb),
        W64LIT(0xfefe21fea33ec0df), W64LIT(0x9d9dd39d9c69f44e), W64LIT(0x8787a1874c35b226), W64LIT(0x5c5c315cdad5896d),
        W64LIT(0x8181bf817c21a03e), W64LIT(0x3535e135b5be8bd4), W64LIT(0xdede81debefe205f), W64LIT(0xb4b45eb4c99f2bea),
        W64LIT(0xa5a50ba541f95cae), W64LIT(0xfcfc2bfcb332ced7), W64LIT(0x8080ba807427a73a), W64LIT(0xefef74ef2b58b79b),
        W64LIT(0xcbcbc0cb16804b0b), W64LIT(0xbbbb6dbbb1bd06d6), W64LIT(0x6b6bda6b7f670cb1), W64LIT(0x7676b37697295fc5),
        W64LIT(0xbaba68bab9bb01d2), W64LIT(0x5a5a2f5aeac19b75), W64LIT(0x7d7d947dcf136ee9), W64LIT(0x78788578e70d75fd),
        W64LIT(0x0b0b270b583a312c), W64LIT(0x9595fb95dc59cc6e), W64LIT(0xe3e348e34b7093ab), W64LIT(0xadad23ad01c9648e),
        W64LIT(0x7474b974872551cd), W64LIT(0x9898c298b477ef5a), W64LIT(0x3b3bd73bc59aa1ec), W64LIT(0x3636ee36adb482d8),
        W64LIT(0x6464e9640745218d), W64LIT(0x6d6dc46d4f731ea9), W64LIT(0xdcdc8bdcaef22e57), W64LIT(0xf0f017f0d31aeae7),
        W64LIT(0x59592059f2cb9279), W64LIT(0xa9a937a921d1789e), W64LIT(0x4c4c614c5ab5f92d), W64LIT(0x17174b17b872655c),
        W64LIT(0x7f7f9e7fdf1f60e1), W64LIT(0x9191ef91fc41d07e), W64LIT(0xb8b862b8a9b70fda), W64LIT(0xc9c9cac9068c4503),
        W64LIT(0x5757165782efb841), W64LIT(0x1b1b771bd85a416c), W64LIT(0xe0e047e0537a9aa7), W64LIT(0x6161f8612f5b3a99)
    }
};

const word64 IT[8][256] =
{
    {
        W64LIT(0x7826942b9f5f8a9a), W64LIT(0x210f43c934970c53), W64LIT(0x5f028fdd9d0551b8), W64LIT(0x14facd82b494c83b),
        W64LIT(0x2b72ab886edd68c0), W64LIT(0xa6a87e5bff19d9b4), W64LIT(0xa29ae571db6443ea), W64LIT(0x039b2c911be8e5b6),
        W64LIT(0xd9275dcb5fd32cc6), W64LIT(0x10c856a890e95265), W64LIT(0x7d96e085b27ab85d), W64LIT(0x31c71561a47e5e36),
        W64LIT(0x74702455f3d83978), W64LIT(0xe8e048aafbad72f0), W64LIT(0x9b39db4437e03460), W64LIT(0x75f2cbd1fa8091e1),
        W64LIT(0x1ab5bee9caa336f6), W64LIT(0x8395a6b8eff34fb9), W64LIT(0x64b872fd63316b1d), W64LIT(0xe1068c7aba0ff3d5),
        W64LIT(0xeecb1095cd60a581), W64LIT(0xbc1dc0b235baef42), W64LIT(0xf04c355623be0929), W64LIT(0xb252b3d94b8d118f),
        W64LIT(0x18ac7dfcd8137bd9), W64LIT(0xbbb477090a2f90aa), W64LIT(0x8625d216c2d67d7e), W64LIT(0x66a1b1e871812632),
        W64LIT(0x6f4775383023a717), W64LIT(0x92df1f947642b545), W64LIT(0xe962a72ef2f5da69), W64LIT(0x8bf18deca7096605),
        W64LIT(0xc86de4e7c662d63a), W64LIT(0xaafece25939e6a56), W64LIT(0x5c99a34c86edb40e), W64LIT(0x52d6d027f8da4ac3),
        W64LIT(0x6b75ee12145e3d49), W64LIT(0x54fd8818ce179db2), W64LIT(0xa3180af5d23ceb73), W64LIT(0xbe0403a7270aa26d),
        W64LIT(0xfe03463d5d89f7e4), W64LIT(0xf1cedad22ae6a1b0), W64LIT(0xd143769f1729057a), W64LIT(0xc7a07808b10d806e),
        W64LIT(0xfc1a85284f39bacb), W64LIT(0xa4b1bd4eeda9949b), W64LIT(0x0bff07c55312cc0a), W64LIT(0xef49ff11c4380d18),
        W64LIT(0xc392e32295701a30), W64LIT(0x7f8f2390a0caf572), W64LIT(0x62932ac255fcbc6c), W64LIT(0xc9ef0b63cf3a7ea3),
        W64LIT(0xf9aaf186621c880c), W64LIT(0x818c65adfd430296), W64LIT(0x325c39f0bf96bb80), W64LIT(0x0c56b07e6c87b3e2),
        W64LIT(0x4bf8425f29919983), W64LIT(0xb5fb046274186e67), W64LIT(0x462c1da54c4e82f8), W64LIT(0x90c6dc8164f2f86a),
        W64LIT(0xf8281e026b442095), W64LIT(0x6af701961d0695d0), W64LIT(0x5766a489d5ff7804), W64LIT(0xf3d719c73856ec9f),
        W64LIT(0xad57799eac0b15be), W64LIT(0x1b37516dc3fb9e6f), W64LIT(0xc009cfb38e98ff86), W64LIT(0x9576a82f49d7caad),
        W64LIT(0xe6af3bc1859a8c3d), W64LIT(0x208dac4d3dcfa4ca), W64LIT(0x8ddad5d391c4b174), W64LIT(0x8e41f9428a2c54c2),
        W64LIT(0x6cdc59a92bcb42a1), W64LIT(0xe53417509e72698b), W64LIT(0xd0c1991b1e71ade3), W64LIT(0x8217493ce6abe720),
        W64LIT(0xd4f302313a0c37bd), W64LIT(0x5e806059945df921), W64LIT(0x73d993eecc4d4690), W64LIT(0xf5fc41f80e9b3bee),
        W64LIT(0x13537a398b01b7d3), W64LIT(0x53543fa3f182e25a), W64LIT(0x2d59f3b75810bfb1), W64LIT(0x35f58e4b8003c468),
        W64LIT(0x886aa17dbce183b3), W64LIT(0x4c51f5e41604e66b), W64LIT(0x98a2f7d52c08d1d6), W64LIT(0xa101c9e0c08ca65c),
        W64LIT(0x4007459a7a835589), W64LIT(0xcc5f7fcde21f4c64), W64LIT(0xa965e2b488768fe0), W64LIT(0x12d195bd82591f4a),
        W64LIT(0x2f4030a24aa0f29e), W64LIT(0x56e44b0ddca7d09d), W64LIT(0x914433056daa50f3), W64LIT(0x37ec4d5e92b38947),
        W64LIT(0xe31f4f6fa8bfbefa), W64LIT(0x50cf1332ea6a07ec), W64LIT(0x6d5eb62d2293ea38), W64LIT(0x09e6c4d041a28125),
        W64LIT(0x8fc316c68374fc5b), W64LIT(0x421e868f683318a6), W64LIT(0xe08463feb3575b4c), W64LIT(0x3821d1b1e5dcdf13),
        W64LIT(0xed503c04d6884037), W64LIT(0xd35ab58a05994855), W64LIT(0x976f6b3a5b678782), W64LIT(0x6ec59abc397b0f8e),
        W64LIT(0x5929d7e2abc886c9), W64LIT(0xa53352cae4f13c02), W64LIT(0x89e84ef9b5b92b2a), W64LIT(0x1761e113af7c2d8d),
        W64LIT(0x28e9871975358d76), W64LIT(0xdc97296572f61e01), W64LIT(0x67235e6c78d98eab), W64LIT(0x3d91a51fc8f9edd4),
        W64LIT(0x68eec2830fb6d8ff), W64LIT(0xfbb3329370acc523), W64LIT(0x062b583f36cdd771), W64LIT(0x15782206bdcc60a2),
        W64LIT(0x16e30e97a6248514), W64LIT(0x79a47baf96072203), W64LIT(0xf7e582ed1c2b76c1), W64LIT(0xde8eea706046532e),
        W64LIT(0xaf4eba8bbebb5891), W64LIT(0x08642b5448fa29bc), W64LIT(0x24bf376719b23e94), W64LIT(0x231680dc2627417c),
        W64LIT(0x0dd45ffa65df1b7b), W64LIT(0x1d1c0952f536491e), W64LIT(0xff81a9b954d15f7d), W64LIT(0x992018512550794f),
        W64LIT(0x71c050fbdefd0bbf), W64LIT(0xc18b203787c0571f), W64LIT(0x253dd8e310ea960d), W64LIT(0xeb7b643be0459746),
        W64LIT(0x0219c31512b04d2f), W64LIT(0xc43b5499aae565d8), W64LIT(0xeaf98bbfe91d3fdf), W64LIT(0x3a3812a4f76c923c),
        W64LIT(0x4dd31a601f5c4ef2), W64LIT(0xa8e70d30812e2779), W64LIT(0x800e8a29f41baa0f), W64LIT(0x1c9ee6d6fc6ee187),
        W64LIT(0x5d1b4cc88fb51c97), W64LIT(0x610806534e1459da), W64LIT(0xf255f643310e4406), W64LIT(0xd2d85a0e0cc1e0cc),
        W64LIT(0x0182ef840958a899), W64LIT(0x7e0dcc14a9925deb), W64LIT(0x653a9d796a69c384), W64LIT(0x4e4836f104b4ab44),
        W64LIT(0x4fcad9750dec03dd), W64LIT(0xcddd9049eb47e4fd), W64LIT(0x0e4f736b7e37fecd), W64LIT(0x4185aa1e73dbfd10),
        W64LIT(0x725b7c6ac515ee09), W64LIT(0x8a736268ae51ce9c), W64LIT(0xc5b9bb1da3bdcd41), W64LIT(0x7bbdb8ba84b76f2c),
        W64LIT(0xdabc715a443bc970), W64LIT(0xe29da0eba1e71663), W64LIT(0x935df0107f1a1ddc), W64LIT(0x608ae9d7474cf143),
        W64LIT(0xd571edb533549f24), W64LIT(0xa0832664c9d40ec5), W64LIT(0xfd986aac46611252), W64LIT(0x4435deb05efecfd7),
        W64LIT(0x0000000000000000), W64LIT(0x2cdb1c3351481728), W64LIT(0x94f447ab408f6234), W64LIT(0x45b7313457a6674e),
        W64LIT(0xb82f5b9811c7751c), W64LIT(0x8c583a57989c19ed), W64LIT(0xdd15c6e17baeb698), W64LIT(0x696c2d0706ee7066),
        W64LIT(0x3f88660ada49a0fb), W64LIT(0xf47eae7c07c39377), W64LIT(0x05b074ae2d2532c7), W64LIT(0xb3d05c5d42d5b916),
        W64LIT(0x39a33e35ec84778a), W64LIT(0x0fcd9cef776f5654), W64LIT(0xacd5961aa553bd27), W64LIT(0x5b3014f7b978cbe6),
        W64LIT(0x347761cf895b6cf1), W64LIT(0xc622978cb85528f7), W64LIT(0xb7e2c77766a82348), W64LIT(0x77eb08c4e830dcce),
        W64LIT(0xb9adb41c189fdd85), W64LIT(0x114ab92c99b1fafc), W64LIT(0x26a6f4720b0273bb), W64LIT(0x1e8725c3eedeaca8),
        W64LIT(0x2af0440c6785c059), W64LIT(0x04329b2a247d9a5e), W64LIT(0xd7682ea021e4d20b), W64LIT(0x7c140f01bb2210c4),
        W64LIT(0x96ed84be523f2f1b), W64LIT(0xca7427f2d4d29b15), W64LIT(0x47aef22145162a61), W64LIT(0xa72a91dff641712d),
        W64LIT(0x5ab2fb73b020637f), W64LIT(0xcbf6c876dd8a338c), W64LIT(0x6311c5465ca414f5), W64LIT(0x07a9b7bb3f957fe8),
        W64LIT(0xe72dd4458cc224a4), W64LIT(0x9d12837b012de311), W64LIT(0x843c1103d0663051), W64LIT(0x0a7de8415a4a6493),
        W64LIT(0xd6eac12428bc7a92), W64LIT(0x9c906cff08754b88), W64LIT(0x7042bf7fd7a5a326), W64LIT(0xbd9f2f363ce247db),
        W64LIT(0xb66028f36ff08bd1), W64LIT(0x192e9278d14bd340), W64LIT(0x9f0b406e139dae3e), W64LIT(0x1f05ca47e7860431),
        W64LIT(0x85befe87d93e98c8), W64LIT(0x439c690b616bb03f), W64LIT(0xba36988d03773833), W64LIT(0x87a73d92cb8ed5e7),
        W64LIT(0xaecc550fb7e3f008), W64LIT(0xc2100ca69c28b2a9), W64LIT(0x9abb34c03eb89cf9), W64LIT(0x49e1814a3b21d4ac),
        W64LIT(0xecd2d380dfd0e8ae), W64LIT(0x296b689d7c6d25ef), W64LIT(0x3c134a9bc1a1454d), W64LIT(0xcfc4535cf9f7a9d2),
        W64LIT(0x557f679cc74f352b), W64LIT(0xb479ebe67d40c6fe), W64LIT(0xf6676d691573de58), W64LIT(0x9e89afea1ac506a7),
        W64LIT(0xd8a5b24f568b845f), W64LIT(0x48636ece32797c35), W64LIT(0xdf0c05f4691efbb7), W64LIT(0xe4b6f8d4972ac112),
        W64LIT(0xfa31dd1779f46dba), W64LIT(0xbf86ec232e520af4), W64LIT(0x3e0a898ed3110862), W64LIT(0x7a3f573e8defc7b5),
        W64LIT(0x27241bf6025adb22), W64LIT(0x58ab3866a2902e50), W64LIT(0x3bbafd20fe343aa5), W64LIT(0x3045fae5ad26f6af),
        W64LIT(0x2ec2df2643f85a07), W64LIT(0x22946f582f7fe9e5), W64LIT(0x366ea2da9beb21de), W64LIT(0x4a7aaddb20c9311a),
        W64LIT(0xb1c99f485065f439), W64LIT(0xb04b70cc593d5ca0), W64LIT(0xab7c21a19ac6c2cf), W64LIT(0x33ded674b6ce1319),
        W64LIT(0xce46bcd8f0af014b), W64LIT(0xdb3e9ede4d6361e9), W64LIT(0x7669e740e1687457), W64LIT(0x514dfcb6e332af75)
    },
    {
        W64LIT(0x1f4f6fa8bfbefae3), W64LIT(0xf0440c6785c0592a), W64LIT(0x1dc0b235baef42bc), W64LIT(0x22978cb85528f7c6),
        W64LIT(0xcedad22ae6a1b0f1), W64LIT(0x180af5d23ceb73a3), W64LIT(0x946f582f7fe9e522), W64LIT(0xe44b0ddca7d09d56),
        W64LIT(0x906cff08754b889c), W64LIT(0x9f2f363ce247dbbd), W64LIT(0xa1b1e87181263266), W64LIT(0x21d1b1e5dcdf1338),
        W64LIT(0x31dd1779f46dbafa), W64LIT(0x4b70cc593d5ca0b0), W64LIT(0xd719c73856ec9ff3), W64LIT(0x8725c3eedeaca81e),
        W64LIT(0x71edb533549f24d5), W64LIT(0x12837b012de3119d), W64LIT(0x3dd8e310ea960d25), W64LIT(0x29d7e2abc886c959),
        W64LIT(0xb477090a2f90aabb), W64LIT(0x45fae5ad26f6af30), W64LIT(0x9ee6d6fc6ee1871c), W64LIT(0xbefe87d93e98c885),
        W64LIT(0xe30e97a624851416), W64LIT(0xd6d027f8da4ac352), W64LIT(0xcc550fb7e3f008ae), W64LIT(0x5ab58a05994855d3),
        W64LIT(0x806059945df9215e), W64LIT(0x82ef840958a89901), W64LIT(0x4ab92c99b1fafc11), W64LIT(0x281e026b442095f8),
        W64LIT(0x62a72ef2f5da69e9), W64LIT(0x8b203787c0571fc1), W64LIT(0x4f736b7e37fecd0e), W64LIT(0xab3866a2902e5058),
        W64LIT(0x6ea2da9beb21de36), W64LIT(0xf447ab408f623494), W64LIT(0x235e6c78d98eab67), W64LIT(0x11c5465ca414f563),
        W64LIT(0xd31a601f5c4ef24d), W64LIT(0xa2f7d52c08d1d698), W64LIT(0x85aa1e73dbfd1041), W64LIT(0xdc59a92bcb42a16c),
        W64LIT(0x59f3b75810bfb12d), W64LIT(0xe2c77766a82348b7), W64LIT(0xb9bb1da3bdcd41c5), W64LIT(0x96e085b27ab85d7d),
        W64LIT(0x99a34c86edb40e5c), W64LIT(0x66a489d5ff780457), W64LIT(0x95a6b8eff34fb983), W64LIT(0x7f679cc74f352b55),
        W64LIT(0x7de8415a4a64930a), W64LIT(0x9b2c911be8e5b603), W64LIT(0x4836f104b4ab444e), W64LIT(0xdb1c33514817282c),
        W64LIT(0x15c6e17baeb698dd), W64LIT(0xed84be523f2f1b96), W64LIT(0xe1814a3b21d4ac49), W64LIT(0x503c04d6884037ed),
        W64LIT(0x4c355623be0929f0), W64LIT(0x3b5499aae565d8c4), W64LIT(0x0a898ed31108623e), W64LIT(0xb074ae2d2532c705),
        W64LIT(0x028fdd9d0551b85f), W64LIT(0xf58e4b8003c46835), W64LIT(0x3352cae4f13c02a5), W64LIT(0x6c2d0706ee706669),
        W64LIT(0x7c21a19ac6c2cfab), W64LIT(0x19c31512b04d2f02), W64LIT(0xa6f4720b0273bb26), W64LIT(0x05ca47e78604311f),
        W64LIT(0x46bcd8f0af014bce), W64LIT(0x1e868f683318a642), W64LIT(0x5c39f0bf96bb8032), W64LIT(0x79ebe67d40c6feb4),
        W64LIT(0xff07c55312cc0a0b), W64LIT(0xaef22145162a6147), W64LIT(0xc1991b1e71ade3d0), W64LIT(0xded674b6ce131933),
        W64LIT(0x7aaddb20c9311a4a), W64LIT(0x4dfcb6e332af7551), W64LIT(0x6de4e7c662d63ac8), W64LIT(0xbf376719b23e9424),
        W64LIT(0x07459a7a83558940), W64LIT(0xac7dfcd8137bd918), W64LIT(0xdf1f947642b54592), W64LIT(0x17493ce6abe72082),
        W64LIT(0xfc41f80e9b3beef5), W64LIT(0xe70d30812e2779a8), W64LIT(0xd993eecc4d469073), W64LIT(0x65e2b488768fe0a9),
        W64LIT(0xd2d380dfd0e8aeec), W64LIT(0xe6c4d041a2812509), W64LIT(0x068c7aba0ff3d5e1), W64LIT(0x51f5e41604e66b4c),
        W64LIT(0x41f9428a2c54c28e), W64LIT(0x537a398b01b7d313), W64LIT(0x782206bdcc60a215), W64LIT(0x89afea1ac506a79e),
        W64LIT(0x8ae9d7474cf14360), W64LIT(0xf6c876dd8a338ccb), W64LIT(0x43769f1729057ad1), W64LIT(0x8dac4d3dcfa4ca20),
        W64LIT(0xb7313457a6674e45), W64LIT(0x2018512550794f99), W64LIT(0xbb34c03eb89cf99a), W64LIT(0xbafd20fe343aa53b),
        W64LIT(0x03463d5d89f7e4fe), W64LIT(0x42bf7fd7a5a32670), W64LIT(0x3f573e8defc7b57a), W64LIT(0xadb41c189fdd85b9),
        W64LIT(0xcad9750dec03dd4f), W64LIT(0x0f43c934970c5321), W64LIT(0x2f5b9811c7751cb8), W64LIT(0xd85a0e0cc1e0ccd2),
        W64LIT(0xe048aafbad72f0e8), W64LIT(0xf18deca70966058b), W64LIT(0xdd9049eb47e4fdcd), W64LIT(0xa87e5bff19d9b4a6),
        W64LIT(0x5df0107f1a1ddc93), W64LIT(0xd195bd82591f4a12), W64LIT(0x0c05f4691efbb7df), W64LIT(0x8463feb3575b4ce0),
        W64LIT(0x55f643310e4406f2), W64LIT(0xb6f8d4972ac112e4), W64LIT(0x4030a24aa0f29e2f), W64LIT(0xfd8818ce179db254),
        W64LIT(0x3c1103d066305184), W64LIT(0x682ea021e4d20bd7), W64LIT(0x81a9b954d15f7dff), W64LIT(0x275dcb5fd32cc6d9),
        W64LIT(0xfacd82b494c83b14), W64LIT(0x4433056daa50f391), W64LIT(0xe9871975358d7628), W64LIT(0xeac12428bc7a92d6),
        W64LIT(0x1a85284f39bacbfc), W64LIT(0xf8425f299199834b), W64LIT(0x676d691573de58f6), W64LIT(0xd05c5d42d5b916b3),
        W64LIT(0x8eea706046532ede), W64LIT(0xfb046274186e67b5), W64LIT(0x134a9bc1a1454d3c), W64LIT(0x57799eac0b15bead),
        W64LIT(0x241bf6025adb2227), W64LIT(0x72ab886edd68c02b), W64LIT(0x9ae571db6443eaa2), W64LIT(0xc050fbdefd0bbf71),
        W64LIT(0xa5b24f568b845fd8), W64LIT(0xe84ef9b5b92b2a89), W64LIT(0x6f6b3a5b67878297), W64LIT(0xc6dc8164f2f86a90),
        W64LIT(0x7eae7c07c39377f4), W64LIT(0x5eb62d2293ea386d), W64LIT(0x8c65adfd43029681), W64LIT(0x2dd4458cc224a4e7),
        W64LIT(0xfece25939e6a56aa), W64LIT(0xcd9cef776f56540f), W64LIT(0xa33e35ec84778a39), W64LIT(0xc2df2643f85a072e),
        W64LIT(0xbc715a443bc970da), W64LIT(0xa07808b10d806ec7), W64LIT(0x36988d03773833ba), W64LIT(0x1680dc2627417c23),
        W64LIT(0xcb1095cd60a581ee), W64LIT(0xbdb8ba84b76f2c7b), W64LIT(0x702455f3d8397874), W64LIT(0x35deb05efecfd744),
        W64LIT(0x8f2390a0caf5727f), W64LIT(0xb1bd4eeda9949ba4), W64LIT(0x39db4437e034609b), W64LIT(0xe582ed1c2b76c1f7),
        W64LIT(0xc4535cf9f7a9d2cf), W64LIT(0xb2fb73b020637f5a), W64LIT(0x583a57989c19ed8c), W64LIT(0x25d216c2d67d7e86),
        W64LIT(0x0806534e1459da61), W64LIT(0x6b689d7c6d25ef29), W64LIT(0x0dcc14a9925deb7e), W64LIT(0xc99f485065f439b1),
        W64LIT(0xa9b7bb3f957fe807), W64LIT(0x2a91dff641712da7), W64LIT(0x1c0952f536491e1d), W64LIT(0x75ee12145e3d496b),
        W64LIT(0xf98bbfe91d3fdfea), W64LIT(0x92e32295701a30c3), W64LIT(0x3e9ede4d6361e9db), W64LIT(0x76a82f49d7caad95),
        W64LIT(0x9da0eba1e71663e2), W64LIT(0x09cfb38e98ff86c0), W64LIT(0x9c690b616bb03f43), W64LIT(0xdad5d391c4b1748d),
        W64LIT(0x3812a4f76c923c3a), W64LIT(0x5f7fcde21f4c64cc), W64LIT(0x6aa17dbce183b388), W64LIT(0xeec2830fb6d8ff68),
        W64LIT(0x736268ae51ce9c8a), W64LIT(0xa47baf9607220379), W64LIT(0x543fa3f182e25a53), W64LIT(0x4eba8bbebb5891af),
        W64LIT(0x2e9278d14bd34019), W64LIT(0x69e740e168745776), W64LIT(0x37516dc3fb9e6f1b), W64LIT(0xb3329370acc523fb),
        W64LIT(0x3a9d796a69c38465), W64LIT(0x7761cf895b6cf134), W64LIT(0x0000000000000000), W64LIT(0x88660ada49a0fb3f),
        W64LIT(0xb5bee9caa336f61a), W64LIT(0x5b7c6ac515ee0972), W64LIT(0x52b3d94b8d118fb2), W64LIT(0x329b2a247d9a5e04),
        W64LIT(0x0e8a29f41baa0f80), W64LIT(0x642b5448fa29bc08), W64LIT(0x7b643be0459746eb), W64LIT(0xd45ffa65df1b7b0d),
        W64LIT(0xeb08c4e830dcce77), W64LIT(0xf2cbd1fa8091e175), W64LIT(0xf302313a0c37bdd4), W64LIT(0x91a51fc8f9edd43d),
        W64LIT(0xef0b63cf3a7ea3c9), W64LIT(0xc316c68374fc5b8f), W64LIT(0x01c9e0c08ca65ca1), W64LIT(0x3417509e72698be5),
        W64LIT(0x4775383023a7176f), W64LIT(0x636ece32797c3548), W64LIT(0x1b4cc88fb51c975d), W64LIT(0x140f01bb2210c47c),
        W64LIT(0x7427f2d4d29b15ca), W64LIT(0xa73d92cb8ed5e787), W64LIT(0xc71561a47e5e3631), W64LIT(0xaaf186621c880cf9),
        W64LIT(0x6028f36ff08bd1b6), W64LIT(0x97296572f61e01dc), W64LIT(0xc59abc397b0f8e6e), W64LIT(0xec4d5e92b3894737),
        W64LIT(0xb872fd63316b1d64), W64LIT(0xaf3bc1859a8c3de6), W64LIT(0x0403a7270aa26dbe), W64LIT(0x26942b9f5f8a9a78),
        W64LIT(0x86ec232e520af4bf), W64LIT(0x49ff11c4380d18ef), W64LIT(0xf701961d0695d06a), W64LIT(0x56b07e6c87b3e20c),
        W64LIT(0xd5961aa553bd27ac), W64LIT(0x61e113af7c2d8d17), W64LIT(0x100ca69c28b2a9c2), W64LIT(0xcf1332ea6a07ec50),
        W64LIT(0xc856a890e9526510), W64LIT(0x2b583f36cdd77106), W64LIT(0x932ac255fcbc6c62), W64LIT(0x0b406e139dae3e9f),
        W64LIT(0x832664c9d40ec5a0), W64LIT(0x3014f7b978cbe65b), W64LIT(0x2c1da54c4e82f846), W64LIT(0x986aac46611252fd)
    },
    {
        W64LIT(0x679cc74f352b557f), W64LIT(0x376719b23e9424bf), W64LIT(0xcc14a9925deb7e0d), W64LIT(0xb07e6c87b3e20c56),
        W64LIT(0xa17dbce183b3886a), W64LIT(0xee12145e3d496b75), W64LIT(0x406e139dae3e9f0b), W64LIT(0x942b9f5f8a9a7826),
        W64LIT(0xb24f568b845fd8a5), W64LIT(0xdf2643f85a072ec2), W64LIT(0x8c7aba0ff3d5e106), W64LIT(0x0b63cf3a7ea3c9ef),
        W64LIT(0x12a4f76c923c3a38), W64LIT(0x8bbfe91d3fdfeaf9), W64LIT(0x9278d14bd340192e), W64LIT(0xca47e78604311f05),
        W64LIT(0x07c55312cc0a0bff), W64LIT(0xcfb38e98ff86c009), W64LIT(0x991b1e71ade3d0c1), W64LIT(0x16c68374fc5b8fc3),
        W64LIT(0x39f0bf96bb80325c), W64LIT(0x3d92cb8ed5e787a7), W64LIT(0xac4d3dcfa4ca208d), W64LIT(0xfae5ad26f6af3045),
        W64LIT(0x63feb3575b4ce084), W64LIT(0x28f36ff08bd1b660), W64LIT(0xc6e17baeb698dd15), W64LIT(0x84be523f2f1b96ed),
        W64LIT(0x3c04d6884037ed50), W64LIT(0xce25939e6a56aafe), W64LIT(0xa34c86edb40e5c99), W64LIT(0xebe67d40c6feb479),
        W64LIT(0x27f2d4d29b15ca74), W64LIT(0x6d691573de58f667), W64LIT(0x329370acc523fbb3), W64LIT(0x2c911be8e5b6039b),
        W64LIT(0x871975358d7628e9), W64LIT(0x550fb7e3f008aecc), W64LIT(0x7e5bff19d9b4a6a8), W64LIT(0xf8d4972ac112e4b6),
        W64LIT(0xd1b1e5dcdf133821), W64LIT(0xfcb6e332af75514d), W64LIT(0x1e026b442095f828), W64LIT(0x1f947642b54592df),
        W64LIT(0x5e6c78d98eab6723), W64LIT(0x17509e72698be534), W64LIT(0x2ac255fcbc6c6293), W64LIT(0x95bd82591f4a12d1),
        W64LIT(0x799eac0b15bead57), W64LIT(0xf0107f1a1ddc935d), W64LIT(0xd674b6ce131933de), W64LIT(0xf5e41604e66b4c51),
        W64LIT(0x8818ce179db254fd), W64LIT(0x03a7270aa26dbe04), W64LIT(0x1c33514817282cdb), W64LIT(0x2f363ce247dbbd9f),
        W64LIT(0xa72ef2f5da69e962), W64LIT(0x93eecc4d469073d9), W64LIT(0xb92c99b1fafc114a), W64LIT(0x77090a2f90aabbb4),
        W64LIT(0x0ca69c28b2a9c210), W64LIT(0xc9e0c08ca65ca101), W64LIT(0x4b0ddca7d09d56e4), W64LIT(0x988d03773833ba36),
        W64LIT(0x06534e1459da6108), W64LIT(0x3a57989c19ed8c58), W64LIT(0x0952f536491e1d1c), W64LIT(0x0af5d23ceb73a318),
        W64LIT(0x0d30812e2779a8e7), W64LIT(0xd7e2abc886c95929), W64LIT(0xa51fc8f9edd43d91), W64LIT(0x690b616bb03f439c),
        W64LIT(0x516dc3fb9e6f1b37), W64LIT(0xa489d5ff78045766), W64LIT(0x52cae4f13c02a533), W64LIT(0x4cc88fb51c975d1b),
        W64LIT(0x459a7a8355894007), W64LIT(0x9d796a69c384653a), W64LIT(0x313457a6674e45b7), W64LIT(0x4a9bc1a1454d3c13),
        W64LIT(0x6268ae51ce9c8a73), W64LIT(0xfe87d93e98c885be), W64LIT(0xff11c4380d18ef49), W64LIT(0x8deca70966058bf1),
        W64LIT(0xdeb05efecfd74435), W64LIT(0xd027f8da4ac352d6), W64LIT(0xf186621c880cf9aa), W64LIT(0x43c934970c53210f),
        W64LIT(0xbee9caa336f61ab5), W64LIT(0x56a890e9526510c8), W64LIT(0xe8415a4a64930a7d), W64LIT(0xe32295701a30c392),
        W64LIT(0x3e35ec84778a39a3), W64LIT(0x4f6fa8bfbefae31f), W64LIT(0x5dcb5fd32cc6d927), W64LIT(0x9f485065f439b1c9),
        W64LIT(0x1095cd60a581eecb), W64LIT(0x978cb85528f7c622), W64LIT(0x7baf9607220379a4), W64LIT(0xd216c2d67d7e8625),
        W64LIT(0xe4e7c662d63ac86d), W64LIT(0xb62d2293ea386d5e), W64LIT(0x8a29f41baa0f800e), W64LIT(0x5ffa65df1b7b0dd4),
        W64LIT(0x61cf895b6cf13477), W64LIT(0xa6b8eff34fb98395), W64LIT(0x814a3b21d4ac49e1), W64LIT(0xaddb20c9311a4a7a),
        W64LIT(0x74ae2d2532c705b0), W64LIT(0x30a24aa0f29e2f40), W64LIT(0x91dff641712da72a), W64LIT(0x9049eb47e4fdcddd),
        W64LIT(0x493ce6abe7208217), W64LIT(0x36f104b4ab444e48), W64LIT(0xf22145162a6147ae), W64LIT(0x5c5d42d5b916b3d0),
        W64LIT(0xf7d52c08d1d698a2), W64LIT(0x7a398b01b7d31353), W64LIT(0x6cff08754b889c90), W64LIT(0x14f7b978cbe65b30),
        W64LIT(0xc4d041a2812509e6), W64LIT(0xe085b27ab85d7d96), W64LIT(0xc0b235baef42bc1d), W64LIT(0x868f683318a6421e),
        W64LIT(0xea706046532ede8e), W64LIT(0x4ef9b5b92b2a89e8), W64LIT(0xdc8164f2f86a90c6), W64LIT(0x2455f3d839787470),
        W64LIT(0x5499aae565d8c43b), W64LIT(0x59a92bcb42a16cdc), W64LIT(0xa9b954d15f7dff81), W64LIT(0xae7c07c39377f47e),
        W64LIT(0x01961d0695d06af7), W64LIT(0xdb4437e034609b39), W64LIT(0x3bc1859a8c3de6af), W64LIT(0xaa1e73dbfd104185),
        W64LIT(0x7dfcd8137bd918ac), W64LIT(0x80dc2627417c2316), W64LIT(0xd9750dec03dd4fca), W64LIT(0xc5465ca414f56311),
        W64LIT(0x203787c0571fc18b), W64LIT(0xd5d391c4b1748dda), W64LIT(0xc2830fb6d8ff68ee), W64LIT(0xbcd8f0af014bce46),
        W64LIT(0xa0eba1e71663e29d), W64LIT(0xfb73b020637f5ab2), W64LIT(0x7c6ac515ee09725b), W64LIT(0x0000000000000000),
        W64LIT(0xc876dd8a338ccbf6), W64LIT(0x9cef776f56540fcd), W64LIT(0x47ab408f623494f4), W64LIT(0xcbd1fa8091e175f2),
        W64LIT(0x9abc397b0f8e6ec5), W64LIT(0xb58a05994855d35a), W64LIT(0x4d5e92b3894737ec), W64LIT(0x961aa553bd27acd5),
        W64LIT(0xc31512b04d2f0219), W64LIT(0xe6d6fc6ee1871c9e), W64LIT(0xe2b488768fe0a965), W64LIT(0xb3d94b8d118fb252),
        W64LIT(0x440c6785c0592af0), W64LIT(0x25c3eedeaca81e87), W64LIT(0x583f36cdd771062b), W64LIT(0x2d0706ee7066696c),
        W64LIT(0x425f299199834bf8), W64LIT(0xfd20fe343aa53bba), W64LIT(0xf643310e4406f255), W64LIT(0xdad22ae6a1b0f1ce),
        W64LIT(0x1da54c4e82f8462c), W64LIT(0x355623be0929f04c), W64LIT(0x769f1729057ad143), W64LIT(0xbd4eeda9949ba4b1),
        W64LIT(0xd8e310ea960d253d), W64LIT(0x736b7e37fecd0e4f), W64LIT(0x65adfd430296818c), W64LIT(0xb8ba84b76f2c7bbd),
        W64LIT(0x9b2a247d9a5e0432), W64LIT(0xc77766a82348b7e2), W64LIT(0x08c4e830dcce77eb), W64LIT(0x0e97a624851416e3),
        W64LIT(0x898ed31108623e0a), W64LIT(0xe571db6443eaa29a), W64LIT(0x573e8defc7b57a3f), W64LIT(0x21a19ac6c2cfab7c),
        W64LIT(0x70cc593d5ca0b04b), W64LIT(0x2664c9d40ec5a083), W64LIT(0x296572f61e01dc97), W64LIT(0x85284f39bacbfc1a),
        W64LIT(0x715a443bc970dabc), W64LIT(0xef840958a8990182), W64LIT(0xcd82b494c83b14fa), W64LIT(0x48aafbad72f0e8e0),
        W64LIT(0xe9d7474cf143608a), W64LIT(0x2390a0caf5727f8f), W64LIT(0xb7bb3f957fe807a9), W64LIT(0x82ed1c2b76c1f7e5),
        W64LIT(0xbb1da3bdcd41c5b9), W64LIT(0x72fd63316b1d64b8), W64LIT(0x7808b10d806ec7a0), W64LIT(0x837b012de3119d12),
        W64LIT(0x689d7c6d25ef296b), W64LIT(0x02313a0c37bdd4f3), W64LIT(0x1103d0663051843c), W64LIT(0xab886edd68c02b72),
        W64LIT(0x6b3a5b678782976f), W64LIT(0xe113af7c2d8d1761), W64LIT(0x6aac46611252fd98), W64LIT(0x50fbdefd0bbf71c0),
        W64LIT(0x2ea021e4d20bd768), W64LIT(0x5a0e0cc1e0ccd2d8), W64LIT(0x34c03eb89cf99abb), W64LIT(0xb41c189fdd85b9ad),
        W64LIT(0x9ede4d6361e9db3e), W64LIT(0xafea1ac506a79e89), W64LIT(0x463d5d89f7e4fe03), W64LIT(0x18512550794f9920),
        W64LIT(0x41f80e9b3beef5fc), W64LIT(0xa82f49d7caad9576), W64LIT(0x0f01bb2210c47c14), W64LIT(0xec232e520af4bf86),
        W64LIT(0x1bf6025adb222724), W64LIT(0xa2da9beb21de366e), W64LIT(0xedb533549f24d571), W64LIT(0x643be0459746eb7b),
        W64LIT(0xbf7fd7a5a3267042), W64LIT(0x046274186e67b5fb), W64LIT(0x8e4b8003c46835f5), W64LIT(0x1332ea6a07ec50cf),
        W64LIT(0xd380dfd0e8aeecd2), W64LIT(0x6f582f7fe9e52294), W64LIT(0xf9428a2c54c28e41), W64LIT(0x3fa3f182e25a5354),
        W64LIT(0x535cf9f7a9d2cfc4), W64LIT(0x660ada49a0fb3f88), W64LIT(0x33056daa50f39144), W64LIT(0x8fdd9d0551b85f02),
        W64LIT(0x19c73856ec9ff3d7), W64LIT(0xb1e87181263266a1), W64LIT(0x1561a47e5e3631c7), W64LIT(0xd4458cc224a4e72d),
        W64LIT(0xe740e16874577669), W64LIT(0xc12428bc7a92d6ea), W64LIT(0x3866a2902e5058ab), W64LIT(0x1a601f5c4ef24dd3),
        W64LIT(0x6059945df9215e80), W64LIT(0x05f4691efbb7df0c), W64LIT(0x5b9811c7751cb82f), W64LIT(0x2b5448fa29bc0864),
        W64LIT(0xba8bbebb5891af4e), W64LIT(0xf4720b0273bb26a6), W64LIT(0xdd1779f46dbafa31), W64LIT(0x6ece32797c354863),
        W64LIT(0x7fcde21f4c64cc5f), W64LIT(0x2206bdcc60a21578), W64LIT(0x75383023a7176f47), W64LIT(0xf3b75810bfb12d59)
    },
    {
        W64LIT(0x03d0663051843c11), W64LIT(0xbfe91d3fdfeaf98b), W64LIT(0xf80e9b3beef5fc41), W64LIT(0xe5ad26f6af3045fa),
        W64LIT(0x5a443bc970dabc71), W64LIT(0x7b012de3119d1283), W64LIT(0x82b494c83b14facd), W64LIT(0x750dec03dd4fcad9),
        W64LIT(0x090a2f90aabbb477), W64LIT(0xb6e332af75514dfc), W64LIT(0xadfd430296818c65), W64LIT(0xfd63316b1d64b872),
        W64LIT(0x3d5d89f7e4fe0346), W64LIT(0xd7474cf143608ae9), W64LIT(0x7e6c87b3e20c56b0), W64LIT(0x601f5c4ef24dd31a),
        W64LIT(0x40e16874577669e7), W64LIT(0x4437e034609b39db), W64LIT(0xe7c662d63ac86de4), W64LIT(0xaf9607220379a47b),
        W64LIT(0xea1ac506a79e89af), W64LIT(0xd8f0af014bce46bc), W64LIT(0x7fd7a5a3267042bf), W64LIT(0x9f1729057ad14376),
        W64LIT(0x1c189fdd85b9adb4), W64LIT(0x87d93e98c885befe), W64LIT(0x57989c19ed8c583a), W64LIT(0xa4f76c923c3a3812),
        W64LIT(0x2a247d9a5e04329b), W64LIT(0xc03eb89cf99abb34), W64LIT(0xf6025adb2227241b), W64LIT(0xa890e9526510c856),
        W64LIT(0x06bdcc60a2157822), W64LIT(0xc73856ec9ff3d719), W64LIT(0xcae4f13c02a53352), W64LIT(0xd6fc6ee1871c9ee6),
        W64LIT(0xf0bf96bb80325c39), W64LIT(0x13af7c2d8d1761e1), W64LIT(0x3be0459746eb7b64), W64LIT(0x99aae565d8c43b54),
        W64LIT(0x95cd60a581eecb10), W64LIT(0x68ae51ce9c8a7362), W64LIT(0xcde21f4c64cc5f7f), W64LIT(0xdc2627417c231680),
        W64LIT(0x428a2c54c28e41f9), W64LIT(0x76dd8a338ccbf6c8), W64LIT(0xb8eff34fb98395a6), W64LIT(0xa69c28b2a9c2100c),
        W64LIT(0x08b10d806ec7a078), W64LIT(0xc55312cc0a0bff07), W64LIT(0x886edd68c02b72ab), W64LIT(0xdd9d0551b85f028f),
        W64LIT(0x1e73dbfd104185aa), W64LIT(0x911be8e5b6039b2c), W64LIT(0x30812e2779a8e70d), W64LIT(0x3a5b678782976f6b),
        W64LIT(0x20fe343aa53bbafd), W64LIT(0xb954d15f7dff81a9), W64LIT(0x9a7a835589400745), W64LIT(0x1fc8f9edd43d91a5),
        W64LIT(0x0e0cc1e0ccd2d85a), W64LIT(0xbb3f957fe807a9b7), W64LIT(0xc3eedeaca81e8725), W64LIT(0x66a2902e5058ab38),
        W64LIT(0xff08754b889c906c), W64LIT(0xfeb3575b4ce08463), W64LIT(0x107f1a1ddc935df0), W64LIT(0x25939e6a56aafece),
        W64LIT(0xa92bcb42a16cdc59), W64LIT(0x32ea6a07ec50cf13), W64LIT(0x947642b54592df1f), W64LIT(0x1779f46dbafa31dd),
        W64LIT(0x5623be0929f04c35), W64LIT(0xf2d4d29b15ca7427), W64LIT(0x59945df9215e8060), W64LIT(0x9370acc523fbb332),
        W64LIT(0xb05efecfd74435de), W64LIT(0x71db6443eaa29ae5), W64LIT(0xe2abc886c95929d7), W64LIT(0x458cc224a4e72dd4),
        W64LIT(0xce32797c3548636e), W64LIT(0x1aa553bd27acd596), W64LIT(0x4a3b21d4ac49e181), W64LIT(0x284f39bacbfc1a85),
        W64LIT(0xd94b8d118fb252b3), W64LIT(0xb235baef42bc1dc0), W64LIT(0x2643f85a072ec2df), W64LIT(0x8bbebb5891af4eba),
        W64LIT(0x89d5ff78045766a4), W64LIT(0xeecc4d469073d993), W64LIT(0x0b616bb03f439c69), W64LIT(0xe41604e66b4c51f5),
        W64LIT(0x16c2d67d7e8625d2), W64LIT(0x6c78d98eab67235e), W64LIT(0x9d7c6d25ef296b68), W64LIT(0x64c9d40ec5a08326),
        W64LIT(0x2ef2f5da69e962a7), W64LIT(0xfa65df1b7b0dd45f), W64LIT(0x12145e3d496b75ee), W64LIT(0xfcd8137bd918ac7d),
        W64LIT(0x52f536491e1d1c09), W64LIT(0xe67d40c6feb479eb), W64LIT(0x2145162a6147aef2), W64LIT(0x29f41baa0f800e8a),
        W64LIT(0x0000000000000000), W64LIT(0x840958a8990182ef), W64LIT(0xc88fb51c975d1b4c), W64LIT(0xc68374fc5b8fc316),
        W64LIT(0x5d42d5b916b3d05c), W64LIT(0x7dbce183b3886aa1), W64LIT(0x512550794f992018), W64LIT(0xe17baeb698dd15c6),
        W64LIT(0x43310e4406f255f6), W64LIT(0x6dc3fb9e6f1b3751), W64LIT(0x86621c880cf9aaf1), W64LIT(0xbc397b0f8e6ec59a),
        W64LIT(0x415a4a64930a7de8), W64LIT(0x04d6884037ed503c), W64LIT(0xe9caa336f61ab5be), W64LIT(0x0ada49a0fb3f8866),
        W64LIT(0x55f3d83978747024), W64LIT(0x3ce6abe720821749), W64LIT(0xf5d23ceb73a3180a), W64LIT(0xa24aa0f29e2f4030),
        W64LIT(0x582f7fe9e522946f), W64LIT(0x7aba0ff3d5e1068c), W64LIT(0x313a0c37bdd4f302), W64LIT(0x3787c0571fc18b20),
        W64LIT(0x5cf9f7a9d2cfc453), W64LIT(0xbe523f2f1b96ed84), W64LIT(0x85b27ab85d7d96e0), W64LIT(0x0706ee7066696c2d),
        W64LIT(0x961d0695d06af701), W64LIT(0x1b1e71ade3d0c199), W64LIT(0xc255fcbc6c62932a), W64LIT(0x398b01b7d313537a),
        W64LIT(0xcc593d5ca0b04b70), W64LIT(0x5f299199834bf842), W64LIT(0x80dfd0e8aeecd2d3), W64LIT(0x9eac0b15bead5779),
        W64LIT(0xef776f56540fcd9c), W64LIT(0x2f49d7caad9576a8), W64LIT(0x2c99b1fafc114ab9), W64LIT(0x8d03773833ba3698),
        W64LIT(0x720b0273bb26a6f4), W64LIT(0x18ce179db254fd88), W64LIT(0x8f683318a6421e86), W64LIT(0x4f568b845fd8a5b2),
        W64LIT(0x8ed31108623e0a89), W64LIT(0xd22ae6a1b0f1ceda), W64LIT(0x74b6ce131933ded6), W64LIT(0x97a624851416e30e),
        W64LIT(0x6e139dae3e9f0b40), W64LIT(0xa7270aa26dbe0403), W64LIT(0x5448fa29bc08642b), W64LIT(0xe310ea960d253dd8),
        W64LIT(0x706046532ede8eea), W64LIT(0x485065f439b1c99f), W64LIT(0x6b7e37fecd0e4f73), W64LIT(0xfbdefd0bbf71c050),
        W64LIT(0xd391c4b1748ddad5), W64LIT(0xa021e4d20bd7682e), W64LIT(0xab408f623494f447), W64LIT(0x5bff19d9b4a6a87e),
        W64LIT(0xb1e5dcdf133821d1), W64LIT(0x026b442095f8281e), W64LIT(0xdff641712da72a91), W64LIT(0x11c4380d18ef49ff),
        W64LIT(0xae2d2532c705b074), W64LIT(0xc1859a8c3de6af3b), W64LIT(0x4b8003c46835f58e), W64LIT(0x92cb8ed5e787a73d),
        W64LIT(0xcb5fd32cc6d9275d), W64LIT(0x8cb85528f7c62297), W64LIT(0x9bc1a1454d3c134a), W64LIT(0x056daa50f3914433),
        W64LIT(0xf4691efbb7df0c05), W64LIT(0xd1fa8091e175f2cb), W64LIT(0x7c07c39377f47eae), W64LIT(0x14a9925deb7e0dcc),
        W64LIT(0xcf895b6cf1347761), W64LIT(0x0fb7e3f008aecc55), W64LIT(0x8a05994855d35ab5), W64LIT(0xf104b4ab444e4836),
        W64LIT(0x691573de58f6676d), W64LIT(0x4eeda9949ba4b1bd), W64LIT(0x2428bc7a92d6eac1), W64LIT(0xb75810bfb12d59f3),
        W64LIT(0x63cf3a7ea3c9ef0b), W64LIT(0x6274186e67b5fb04), W64LIT(0x1512b04d2f0219c3), W64LIT(0xe87181263266a1b1),
        W64LIT(0x1975358d7628e987), W64LIT(0x534e1459da610806), W64LIT(0x47e78604311f05ca), W64LIT(0xd4972ac112e4b6f8),
        W64LIT(0x33514817282cdb1c), W64LIT(0x90a0caf5727f8f23), W64LIT(0x3e8defc7b57a3f57), W64LIT(0x3f36cdd771062b58),
        W64LIT(0x796a69c384653a9d), W64LIT(0x465ca414f56311c5), W64LIT(0x5e92b3894737ec4d), W64LIT(0x9811c7751cb82f5b),
        W64LIT(0xd041a2812509e6c4), W64LIT(0x49eb47e4fdcddd90), W64LIT(0x78d14bd340192e92), W64LIT(0xf9b5b92b2a89e84e),
        W64LIT(0x61a47e5e3631c715), W64LIT(0x509e72698be53417), W64LIT(0xb533549f24d571ed), W64LIT(0x27f8da4ac352d6d0),
        W64LIT(0x6572f61e01dc9729), W64LIT(0xde4d6361e9db3e9e), W64LIT(0x3457a6674e45b731), W64LIT(0xa54c4e82f8462c1d),
        W64LIT(0xbd82591f4a12d195), W64LIT(0x830fb6d8ff68eec2), W64LIT(0x383023a7176f4775), W64LIT(0x7766a82348b7e2c7),
        W64LIT(0x0c6785c0592af044), W64LIT(0xba84b76f2c7bbdb8), W64LIT(0xe0c08ca65ca101c9), W64LIT(0xeba1e71663e29da0),
        W64LIT(0xd52c08d1d698a2f7), W64LIT(0xc4e830dcce77eb08), W64LIT(0xda9beb21de366ea2), W64LIT(0xa3f182e25a53543f),
        W64LIT(0xac46611252fd986a), W64LIT(0xb38e98ff86c009cf), W64LIT(0xf36ff08bd1b66028), W64LIT(0xdb20c9311a4a7aad),
        W64LIT(0xa19ac6c2cfab7c21), W64LIT(0x6ac515ee09725b7c), W64LIT(0x4c86edb40e5c99a3), W64LIT(0x363ce247dbbd9f2f),
        W64LIT(0x8164f2f86a90c6dc), W64LIT(0x35ec84778a39a33e), W64LIT(0xb488768fe0a965e2), W64LIT(0x73b020637f5ab2fb),
        W64LIT(0x232e520af4bf86ec), W64LIT(0x6fa8bfbefae31f4f), W64LIT(0xeca70966058bf18d), W64LIT(0x1da3bdcd41c5b9bb),
        W64LIT(0x9cc74f352b557f67), W64LIT(0x4d3dcfa4ca208dac), W64LIT(0x2b9f5f8a9a782694), W64LIT(0xaafbad72f0e8e048),
        W64LIT(0xc934970c53210f43), W64LIT(0xed1c2b76c1f7e582), W64LIT(0x01bb2210c47c140f), W64LIT(0x0ddca7d09d56e44b),
        W64LIT(0x2d2293ea386d5eb6), W64LIT(0xf7b978cbe65b3014), W64LIT(0x6719b23e9424bf37), W64LIT(0x2295701a30c392e3)
    },
    {
        W64LIT(0x9f5f8a9a7826942b), W64LIT(0x34970c53210f43c9), W64LIT(0x9d0551b85f028fdd), W64LIT(0xb494c83b14facd82),
        W64LIT(0x6edd68c02b72ab88), W64LIT(0xff19d9b4a6a87e5b), W64LIT(0xdb6443eaa29ae571), W64LIT(0x1be8e5b6039b2c91),
        W64LIT(0x5fd32cc6d9275dcb), W64LIT(0x90e9526510c856a8), W64LIT(0xb27ab85d7d96e085), W64LIT(0xa47e5e3631c71561),
        W64LIT(0xf3d8397874702455), W64LIT(0xfbad72f0e8e048aa), W64LIT(0x37e034609b39db44), W64LIT(0xfa8091e175f2cbd1),
        W64LIT(0xcaa336f61ab5bee9), W64LIT(0xeff34fb98395a6b8), W64LIT(0x63316b1d64b872fd), W64LIT(0xba0ff3d5e1068c7a),
        W64LIT(0xcd60a581eecb1095), W64LIT(0x35baef42bc1dc0b2), W64LIT(0x23be0929f04c3556), W64LIT(0x4b8d118fb252b3d9),
        W64LIT(0xd8137bd918ac7dfc), W64LIT(0x0a2f90aabbb47709), W64LIT(0xc2d67d7e8625d216), W64LIT(0x7181263266a1b1e8),
        W64LIT(0x3023a7176f477538), W64LIT(0x7642b54592df1f94), W64LIT(0xf2f5da69e962a72e), W64LIT(0xa70966058bf18dec),
        W64LIT(0xc662d63ac86de4e7), W64LIT(0x939e6a56aafece25), W64LIT(0x86edb40e5c99a34c), W64LIT(0xf8da4ac352d6d027),
        W64LIT(0x145e3d496b75ee12), W64LIT(0xce179db254fd8818), W64LIT(0xd23ceb73a3180af5), W64LIT(0x270aa26dbe0403a7),
        W64LIT(0x5d89f7e4fe03463d), W64LIT(0x2ae6a1b0f1cedad2), W64LIT(0x1729057ad143769f), W64LIT(0xb10d806ec7a07808),
        W64LIT(0x4f39bacbfc1a8528), W64LIT(0xeda9949ba4b1bd4e), W64LIT(0x5312cc0a0bff07c5), W64LIT(0xc4380d18ef49ff11),
        W64LIT(0x95701a30c392e322), W64LIT(0xa0caf5727f8f2390), W64LIT(0x55fcbc6c62932ac2), W64LIT(0xcf3a7ea3c9ef0b63),
        W64LIT(0x621c880cf9aaf186), W64LIT(0xfd430296818c65ad), W64LIT(0xbf96bb80325c39f0), W64LIT(0x6c87b3e20c56b07e),
        W64LIT(0x299199834bf8425f), W64LIT(0x74186e67b5fb0462), W64LIT(0x4c4e82f8462c1da5), W64LIT(0x64f2f86a90c6dc81),
        W64LIT(0x6b442095f8281e02), W64LIT(0x1d0695d06af70196), W64LIT(0xd5ff78045766a489), W64LIT(0x3856ec9ff3d719c7),
        W64LIT(0xac0b15bead57799e), W64LIT(0xc3fb9e6f1b37516d), W64LIT(0x8e98ff86c009cfb3), W64LIT(0x49d7caad9576a82f),
        W64LIT(0x859a8c3de6af3bc1), W64LIT(0x3dcfa4ca208dac4d), W64LIT(0x91c4b1748ddad5d3), W64LIT(0x8a2c54c28e41f942),
        W64LIT(0x2bcb42a16cdc59a9), W64LIT(0x9e72698be5341750), W64LIT(0x1e71ade3d0c1991b), W64LIT(0xe6abe7208217493c),
        W64LIT(0x3a0c37bdd4f30231), W64LIT(0x945df9215e806059), W64LIT(0xcc4d469073d993ee), W64LIT(0x0e9b3beef5fc41f8),
        W64LIT(0x8b01b7d313537a39), W64LIT(0xf182e25a53543fa3), W64LIT(0x5810bfb12d59f3b7), W64LIT(0x8003c46835f58e4b),
        W64LIT(0xbce183b3886aa17d), W64LIT(0x1604e66b4c51f5e4), W64LIT(0x2c08d1d698a2f7d5), W64LIT(0xc08ca65ca101c9e0),
        W64LIT(0x7a8355894007459a), W64LIT(0xe21f4c64cc5f7fcd), W64LIT(0x88768fe0a965e2b4), W64LIT(0x82591f4a12d195bd),
        W64LIT(0x4aa0f29e2f4030a2), W64LIT(0xdca7d09d56e44b0d), W64LIT(0x6daa50f391443305), W64LIT(0x92b3894737ec4d5e),
        W64LIT(0xa8bfbefae31f4f6f), W64LIT(0xea6a07ec50cf1332), W64LIT(0x2293ea386d5eb62d), W64LIT(0x41a2812509e6c4d0),
        W64LIT(0x8374fc5b8fc316c6), W64LIT(0x683318a6421e868f), W64LIT(0xb3575b4ce08463fe), W64LIT(0xe5dcdf133821d1b1),
        W64LIT(0xd6884037ed503c04), W64LIT(0x05994855d35ab58a), W64LIT(0x5b678782976f6b3a), W64LIT(0x397b0f8e6ec59abc),
        W64LIT(0xabc886c95929d7e2), W64LIT(0xe4f13c02a53352ca), W64LIT(0xb5b92b2a89e84ef9), W64LIT(0xaf7c2d8d1761e113),
        W64LIT(0x75358d7628e98719), W64LIT(0x72f61e01dc972965), W64LIT(0x78d98eab67235e6c), W64LIT(0xc8f9edd43d91a51f),
        W64LIT(0x0fb6d8ff68eec283), W64LIT(0x70acc523fbb33293), W64LIT(0x36cdd771062b583f), W64LIT(0xbdcc60a215782206),
        W64LIT(0xa624851416e30e97), W64LIT(0x9607220379a47baf), W64LIT(0x1c2b76c1f7e582ed), W64LIT(0x6046532ede8eea70),
        W64LIT(0xbebb5891af4eba8b), W64LIT(0x48fa29bc08642b54), W64LIT(0x19b23e9424bf3767), W64LIT(0x2627417c231680dc),
        W64LIT(0x65df1b7b0dd45ffa), W64LIT(0xf536491e1d1c0952), W64LIT(0x54d15f7dff81a9b9), W64LIT(0x2550794f99201851),
        W64LIT(0xdefd0bbf71c050fb), W64LIT(0x87c0571fc18b2037), W64LIT(0x10ea960d253dd8e3), W64LIT(0xe0459746eb7b643b),
        W64LIT(0x12b04d2f0219c315), W64LIT(0xaae565d8c43b5499), W64LIT(0xe91d3fdfeaf98bbf), W64LIT(0xf76c923c3a3812a4),
        W64LIT(0x1f5c4ef24dd31a60), W64LIT(0x812e2779a8e70d30), W64LIT(0xf41baa0f800e8a29), W64LIT(0xfc6ee1871c9ee6d6),
        W64LIT(0x8fb51c975d1b4cc8), W64LIT(0x4e1459da61080653), W64LIT(0x310e4406f255f643), W64LIT(0x0cc1e0ccd2d85a0e),
        W64LIT(0x0958a8990182ef84), W64LIT(0xa9925deb7e0dcc14), W64LIT(0x6a69c384653a9d79), W64LIT(0x04b4ab444e4836f1),
        W64LIT(0x0dec03dd4fcad975), W64LIT(0xeb47e4fdcddd9049), W64LIT(0x7e37fecd0e4f736b), W64LIT(0x73dbfd104185aa1e),
        W64LIT(0xc515ee09725b7c6a), W64LIT(0xae51ce9c8a736268), W64LIT(0xa3bdcd41c5b9bb1d), W64LIT(0x84b76f2c7bbdb8ba),
        W64LIT(0x443bc970dabc715a), W64LIT(0xa1e71663e29da0eb), W64LIT(0x7f1a1ddc935df010), W64LIT(0x474cf143608ae9d7),
        W64LIT(0x33549f24d571edb5), W64LIT(0xc9d40ec5a0832664), W64LIT(0x46611252fd986aac), W64LIT(0x5efecfd74435deb0),
        W64LIT(0x0000000000000000), W64LIT(0x514817282cdb1c33), W64LIT(0x408f623494f447ab), W64LIT(0x57a6674e45b73134),
        W64LIT(0x11c7751cb82f5b98), W64LIT(0x989c19ed8c583a57), W64LIT(0x7baeb698dd15c6e1), W64LIT(0x06ee7066696c2d07),
        W64LIT(0xda49a0fb3f88660a), W64LIT(0x07c39377f47eae7c), W64LIT(0x2d2532c705b074ae), W64LIT(0x42d5b916b3d05c5d),
        W64LIT(0xec84778a39a33e35), W64LIT(0x776f56540fcd9cef), W64LIT(0xa553bd27acd5961a), W64LIT(0xb978cbe65b3014f7),
        W64LIT(0x895b6cf1347761cf), W64LIT(0xb85528f7c622978c), W64LIT(0x66a82348b7e2c777), W64LIT(0xe830dcce77eb08c4),
        W64LIT(0x189fdd85b9adb41c), W64LIT(0x99b1fafc114ab92c), W64LIT(0x0b0273bb26a6f472), W64LIT(0xeedeaca81e8725c3),
        W64LIT(0x6785c0592af0440c), W64LIT(0x247d9a5e04329b2a), W64LIT(0x21e4d20bd7682ea0), W64LIT(0xbb2210c47c140f01),
        W64LIT(0x523f2f1b96ed84be), W64LIT(0xd4d29b15ca7427f2), W64LIT(0x45162a6147aef221), W64LIT(0xf641712da72a91df),
        W64LIT(0xb020637f5ab2fb73), W64LIT(0xdd8a338ccbf6c876), W64LIT(0x5ca414f56311c546), W64LIT(0x3f957fe807a9b7bb),
        W64LIT(0x8cc224a4e72dd445), W64LIT(0x012de3119d12837b), W64LIT(0xd0663051843c1103), W64LIT(0x5a4a64930a7de841),
        W64LIT(0x28bc7a92d6eac124), W64LIT(0x08754b889c906cff), W64LIT(0xd7a5a3267042bf7f), W64LIT(0x3ce247dbbd9f2f36),
        W64LIT(0x6ff08bd1b66028f3), W64LIT(0xd14bd340192e9278), W64LIT(0x139dae3e9f0b406e), W64LIT(0xe78604311f05ca47),
        W64LIT(0xd93e98c885befe87), W64LIT(0x616bb03f439c690b), W64LIT(0x03773833ba36988d), W64LIT(0xcb8ed5e787a73d92),
        W64LIT(0xb7e3f008aecc550f), W64LIT(0x9c28b2a9c2100ca6), W64LIT(0x3eb89cf99abb34c0), W64LIT(0x3b21d4ac49e1814a),
        W64LIT(0xdfd0e8aeecd2d380), W64LIT(0x7c6d25ef296b689d), W64LIT(0xc1a1454d3c134a9b), W64LIT(0xf9f7a9d2cfc4535c),
        W64LIT(0xc74f352b557f679c), W64LIT(0x7d40c6feb479ebe6), W64LIT(0x1573de58f6676d69), W64LIT(0x1ac506a79e89afea),
        W64LIT(0x568b845fd8a5b24f), W64LIT(0x32797c3548636ece), W64LIT(0x691efbb7df0c05f4), W64LIT(0x972ac112e4b6f8d4),
        W64LIT(0x79f46dbafa31dd17), W64LIT(0x2e520af4bf86ec23), W64LIT(0xd31108623e0a898e), W64LIT(0x8defc7b57a3f573e),
        W64LIT(0x025adb2227241bf6), W64LIT(0xa2902e5058ab3866), W64LIT(0xfe343aa53bbafd20), W64LIT(0xad26f6af3045fae5),
        W64LIT(0x43f85a072ec2df26), W64LIT(0x2f7fe9e522946f58), W64LIT(0x9beb21de366ea2da), W64LIT(0x20c9311a4a7aaddb),
        W64LIT(0x5065f439b1c99f48), W64LIT(0x593d5ca0b04b70cc), W64LIT(0x9ac6c2cfab7c21a1), W64LIT(0xb6ce131933ded674),
        W64LIT(0xf0af014bce46bcd8), W64LIT(0x4d6361e9db3e9ede), W64LIT(0xe16874577669e740), W64LIT(0xe332af75514dfcb6)
    },
    {
        W64LIT(0xbfbefae31f4f6fa8), W64LIT(0x85c0592af0440c67), W64LIT(0xbaef42bc1dc0b235), W64LIT(0x5528f7c622978cb8),
        W64LIT(0xe6a1b0f1cedad22a), W64LIT(0x3ceb73a3180af5d2), W64LIT(0x7fe9e522946f582f), W64LIT(0xa7d09d56e44b0ddc),
        W64LIT(0x754b889c906cff08), W64LIT(0xe247dbbd9f2f363c), W64LIT(0x81263266a1b1e871), W64LIT(0xdcdf133821d1b1e5),
        W64LIT(0xf46dbafa31dd1779), W64LIT(0x3d5ca0b04b70cc59), W64LIT(0x56ec9ff3d719c738), W64LIT(0xdeaca81e8725c3ee),
        W64LIT(0x549f24d571edb533), W64LIT(0x2de3119d12837b01), W64LIT(0xea960d253dd8e310), W64LIT(0xc886c95929d7e2ab),
        W64LIT(0x2f90aabbb477090a), W64LIT(0x26f6af3045fae5ad), W64LIT(0x6ee1871c9ee6d6fc), W64LIT(0x3e98c885befe87d9),
        W64LIT(0x24851416e30e97a6), W64LIT(0xda4ac352d6d027f8), W64LIT(0xe3f008aecc550fb7), W64LIT(0x994855d35ab58a05),
        W64LIT(0x5df9215e80605994), W64LIT(0x58a8990182ef8409), W64LIT(0xb1fafc114ab92c99), W64LIT(0x442095f8281e026b),
        W64LIT(0xf5da69e962a72ef2), W64LIT(0xc0571fc18b203787), W64LIT(0x37fecd0e4f736b7e), W64LIT(0x902e5058ab3866a2),
        W64LIT(0xeb21de366ea2da9b), W64LIT(0x8f623494f447ab40), W64LIT(0xd98eab67235e6c78), W64LIT(0xa414f56311c5465c),
        W64LIT(0x5c4ef24dd31a601f), W64LIT(0x08d1d698a2f7d52c), W64LIT(0xdbfd104185aa1e73), W64LIT(0xcb42a16cdc59a92b),
        W64LIT(0x10bfb12d59f3b758), W64LIT(0xa82348b7e2c77766), W64LIT(0xbdcd41c5b9bb1da3), W64LIT(0x7ab85d7d96e085b2),
        W64LIT(0xedb40e5c99a34c86), W64LIT(0xff78045766a489d5), W64LIT(0xf34fb98395a6b8ef), W64LIT(0x4f352b557f679cc7),
        W64LIT(0x4a64930a7de8415a), W64LIT(0xe8e5b6039b2c911b), W64LIT(0xb4ab444e4836f104), W64LIT(0x4817282cdb1c3351),
        W64LIT(0xaeb698dd15c6e17b), W64LIT(0x3f2f1b96ed84be52), W64LIT(0x21d4ac49e1814a3b), W64LIT(0x884037ed503c04d6),
        W64LIT(0xbe0929f04c355623), W64LIT(0xe565d8c43b5499aa), W64LIT(0x1108623e0a898ed3), W64LIT(0x2532c705b074ae2d),
        W64LIT(0x0551b85f028fdd9d), W64LIT(0x03c46835f58e4b80), W64LIT(0xf13c02a53352cae4), W64LIT(0xee7066696c2d0706),
        W64LIT(0xc6c2cfab7c21a19a), W64LIT(0xb04d2f0219c31512), W64LIT(0x0273bb26a6f4720b), W64LIT(0x8604311f05ca47e7),
        W64LIT(0xaf014bce46bcd8f0), W64LIT(0x3318a6421e868f68), W64LIT(0x96bb80325c39f0bf), W64LIT(0x40c6feb479ebe67d),
        W64LIT(0x12cc0a0bff07c553), W64LIT(0x162a6147aef22145), W64LIT(0x71ade3d0c1991b1e), W64LIT(0xce131933ded674b6),
        W64LIT(0xc9311a4a7aaddb20), W64LIT(0x32af75514dfcb6e3), W64LIT(0x62d63ac86de4e7c6), W64LIT(0xb23e9424bf376719),
        W64LIT(0x8355894007459a7a), W64LIT(0x137bd918ac7dfcd8), W64LIT(0x42b54592df1f9476), W64LIT(0xabe7208217493ce6),
        W64LIT(0x9b3beef5fc41f80e), W64LIT(0x2e2779a8e70d3081), W64LIT(0x4d469073d993eecc), W64LIT(0x768fe0a965e2b488),
        W64LIT(0xd0e8aeecd2d380df), W64LIT(0xa2812509e6c4d041), W64LIT(0x0ff3d5e1068c7aba), W64LIT(0x04e66b4c51f5e416),
        W64LIT(0x2c54c28e41f9428a), W64LIT(0x01b7d313537a398b), W64LIT(0xcc60a215782206bd), W64LIT(0xc506a79e89afea1a),
        W64LIT(0x4cf143608ae9d747), W64LIT(0x8a338ccbf6c876dd), W64LIT(0x29057ad143769f17), W64LIT(0xcfa4ca208dac4d3d),
        W64LIT(0xa6674e45b7313457), W64LIT(0x50794f9920185125), W64LIT(0xb89cf99abb34c03e), W64LIT(0x343aa53bbafd20fe),
        W64LIT(0x89f7e4fe03463d5d), W64LIT(0xa5a3267042bf7fd7), W64LIT(0xefc7b57a3f573e8d), W64LIT(0x9fdd85b9adb41c18),
        W64LIT(0xec03dd4fcad9750d), W64LIT(0x970c53210f43c934), W64LIT(0xc7751cb82f5b9811), W64LIT(0xc1e0ccd2d85a0e0c),
        W64LIT(0xad72f0e8e048aafb), W64LIT(0x0966058bf18deca7), W64LIT(0x47e4fdcddd9049eb), W64LIT(0x19d9b4a6a87e5bff),
        W64LIT(0x1a1ddc935df0107f), W64LIT(0x591f4a12d195bd82), W64LIT(0x1efbb7df0c05f469), W64LIT(0x575b4ce08463feb3),
        W64LIT(0x0e4406f255f64331), W64LIT(0x2ac112e4b6f8d497), W64LIT(0xa0f29e2f4030a24a), W64LIT(0x179db254fd8818ce),
        W64LIT(0x663051843c1103d0), W64LIT(0xe4d20bd7682ea021), W64LIT(0xd15f7dff81a9b954), W64LIT(0xd32cc6d9275dcb5f),
        W64LIT(0x94c83b14facd82b4), W64LIT(0xaa50f3914433056d), W64LIT(0x358d7628e9871975), W64LIT(0xbc7a92d6eac12428),
        W64LIT(0x39bacbfc1a85284f), W64LIT(0x9199834bf8425f29), W64LIT(0x73de58f6676d6915), W64LIT(0xd5b916b3d05c5d42),
        W64LIT(0x46532ede8eea7060), W64LIT(0x186e67b5fb046274), W64LIT(0xa1454d3c134a9bc1), W64LIT(0x0b15bead57799eac),
        W64LIT(0x5adb2227241bf602), W64LIT(0xdd68c02b72ab886e), W64LIT(0x6443eaa29ae571db), W64LIT(0xfd0bbf71c050fbde),
        W64LIT(0x8b845fd8a5b24f56), W64LIT(0xb92b2a89e84ef9b5), W64LIT(0x678782976f6b3a5b), W64LIT(0xf2f86a90c6dc8164),
        W64LIT(0xc39377f47eae7c07), W64LIT(0x93ea386d5eb62d22), W64LIT(0x430296818c65adfd), W64LIT(0xc224a4e72dd4458c),
        W64LIT(0x9e6a56aafece2593), W64LIT(0x6f56540fcd9cef77), W64LIT(0x84778a39a33e35ec), W64LIT(0xf85a072ec2df2643),
        W64LIT(0x3bc970dabc715a44), W64LIT(0x0d806ec7a07808b1), W64LIT(0x773833ba36988d03), W64LIT(0x27417c231680dc26),
        W64LIT(0x60a581eecb1095cd), W64LIT(0xb76f2c7bbdb8ba84), W64LIT(0xd8397874702455f3), W64LIT(0xfecfd74435deb05e),
        W64LIT(0xcaf5727f8f2390a0), W64LIT(0xa9949ba4b1bd4eed), W64LIT(0xe034609b39db4437), W64LIT(0x2b76c1f7e582ed1c),
        W64LIT(0xf7a9d2cfc4535cf9), W64LIT(0x20637f5ab2fb73b0), W64LIT(0x9c19ed8c583a5798), W64LIT(0xd67d7e8625d216c2),
        W64LIT(0x1459da610806534e), W64LIT(0x6d25ef296b689d7c), W64LIT(0x925deb7e0dcc14a9), W64LIT(0x65f439b1c99f4850),
        W64LIT(0x957fe807a9b7bb3f), W64LIT(0x41712da72a91dff6), W64LIT(0x36491e1d1c0952f5), W64LIT(0x5e3d496b75ee1214),
        W64LIT(0x1d3fdfeaf98bbfe9), W64LIT(0x701a30c392e32295), W64LIT(0x6361e9db3e9ede4d), W64LIT(0xd7caad9576a82f49),
        W64LIT(0xe71663e29da0eba1), W64LIT(0x98ff86c009cfb38e), W64LIT(0x6bb03f439c690b61), W64LIT(0xc4b1748ddad5d391),
        W64LIT(0x6c923c3a3812a4f7), W64LIT(0x1f4c64cc5f7fcde2), W64LIT(0xe183b3886aa17dbc), W64LIT(0xb6d8ff68eec2830f),
        W64LIT(0x51ce9c8a736268ae), W64LIT(0x07220379a47baf96), W64LIT(0x82e25a53543fa3f1), W64LIT(0xbb5891af4eba8bbe),
        W64LIT(0x4bd340192e9278d1), W64LIT(0x6874577669e740e1), W64LIT(0xfb9e6f1b37516dc3), W64LIT(0xacc523fbb3329370),
        W64LIT(0x69c384653a9d796a), W64LIT(0x5b6cf1347761cf89), W64LIT(0x0000000000000000), W64LIT(0x49a0fb3f88660ada),
        W64LIT(0xa336f61ab5bee9ca), W64LIT(0x15ee09725b7c6ac5), W64LIT(0x8d118fb252b3d94b), W64LIT(0x7d9a5e04329b2a24),
        W64LIT(0x1baa0f800e8a29f4), W64LIT(0xfa29bc08642b5448), W64LIT(0x459746eb7b643be0), W64LIT(0xdf1b7b0dd45ffa65),
        W64LIT(0x30dcce77eb08c4e8), W64LIT(0x8091e175f2cbd1fa), W64LIT(0x0c37bdd4f302313a), W64LIT(0xf9edd43d91a51fc8),
        W64LIT(0x3a7ea3c9ef0b63cf), W64LIT(0x74fc5b8fc316c683), W64LIT(0x8ca65ca101c9e0c0), W64LIT(0x72698be53417509e),
        W64LIT(0x23a7176f47753830), W64LIT(0x797c3548636ece32), W64LIT(0xb51c975d1b4cc88f), W64LIT(0x2210c47c140f01bb),
        W64LIT(0xd29b15ca7427f2d4), W64LIT(0x8ed5e787a73d92cb), W64LIT(0x7e5e3631c71561a4), W64LIT(0x1c880cf9aaf18662),
        W64LIT(0xf08bd1b66028f36f), W64LIT(0xf61e01dc97296572), W64LIT(0x7b0f8e6ec59abc39), W64LIT(0xb3894737ec4d5e92),
        W64LIT(0x316b1d64b872fd63), W64LIT(0x9a8c3de6af3bc185), W64LIT(0x0aa26dbe0403a727), W64LIT(0x5f8a9a7826942b9f),
        W64LIT(0x520af4bf86ec232e), W64LIT(0x380d18ef49ff11c4), W64LIT(0x0695d06af701961d), W64LIT(0x87b3e20c56b07e6c),
        W64LIT(0x53bd27acd5961aa5), W64LIT(0x7c2d8d1761e113af), W64LIT(0x28b2a9c2100ca69c), W64LIT(0x6a07ec50cf1332ea),
        W64LIT(0xe9526510c856a890), W64LIT(0xcdd771062b583f36), W64LIT(0xfcbc6c62932ac255), W64LIT(0x9dae3e9f0b406e13),
        W64LIT(0xd40ec5a0832664c9), W64LIT(0x78cbe65b3014f7b9), W64LIT(0x4e82f8462c1da54c), W64LIT(0x611252fd986aac46)
    },
    {
        W64LIT(0x352b557f679cc74f), W64LIT(0x3e9424bf376719b2), W64LIT(0x5deb7e0dcc14a992), W64LIT(0xb3e20c56b07e6c87),
        W64LIT(0x83b3886aa17dbce1), W64LIT(0x3d496b75ee12145e), W64LIT(0xae3e9f0b406e139d), W64LIT(0x8a9a7826942b9f5f),
        W64LIT(0x845fd8a5b24f568b), W64LIT(0x5a072ec2df2643f8), W64LIT(0xf3d5e1068c7aba0f), W64LIT(0x7ea3c9ef0b63cf3a),
        W64LIT(0x923c3a3812a4f76c), W64LIT(0x3fdfeaf98bbfe91d), W64LIT(0xd340192e9278d14b), W64LIT(0x04311f05ca47e786),
        W64LIT(0xcc0a0bff07c55312), W64LIT(0xff86c009cfb38e98), W64LIT(0xade3d0c1991b1e71), W64LIT(0xfc5b8fc316c68374),
        W64LIT(0xbb80325c39f0bf96), W64LIT(0xd5e787a73d92cb8e), W64LIT(0xa4ca208dac4d3dcf), W64LIT(0xf6af3045fae5ad26),
        W64LIT(0x5b4ce08463feb357), W64LIT(0x8bd1b66028f36ff0), W64LIT(0xb698dd15c6e17bae), W64LIT(0x2f1b96ed84be523f),
        W64LIT(0x4037ed503c04d688), W64LIT(0x6a56aafece25939e), W64LIT(0xb40e5c99a34c86ed), W64LIT(0xc6feb479ebe67d40),
        W64LIT(0x9b15ca7427f2d4d2), W64LIT(0xde58f6676d691573), W64LIT(0xc523fbb3329370ac), W64LIT(0xe5b6039b2c911be8),
        W64LIT(0x8d7628e987197535), W64LIT(0xf008aecc550fb7e3), W64LIT(0xd9b4a6a87e5bff19), W64LIT(0xc112e4b6f8d4972a),
        W64LIT(0xdf133821d1b1e5dc), W64LIT(0xaf75514dfcb6e332), W64LIT(0x2095f8281e026b44), W64LIT(0xb54592df1f947642),
        W64LIT(0x8eab67235e6c78d9), W64LIT(0x698be53417509e72), W64LIT(0xbc6c62932ac255fc), W64LIT(0x1f4a12d195bd8259),
        W64LIT(0x15bead57799eac0b), W64LIT(0x1ddc935df0107f1a), W64LIT(0x131933ded674b6ce), W64LIT(0xe66b4c51f5e41604),
        W64LIT(0x9db254fd8818ce17), W64LIT(0xa26dbe0403a7270a), W64LIT(0x17282cdb1c335148), W64LIT(0x47dbbd9f2f363ce2),
        W64LIT(0xda69e962a72ef2f5), W64LIT(0x469073d993eecc4d), W64LIT(0xfafc114ab92c99b1), W64LIT(0x90aabbb477090a2f),
        W64LIT(0xb2a9c2100ca69c28), W64LIT(0xa65ca101c9e0c08c), W64LIT(0xd09d56e44b0ddca7), W64LIT(0x3833ba36988d0377),
        W64LIT(0x59da610806534e14), W64LIT(0x19ed8c583a57989c), W64LIT(0x491e1d1c0952f536), W64LIT(0xeb73a3180af5d23c),
        W64LIT(0x2779a8e70d30812e), W64LIT(0x86c95929d7e2abc8), W64LIT(0xedd43d91a51fc8f9), W64LIT(0xb03f439c690b616b),
        W64LIT(0x9e6f1b37516dc3fb), W64LIT(0x78045766a489d5ff), W64LIT(0x3c02a53352cae4f1), W64LIT(0x1c975d1b4cc88fb5),
        W64LIT(0x55894007459a7a83), W64LIT(0xc384653a9d796a69), W64LIT(0x674e45b7313457a6), W64LIT(0x454d3c134a9bc1a1),
        W64LIT(0xce9c8a736268ae51), W64LIT(0x98c885befe87d93e), W64LIT(0x0d18ef49ff11c438), W64LIT(0x66058bf18deca709),
        W64LIT(0xcfd74435deb05efe), W64LIT(0x4ac352d6d027f8da), W64LIT(0x880cf9aaf186621c), W64LIT(0x0c53210f43c93497),
        W64LIT(0x36f61ab5bee9caa3), W64LIT(0x526510c856a890e9), W64LIT(0x64930a7de8415a4a), W64LIT(0x1a30c392e3229570),
        W64LIT(0x778a39a33e35ec84), W64LIT(0xbefae31f4f6fa8bf), W64LIT(0x2cc6d9275dcb5fd3), W64LIT(0xf439b1c99f485065),
        W64LIT(0xa581eecb1095cd60), W64LIT(0x28f7c622978cb855), W64LIT(0x220379a47baf9607), W64LIT(0x7d7e8625d216c2d6),
        W64LIT(0xd63ac86de4e7c662), W64LIT(0xea386d5eb62d2293), W64LIT(0xaa0f800e8a29f41b), W64LIT(0x1b7b0dd45ffa65df),
        W64LIT(0x6cf1347761cf895b), W64LIT(0x4fb98395a6b8eff3), W64LIT(0xd4ac49e1814a3b21), W64LIT(0x311a4a7aaddb20c9),
        W64LIT(0x32c705b074ae2d25), W64LIT(0xf29e2f4030a24aa0), W64LIT(0x712da72a91dff641), W64LIT(0xe4fdcddd9049eb47),
        W64LIT(0xe7208217493ce6ab), W64LIT(0xab444e4836f104b4), W64LIT(0x2a6147aef2214516), W64LIT(0xb916b3d05c5d42d5),
        W64LIT(0xd1d698a2f7d52c08), W64LIT(0xb7d313537a398b01), W64LIT(0x4b889c906cff0875), W64LIT(0xcbe65b3014f7b978),
        W64LIT(0x812509e6c4d041a2), W64LIT(0xb85d7d96e085b27a), W64LIT(0xef42bc1dc0b235ba), W64LIT(0x18a6421e868f6833),
        W64LIT(0x532ede8eea706046), W64LIT(0x2b2a89e84ef9b5b9), W64LIT(0xf86a90c6dc8164f2), W64LIT(0x397874702455f3d8),
        W64LIT(0x65d8c43b5499aae5), W64LIT(0x42a16cdc59a92bcb), W64LIT(0x5f7dff81a9b954d1), W64LIT(0x9377f47eae7c07c3),
        W64LIT(0x95d06af701961d06), W64LIT(0x34609b39db4437e0), W64LIT(0x8c3de6af3bc1859a), W64LIT(0xfd104185aa1e73db),
        W64LIT(0x7bd918ac7dfcd813), W64LIT(0x417c231680dc2627), W64LIT(0x03dd4fcad9750dec), W64LIT(0x14f56311c5465ca4),
        W64LIT(0x571fc18b203787c0), W64LIT(0xb1748ddad5d391c4), W64LIT(0xd8ff68eec2830fb6), W64LIT(0x014bce46bcd8f0af),
        W64LIT(0x1663e29da0eba1e7), W64LIT(0x637f5ab2fb73b020), W64LIT(0xee09725b7c6ac515), W64LIT(0x0000000000000000),
        W64LIT(0x338ccbf6c876dd8a), W64LIT(0x56540fcd9cef776f), W64LIT(0x623494f447ab408f), W64LIT(0x91e175f2cbd1fa80),
        W64LIT(0x0f8e6ec59abc397b), W64LIT(0x4855d35ab58a0599), W64LIT(0x894737ec4d5e92b3), W64LIT(0xbd27acd5961aa553),
        W64LIT(0x4d2f0219c31512b0), W64LIT(0xe1871c9ee6d6fc6e), W64LIT(0x8fe0a965e2b48876), W64LIT(0x118fb252b3d94b8d),
        W64LIT(0xc0592af0440c6785), W64LIT(0xaca81e8725c3eede), W64LIT(0xd771062b583f36cd), W64LIT(0x7066696c2d0706ee),
        W64LIT(0x99834bf8425f2991), W64LIT(0x3aa53bbafd20fe34), W64LIT(0x4406f255f643310e), W64LIT(0xa1b0f1cedad22ae6),
        W64LIT(0x82f8462c1da54c4e), W64LIT(0x0929f04c355623be), W64LIT(0x057ad143769f1729), W64LIT(0x949ba4b1bd4eeda9),
        W64LIT(0x960d253dd8e310ea), W64LIT(0xfecd0e4f736b7e37), W64LIT(0x0296818c65adfd43), W64LIT(0x6f2c7bbdb8ba84b7),
        W64LIT(0x9a5e04329b2a247d), W64LIT(0x2348b7e2c77766a8), W64LIT(0xdcce77eb08c4e830), W64LIT(0x851416e30e97a624),
        W64LIT(0x08623e0a898ed311), W64LIT(0x43eaa29ae571db64), W64LIT(0xc7b57a3f573e8def), W64LIT(0xc2cfab7c21a19ac6),
        W64LIT(0x5ca0b04b70cc593d), W64LIT(0x0ec5a0832664c9d4), W64LIT(0x1e01dc97296572f6), W64LIT(0xbacbfc1a85284f39),
        W64LIT(0xc970dabc715a443b), W64LIT(0xa8990182ef840958), W64LIT(0xc83b14facd82b494), W64LIT(0x72f0e8e048aafbad),
        W64LIT(0xf143608ae9d7474c), W64LIT(0xf5727f8f2390a0ca), W64LIT(0x7fe807a9b7bb3f95), W64LIT(0x76c1f7e582ed1c2b),
        W64LIT(0xcd41c5b9bb1da3bd), W64LIT(0x6b1d64b872fd6331), W64LIT(0x806ec7a07808b10d), W64LIT(0xe3119d12837b012d),
        W64LIT(0x25ef296b689d7c6d), W64LIT(0x37bdd4f302313a0c), W64LIT(0x3051843c1103d066), W64LIT(0x68c02b72ab886edd),
        W64LIT(0x8782976f6b3a5b67), W64LIT(0x2d8d1761e113af7c), W64LIT(0x1252fd986aac4661), W64LIT(0x0bbf71c050fbdefd),
        W64LIT(0xd20bd7682ea021e4), W64LIT(0xe0ccd2d85a0e0cc1), W64LIT(0x9cf99abb34c03eb8), W64LIT(0xdd85b9adb41c189f),
        W64LIT(0x61e9db3e9ede4d63), W64LIT(0x06a79e89afea1ac5), W64LIT(0xf7e4fe03463d5d89), W64LIT(0x794f992018512550),
        W64LIT(0x3beef5fc41f80e9b), W64LIT(0xcaad9576a82f49d7), W64LIT(0x10c47c140f01bb22), W64LIT(0x0af4bf86ec232e52),
        W64LIT(0xdb2227241bf6025a), W64LIT(0x21de366ea2da9beb), W64LIT(0x9f24d571edb53354), W64LIT(0x9746eb7b643be045),
        W64LIT(0xa3267042bf7fd7a5), W64LIT(0x6e67b5fb04627418), W64LIT(0xc46835f58e4b8003), W64LIT(0x07ec50cf1332ea6a),
        W64LIT(0xe8aeecd2d380dfd0), W64LIT(0xe9e522946f582f7f), W64LIT(0x54c28e41f9428a2c), W64LIT(0xe25a53543fa3f182),
        W64LIT(0xa9d2cfc4535cf9f7), W64LIT(0xa0fb3f88660ada49), W64LIT(0x50f3914433056daa), W64LIT(0x51b85f028fdd9d05),
        W64LIT(0xec9ff3d719c73856), W64LIT(0x263266a1b1e87181), W64LIT(0x5e3631c71561a47e), W64LIT(0x24a4e72dd4458cc2),
        W64LIT(0x74577669e740e168), W64LIT(0x7a92d6eac12428bc), W64LIT(0x2e5058ab3866a290), W64LIT(0x4ef24dd31a601f5c),
        W64LIT(0xf9215e806059945d), W64LIT(0xfbb7df0c05f4691e), W64LIT(0x751cb82f5b9811c7), W64LIT(0x29bc08642b5448fa),
        W64LIT(0x5891af4eba8bbebb), W64LIT(0x73bb26a6f4720b02), W64LIT(0x6dbafa31dd1779f4), W64LIT(0x7c3548636ece3279),
        W64LIT(0x4c64cc5f7fcde21f), W64LIT(0x60a215782206bdcc), W64LIT(0xa7176f4775383023), W64LIT(0xbfb12d59f3b75810)
    },
    {
        W64LIT(0x51843c1103d06630), W64LIT(0xdfeaf98bbfe91d3f), W64LIT(0xeef5fc41f80e9b3b), W64LIT(0xaf3045fae5ad26f6),
            W64LIT(0x70dabc715a443bc9), W64LIT(0x119d12837b012de3), W64LIT(0x3b14facd82b494c8), W64LIT(0xdd4fcad9750dec03),
        W64LIT(0xaabbb477090a2f90), W64LIT(0x75514dfcb6e332af), W64LIT(0x96818c65adfd4302), W64LIT(0x1d64b872fd63316b),
        W64LIT(0xe4fe03463d5d89f7), W64LIT(0x43608ae9d7474cf1), W64LIT(0xe20c56b07e6c87b3), W64LIT(0xf24dd31a601f5c4e),
        W64LIT(0x577669e740e16874), W64LIT(0x609b39db4437e034), W64LIT(0x3ac86de4e7c662d6), W64LIT(0x0379a47baf960722),
        W64LIT(0xa79e89afea1ac506), W64LIT(0x4bce46bcd8f0af01), W64LIT(0x267042bf7fd7a5a3), W64LIT(0x7ad143769f172905),
        W64LIT(0x85b9adb41c189fdd), W64LIT(0xc885befe87d93e98), W64LIT(0xed8c583a57989c19), W64LIT(0x3c3a3812a4f76c92),
        W64LIT(0x5e04329b2a247d9a), W64LIT(0xf99abb34c03eb89c), W64LIT(0x2227241bf6025adb), W64LIT(0x6510c856a890e952),
        W64LIT(0xa215782206bdcc60), W64LIT(0x9ff3d719c73856ec), W64LIT(0x02a53352cae4f13c), W64LIT(0x871c9ee6d6fc6ee1),
        W64LIT(0x80325c39f0bf96bb), W64LIT(0x8d1761e113af7c2d), W64LIT(0x46eb7b643be04597), W64LIT(0xd8c43b5499aae565),
        W64LIT(0x81eecb1095cd60a5), W64LIT(0x9c8a736268ae51ce), W64LIT(0x64cc5f7fcde21f4c), W64LIT(0x7c231680dc262741),
        W64LIT(0xc28e41f9428a2c54), W64LIT(0x8ccbf6c876dd8a33), W64LIT(0xb98395a6b8eff34f), W64LIT(0xa9c2100ca69c28b2),
        W64LIT(0x6ec7a07808b10d80), W64LIT(0x0a0bff07c55312cc), W64LIT(0xc02b72ab886edd68), W64LIT(0xb85f028fdd9d0551),
        W64LIT(0x104185aa1e73dbfd), W64LIT(0xb6039b2c911be8e5), W64LIT(0x79a8e70d30812e27), W64LIT(0x82976f6b3a5b6787),
        W64LIT(0xa53bbafd20fe343a), W64LIT(0x7dff81a9b954d15f), W64LIT(0x894007459a7a8355), W64LIT(0xd43d91a51fc8f9ed),
        W64LIT(0xccd2d85a0e0cc1e0), W64LIT(0xe807a9b7bb3f957f), W64LIT(0xa81e8725c3eedeac), W64LIT(0x5058ab3866a2902e),
        W64LIT(0x889c906cff08754b), W64LIT(0x4ce08463feb3575b), W64LIT(0xdc935df0107f1a1d), W64LIT(0x56aafece25939e6a),
        W64LIT(0xa16cdc59a92bcb42), W64LIT(0xec50cf1332ea6a07), W64LIT(0x4592df1f947642b5), W64LIT(0xbafa31dd1779f46d),
        W64LIT(0x29f04c355623be09), W64LIT(0x15ca7427f2d4d29b), W64LIT(0x215e806059945df9), W64LIT(0x23fbb3329370acc5),
        W64LIT(0xd74435deb05efecf), W64LIT(0xeaa29ae571db6443), W64LIT(0xc95929d7e2abc886), W64LIT(0xa4e72dd4458cc224),
        W64LIT(0x3548636ece32797c), W64LIT(0x27acd5961aa553bd), W64LIT(0xac49e1814a3b21d4), W64LIT(0xcbfc1a85284f39ba),
        W64LIT(0x8fb252b3d94b8d11), W64LIT(0x42bc1dc0b235baef), W64LIT(0x072ec2df2643f85a), W64LIT(0x91af4eba8bbebb58),
        W64LIT(0x045766a489d5ff78), W64LIT(0x9073d993eecc4d46), W64LIT(0x3f439c690b616bb0), W64LIT(0x6b4c51f5e41604e6),
        W64LIT(0x7e8625d216c2d67d), W64LIT(0xab67235e6c78d98e), W64LIT(0xef296b689d7c6d25), W64LIT(0xc5a0832664c9d40e),
        W64LIT(0x69e962a72ef2f5da), W64LIT(0x7b0dd45ffa65df1b), W64LIT(0x496b75ee12145e3d), W64LIT(0xd918ac7dfcd8137b),
        W64LIT(0x1e1d1c0952f53649), W64LIT(0xfeb479ebe67d40c6), W64LIT(0x6147aef22145162a), W64LIT(0x0f800e8a29f41baa),
        W64LIT(0x0000000000000000), W64LIT(0x990182ef840958a8), W64LIT(0x975d1b4cc88fb51c), W64LIT(0x5b8fc316c68374fc),
        W64LIT(0x16b3d05c5d42d5b9), W64LIT(0xb3886aa17dbce183), W64LIT(0x4f99201851255079), W64LIT(0x98dd15c6e17baeb6),
        W64LIT(0x06f255f643310e44), W64LIT(0x6f1b37516dc3fb9e), W64LIT(0x0cf9aaf186621c88), W64LIT(0x8e6ec59abc397b0f),
        W64LIT(0x930a7de8415a4a64), W64LIT(0x37ed503c04d68840), W64LIT(0xf61ab5bee9caa336), W64LIT(0xfb3f88660ada49a0),
        W64LIT(0x7874702455f3d839), W64LIT(0x208217493ce6abe7), W64LIT(0x73a3180af5d23ceb), W64LIT(0x9e2f4030a24aa0f2),
        W64LIT(0xe522946f582f7fe9), W64LIT(0xd5e1068c7aba0ff3), W64LIT(0xbdd4f302313a0c37), W64LIT(0x1fc18b203787c057),
        W64LIT(0xd2cfc4535cf9f7a9), W64LIT(0x1b96ed84be523f2f), W64LIT(0x5d7d96e085b27ab8), W64LIT(0x66696c2d0706ee70),
        W64LIT(0xd06af701961d0695), W64LIT(0xe3d0c1991b1e71ad), W64LIT(0x6c62932ac255fcbc), W64LIT(0xd313537a398b01b7),
        W64LIT(0xa0b04b70cc593d5c), W64LIT(0x834bf8425f299199), W64LIT(0xaeecd2d380dfd0e8), W64LIT(0xbead57799eac0b15),
        W64LIT(0x540fcd9cef776f56), W64LIT(0xad9576a82f49d7ca), W64LIT(0xfc114ab92c99b1fa), W64LIT(0x33ba36988d037738),
        W64LIT(0xbb26a6f4720b0273), W64LIT(0xb254fd8818ce179d), W64LIT(0xa6421e868f683318), W64LIT(0x5fd8a5b24f568b84),
        W64LIT(0x623e0a898ed31108), W64LIT(0xb0f1cedad22ae6a1), W64LIT(0x1933ded674b6ce13), W64LIT(0x1416e30e97a62485),
        W64LIT(0x3e9f0b406e139dae), W64LIT(0x6dbe0403a7270aa2), W64LIT(0xbc08642b5448fa29), W64LIT(0x0d253dd8e310ea96),
        W64LIT(0x2ede8eea70604653), W64LIT(0x39b1c99f485065f4), W64LIT(0xcd0e4f736b7e37fe), W64LIT(0xbf71c050fbdefd0b),
        W64LIT(0x748ddad5d391c4b1), W64LIT(0x0bd7682ea021e4d2), W64LIT(0x3494f447ab408f62), W64LIT(0xb4a6a87e5bff19d9),
        W64LIT(0x133821d1b1e5dcdf), W64LIT(0x95f8281e026b4420), W64LIT(0x2da72a91dff64171), W64LIT(0x18ef49ff11c4380d),
        W64LIT(0xc705b074ae2d2532), W64LIT(0x3de6af3bc1859a8c), W64LIT(0x6835f58e4b8003c4), W64LIT(0xe787a73d92cb8ed5),
        W64LIT(0xc6d9275dcb5fd32c), W64LIT(0xf7c622978cb85528), W64LIT(0x4d3c134a9bc1a145), W64LIT(0xf3914433056daa50),
        W64LIT(0xb7df0c05f4691efb), W64LIT(0xe175f2cbd1fa8091), W64LIT(0x77f47eae7c07c393), W64LIT(0xeb7e0dcc14a9925d),
        W64LIT(0xf1347761cf895b6c), W64LIT(0x08aecc550fb7e3f0), W64LIT(0x55d35ab58a059948), W64LIT(0x444e4836f104b4ab),
        W64LIT(0x58f6676d691573de), W64LIT(0x9ba4b1bd4eeda994), W64LIT(0x92d6eac12428bc7a), W64LIT(0xb12d59f3b75810bf),
        W64LIT(0xa3c9ef0b63cf3a7e), W64LIT(0x67b5fb046274186e), W64LIT(0x2f0219c31512b04d), W64LIT(0x3266a1b1e8718126),
        W64LIT(0x7628e9871975358d), W64LIT(0xda610806534e1459), W64LIT(0x311f05ca47e78604), W64LIT(0x12e4b6f8d4972ac1),
        W64LIT(0x282cdb1c33514817), W64LIT(0x727f8f2390a0caf5), W64LIT(0xb57a3f573e8defc7), W64LIT(0x71062b583f36cdd7),
        W64LIT(0x84653a9d796a69c3), W64LIT(0xf56311c5465ca414), W64LIT(0x4737ec4d5e92b389), W64LIT(0x1cb82f5b9811c775),
        W64LIT(0x2509e6c4d041a281), W64LIT(0xfdcddd9049eb47e4), W64LIT(0x40192e9278d14bd3), W64LIT(0x2a89e84ef9b5b92b),
        W64LIT(0x3631c71561a47e5e), W64LIT(0x8be53417509e7269), W64LIT(0x24d571edb533549f), W64LIT(0xc352d6d027f8da4a),
        W64LIT(0x01dc97296572f61e), W64LIT(0xe9db3e9ede4d6361), W64LIT(0x4e45b7313457a667), W64LIT(0xf8462c1da54c4e82),
        W64LIT(0x4a12d195bd82591f), W64LIT(0xff68eec2830fb6d8), W64LIT(0x176f4775383023a7), W64LIT(0x48b7e2c77766a823),
        W64LIT(0x592af0440c6785c0), W64LIT(0x2c7bbdb8ba84b76f), W64LIT(0x5ca101c9e0c08ca6), W64LIT(0x63e29da0eba1e716),
        W64LIT(0xd698a2f7d52c08d1), W64LIT(0xce77eb08c4e830dc), W64LIT(0xde366ea2da9beb21), W64LIT(0x5a53543fa3f182e2),
        W64LIT(0x52fd986aac466112), W64LIT(0x86c009cfb38e98ff), W64LIT(0xd1b66028f36ff08b), W64LIT(0x1a4a7aaddb20c931),
        W64LIT(0xcfab7c21a19ac6c2), W64LIT(0x09725b7c6ac515ee), W64LIT(0x0e5c99a34c86edb4), W64LIT(0xdbbd9f2f363ce247),
        W64LIT(0x6a90c6dc8164f2f8), W64LIT(0x8a39a33e35ec8477), W64LIT(0xe0a965e2b488768f), W64LIT(0x7f5ab2fb73b02063),
        W64LIT(0xf4bf86ec232e520a), W64LIT(0xfae31f4f6fa8bfbe), W64LIT(0x058bf18deca70966), W64LIT(0x41c5b9bb1da3bdcd),
        W64LIT(0x2b557f679cc74f35), W64LIT(0xca208dac4d3dcfa4), W64LIT(0x9a7826942b9f5f8a), W64LIT(0xf0e8e048aafbad72),
        W64LIT(0x53210f43c934970c), W64LIT(0xc1f7e582ed1c2b76), W64LIT(0xc47c140f01bb2210), W64LIT(0x9d56e44b0ddca7d0),
        W64LIT(0x386d5eb62d2293ea), W64LIT(0xe65b3014f7b978cb), W64LIT(0x9424bf376719b23e), W64LIT(0x30c392e32295701a)
    }
};

const byte S[4][256] =
{
    {
        0xA8, 0x43, 0x5F, 0x06, 0x6B, 0x75, 0x6C, 0x59, 0x71, 0xDF, 0x87, 0x95, 0x17, 0xF0, 0xD8, 0x09,
        0x6D, 0xF3, 0x1D, 0xCB, 0xC9, 0x4D, 0x2C, 0xAF, 0x79, 0xE0, 0x97, 0xFD, 0x6F, 0x4B, 0x45, 0x39,
        0x3E, 0xDD, 0xA3, 0x4F, 0xB4, 0xB6, 0x9A, 0x0E, 0x1F, 0xBF, 0x15, 0xE1, 0x49, 0xD2, 0x93, 0xC6,
        0x92, 0x72, 0x9E, 0x61, 0xD1, 0x63, 0xFA, 0xEE, 0xF4, 0x19, 0xD5, 0xAD, 0x58, 0xA4, 0xBB, 0xA1,
        0xDC, 0xF2, 0x83, 0x37, 0x42, 0xE4, 0x7A, 0x32, 0x9C, 0xCC, 0xAB, 0x4A, 0x8F, 0x6E, 0x04, 0x27,
        0x2E, 0xE7, 0xE2, 0x5A, 0x96, 0x16, 0x23, 0x2B, 0xC2, 0x65, 0x66, 0x0F, 0xBC, 0xA9, 0x47, 0x41,
        0x34, 0x48, 0xFC, 0xB7, 0x6A, 0x88, 0xA5, 0x53, 0x86, 0xF9, 0x5B, 0xDB, 0x38, 0x7B, 0xC3, 0x1E,
        0x22, 0x33, 0x24, 0x28, 0x36, 0xC7, 0xB2, 0x3B, 0x8E, 0x77, 0xBA, 0xF5, 0x14, 0x9F, 0x08, 0x55,
        0x9B, 0x4C, 0xFE, 0x60, 0x5C, 0xDA, 0x18, 0x46, 0xCD, 0x7D, 0x21, 0xB0, 0x3F, 0x1B, 0x89, 0xFF,
        0xEB, 0x84, 0x69, 0x3A, 0x9D, 0xD7, 0xD3, 0x70, 0x67, 0x40, 0xB5, 0xDE, 0x5D, 0x30, 0x91, 0xB1,
        0x78, 0x11, 0x01, 0xE5, 0x00, 0x68, 0x98, 0xA0, 0xC5, 0x02, 0xA6, 0x74, 0x2D, 0x0B, 0xA2, 0x76,
        0xB3, 0xBE, 0xCE, 0xBD, 0xAE, 0xE9, 0x8A, 0x31, 0x1C, 0xEC, 0xF1, 0x99, 0x94, 0xAA, 0xF6, 0x26,
        0x2F, 0xEF, 0xE8, 0x8C, 0x35, 0x03, 0xD4, 0x7F, 0xFB, 0x05, 0xC1, 0x5E, 0x90, 0x20, 0x3D, 0x82,
        0xF7, 0xEA, 0x0A, 0x0D, 0x7E, 0xF8, 0x50, 0x1A, 0xC4, 0x07, 0x57, 0xB8, 0x3C, 0x62, 0xE3, 0xC8,
        0xAC, 0x52, 0x64, 0x10, 0xD0, 0xD9, 0x13, 0x0C, 0x12, 0x29, 0x51, 0xB9, 0xCF, 0xD6, 0x73, 0x8D,
        0x81, 0x54, 0xC0, 0xED, 0x4E, 0x44, 0xA7, 0x2A, 0x85, 0x25, 0xE6, 0xCA, 0x7C, 0x8B, 0x56, 0x80
    },
    {
        0xCE, 0xBB, 0xEB, 0x92, 0xEA, 0xCB, 0x13, 0xC1, 0xE9, 0x3A, 0xD6, 0xB2, 0xD2, 0x90, 0x17, 0xF8,
        0x42, 0x15, 0x56, 0xB4, 0x65, 0x1C, 0x88, 0x43, 0xC5, 0x5C, 0x36, 0xBA, 0xF5, 0x57, 0x67, 0x8D,
        0x31, 0xF6, 0x64, 0x58, 0x9E, 0xF4, 0x22, 0xAA, 0x75, 0x0F, 0x02, 0xB1, 0xDF, 0x6D, 0x73, 0x4D,
        0x7C, 0x26, 0x2E, 0xF7, 0x08, 0x5D, 0x44, 0x3E, 0x9F, 0x14, 0xC8, 0xAE, 0x54, 0x10, 0xD8, 0xBC,
        0x1A, 0x6B, 0x69, 0xF3, 0xBD, 0x33, 0xAB, 0xFA, 0xD1, 0x9B, 0x68, 0x4E, 0x16, 0x95, 0x91, 0xEE,
        0x4C, 0x63, 0x8E, 0x5B, 0xCC, 0x3C, 0x19, 0xA1, 0x81, 0x49, 0x7B, 0xD9, 0x6F, 0x37, 0x60, 0xCA,
        0xE7, 0x2B, 0x48, 0xFD, 0x96, 0x45, 0xFC, 0x41, 0x12, 0x0D, 0x79, 0xE5, 0x89, 0x8C, 0xE3, 0x20,
        0x30, 0xDC, 0xB7, 0x6C, 0x4A, 0xB5, 0x3F, 0x97, 0xD4, 0x62, 0x2D, 0x06, 0xA4, 0xA5, 0x83, 0x5F,
        0x2A, 0xDA, 0xC9, 0x00, 0x7E, 0xA2, 0x55, 0xBF, 0x11, 0xD5, 0x9C, 0xCF, 0x0E, 0x0A, 0x3D, 0x51,
        0x7D, 0x93, 0x1B, 0xFE, 0xC4, 0x47, 0x09, 0x86, 0x0B, 0x8F, 0x9D, 0x6A, 0x07, 0xB9, 0xB0, 0x98,
        0x18, 0x32, 0x71, 0x4B, 0xEF, 0x3B, 0x70, 0xA0, 0xE4, 0x40, 0xFF, 0xC3, 0xA9, 0xE6, 0x78, 0xF9,
        0x8B, 0x46, 0x80, 0x1E, 0x38, 0xE1, 0xB8, 0xA8, 0xE0, 0x0C, 0x23, 0x76, 0x1D, 0x25, 0x24, 0x05,
        0xF1, 0x6E, 0x94, 0x28, 0x9A, 0x84, 0xE8, 0xA3, 0x4F, 0x77, 0xD3, 0x85, 0xE2, 0x52, 0xF2, 0x82,
        0x50, 0x7A, 0x2F, 0x74, 0x53, 0xB3, 0x61, 0xAF, 0x39, 0x35, 0xDE, 0xCD, 0x1F, 0x99, 0xAC, 0xAD,
        0x72, 0x2C, 0xDD, 0xD0, 0x87, 0xBE, 0x5E, 0xA6, 0xEC, 0x04, 0xC6, 0x03, 0x34, 0xFB, 0xDB, 0x59,
        0xB6, 0xC2, 0x01, 0xF0, 0x5A, 0xED, 0xA7, 0x66, 0x21, 0x7F, 0x8A, 0x27, 0xC7, 0xC0, 0x29, 0xD7
    },
    {
        0x93, 0xD9, 0x9A, 0xB5, 0x98, 0x22, 0x45, 0xFC, 0xBA, 0x6A, 0xDF, 0x02, 0x9F, 0xDC, 0x51, 0x59,
        0x4A, 0x17, 0x2B, 0xC2, 0x94, 0xF4, 0xBB, 0xA3, 0x62, 0xE4, 0x71, 0xD4, 0xCD, 0x70, 0x16, 0xE1,
        0x49, 0x3C, 0xC0, 0xD8, 0x5C, 0x9B, 0xAD, 0x85, 0x53, 0xA1, 0x7A, 0xC8, 0x2D, 0xE0, 0xD1, 0x72,
        0xA6, 0x2C, 0xC4, 0xE3, 0x76, 0x78, 0xB7, 0xB4, 0x09, 0x3B, 0x0E, 0x41, 0x4C, 0xDE, 0xB2, 0x90,
        0x25, 0xA5, 0xD7, 0x03, 0x11, 0x00, 0xC3, 0x2E, 0x92, 0xEF, 0x4E, 0x12, 0x9D, 0x7D, 0xCB, 0x35,
        0x10, 0xD5, 0x4F, 0x9E, 0x4D, 0xA9, 0x55, 0xC6, 0xD0, 0x7B, 0x18, 0x97, 0xD3, 0x36, 0xE6, 0x48,
        0x56, 0x81, 0x8F, 0x77, 0xCC, 0x9C, 0xB9, 0xE2, 0xAC, 0xB8, 0x2F, 0x15, 0xA4, 0x7C, 0xDA, 0x38,
        0x1E, 0x0B, 0x05, 0xD6, 0x14, 0x6E, 0x6C, 0x7E, 0x66, 0xFD, 0xB1, 0xE5, 0x60, 0xAF, 0x5E, 0x33,
        0x87, 0xC9, 0xF0, 0x5D, 0x6D, 0x3F, 0x88, 0x8D, 0xC7, 0xF7, 0x1D, 0xE9, 0xEC, 0xED, 0x80, 0x29,
        0x27, 0xCF, 0x99, 0xA8, 0x50, 0x0F, 0x37, 0x24, 0x28, 0x30, 0x95, 0xD2, 0x3E, 0x5B, 0x40, 0x83,
        0xB3, 0x69, 0x57, 0x1F, 0x07, 0x1C, 0x8A, 0xBC, 0x20, 0xEB, 0xCE, 0x8E, 0xAB, 0xEE, 0x31, 0xA2,
        0x73, 0xF9, 0xCA, 0x3A, 0x1A, 0xFB, 0x0D, 0xC1, 0xFE, 0xFA, 0xF2, 0x6F, 0xBD, 0x96, 0xDD, 0x43,
        0x52, 0xB6, 0x08, 0xF3, 0xAE, 0xBE, 0x19, 0x89, 0x32, 0x26, 0xB0, 0xEA, 0x4B, 0x64, 0x84, 0x82,
        0x6B, 0xF5, 0x79, 0xBF, 0x01, 0x5F, 0x75, 0x63, 0x1B, 0x23, 0x3D, 0x68, 0x2A, 0x65, 0xE8, 0x91,
        0xF6, 0xFF, 0x13, 0x58, 0xF1, 0x47, 0x0A, 0x7F, 0xC5, 0xA7, 0xE7, 0x61, 0x5A, 0x06, 0x46, 0x44,
        0x42, 0x04, 0xA0, 0xDB, 0x39, 0x86, 0x54, 0xAA, 0x8C, 0x34, 0x21, 0x8B, 0xF8, 0x0C, 0x74, 0x67
    },
    {
        0x68, 0x8D, 0xCA, 0x4D, 0x73, 0x4B, 0x4E, 0x2A, 0xD4, 0x52, 0x26, 0xB3, 0x54, 0x1E, 0x19, 0x1F,
        0x22, 0x03, 0x46, 0x3D, 0x2D, 0x4A, 0x53, 0x83, 0x13, 0x8A, 0xB7, 0xD5, 0x25, 0x79, 0xF5, 0xBD,
        0x58, 0x2F, 0x0D, 0x02, 0xED, 0x51, 0x9E, 0x11, 0xF2, 0x3E, 0x55, 0x5E, 0xD1, 0x16, 0x3C, 0x66,
        0x70, 0x5D, 0xF3, 0x45, 0x40, 0xCC, 0xE8, 0x94, 0x56, 0x08, 0xCE, 0x1A, 0x3A, 0xD2, 0xE1, 0xDF,
        0xB5, 0x38, 0x6E, 0x0E, 0xE5, 0xF4, 0xF9, 0x86, 0xE9, 0x4F, 0xD6, 0x85, 0x23, 0xCF, 0x32, 0x99,
        0x31, 0x14, 0xAE, 0xEE, 0xC8, 0x48, 0xD3, 0x30, 0xA1, 0x92, 0x41, 0xB1, 0x18, 0xC4, 0x2C, 0x71,
        0x72, 0x44, 0x15, 0xFD, 0x37, 0xBE, 0x5F, 0xAA, 0x9B, 0x88, 0xD8, 0xAB, 0x89, 0x9C, 0xFA, 0x60,
        0xEA, 0xBC, 0x62, 0x0C, 0x24, 0xA6, 0xA8, 0xEC, 0x67, 0x20, 0xDB, 0x7C, 0x28, 0xDD, 0xAC, 0x5B,
        0x34, 0x7E, 0x10, 0xF1, 0x7B, 0x8F, 0x63, 0xA0, 0x05, 0x9A, 0x43, 0x77, 0x21, 0xBF, 0x27, 0x09,
        0xC3, 0x9F, 0xB6, 0xD7, 0x29, 0xC2, 0xEB, 0xC0, 0xA4, 0x8B, 0x8C, 0x1D, 0xFB, 0xFF, 0xC1, 0xB2,
        0x97, 0x2E, 0xF8, 0x65, 0xF6, 0x75, 0x07, 0x04, 0x49, 0x33, 0xE4, 0xD9, 0xB9, 0xD0, 0x42, 0xC7,
        0x6C, 0x90, 0x00, 0x8E, 0x6F, 0x50, 0x01, 0xC5, 0xDA, 0x47, 0x3F, 0xCD, 0x69, 0xA2, 0xE2, 0x7A,
        0xA7, 0xC6, 0x93, 0x0F, 0x0A, 0x06, 0xE6, 0x2B, 0x96, 0xA3, 0x1C, 0xAF, 0x6A, 0x12, 0x84, 0x39,
        0xE7, 0xB0, 0x82, 0xF7, 0xFE, 0x9D, 0x87, 0x5C, 0x81, 0x35, 0xDE, 0xB4, 0xA5, 0xFC, 0x80, 0xEF,
        0xCB, 0xBB, 0x6B, 0x76, 0xBA, 0x5A, 0x7D, 0x78, 0x0B, 0x95, 0xE3, 0xAD, 0x74, 0x98, 0x3B, 0x36,
        0x64, 0x6D, 0xDC, 0xF0, 0x59, 0xA9, 0x4C, 0x17, 0x7F, 0x91, 0xB8, 0xC9, 0x57, 0x1B, 0xE0, 0x61
    }
};

const byte IS[4][256] =
{
    {
        0xA4, 0xA2, 0xA9, 0xC5, 0x4E, 0xC9, 0x03, 0xD9, 0x7E, 0x0F, 0xD2, 0xAD, 0xE7, 0xD3, 0x27, 0x5B,
        0xE3, 0xA1, 0xE8, 0xE6, 0x7C, 0x2A, 0x55, 0x0C, 0x86, 0x39, 0xD7, 0x8D, 0xB8, 0x12, 0x6F, 0x28,
        0xCD, 0x8A, 0x70, 0x56, 0x72, 0xF9, 0xBF, 0x4F, 0x73, 0xE9, 0xF7, 0x57, 0x16, 0xAC, 0x50, 0xC0,
        0x9D, 0xB7, 0x47, 0x71, 0x60, 0xC4, 0x74, 0x43, 0x6C, 0x1F, 0x93, 0x77, 0xDC, 0xCE, 0x20, 0x8C,
        0x99, 0x5F, 0x44, 0x01, 0xF5, 0x1E, 0x87, 0x5E, 0x61, 0x2C, 0x4B, 0x1D, 0x81, 0x15, 0xF4, 0x23,
        0xD6, 0xEA, 0xE1, 0x67, 0xF1, 0x7F, 0xFE, 0xDA, 0x3C, 0x07, 0x53, 0x6A, 0x84, 0x9C, 0xCB, 0x02,
        0x83, 0x33, 0xDD, 0x35, 0xE2, 0x59, 0x5A, 0x98, 0xA5, 0x92, 0x64, 0x04, 0x06, 0x10, 0x4D, 0x1C,
        0x97, 0x08, 0x31, 0xEE, 0xAB, 0x05, 0xAF, 0x79, 0xA0, 0x18, 0x46, 0x6D, 0xFC, 0x89, 0xD4, 0xC7,
        0xFF, 0xF0, 0xCF, 0x42, 0x91, 0xF8, 0x68, 0x0A, 0x65, 0x8E, 0xB6, 0xFD, 0xC3, 0xEF, 0x78, 0x4C,
        0xCC, 0x9E, 0x30, 0x2E, 0xBC, 0x0B, 0x54, 0x1A, 0xA6, 0xBB, 0x26, 0x80, 0x48, 0x94, 0x32, 0x7D,
        0xA7, 0x3F, 0xAE, 0x22, 0x3D, 0x66, 0xAA, 0xF6, 0x00, 0x5D, 0xBD, 0x4A, 0xE0, 0x3B, 0xB4, 0x17,
        0x8B, 0x9F, 0x76, 0xB0, 0x24, 0x9A, 0x25, 0x63, 0xDB, 0xEB, 0x7A, 0x3E, 0x5C, 0xB3, 0xB1, 0x29,
        0xF2, 0xCA, 0x58, 0x6E, 0xD8, 0xA8, 0x2F, 0x75, 0xDF, 0x14, 0xFB, 0x13, 0x49, 0x88, 0xB2, 0xEC,
        0xE4, 0x34, 0x2D, 0x96, 0xC6, 0x3A, 0xED, 0x95, 0x0E, 0xE5, 0x85, 0x6B, 0x40, 0x21, 0x9B, 0x09,
        0x19, 0x2B, 0x52, 0xDE, 0x45, 0xA3, 0xFA, 0x51, 0xC2, 0xB5, 0xD1, 0x90, 0xB9, 0xF3, 0x37, 0xC1,
        0x0D, 0xBA, 0x41, 0x11, 0x38, 0x7B, 0xBE, 0xD0, 0xD5, 0x69, 0x36, 0xC8, 0x62, 0x1B, 0x82, 0x8F
    },
    {
        0x83, 0xF2, 0x2A, 0xEB, 0xE9, 0xBF, 0x7B, 0x9C, 0x34, 0x96, 0x8D, 0x98, 0xB9, 0x69, 0x8C, 0x29,
        0x3D, 0x88, 0x68, 0x06, 0x39, 0x11, 0x4C, 0x0E, 0xA0, 0x56, 0x40, 0x92, 0x15, 0xBC, 0xB3, 0xDC,
        0x6F, 0xF8, 0x26, 0xBA, 0xBE, 0xBD, 0x31, 0xFB, 0xC3, 0xFE, 0x80, 0x61, 0xE1, 0x7A, 0x32, 0xD2,
        0x70, 0x20, 0xA1, 0x45, 0xEC, 0xD9, 0x1A, 0x5D, 0xB4, 0xD8, 0x09, 0xA5, 0x55, 0x8E, 0x37, 0x76,
        0xA9, 0x67, 0x10, 0x17, 0x36, 0x65, 0xB1, 0x95, 0x62, 0x59, 0x74, 0xA3, 0x50, 0x2F, 0x4B, 0xC8,
        0xD0, 0x8F, 0xCD, 0xD4, 0x3C, 0x86, 0x12, 0x1D, 0x23, 0xEF, 0xF4, 0x53, 0x19, 0x35, 0xE6, 0x7F,
        0x5E, 0xD6, 0x79, 0x51, 0x22, 0x14, 0xF7, 0x1E, 0x4A, 0x42, 0x9B, 0x41, 0x73, 0x2D, 0xC1, 0x5C,
        0xA6, 0xA2, 0xE0, 0x2E, 0xD3, 0x28, 0xBB, 0xC9, 0xAE, 0x6A, 0xD1, 0x5A, 0x30, 0x90, 0x84, 0xF9,
        0xB2, 0x58, 0xCF, 0x7E, 0xC5, 0xCB, 0x97, 0xE4, 0x16, 0x6C, 0xFA, 0xB0, 0x6D, 0x1F, 0x52, 0x99,
        0x0D, 0x4E, 0x03, 0x91, 0xC2, 0x4D, 0x64, 0x77, 0x9F, 0xDD, 0xC4, 0x49, 0x8A, 0x9A, 0x24, 0x38,
        0xA7, 0x57, 0x85, 0xC7, 0x7C, 0x7D, 0xE7, 0xF6, 0xB7, 0xAC, 0x27, 0x46, 0xDE, 0xDF, 0x3B, 0xD7,
        0x9E, 0x2B, 0x0B, 0xD5, 0x13, 0x75, 0xF0, 0x72, 0xB6, 0x9D, 0x1B, 0x01, 0x3F, 0x44, 0xE5, 0x87,
        0xFD, 0x07, 0xF1, 0xAB, 0x94, 0x18, 0xEA, 0xFC, 0x3A, 0x82, 0x5F, 0x05, 0x54, 0xDB, 0x00, 0x8B,
        0xE3, 0x48, 0x0C, 0xCA, 0x78, 0x89, 0x0A, 0xFF, 0x3E, 0x5B, 0x81, 0xEE, 0x71, 0xE2, 0xDA, 0x2C,
        0xB8, 0xB5, 0xCC, 0x6E, 0xA8, 0x6B, 0xAD, 0x60, 0xC6, 0x08, 0x04, 0x02, 0xE8, 0xF5, 0x4F, 0xA4,
        0xF3, 0xC0, 0xCE, 0x43, 0x25, 0x1C, 0x21, 0x33, 0x0F, 0xAF, 0x47, 0xED, 0x66, 0x63, 0x93, 0xAA
    },
    {
        0x45, 0xD4, 0x0B, 0x43, 0xF1, 0x72, 0xED, 0xA4, 0xC2, 0x38, 0xE6, 0x71, 0xFD, 0xB6, 0x3A, 0x95,
        0x50, 0x44, 0x4B, 0xE2, 0x74, 0x6B, 0x1E, 0x11, 0x5A, 0xC6, 0xB4, 0xD8, 0xA5, 0x8A, 0x70, 0xA3,
        0xA8, 0xFA, 0x05, 0xD9, 0x97, 0x40, 0xC9, 0x90, 0x98, 0x8F, 0xDC, 0x12, 0x31, 0x2C, 0x47, 0x6A,
        0x99, 0xAE, 0xC8, 0x7F, 0xF9, 0x4F, 0x5D, 0x96, 0x6F, 0xF4, 0xB3, 0x39, 0x21, 0xDA, 0x9C, 0x85,
        0x9E, 0x3B, 0xF0, 0xBF, 0xEF, 0x06, 0xEE, 0xE5, 0x5F, 0x20, 0x10, 0xCC, 0x3C, 0x54, 0x4A, 0x52,
        0x94, 0x0E, 0xC0, 0x28, 0xF6, 0x56, 0x60, 0xA2, 0xE3, 0x0F, 0xEC, 0x9D, 0x24, 0x83, 0x7E, 0xD5,
        0x7C, 0xEB, 0x18, 0xD7, 0xCD, 0xDD, 0x78, 0xFF, 0xDB, 0xA1, 0x09, 0xD0, 0x76, 0x84, 0x75, 0xBB,
        0x1D, 0x1A, 0x2F, 0xB0, 0xFE, 0xD6, 0x34, 0x63, 0x35, 0xD2, 0x2A, 0x59, 0x6D, 0x4D, 0x77, 0xE7,
        0x8E, 0x61, 0xCF, 0x9F, 0xCE, 0x27, 0xF5, 0x80, 0x86, 0xC7, 0xA6, 0xFB, 0xF8, 0x87, 0xAB, 0x62,
        0x3F, 0xDF, 0x48, 0x00, 0x14, 0x9A, 0xBD, 0x5B, 0x04, 0x92, 0x02, 0x25, 0x65, 0x4C, 0x53, 0x0C,
        0xF2, 0x29, 0xAF, 0x17, 0x6C, 0x41, 0x30, 0xE9, 0x93, 0x55, 0xF7, 0xAC, 0x68, 0x26, 0xC4, 0x7D,
        0xCA, 0x7A, 0x3E, 0xA0, 0x37, 0x03, 0xC1, 0x36, 0x69, 0x66, 0x08, 0x16, 0xA7, 0xBC, 0xC5, 0xD3,
        0x22, 0xB7, 0x13, 0x46, 0x32, 0xE8, 0x57, 0x88, 0x2B, 0x81, 0xB2, 0x4E, 0x64, 0x1C, 0xAA, 0x91,
        0x58, 0x2E, 0x9B, 0x5C, 0x1B, 0x51, 0x73, 0x42, 0x23, 0x01, 0x6E, 0xF3, 0x0D, 0xBE, 0x3D, 0x0A,
        0x2D, 0x1F, 0x67, 0x33, 0x19, 0x7B, 0x5E, 0xEA, 0xDE, 0x8B, 0xCB, 0xA9, 0x8C, 0x8D, 0xAD, 0x49,
        0x82, 0xE4, 0xBA, 0xC3, 0x15, 0xD1, 0xE0, 0x89, 0xFC, 0xB1, 0xB9, 0xB5, 0x07, 0x79, 0xB8, 0xE1
    },
    {
        0xB2, 0xB6, 0x23, 0x11, 0xA7, 0x88, 0xC5, 0xA6, 0x39, 0x8F, 0xC4, 0xE8, 0x73, 0x22, 0x43, 0xC3,
        0x82, 0x27, 0xCD, 0x18, 0x51, 0x62, 0x2D, 0xF7, 0x5C, 0x0E, 0x3B, 0xFD, 0xCA, 0x9B, 0x0D, 0x0F,
        0x79, 0x8C, 0x10, 0x4C, 0x74, 0x1C, 0x0A, 0x8E, 0x7C, 0x94, 0x07, 0xC7, 0x5E, 0x14, 0xA1, 0x21,
        0x57, 0x50, 0x4E, 0xA9, 0x80, 0xD9, 0xEF, 0x64, 0x41, 0xCF, 0x3C, 0xEE, 0x2E, 0x13, 0x29, 0xBA,
        0x34, 0x5A, 0xAE, 0x8A, 0x61, 0x33, 0x12, 0xB9, 0x55, 0xA8, 0x15, 0x05, 0xF6, 0x03, 0x06, 0x49,
        0xB5, 0x25, 0x09, 0x16, 0x0C, 0x2A, 0x38, 0xFC, 0x20, 0xF4, 0xE5, 0x7F, 0xD7, 0x31, 0x2B, 0x66,
        0x6F, 0xFF, 0x72, 0x86, 0xF0, 0xA3, 0x2F, 0x78, 0x00, 0xBC, 0xCC, 0xE2, 0xB0, 0xF1, 0x42, 0xB4,
        0x30, 0x5F, 0x60, 0x04, 0xEC, 0xA5, 0xE3, 0x8B, 0xE7, 0x1D, 0xBF, 0x84, 0x7B, 0xE6, 0x81, 0xF8,
        0xDE, 0xD8, 0xD2, 0x17, 0xCE, 0x4B, 0x47, 0xD6, 0x69, 0x6C, 0x19, 0x99, 0x9A, 0x01, 0xB3, 0x85,
        0xB1, 0xF9, 0x59, 0xC2, 0x37, 0xE9, 0xC8, 0xA0, 0xED, 0x4F, 0x89, 0x68, 0x6D, 0xD5, 0x26, 0x91,
        0x87, 0x58, 0xBD, 0xC9, 0x98, 0xDC, 0x75, 0xC0, 0x76, 0xF5, 0x67, 0x6B, 0x7E, 0xEB, 0x52, 0xCB,
        0xD1, 0x5B, 0x9F, 0x0B, 0xDB, 0x40, 0x92, 0x1A, 0xFA, 0xAC, 0xE4, 0xE1, 0x71, 0x1F, 0x65, 0x8D,
        0x97, 0x9E, 0x95, 0x90, 0x5D, 0xB7, 0xC1, 0xAF, 0x54, 0xFB, 0x02, 0xE0, 0x35, 0xBB, 0x3A, 0x4D,
        0xAD, 0x2C, 0x3D, 0x56, 0x08, 0x1B, 0x4A, 0x93, 0x6A, 0xAB, 0xB8, 0x7A, 0xF2, 0x7D, 0xDA, 0x3F,
        0xFE, 0x3E, 0xBE, 0xEA, 0xAA, 0x44, 0xC6, 0xD0, 0x36, 0x48, 0x70, 0x96, 0x77, 0x24, 0x53, 0xDF,
        0xF3, 0x83, 0x28, 0x32, 0x45, 0x1E, 0xA4, 0xD3, 0xA2, 0x46, 0x6E, 0x9C, 0xDD, 0x63, 0xD4, 0x9D
    }
};

NAMESPACE_END
NAMESPACE_END
