/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef COMBOBOX_H
#define COMBOBOX_H

#include <QWidget>
#include <QComboBox>

#include "comboboxitem.h"
#include "nofocusframedelegate.h"
#include "libukcc_global.h"

class QListWidget;
class QListWidgetItem;

class LIBUKCC_EXPORT ComboBox : public QComboBox
{
    Q_OBJECT

public:
    explicit ComboBox(QWidget *parent = 0);
    ~ComboBox();

//    void setCurrentItem(QString text);
    void addwidgetItem(QString text);
    void removewidgetItems();
    void setcurrentwidgetIndex(int index);

private:
//    QString currentitemtext;

    QListWidget * partListWidget;

public slots:
//    void currentItemChanged(QListWidgetItem * current, QListWidgetItem * previous);
    void onChooseItem(QString text);

};

#endif // COMBOBOX_H
