/*
	file automatically generated by make_test_files.pl
	Sat Dec  3 13:38:53 2022
*/

/*****************************************************************************
 *                                                                           *
 *          UNU.RAN -- Universal Non-Uniform Random number generator         *
 *                                                                           *
 *****************************************************************************/
    
/**
 ** Tests for INFO
 **/
    
/*---------------------------------------------------------------------------*/
#include "testunuran.h"

#ifdef UNUR_URNG_DEFAULT_RNGSTREAM
#include <RngStream.h>
#endif
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* global variables                                                          */

static FILE *TESTLOG;               /* test log file                         */
static FILE *UNURANLOG;             /* unuran log file                       */

static int test_ok = TRUE;          /* all tests ok (boolean)                */
static int fullcheck = FALSE;       /* whether all checks are performed      */ 

static TIMER watch;                 /* stop watch                            */

/*---------------------------------------------------------------------------*/

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par );

int unur_info_set_verify( UNUR_PAR *par, int verify);


/*---------------------------------------------------------------------------*/

void test_new (void);
void test_set (void);
void test_get (void);
void test_chg (void);
void test_init (void);
void test_reinit (void);
void test_sample (void);
void test_validate (void);
void test_special(void);

/*---------------------------------------------------------------------------*/



/* prototypes */

/* CEXT: */
double exp1_sample(UNUR_GEN *gen);

/* DEXT: */
int geom12_sample(UNUR_GEN *gen);


#define COMPARE_SAMPLE_SIZE   (10000)
#define VIOLATE_SAMPLE_SIZE   (20)


/* macros for running info test */

#define INFO_TEST(genstr) \
   gen = unur_str2gen((genstr)); \
   fprintf(TESTLOG,"GEN  = \"%s\"\n",(genstr)); \
   fprintf(TESTLOG,"INFO = \n%s\n",unur_gen_info(gen,FALSE)); \
   fprintf(TESTLOG,"HELP = \n%s\n",unur_gen_info(gen,TRUE)); \
   fprintf(TESTLOG,"---------------------\n"); \
   unur_free(gen); gen = NULL;

#define INFO_TEST_chg(genstr,run_chg) \
   gen = unur_str2gen((genstr)); \
   run_chg; \
   fprintf(TESTLOG,"GEN  = \"%s\"\n",(genstr)); \
   fprintf(TESTLOG,"INFO = \n%s\n",unur_gen_info(gen,FALSE)); \
   fprintf(TESTLOG,"HELP = \n%s\n",unur_gen_info(gen,TRUE)); \
   fprintf(TESTLOG,"---------------------\n"); \
   unur_free(gen); gen = NULL;

#define METHOD(m) \
   printf("%s ",(m)); \
   fprintf(TESTLOG,"*********************\n"); \
   fprintf(TESTLOG,"* %s\n",(m)); \
   fprintf(TESTLOG,"*********************\n\n"); \
   fflush(stdout);

#define INFO_TEST_par(genstr,gen) \
   fprintf(TESTLOG,"GEN  = \"%s\"\n",(genstr)); \
   fprintf(TESTLOG,"INFO = \n%s\n",unur_gen_info((gen),FALSE)); \
   fprintf(TESTLOG,"HELP = \n%s\n",unur_gen_info((gen),TRUE)); \
   fprintf(TESTLOG,"---------------------\n"); \
   unur_free(gen); gen = NULL;





/*---------------------------------------------------------------------------*/

#ifndef CHI2_FAILURES_TOLERATED
#  define CHI2_FAILURES_TOLERATED DEFAULT_CHI2_FAILURES_TOLERATED
#endif

/*---------------------------------------------------------------------------*/
/* [verbatim] */




double exp1_sample(UNUR_GEN *gen) { 
	double U = unur_sample_urng(gen);
	return (-log(1. - U));
}


int geom12_sample(UNUR_GEN *gen) { 
	double U = unur_sample_urng(gen);
	return ((int) (log(U) / log(0.5)));
}

/*---------------------------------------------------------------------------*/
/* [new] */

void test_new (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[new "); fflush(stdout);
	fprintf(TESTLOG,"\n[new]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_new() */

/*---------------------------------------------------------------------------*/
/* [sample] */

void test_sample (void)
{
        int n_tests_failed;          /* number of failed tests */

	/* start test */
	printf("[sample "); fflush(stdout);
	fprintf(TESTLOG,"\n[sample]\n");

	/* reset counter */
	n_tests_failed = 0;

	/* set stop watch */
	stopwatch_lap(&watch);
  
{ /* set debugging flags */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

unur_set_default_debug(UNUR_DEBUG_INIT);
unur_free(gen);
}

{ /* AROU */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("AROU");
INFO_TEST("normal & method=arou");
INFO_TEST("normal & method=arou; max_segments=10; cpoints=3");
INFO_TEST("cont; pdf='exp(-x^2)' & method=arou; max_segments=1000");
INFO_TEST("cont; pdf='exp(-x^2)' & method=arou; max_segments=1000; max_sqhratio=0.90");
#endif
unur_free(gen);
}

{ /* ARS */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("ARS");
INFO_TEST("normal & method=ars");
INFO_TEST("normal & method=ars; cpoints=100");
INFO_TEST("cont; logpdf='-x^2' & method=ars");
#endif
unur_free(gen);
}

{ /* CEXT */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("CEXT");
distr = unur_distr_exponential(NULL,0);
par = unur_cext_new(distr);
unur_cext_set_sample(par,exp1_sample);
gen = unur_init(par);
INFO_TEST_par("... & method=cext",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* CSTD */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("CSTD");
INFO_TEST("normal & method=cstd");
INFO_TEST("normal & method=cstd; variant=0");
INFO_TEST("normal & method=cstd; variant=-1");
INFO_TEST("normal & method=cstd; variant=1");
INFO_TEST("normal & method=cstd; variant=2");
INFO_TEST("normal & method=cstd; variant=3");
#endif
unur_free(gen);
}

{ /* DARI */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DARI");
INFO_TEST("geometric(0.5) & method=dari");
INFO_TEST("binomial(20,0.5) & method=dari");
INFO_TEST("binomial(20,0.5) & method=dari;squeeze=on");
INFO_TEST("binomial(20,0.5) & method=dari;tablesize=0");
INFO_TEST("binomial(20,0.5) & method=dari;cpfactor=0.6");
INFO_TEST("discr; pmf='0.5^x';domain=(0,inf) & method=dari");
INFO_TEST("discr; pmf='2*0.5^x';domain=(1,inf) & method=dari");
#endif
unur_free(gen);
}

{ /* DAU */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DAU");
INFO_TEST("geometric(0.5) & method=dau");
INFO_TEST("geometric(0.5) & method=dau;urnfactor=2");
INFO_TEST("discr; pv=(.1,.2,.3,.4,.5,.6,.7) & method=dau");
#endif
unur_free(gen);
}

{ /* DGT */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DGT");
INFO_TEST("geometric(0.5) & method=dgt");
INFO_TEST("geometric(0.5) & method=dgt;guidefactor=2");
INFO_TEST("discr; pv=(.1,.2,.3,.4,.5,.6,.7) & method=dgt");
#endif
unur_free(gen);
}

{ /* DSROU */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DSROU");
INFO_TEST("geometric(0.5) & method=dsrou");
INFO_TEST("binomial(20,0.5) & method=dsrou;cdfatmode=0.5");
INFO_TEST("binomial(20,0.5) & method=dsrou");
INFO_TEST("discr; pmf='0.5^x';domain=(0,inf);pmfsum=2 & method=dsrou");
INFO_TEST("discr; pmf='2*0.5^x';domain=(1,inf);pmfsum=2 & method=dsrou");
#endif
unur_free(gen);
}

{ /* DSS */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DSS");
INFO_TEST("geometric(0.5) & method=dss");
INFO_TEST("discr; pv=(.1,.2,.3,.4,.5,.6,.7);pmfsum=2.8 & method=dss");
INFO_TEST("discr; cdf='1-exp(-x)';pmfsum=1 & method=dss");
#endif
unur_free(gen);
}

{ /* DSTD */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DSTD");
INFO_TEST("poisson(10) & method=dstd");
INFO_TEST("poisson(10) & method=dstd;variant=0");
INFO_TEST("poisson(10) & method=dstd;variant=2");
INFO_TEST("geometric(0.5) & method=dstd");
INFO_TEST("geometric(0.5) & method=dstd;variant=0");
INFO_TEST("geometric(0.5) & method=dstd;variant=-1");
#endif
unur_free(gen);
}

{ /* DEXT */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double fpar[1] = {0.5};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("DEXT");
distr = unur_distr_geometric(fpar,1);
par = unur_dext_new(distr);
unur_dext_set_sample(par,geom12_sample);
gen = unur_init(par);
INFO_TEST_par("... & method=dext",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* EMPK */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("EMPK");
INFO_TEST("cemp; data=(1.,2.,3.,4.,5.,6.,7.,8.,9.) & method=empk");
INFO_TEST("cemp; data=(1.,2.,3.,4.,5.,6.,7.,8.,9.) & method=empk\
	;beta=1.5;positive=on;smoothing=1.2;varcor=on");
#endif
unur_free(gen);
}

{ /* EMPL */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("EMPL");
INFO_TEST("cemp; data=(1.,2.,3.,4.,5.,6.,7.,8.,9.) & method = empl");
#endif
unur_free(gen);
}

{ /* GIBBS */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double ll[] = {0.,0.,0.};
   double ru[] = {1.,UNUR_INFINITY,UNUR_INFINITY};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("GIBBS");
distr = unur_distr_multinormal( dim, mean, covar );
par = unur_gibbs_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=gibbs",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
unur_distr_cvec_set_domain_rect( distr, ll, ru);
par = unur_gibbs_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=gibbs",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_gibbs_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=gibbs",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_gibbs_new(distr);
unur_gibbs_set_variant_random_direction(par);
unur_gibbs_set_c(par,-0.5);
unur_gibbs_set_thinning(par,3);
unur_gibbs_set_burnin(par,1000);
gen = unur_init(par);
INFO_TEST_par("... & method=gibbs",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* HINV */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("HINV");
INFO_TEST("normal & method=hinv");
INFO_TEST("cont; cdf='1-exp(-x)'; domain=(0,inf) & method=hinv");
INFO_TEST("cont; cdf='1-exp(-x)'; domain=(0,inf) & method=hinv; order=5");
INFO_TEST("cont; cdf='1-exp(-x)'; domain=(0,inf); mode=0 & method=hinv");
INFO_TEST("cont; cdf='1-exp(-x)'; domain=(0,inf) & method=hinv; u_resolution=1e-16");
INFO_TEST_chg("normal & method=hinv", unur_hinv_chg_truncated(gen,0.,1.));
#endif
unur_free(gen);
}

{ /* HIST */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double hist[] = {0.1,0.2,0.3,0.4,0.5,0.4,0.3,0.2,0.1};
   double bins[] = {1.,2.,3.,4.,5.,6.,7.,8.,9.,10.};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("HIST");
distr = unur_distr_cemp_new();
unur_distr_cemp_set_hist_prob(distr,hist,9);
unur_distr_cemp_set_hist_domain(distr,1.,10.);
par = unur_hist_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=hist",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_cemp_new();
unur_distr_cemp_set_hist_prob(distr,hist,9);
unur_distr_cemp_set_hist_bins(distr,bins,10);
unur_distr_cemp_set_hist_domain(distr,1.,10.);
par = unur_hist_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=hist",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* HITRO */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double ll[] = {0.,0.,0.};
   double ru[] = {1.,UNUR_INFINITY,UNUR_INFINITY};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("HITRO");
distr = unur_distr_multinormal( dim, mean, covar );
par = unur_hitro_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=hitro",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
unur_distr_cvec_set_domain_rect( distr, ll, ru);
par = unur_hitro_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=hitro",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_hitro_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=hitro",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_hitro_new(distr);
unur_hitro_set_variant_random_direction(par);
unur_hitro_set_r(par,2.);
unur_hitro_set_thinning(par,3);
unur_hitro_set_burnin(par,1000);
gen = unur_init(par);
INFO_TEST_par("... & method=hitro",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* HRB */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("HRB");
INFO_TEST("cont; hr='1./(1.+x)' & method=hrb");
INFO_TEST("cont; hr='1./(1.+x)' & method=hrb;upperbound=1.1");
#endif
unur_free(gen);
}

{ /* HRD */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("HRD");
INFO_TEST("cont; hr='1./(1.+x)' & method=hrd");
#endif
unur_free(gen);
}

{ /* HRI */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("HRI");
INFO_TEST("cont; hr='3*x*x' & method=hri");
INFO_TEST("cont; hr='3*x*x' & method=hri;p0=0.8");
#endif
unur_free(gen);
}

{ /* ITDR */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("ITDR");
INFO_TEST("gamma(0.5) & method=itdr");
INFO_TEST("gamma(0.5) & method=itdr; cp=-0.5; ct=-0.5");
INFO_TEST("gamma(0.5) & method=itdr; cp=-0.5; ct=-0.5; xi=0.4");
INFO_TEST("cont; pdf='exp(-x)/sqrt(x)';mode=0;domain=(0,inf) & method=itdr");
#endif
unur_free(gen);
}

{ /* MCORR */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double eigenvalues[] = {1.,2.,3.,4.};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("MCORR");
distr = unur_distr_correlation(4); 
par = unur_mcorr_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=mcorr",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_correlation(4); 
par = unur_mcorr_new(distr);
unur_mcorr_set_eigenvalues( par, eigenvalues );
gen = unur_init(par);
INFO_TEST_par("... & method=mcorr",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* MIXT */
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   UNUR_GEN *comp[3];
   double prob[3] = {1,2,3};
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("MIXT");
comp[0] = unur_str2gen("normal;domain=(-inf,-1)&method=pinv");
comp[1] = unur_str2gen("uniform(-1,1)&method=cstd");
comp[2] = unur_str2gen("exponential;domain=(1,inf)&method=pinv");
par = unur_mixt_new(3,prob,comp);
gen = unur_init(par);
INFO_TEST_par("... & method=mixt",gen);
par = unur_mixt_new(3,prob,comp);
unur_mixt_set_useinversion(par,TRUE);
gen = unur_init(par);
INFO_TEST_par("... & method=mixt; useinversion=ON",gen);
unur_free(comp[0]);
unur_free(comp[1]);
unur_free(comp[2]);
comp[0] = unur_str2gen("exponential&method=pinv");
comp[1] = unur_str2gen("poisson(5)&method=dgt");
par = unur_mixt_new(2,prob,comp);
gen = unur_init(par);
INFO_TEST_par("... & method=mixt",gen);
unur_free(comp[0]);
unur_free(comp[1]);
comp[0] = unur_str2gen("binomial(100,0.05)&method=dgt");
comp[1] = unur_str2gen("poisson(5)&method=dgt");
par = unur_mixt_new(2,prob,comp);
gen = unur_init(par);
INFO_TEST_par("... & method=mixt",gen);
unur_free(comp[0]);
unur_free(comp[1]);
#endif
unur_free(gen);
}

{ /* MVSTD */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("MVSTD");
distr = unur_distr_multinormal( dim, mean, covar );
par = unur_mvstd_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=mvstd",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_mvstd_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=mvstd",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* MVTDR */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double ll[] = {0.,0.,0.};
   double ru[] = {1.,UNUR_INFINITY,UNUR_INFINITY};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("MVTDR");
distr = unur_distr_multinormal( dim, mean, covar );
par = unur_mvtdr_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=mvtdr",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
unur_distr_cvec_set_domain_rect( distr, ll, ru);
par = unur_mvtdr_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=mvtdr",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_mvtdr_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=mvtdr",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_mvtdr_new(distr);
unur_mvtdr_set_stepsmin( par, 7 );
unur_mvtdr_set_boundsplitting( par, 1.2 );
unur_mvtdr_set_maxcones( par, 9999 );
gen = unur_init(par);
INFO_TEST_par("... & method=mvtdr",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_mvtdr_new(distr);
unur_mvtdr_set_maxcones( par, 10 );
gen = unur_init(par);
INFO_TEST_par("... & method=mvtdr",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* NINV */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("NINV");
INFO_TEST("normal & method=ninv");
INFO_TEST("normal & method=ninv; usenewton");
INFO_TEST("normal & method=ninv; usebisect");
INFO_TEST("cont; cdf='1-exp(-x)'; domain=(0,inf) & method=ninv");
INFO_TEST_chg("normal & method=ninv", unur_ninv_chg_truncated(gen,0.,1.));
INFO_TEST("normal & method=ninv; x_resolution=1e-10");
INFO_TEST("normal & method=ninv; u_resolution=1e-10");
INFO_TEST("normal & method=ninv; u_resolution=1e-10; x_resolution=1e-10");
INFO_TEST("normal & method=ninv; u_resolution=1e-10; x_resolution=-1");
INFO_TEST("normal & method=ninv; max_iter=100");
INFO_TEST("normal & method=ninv; start=(-1,1)");
INFO_TEST("normal & method=ninv; table=123");
#endif
unur_free(gen);
}

{ /* NORTA */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double rankcorr[] = { 1., 0.5, 0.1,  0.5, 1., 0.3,  0.1, 0.3, 1. };
   double gamma_params[] = {5.};
   double beta_params[] = {3.,5.};
   UNUR_DISTR *marginal = NULL;
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("NORTA");
distr = unur_distr_copula(dim, rankcorr);
par = unur_norta_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=norta",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr,rankcorr);
marginal = unur_distr_gamma(gamma_params,1);
unur_distr_cvec_set_marginals(distr,marginal);
unur_distr_free(marginal);
par = unur_norta_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=norta",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_cvec_new(dim);
unur_distr_cvec_set_rankcorr(distr,rankcorr);
unur_distr_cvec_set_marginal_list(distr,
	unur_distr_cauchy(NULL,0),
	unur_distr_gamma(gamma_params,1),
	unur_distr_beta(beta_params,2) );
par = unur_norta_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=norta",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* NROU */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

METHOD("NROU");
INFO_TEST("normal & method=nrou");
INFO_TEST("cont; pdf='exp(-x^2)' & method=nrou");
INFO_TEST("cont; pdf='exp(-x^2)' & method=nrou; r=2");
INFO_TEST("cont; pdf='exp(-x^2)' & method=nrou; v=1");
INFO_TEST("cont; pdf='exp(-x^2)' & method=nrou; u=(-0.61, 0.61)");
INFO_TEST("cont; pdf='exp(-x^2)' & method=nrou; v=1; u=(-0.61, 0.61)");
unur_free(gen);
}

{ /* PINV */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("PINV");
INFO_TEST("normal & method=pinv");
INFO_TEST("normal & method=pinv; smoothness=1");
INFO_TEST("normal & method=pinv; smoothness=2");
INFO_TEST("normal & method=pinv; smoothness=1; order=6");
INFO_TEST("normal & method=pinv; usecdf");
INFO_TEST("normal & method=pinv; order=7; u_resolution=1e-14; use_upoints=on");
INFO_TEST("normal & method=pinv; boundary=(-10,10); searchboundary=(1,0)");
INFO_TEST("cont; cdf='1-exp(-x)'; domain=(0,inf) & method=pinv");
INFO_TEST("chisquare(2) & method=pinv");
INFO_TEST("normal & method=pinv; keepcdf=on");
#endif
unur_free(gen);
}

{ /* SROU */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

METHOD("SROU");
INFO_TEST("normal & method=srou");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=srou");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=srou; usemirror");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=srou; cdfatmode=0.5; usesqueeze");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=srou; r=2");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=srou; r=2; cdfatmode=0.5");
unur_free(gen);
}

{ /* SSR */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

METHOD("SSR");
INFO_TEST("normal & method=ssr");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=ssr");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=ssr; cdfatmode=0.5; usesqueeze");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=ssr; cdfatmode=0.5");
INFO_TEST("cont; pdf='exp(-x^2)';domain=(0,inf);pdfarea=0.887 & method=ssr");
unur_free(gen);
}

{ /* TABL */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("TABL");
INFO_TEST("normal & method=tabl");
INFO_TEST("normal & method=tabl;variant_ia=off;max_intervals=50");
INFO_TEST("cont; pdf='exp(-x^2)';mode=0 & method=tabl");
INFO_TEST("cont; pdf='exp(-x^2)';mode=0  & method=tabl; max_intervals=100; max_sqhratio=0.99");
INFO_TEST_chg("normal & method=tabl", unur_tabl_chg_truncated(gen,0.,1.));
#endif
unur_free(gen);
}

{ /* TDR */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("TDR");
INFO_TEST("normal & method=tdr");
INFO_TEST("normal & method=tdr; max_intervals=10; cpoints=3");
INFO_TEST("cont; pdf='exp(-x^2)' & method=tdr");
INFO_TEST("cont; pdf='exp(-x^2)' & method=tdr; c=0");
INFO_TEST("cont; pdf='exp(-x^2)' & method=tdr; c=0; variant_ia");
INFO_TEST("cont; pdf='exp(-x^2)' & method=tdr; c=0; variant_ia; max_intervals=1000");
INFO_TEST("cont; pdf='exp(-x^2)' & method=tdr; c=0; variant_ia; max_intervals=1000; max_sqhratio=0.90");
INFO_TEST_chg("normal & method=tdr", unur_tdr_chg_truncated(gen,0.,1.));
#endif
unur_free(gen);
}

{ /* UNIF */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("UNIF");
INFO_TEST("uniform(0,1) & method=unif");
#endif
unur_free(gen);
}

{ /* UTDR */
UNUR_GEN   *gen = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("UTDR");
INFO_TEST("normal & method=utdr");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=utdr");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=utdr;pdfatmode=1.0");
INFO_TEST("cont; pdf='exp(-x^2)';pdfarea=1.773 & method=utdr;deltafactor=1e-8");
#endif
unur_free(gen);
}

{ /* VEMPK */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   double data[] = {1.,1.,-1.,1.,1.,-1.,-1.,-1. };
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("VEMPK");
distr = unur_distr_cvemp_new(2);
unur_distr_cvemp_set_data(distr, data, 4); 
par = unur_vempk_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=vempk",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_cvemp_new(2);
unur_distr_cvemp_set_data(distr, data, 4); 
par = unur_vempk_new(distr);
unur_vempk_set_smoothing(par,1.5);
unur_vempk_set_varcor(par,TRUE);
gen = unur_init(par);
INFO_TEST_par("... & method=vempk",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}

{ /* VNROU */
UNUR_DISTR *distr = NULL;
UNUR_PAR   *par = NULL;
UNUR_GEN   *gen = NULL;
   const int dim = 3;
   double mean[] = {1.,2.,3.};
   double covar[] = { 2., 2., 1.,   2., 4., 3.,   1., 3., 3. };
   double ll[] = {0.,0.,0.};
   double ru[] = {1.,UNUR_INFINITY,UNUR_INFINITY};
   distr = NULL;
   par = NULL;
   gen = NULL; 

#ifdef UNUR_ENABLE_INFO
METHOD("VNROU");
distr = unur_distr_multinormal( dim, mean, covar );
par = unur_vnrou_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=vnrou",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
unur_distr_cvec_set_domain_rect( distr, ll, ru);
par = unur_vnrou_new(distr);
gen = unur_init(par);
INFO_TEST_par("... & method=vnrou",gen);
unur_distr_free(distr);unur_free(gen);
distr = unur_distr_multinormal( dim, NULL, NULL );
par = unur_vnrou_new(distr);
unur_vnrou_set_r(par,2.);
gen = unur_init(par);
INFO_TEST_par("... & method=vnrou",gen);
#endif
unur_distr_free(distr);
unur_free(gen);
}


	/* timing */
	stopwatch_print(TESTLOG,"\n<*>time = %.3f ms\n\n", stopwatch_lap(&watch));

	/* test finished */
	test_ok &= (n_tests_failed) ? 0 : 1;
	(n_tests_failed) ? printf(" ==> failed] ") : printf(" ==> ok] ");

} /* end of test_sample() */


/*---------------------------------------------------------------------------*/
/* run generator in verifying mode */

void run_verify_generator( FILE *LOG, int line, UNUR_PAR *par )
{
	UNUR_GEN *gen;
	int i;

	/* switch to verifying mode */
	unur_info_set_verify(par,1);

	/* initialize generator */
	gen = unur_init( par ); abort_if_NULL(LOG, line, gen);

	/* run generator */
	for (i=0; i<VIOLATE_SAMPLE_SIZE; i++)
		unur_sample_cont(gen);

	/* destroy generator */
	unur_free(gen); 

} /* end of run_verify_generator() */

int unur_info_set_verify(UNUR_PAR *par ATTRIBUTE__UNUSED, int verify ATTRIBUTE__UNUSED) {return 0;}

/*---------------------------------------------------------------------------*/

int main(void)
{ 
        unsigned long seed;
	char *str_seed, *str_tail;

	/* start stop watch */
	stopwatch_init();
	stopwatch_start(&watch);

        /* open log file for unuran and set output stream for unuran messages */
        UNURANLOG = fopen( "t_info_unuran.log","w" );
        abort_if_NULL( stderr,-1, UNURANLOG );
        unur_set_stream( UNURANLOG );

        /* open log file for testing */
	TESTLOG = fopen( "t_info_test.log","w" );
	abort_if_NULL( stderr,-1, TESTLOG );

        /* seed for uniform generators */

	/* seed set by environment */
	str_seed = getenv("SEED");

	if (str_seed != NULL) {
	    seed = strtol(str_seed, &str_tail, 10);
	    if (seed == 0u) 
		seed = 65009;
	}
	else {
#ifdef SEED
	    seed = SEED;
#else
	    seed = 65009;
#endif
	}

        /* seed build-in uniform generators */
        unur_urng_MRG31k3p_seed(NULL,seed);
        unur_urng_fish_seed(NULL,seed);
	unur_urng_mstd_seed(NULL,seed);

	/* seed uniform random number generator */
#ifdef UNUR_URNG_UNURAN
#  ifdef UNUR_URNG_DEFAULT_RNGSTREAM
	{
	        unsigned long sa[6];
	        int i;
	        for (i=0; i<6; i++) sa[i] = seed;
                RngStream_SetPackageSeed(sa);
        }
#  else
	if (unur_urng_seed(NULL,seed) != UNUR_SUCCESS) {
	        fprintf(stderr,"WARNING: Seed could not be set at random\n");
                seed = ~0u;
	}
#  endif  /* UNUR_URNG_DEFAULT_RNGSTREAM */
#endif  /* UNUR_URNG_UNURAN */
 
	/* set default debugging flag */
	unur_set_default_debug(UNUR_DEBUG_ALL);

        /* detect required check mode */
        fullcheck = (getenv("UNURANFULLCHECK")==NULL) ? FALSE : TRUE;

	/* write header into log file */
        print_test_log_header( TESTLOG, seed, fullcheck );

	/* set timer for sending SIGALRM signal */
	set_alarm(TESTLOG);

	/* start test */
	printf("info: ");

	/* run tests */
test_new();
test_sample();


	/* test finished */
	printf("\n");  fflush(stdout);

	/* close log files */
	fprintf(TESTLOG,"\n====================================================\n\n");
	if (test_ok)
		fprintf(TESTLOG,"All tests PASSED.\n");
	else
		fprintf(TESTLOG,"Test(s) FAILED.\n");

	/* timing */
	stopwatch_print(TESTLOG,"\n<*>total time = %.0f ms\n\n", stopwatch_stop(&watch));

	fclose(UNURANLOG);
	fclose(TESTLOG);

	/* free memory */
	compare_free_memory();
	unur_urng_free(unur_get_default_urng());
	unur_urng_free(unur_get_default_urng_aux());

	/* exit */
	exit( (test_ok) ? EXIT_SUCCESS : EXIT_FAILURE );

} /* end of main */

