#include <gtest/gtest.h>
#include "ut_PenalItem.h"
#include <QtTest/QtTest> //for testing Gui
#include <QString>

class GPanelItemTest : public ::testing::Test
{
protected:
    virtual void SetUp()
    {
        panelItem = new GPanelItem();
    }
    virtual void TearDown()
    {
        delete panelItem;
    }

    GPanelItem *panelItem;
};

TEST_F(GPanelItemTest, testInit)
{
}

//GUI testing using QtTest
TEST_F(GPanelItemTest, testIncButton)
{
    panelItem->reset();
    QTest::mouseClick(panelItem->getIncreaseButton(), Qt::LeftButton);
    QCOMPARE(panelItem->getNumLabel()->text(), QString("1"));
}

TEST_F(GPanelItemTest, testDescButton)
{
    panelItem->setValue(1);
    QCOMPARE(panelItem->getNumLabel()->text(), QString("1"));
    QTest::mouseClick(panelItem->getDecreaseButton(), Qt::LeftButton);
    QCOMPARE(panelItem->getNumLabel()->text(), QString("0"));
}

TEST_F(GPanelItemTest, testIncButtonEdge)
{
    panelItem->setValue(9);
    QTest::mouseClick(panelItem->getIncreaseButton(), Qt::LeftButton);
    QCOMPARE(panelItem->getNumLabel()->text(), QString("9"));
}

TEST_F(GPanelItemTest, testDescButtonEdge)
{
    panelItem->setValue(0);
    QTest::mouseClick(panelItem->getDecreaseButton(), Qt::LeftButton);
    QCOMPARE(panelItem->getNumLabel()->text(), QString("0"));
}
