#!/bin/bash
#
# Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
mount --bind -v --bind /dev/ /target/dev || echo "Failed to bind /dev"
mount -vt devpts devpts /target/dev/pts || echo "Failed to bind devpts"
mount -vt proc proc /target/proc || echo "Failed to bind proc"
mount -vt sysfs sysfs /target/sys || echo "Failed to bind sysfs"
mount --bind /run /target/run || echo "Failed to bind /run"
if [ ! -d /target/var/run ]; then
   mkdir /target/var/run
fi
mount --bind /var/run /target/var/run || echo "Failed to bind /var/run"
mount --bind /tmp/.X11-unix/ /target/tmp/.X11-unix || echo "Failed to bind /tmp/.X11-unix"

if [ ! -d /target/var/lib ]; then
  cp -rf /var/lib /target/var || echo "Failed to copy /tmp/oem to /target"
fi
chroot /target update-grub

umount /target/dev
umount /target/dev/pts
umount /target/proc 
umount /target/sys
umount /target/sys
umount /target/var/run
umount /target/tmp/.X11-unix
cd /usr/lib/deepin-repair-tools/plugins/fstab_repair
sh ./generate_fstab.sh
