package main

import (
	"github.com/godbus/dbus"
	"github.com/godbus/dbus/introspect"
	"github.com/godbus/dbus/prop"
)

const (
	dbusName = "com.deepin.sync.Daemon"
	dbusPath = "/com/deepin/sync/Daemon"
	dbusIFC  = dbusName

	dbusPropMachineName   = "MachineName"
	dbusPropLastSyncTime  = "LastSyncTime"
	dbusPropState         = "State"
	dbusSigSwitcherChange = "SwitcherChange"
)

// GetDBusName return dbus service name
func (d *Daemon) GetDBusName() string {
	return dbusName
}

// GetDBusPath return dbus service path
func (d *Daemon) GetDBusPath() dbus.ObjectPath {
	return dbusPath
}

// GetDBusInterface return dbus service interface
func (d *Daemon) GetDBusInterface() string {
	return dbusIFC
}

// MakePropSpec create props
func (d *Daemon) MakePropSpec() map[string]map[string]*prop.Prop {
	return map[string]map[string]*prop.Prop{
		d.GetDBusInterface(): {
			"State": {
				Value:    d.state,
				Writable: false,
				Emit:     prop.EmitTrue,
				Callback: func(c *prop.Change) *dbus.Error {
					return nil
				},
			},
			"LastSyncTime": {
				Value:    &d.lastSyncTime,
				Writable: false,
				Emit:     prop.EmitTrue,
				Callback: func(c *prop.Change) *dbus.Error {
					return nil
				},
			},
		},
	}
}

// MakeSignals create signals
func (d *Daemon) MakeSignals() []introspect.Signal {
	return []introspect.Signal{
		{
			Name: "SwitcherChange",
			Args: []introspect.Arg{
				{
					Name: "switcher",
					Type: "s",
				},
				{
					Name: "enabled",
					Type: "b",
				},
			},
		},
	}
}
